/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.tools.checkstyle.checks.naming;

import org.openrewrite.tools.checkstyle.api.DetailAST;
import org.openrewrite.tools.checkstyle.checks.naming.AbstractAccessControlNameCheck;
import org.openrewrite.tools.checkstyle.utils.ScopeUtil;

public class StaticVariableNameCheck
extends AbstractAccessControlNameCheck {
    public StaticVariableNameCheck() {
        super("^[a-z][a-zA-Z0-9]*$");
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{10};
    }

    @Override
    protected final boolean mustCheckName(DetailAST ast) {
        DetailAST modifiersAST = ast.findFirstToken(5);
        boolean isStatic = modifiersAST.findFirstToken(64) != null;
        boolean isFinal = modifiersAST.findFirstToken(39) != null;
        return isStatic && !isFinal && this.shouldCheckInScope(modifiersAST) && !ScopeUtil.isInInterfaceOrAnnotationBlock(ast);
    }
}

