/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.J;

public class UnwrapParentheses<P>
extends JavaVisitor<P> {
    private final J.Parentheses<?> scope;

    public UnwrapParentheses(J.Parentheses<?> scope) {
        this.scope = scope;
    }

    @Override
    public <T extends J> J visitParentheses(J.Parentheses<T> parens, P p) {
        if (this.scope.isScope(parens) && UnwrapParentheses.isUnwrappable(this.getCursor())) {
            Object parent;
            Object tree = parens.getTree().withPrefix(parens.getPrefix());
            if (tree.getPrefix().isEmpty() && ((parent = this.getCursor().getParentOrThrow().getValue()) instanceof J.Return || parent instanceof J.Throw)) {
                tree = tree.withPrefix(tree.getPrefix().withWhitespace(" "));
            }
            return tree;
        }
        return super.visitParentheses(parens, p);
    }

    public static boolean isUnwrappable(Cursor parensScope) {
        if (!(parensScope.getValue() instanceof J.Parentheses)) {
            return false;
        }
        Tree parent = (Tree)parensScope.getParentTreeCursor().getValue();
        if (parent instanceof J.If || parent instanceof J.Switch || parent instanceof J.Synchronized || parent instanceof J.Try.Catch || parent instanceof J.TypeCast || parent instanceof J.WhileLoop) {
            return false;
        }
        if (parent instanceof J.DoWhileLoop) {
            return parensScope.getValue() != ((J.DoWhileLoop)parent).getWhileCondition();
        }
        if (parent instanceof J.Unary) {
            Object innerJ = ((J.Parentheses)parensScope.getValue()).getTree();
            return !(innerJ instanceof J.Binary);
        }
        return true;
    }
}

