/*
 * Copyright 2023 the original author or authors.
 * <p>
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * <p>
 * https://www.apache.org/licenses/LICENSE-2.0
 * <p>
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.openrewrite.javascript.markers;

import lombok.Value;
import lombok.With;
import org.openrewrite.Incubating;
import org.openrewrite.marker.Marker;

import java.util.UUID;

@Incubating(since = "0.0")
@Value
@With
public class ForLoopType implements Marker {

    UUID id;
    Keyword keyword;

    public enum Keyword {
        OF("of"), IN("in");

        final String word;

        Keyword(String word) {
            this.word = word;
        }

        public String getWord() {
            return word;
        }
    }
}
