/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.json.format;

import org.jspecify.annotations.Nullable;
import org.openrewrite.Tree;
import org.openrewrite.json.JsonIsoVisitor;
import org.openrewrite.json.style.TabsAndIndentsStyle;
import org.openrewrite.json.tree.Json;

public class TabsAndIndentsVisitor<P>
extends JsonIsoVisitor<P> {
    private final TabsAndIndentsStyle style;
    private final @Nullable Tree stopAfter;

    public TabsAndIndentsVisitor(TabsAndIndentsStyle style, @Nullable Tree stopAfter) {
        this.style = style;
        this.stopAfter = stopAfter;
    }

    public Json preVisit(Json tree, P p) {
        String ws;
        Json json = (Json)super.preVisit((Tree)tree, p);
        if (json != null && (ws = json.getPrefix().getWhitespace()).contains("\n")) {
            int indentMultiple = (int)this.getCursor().getPathAsStream().filter(Json.JsonObject.class::isInstance).count();
            String shiftedPrefix = this.createIndent(ws, indentMultiple);
            if (!shiftedPrefix.equals(ws)) {
                return json.withPrefix(json.getPrefix().withWhitespace(shiftedPrefix));
            }
        }
        return json;
    }

    public @Nullable Json postVisit(Json tree, P p) {
        if (this.stopAfter != null && this.stopAfter.isScope((Tree)tree)) {
            this.getCursor().putMessageOnFirstEnclosing(Json.Document.class, "stop", (Object)true);
        }
        return (Json)super.postVisit((Tree)tree, p);
    }

    public @Nullable Json visit(@Nullable Tree tree, P p) {
        if (this.getCursor().getNearestMessage("stop") != null) {
            return (Json)tree;
        }
        return (Json)super.visit(tree, p);
    }

    private String createIndent(String ws, int indentMultiple) {
        StringBuilder shiftedPrefixBuilder = new StringBuilder(ws.substring(0, ws.lastIndexOf(10) + 1));
        for (int i = 0; i < indentMultiple; ++i) {
            if (this.style.getUseTabCharacter().booleanValue()) {
                shiftedPrefixBuilder.append("\t");
                continue;
            }
            for (int j = 0; j < this.style.getIndentSize(); ++j) {
                shiftedPrefixBuilder.append(" ");
            }
        }
        return shiftedPrefixBuilder.toString();
    }
}

