/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.json.format;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.json.JsonIsoVisitor;
import org.openrewrite.json.style.TabsAndIndentsStyle;
import org.openrewrite.json.style.WrappingAndBracesStyle;
import org.openrewrite.json.tree.Json;
import org.openrewrite.json.tree.Space;
import org.openrewrite.style.GeneralFormatStyle;

public class TabsAndIndentsVisitor<P>
extends JsonIsoVisitor<P> {
    private final String singleIndent;
    private final String objectsWrappingDelimiter;
    private final @Nullable Tree stopAfter;

    public TabsAndIndentsVisitor(WrappingAndBracesStyle wrappingAndBracesStyle, TabsAndIndentsStyle tabsAndIndentsStyle, GeneralFormatStyle generalFormatStyle, @Nullable Tree stopAfter) {
        this.stopAfter = stopAfter;
        if (tabsAndIndentsStyle.getUseTabCharacter().booleanValue()) {
            this.singleIndent = "\t";
        } else {
            StringBuilder sb = new StringBuilder();
            for (int j = 0; j < tabsAndIndentsStyle.getIndentSize(); ++j) {
                sb.append(" ");
            }
            this.singleIndent = sb.toString();
        }
        this.objectsWrappingDelimiter = wrappingAndBracesStyle.getWrapObjects().delimiter(generalFormatStyle);
    }

    public Json preVisit(Json tree, P p) {
        Json json = (Json)super.preVisit((Tree)tree, p);
        if (tree instanceof Json.JsonObject) {
            String newIndent = this.getCurrentIndent() + this.singleIndent;
            this.getCursor().putMessage("indentToUse", (Object)newIndent);
        }
        return json;
    }

    public @Nullable Json postVisit(Json tree, P p) {
        if (this.stopAfter != null && this.stopAfter.isScope((Tree)tree)) {
            this.getCursor().putMessageOnFirstEnclosing(Json.Document.class, "stop", (Object)true);
        }
        return (Json)super.postVisit((Tree)tree, p);
    }

    public @Nullable Json visit(@Nullable Tree tree, P p) {
        String shiftedPrefix;
        String ws;
        if (this.getCursor().getNearestMessage("stop") != null) {
            return (Json)tree;
        }
        Json json = (Json)super.visit(tree, p);
        String relativeIndent = this.getCurrentIndent();
        if (json != null && (ws = json.getPrefix().getWhitespace()).contains("\n") && !(shiftedPrefix = this.combineIndent(ws, relativeIndent)).equals(ws)) {
            json = json.withPrefix(json.getPrefix().withWhitespace(shiftedPrefix));
        }
        if (json instanceof Json.JsonObject) {
            Json.JsonObject obj = (Json.JsonObject)json;
            List children = obj.getPadding().getMembers();
            children = ListUtils.mapLast(children, last -> {
                String currentAfter = last.getAfter().getWhitespace();
                String newAfter = this.objectsWrappingDelimiter + relativeIndent;
                if (!newAfter.equals(currentAfter)) {
                    return last.withAfter(Space.build(newAfter, Collections.emptyList()));
                }
                return last;
            });
            json = obj.getPadding().withMembers(children);
        }
        return json;
    }

    private String getCurrentIndent() {
        String ret = (String)this.getCursor().getNearestMessage("indentToUse");
        if (ret == null) {
            Optional<Json> containingNode = this.getCursor().getPathAsStream().filter(obj -> obj instanceof Json && ((Json)obj).getPrefix().getWhitespace().contains("\n")).findFirst().map(obj -> (Json)obj);
            return containingNode.map(node -> node.getPrefix().getWhitespaceIndent()).orElse("");
        }
        return ret;
    }

    private String combineIndent(String oldWs, String relativeIndent) {
        return oldWs.substring(0, oldWs.lastIndexOf(10) + 1) + relativeIndent;
    }
}

