/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.json.format;

import java.util.Collections;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.json.JsonIsoVisitor;
import org.openrewrite.json.style.WrappingAndBracesStyle;
import org.openrewrite.json.tree.Json;
import org.openrewrite.json.tree.JsonRightPadded;
import org.openrewrite.json.tree.JsonValue;
import org.openrewrite.json.tree.Space;
import org.openrewrite.style.GeneralFormatStyle;

public class WrappingAndBracesVisitor<P>
extends JsonIsoVisitor<P> {
    private final @Nullable Tree stopAfter;
    private final WrappingAndBracesStyle wrappingAndBracesStyle;
    private final GeneralFormatStyle generalFormatStyle;

    public WrappingAndBracesVisitor(WrappingAndBracesStyle wrappingAndBracesStyle, GeneralFormatStyle generalFormatStyle, @Nullable Tree stopAfter) {
        this.wrappingAndBracesStyle = wrappingAndBracesStyle;
        this.generalFormatStyle = generalFormatStyle;
        this.stopAfter = stopAfter;
    }

    @Override
    public Json.JsonObject visitObject(Json.JsonObject obj, P p) {
        Json ret = super.visitObject(obj, (Object)p);
        String possibleNewLine = this.wrappingAndBracesStyle.getWrapObjects().delimiter(this.generalFormatStyle);
        List<JsonRightPadded<Json>> members = ((Json.JsonObject)ret).getPadding().getMembers();
        members = WrappingAndBracesVisitor.applyWrappingStyleToLastChildSuffix(members, possibleNewLine);
        members = WrappingAndBracesVisitor.applyWrappingStyleToPrefixes(members, possibleNewLine);
        return ((Json.JsonObject)ret).getPadding().withMembers(members);
    }

    @Override
    public Json.Array visitArray(Json.Array array, P p) {
        Json ret = super.visitArray(array, (Object)p);
        String possibleNewLine = this.wrappingAndBracesStyle.getWrapArrays().delimiter(this.generalFormatStyle);
        List<JsonRightPadded<JsonValue>> members = ((Json.Array)ret).getPadding().getValues();
        members = WrappingAndBracesVisitor.applyWrappingStyleToLastChildSuffix(members, possibleNewLine);
        members = WrappingAndBracesVisitor.applyWrappingStyleToPrefixes(members, possibleNewLine);
        return ((Json.Array)ret).getPadding().withValues(members);
    }

    public @Nullable Json postVisit(Json tree, P p) {
        if (this.stopAfter != null && this.stopAfter.isScope((Tree)tree)) {
            this.getCursor().putMessageOnFirstEnclosing(Json.Document.class, "stop", (Object)true);
        }
        return (Json)super.postVisit((Tree)tree, p);
    }

    public @Nullable Json visit(@Nullable Tree tree, P p) {
        if (this.getCursor().getNearestMessage("stop") != null) {
            return (Json)tree;
        }
        return (Json)super.visit(tree, p);
    }

    private static <JS extends Json> List<JsonRightPadded<JS>> applyWrappingStyleToPrefixes(List<JsonRightPadded<JS>> elements, String possibleNewLine) {
        return ListUtils.map(elements, elem -> {
            String oldAfterNewLine = elem.getElement().getPrefix().getWhitespaceIndent();
            String newPrefix = possibleNewLine + oldAfterNewLine;
            if (!newPrefix.equals(elem.getElement().getPrefix().getWhitespace())) {
                return elem.withElement(elem.getElement().withPrefix(Space.build(newPrefix, Collections.emptyList())));
            }
            return elem;
        });
    }

    private static <JS extends Json> List<JsonRightPadded<JS>> applyWrappingStyleToLastChildSuffix(List<JsonRightPadded<JS>> elements, String possibleNewLine) {
        return ListUtils.mapLast(elements, last -> {
            String currentAfterNewLine = last.getAfter().getWhitespaceIndent();
            String currentAfter = last.getAfter().getWhitespace();
            String newAfter = possibleNewLine + currentAfterNewLine;
            if (!newAfter.equals(currentAfter)) {
                return last.withAfter(Space.build(newAfter, Collections.emptyList()));
            }
            return last;
        });
    }
}

