/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.json.internal.rpc;

import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.UUID;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Checksum;
import org.openrewrite.FileAttributes;
import org.openrewrite.Tree;
import org.openrewrite.json.JsonVisitor;
import org.openrewrite.json.tree.Json;
import org.openrewrite.json.tree.JsonRightPadded;
import org.openrewrite.json.tree.JsonValue;
import org.openrewrite.json.tree.Space;
import org.openrewrite.marker.Markers;
import org.openrewrite.rpc.RpcReceiveQueue;

public class JsonReceiver
extends JsonVisitor<RpcReceiveQueue> {
    public Json preVisit(@NonNull Json j, RpcReceiveQueue q) {
        j = (Json)j.withId((UUID)q.receiveAndGet((Object)j.getId(), UUID::fromString));
        j = j.withPrefix((Space)q.receive((Object)j.getPrefix(), space -> this.visitSpace((Space)space, q)));
        return (Json)j.withMarkers((Markers)q.receive((Object)j.getMarkers()));
    }

    @Override
    public Json visitDocument(Json.Document document, RpcReceiveQueue q) {
        return document.withSourcePath((Path)q.receiveAndGet((Object)document.getSourcePath(), x$0 -> Paths.get(x$0, new String[0]))).withCharset((Charset)q.receiveAndGet((Object)document.getCharset(), Charset::forName)).withCharsetBomMarked((Boolean)q.receive((Object)document.isCharsetBomMarked())).withChecksum((Checksum)q.receive((Object)document.getChecksum())).withFileAttributes((FileAttributes)q.receive((Object)document.getFileAttributes())).withValue((JsonValue)q.receive((Object)document.getValue(), j -> (JsonValue)this.visitNonNull((Tree)j, q))).withEof((Space)q.receive((Object)document.getEof(), space -> this.visitSpace((Space)space, q)));
    }

    @Override
    public Json visitArray(Json.Array array, RpcReceiveQueue q) {
        return array.getPadding().withValues(q.receiveList(array.getPadding().getValues(), j -> this.visitRightPadded((JsonRightPadded)j, q)));
    }

    @Override
    public Json visitEmpty(Json.Empty empty, RpcReceiveQueue q) {
        return empty;
    }

    @Override
    public Json visitIdentifier(Json.Identifier identifier, RpcReceiveQueue q) {
        return identifier.withName((String)q.receive((Object)identifier.getName()));
    }

    @Override
    public Json visitLiteral(Json.Literal literal, RpcReceiveQueue q) {
        return literal.withSource((String)q.receive((Object)literal.getSource())).withValue(q.receive(literal.getValue()));
    }

    @Override
    public Json visitMember(Json.Member member, RpcReceiveQueue q) {
        return member.getPadding().withKey((JsonRightPadded)q.receive(member.getPadding().getKey(), j -> Objects.requireNonNull(this.visitRightPadded((JsonRightPadded)j, q)))).withValue((JsonValue)q.receive((Object)member.getValue(), j -> (JsonValue)this.visitNonNull((Tree)j, q)));
    }

    @Override
    public Json visitObject(Json.JsonObject object, RpcReceiveQueue q) {
        return object.getPadding().withMembers(q.receiveList(object.getPadding().getMembers(), j -> this.visitRightPadded((JsonRightPadded)j, q)));
    }

    @Override
    public Space visitSpace(Space space, RpcReceiveQueue q) {
        return space.withComments(q.receiveList(space.getComments(), c -> c.withMultiline((Boolean)q.receive((Object)c.isMultiline())).withText((String)q.receive((Object)c.getText())).withSuffix((String)q.receive((Object)c.getSuffix())).withMarkers((Markers)q.receive((Object)c.getMarkers())))).withWhitespace((String)q.receive((Object)space.getWhitespace()));
    }

    @Override
    public <T extends Json> JsonRightPadded<T> visitRightPadded(@Nullable JsonRightPadded<T> right, RpcReceiveQueue q) {
        assert (right != null) : "TreeDataReceiveQueue should have instantiated an empty padding";
        return right.withElement((Json)q.receive(right.getElement(), j -> (Json)this.visitNonNull((Tree)j, q))).withAfter((Space)q.receive((Object)right.getAfter(), space -> this.visitSpace((Space)space, q))).withMarkers((Markers)q.receive((Object)right.getMarkers()));
    }
}

