/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kotlin;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.declarations.impl.FirOuterClassTypeParameterRef;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.FirVarargArgumentsExpression;
import org.jetbrains.kotlin.fir.expressions.FirVariableAssignment;
import org.jetbrains.kotlin.fir.java.declarations.FirJavaField;
import org.jetbrains.kotlin.fir.java.declarations.FirJavaMethod;
import org.jetbrains.kotlin.fir.java.declarations.FirJavaValueParameter;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.ConeClassifierLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirEnumEntrySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFieldSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFileSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionIn;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionOut;
import org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirFunctionTypeRef;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitNullableAnyTypeRef;
import org.jetbrains.kotlin.fir.types.jvm.FirJavaTypeRef;
import org.jetbrains.kotlin.load.java.structure.JavaAnnotation;
import org.jetbrains.kotlin.load.java.structure.JavaArrayType;
import org.jetbrains.kotlin.load.java.structure.JavaClass;
import org.jetbrains.kotlin.load.java.structure.JavaClassifierType;
import org.jetbrains.kotlin.load.java.structure.JavaConstructor;
import org.jetbrains.kotlin.load.java.structure.JavaElement;
import org.jetbrains.kotlin.load.java.structure.JavaField;
import org.jetbrains.kotlin.load.java.structure.JavaMethod;
import org.jetbrains.kotlin.load.java.structure.JavaPrimitiveType;
import org.jetbrains.kotlin.load.java.structure.JavaType;
import org.jetbrains.kotlin.load.java.structure.JavaTypeParameter;
import org.jetbrains.kotlin.load.java.structure.JavaValueParameter;
import org.jetbrains.kotlin.load.java.structure.JavaWildcardType;
import org.jetbrains.kotlin.load.java.structure.impl.classFiles.BinaryJavaClass;
import org.jetbrains.kotlin.load.kotlin.JvmPackagePartSource;
import org.jetbrains.kotlin.name.ClassId;
import org.openrewrite.Incubating;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaTypeSignatureBuilder;

@Incubating(since="0.0")
public class KotlinTypeSignatureBuilder
implements JavaTypeSignatureBuilder {
    private final FirSession firSession;
    @Nullable
    Set<String> typeVariableNameStack;

    public KotlinTypeSignatureBuilder(FirSession firSession) {
        this.firSession = firSession;
    }

    public String signature(@Nullable Object type) {
        return this.signature(type, null);
    }

    public String signature(@Nullable Object type, @Nullable FirBasedSymbol<?> ownerSymbol) {
        if (type == null) {
            return "{undefined}";
        }
        if (type instanceof String) {
            return (String)type;
        }
        if (type instanceof FirClass) {
            return !((FirClass)type).getTypeParameters().isEmpty() ? this.parameterizedSignature(type) : this.classSignature(type);
        }
        if (type instanceof FirFunction) {
            return this.methodDeclarationSignature((FirFunctionSymbol<? extends FirFunction>)((FirFunction)type).getSymbol());
        }
        if (type instanceof FirVariable) {
            return this.variableSignature((FirVariableSymbol<? extends FirVariable>)((FirVariable)type).getSymbol(), ownerSymbol);
        }
        if (type instanceof FirBasedSymbol) {
            return this.signature(((FirBasedSymbol)type).getFir(), ownerSymbol);
        }
        if (type instanceof FirFile) {
            return ((FirFile)type).getName();
        }
        if (type instanceof FirJavaTypeRef) {
            return this.signature(((FirJavaTypeRef)type).getType());
        }
        if (type instanceof JavaType) {
            return this.mapJavaTypeSignature((JavaType)type);
        }
        if (type instanceof JavaElement) {
            return this.mapJavaElementSignature((JavaElement)type);
        }
        return this.resolveSignature(type, ownerSymbol);
    }

    private String resolveSignature(Object type, @Nullable FirBasedSymbol<?> ownerSymbol) {
        if (type instanceof ConeTypeProjection) {
            return this.coneTypeProjectionSignature((ConeTypeProjection)type);
        }
        if (type instanceof FirResolvedQualifier) {
            return this.signature(((FirResolvedQualifier)type).getSymbol());
        }
        if (type instanceof FirExpression) {
            return this.signature(((FirExpression)type).getTypeRef(), ownerSymbol);
        }
        if (type instanceof FirFunctionTypeRef) {
            return this.signature(((FirFunctionTypeRef)type).getReturnTypeRef(), ownerSymbol);
        }
        if (type instanceof FirResolvedNamedReference) {
            FirBasedSymbol resolvedSymbol = ((FirResolvedNamedReference)type).getResolvedSymbol();
            if (resolvedSymbol instanceof FirConstructorSymbol) {
                return this.signature(((FirConstructorSymbol)resolvedSymbol).getResolvedReturnTypeRef(), ownerSymbol);
            }
            if (resolvedSymbol instanceof FirEnumEntrySymbol) {
                return this.signature(((FirEnumEntrySymbol)resolvedSymbol).getResolvedReturnTypeRef(), ownerSymbol);
            }
            if (resolvedSymbol instanceof FirNamedFunctionSymbol) {
                return this.signature(((FirNamedFunctionSymbol)resolvedSymbol).getResolvedReturnTypeRef(), ownerSymbol);
            }
            if (resolvedSymbol instanceof FirPropertySymbol) {
                return this.signature(((FirPropertySymbol)resolvedSymbol).getResolvedReturnTypeRef(), ownerSymbol);
            }
            if (resolvedSymbol instanceof FirValueParameterSymbol) {
                return this.signature(((FirValueParameterSymbol)resolvedSymbol).getResolvedReturnType(), ownerSymbol);
            }
            if (resolvedSymbol instanceof FirFieldSymbol) {
                return this.signature(((FirFieldSymbol)resolvedSymbol).getResolvedReturnType(), ownerSymbol);
            }
        } else {
            if (type instanceof FirResolvedTypeRef) {
                ConeKotlinType coneKotlinType = ((FirResolvedTypeRef)type).getType();
                if (coneKotlinType instanceof ConeTypeParameterType) {
                    FirClassifierSymbol classifierSymbol = LookupTagUtilsKt.toSymbol((ConeClassifierLookupTag)((ConeTypeParameterType)coneKotlinType).getLookupTag(), (FirSession)this.firSession);
                    if (classifierSymbol != null && classifierSymbol.getFir() instanceof FirTypeParameter) {
                        return this.genericSignature(classifierSymbol.getFir());
                    }
                } else if (coneKotlinType instanceof ConeFlexibleType) {
                    return this.typeRefClassSignature((ConeKotlinType)((ConeFlexibleType)coneKotlinType).getLowerBound());
                }
                return coneKotlinType.getTypeArguments().length > 0 ? this.parameterizedTypeRef(coneKotlinType) : this.typeRefClassSignature(coneKotlinType);
            }
            if (type instanceof FirTypeParameter) {
                return this.genericSignature(type);
            }
            if (type instanceof FirValueParameterSymbol) {
                return this.signature(((FirValueParameterSymbol)type).getResolvedReturnType(), ownerSymbol);
            }
            if (type instanceof FirVariableAssignment) {
                return this.signature(((FirVariableAssignment)type).getCalleeReference(), ownerSymbol);
            }
            if (type instanceof FirOuterClassTypeParameterRef) {
                return this.signature(((FirOuterClassTypeParameterRef)type).getSymbol());
            }
        }
        return "{undefined}";
    }

    public String arraySignature(Object type) {
        throw new UnsupportedOperationException("This should never happen.");
    }

    public String classSignature(@Nullable Object type) {
        FirClassSymbol symbol;
        FirClass resolveType = null;
        if (type instanceof FirClass) {
            resolveType = (FirClass)type;
        } else if (type instanceof FirFunction) {
            FirFunction function;
            resolveType = type instanceof FirConstructor ? this.convertToRegularClass(((FirResolvedTypeRef)((FirConstructor)type).getReturnTypeRef()).getType()) : this.convertToRegularClass((ConeKotlinType)((function = (FirFunction)type).getDispatchReceiverType() != null ? function.getDispatchReceiverType() : ((FirResolvedTypeRef)function.getReturnTypeRef()).getType()));
        } else if (type instanceof FirResolvedTypeRef) {
            symbol = TypeUtilsKt.toRegularClassSymbol((ConeKotlinType)((FirResolvedTypeRef)type).getType(), (FirSession)this.firSession);
            if (symbol != null) {
                resolveType = (FirClass)symbol.getFir();
            }
        } else if (type instanceof ConeClassLikeType) {
            symbol = TypeUtilsKt.toRegularClassSymbol((ConeClassLikeType)((ConeClassLikeType)type), (FirSession)this.firSession);
            if (symbol != null) {
                resolveType = (FirClass)symbol.getFir();
            }
        } else if (type instanceof ConeClassLikeLookupTag) {
            symbol = LookupTagUtilsKt.toFirRegularClassSymbol((ConeClassLikeLookupTag)((ConeClassLikeLookupTag)type), (FirSession)this.firSession);
            if (symbol != null) {
                resolveType = (FirClass)symbol.getFir();
            }
        } else if (type instanceof FirFile) {
            return ((FirFile)type).getName();
        }
        if (resolveType == null) {
            return "{undefined}";
        }
        symbol = resolveType.getSymbol();
        return KotlinTypeSignatureBuilder.convertClassIdToFqn(symbol.getClassId());
    }

    public String parameterizedSignature(Object type) {
        StringBuilder s = new StringBuilder(this.classSignature(type));
        StringJoiner joiner = new StringJoiner(", ", "<", ">");
        for (FirTypeParameterRef tp : ((FirClass)type).getTypeParameters()) {
            String signature = this.signature(tp, (FirBasedSymbol<?>)((FirClass)type).getSymbol());
            joiner.add(signature);
        }
        s.append(joiner);
        return s.toString();
    }

    private String typeRefClassSignature(ConeKotlinType type) {
        ClassId classId = ConeTypeUtilsKt.getClassId((ConeKotlinType)(type instanceof ConeFlexibleType ? ((ConeFlexibleType)type).getLowerBound() : type));
        return classId == null ? "{undefined}" : KotlinTypeSignatureBuilder.convertClassIdToFqn(classId);
    }

    private String parameterizedTypeRef(ConeKotlinType type) {
        ClassId classId = ConeTypeUtilsKt.getClassId((ConeKotlinType)type);
        String fq = classId == null ? "{undefined}" : KotlinTypeSignatureBuilder.convertClassIdToFqn(classId);
        StringBuilder s = new StringBuilder(fq);
        StringJoiner joiner = new StringJoiner(", ", "<", ">");
        for (ConeTypeProjection argument : type.getTypeArguments()) {
            String signature = this.coneTypeProjectionSignature(argument);
            joiner.add(signature);
        }
        s.append(joiner);
        return s.toString();
    }

    public String genericSignature(Object type) {
        FirTypeParameter typeParameter = (FirTypeParameter)type;
        String name = typeParameter.getName().asString();
        if (this.typeVariableNameStack == null) {
            this.typeVariableNameStack = new HashSet<String>();
        }
        if (!this.typeVariableNameStack.add(name)) {
            return "Generic{" + name + "}";
        }
        StringBuilder s = new StringBuilder("Generic{").append(name);
        StringJoiner boundSigs = new StringJoiner(", ");
        for (FirTypeRef bound : typeParameter.getBounds()) {
            if (bound instanceof FirImplicitNullableAnyTypeRef) continue;
            boundSigs.add(this.signature(bound));
        }
        String boundSigStr = boundSigs.toString();
        if (!boundSigStr.isEmpty()) {
            s.append(": ").append(boundSigStr);
        }
        this.typeVariableNameStack.remove(name);
        return s.append("}").toString();
    }

    private String coneTypeProjectionSignature(ConeTypeProjection type) {
        StringBuilder s = new StringBuilder();
        System.out.println(type.getClass().getName());
        if (type instanceof ConeKotlinTypeProjectionIn) {
            ConeKotlinTypeProjectionIn in = (ConeKotlinTypeProjectionIn)type;
            s.append("Generic{in ");
            s.append(this.signature(in.getType()));
            s.append("}");
        } else if (type instanceof ConeKotlinTypeProjectionOut) {
            ConeKotlinTypeProjectionOut out = (ConeKotlinTypeProjectionOut)type;
            s.append("Generic{out ");
            s.append(this.signature(out.getType()));
            s.append("}");
        } else if (type instanceof ConeStarProjection) {
            s.append("Generic{*}");
        } else if (type instanceof ConeClassLikeType) {
            ConeClassLikeType classLikeType = (ConeClassLikeType)type;
            s.append(KotlinTypeSignatureBuilder.convertClassIdToFqn(classLikeType.getLookupTag().getClassId()));
            if (classLikeType.getTypeArguments().length > 0) {
                s.append("<");
                ConeTypeProjection[] typeArguments = classLikeType.getTypeArguments();
                for (int i = 0; i < typeArguments.length; ++i) {
                    ConeTypeProjection typeArgument = typeArguments[i];
                    s.append(this.signature(typeArgument));
                    if (i >= typeArguments.length - 1) continue;
                    s.append(", ");
                }
                s.append(">");
            }
        } else if (type instanceof ConeTypeParameterType) {
            ConeTypeParameterType typeParameterType = (ConeTypeParameterType)type;
            s.append("Generic{");
            String typeSignature = KotlinTypeSignatureBuilder.convertKotlinFqToJavaFq(typeParameterType.toString());
            s.append(typeSignature);
            s.append("}");
        } else if (type instanceof ConeFlexibleType) {
            s.append(this.signature(((ConeFlexibleType)type).getLowerBound()));
        } else if (type instanceof ConeDefinitelyNotNullType) {
            s.append("Generic{");
            s.append(type);
            s.append("}");
        } else if (type instanceof ConeIntersectionType) {
            s.append("Generic{");
            StringJoiner boundSigs = new StringJoiner(" & ");
            for (ConeKotlinType coneKotlinType : ((ConeIntersectionType)type).getIntersectedTypes()) {
                boundSigs.add(this.signature(coneKotlinType));
            }
            s.append(boundSigs);
            s.append("}");
        } else {
            throw new IllegalArgumentException("Unsupported ConeTypeProjection " + type.getClass().getName());
        }
        return s.toString();
    }

    private String mapJavaElementSignature(JavaElement type) {
        if (type instanceof BinaryJavaClass) {
            return ((BinaryJavaClass)type).getTypeParameters().isEmpty() ? this.javaClassSignature((JavaClass)type) : this.javaParameterizedSignature((JavaClass)type);
        }
        if (type instanceof JavaTypeParameter) {
            return this.mapJavaTypeParameter((JavaTypeParameter)type);
        }
        if (type instanceof JavaValueParameter) {
            return this.mapJavaValueParameter((JavaValueParameter)type);
        }
        if (type instanceof JavaAnnotation) {
            return KotlinTypeSignatureBuilder.convertClassIdToFqn(((JavaAnnotation)type).getClassId());
        }
        throw new UnsupportedOperationException("Unsupported JavaElement type: " + type.getClass().getName());
    }

    private String mapJavaTypeSignature(JavaType type) {
        if (type instanceof JavaPrimitiveType) {
            return this.primitive(((JavaPrimitiveType)type).getType());
        }
        if (type instanceof JavaClassifierType) {
            return this.mapClassifierType((JavaClassifierType)type);
        }
        if (type instanceof JavaArrayType) {
            return this.array((JavaArrayType)type);
        }
        if (type instanceof JavaWildcardType) {
            return this.mapWildCardType((JavaWildcardType)type);
        }
        throw new UnsupportedOperationException("Unsupported kotlin structure JavaType: " + type.getClass().getName());
    }

    private String mapClassifierType(JavaClassifierType type) {
        if (type.getTypeArguments().isEmpty()) {
            return type.getClassifierQualifiedName();
        }
        StringBuilder s = new StringBuilder(type.getClassifierQualifiedName());
        StringJoiner joiner = new StringJoiner(", ", "<", ">");
        for (JavaType tp : type.getTypeArguments()) {
            String signature = this.signature(tp);
            joiner.add(signature);
        }
        s.append(joiner);
        return s.toString();
    }

    private String mapWildCardType(JavaWildcardType type) {
        StringBuilder s = new StringBuilder("Generic{?");
        if (type.getBound() != null) {
            s.append(type.isExtends() ? " extends " : " super ");
            s.append(this.signature(type.getBound()));
        }
        return s.append("}").toString();
    }

    private String array(JavaArrayType type) {
        return this.signature(type.getComponentType()) + "[]";
    }

    private String javaClassSignature(JavaClass type) {
        if (type.getFqName() == null) {
            return "{undefined}";
        }
        if (type.getOuterClass() != null) {
            return this.javaClassSignature(type.getOuterClass()) + "$" + type.getName();
        }
        return type.getFqName().asString();
    }

    private String javaParameterizedSignature(JavaClass type) {
        StringBuilder s = new StringBuilder(this.javaClassSignature(type));
        StringJoiner joiner = new StringJoiner(", ", "<", ">");
        for (JavaTypeParameter tp : type.getTypeParameters()) {
            String signature = this.signature(tp);
            joiner.add(signature);
        }
        s.append(joiner);
        return s.toString();
    }

    private String mapJavaTypeParameter(JavaTypeParameter typeParameter) {
        String name = typeParameter.getName().asString();
        if (this.typeVariableNameStack == null) {
            this.typeVariableNameStack = new HashSet<String>();
        }
        if (!this.typeVariableNameStack.add(name)) {
            return "Generic{" + name + "}";
        }
        StringBuilder s = new StringBuilder("Generic{").append(name);
        StringJoiner boundSigs = new StringJoiner(", ");
        for (JavaClassifierType type : typeParameter.getUpperBounds()) {
            if (type.getClassifier() == null || "java.lang.Object".equals(type.getClassifierQualifiedName())) continue;
            boundSigs.add(this.signature(type));
        }
        String boundSigStr = boundSigs.toString();
        if (!boundSigStr.isEmpty()) {
            s.append(": ").append(boundSigStr);
        }
        this.typeVariableNameStack.remove(name);
        return s.append("}").toString();
    }

    private String mapJavaValueParameter(JavaValueParameter type) {
        return this.mapJavaTypeSignature(type.getType());
    }

    private String primitive(@Nullable PrimitiveType type) {
        if (type == null) {
            return "void";
        }
        switch (type) {
            case BOOLEAN: {
                return "java.lang.boolean";
            }
            case BYTE: {
                return "java.lang.byte";
            }
            case CHAR: {
                return "java.lang.char";
            }
            case DOUBLE: {
                return "java.lang.double";
            }
            case FLOAT: {
                return "java.lang.float";
            }
            case INT: {
                return "java.lang.int";
            }
            case LONG: {
                return "java.lang.long";
            }
            case SHORT: {
                return "java.lang.short";
            }
        }
        throw new IllegalArgumentException("Unsupported primitive type.");
    }

    public String primitiveSignature(Object type) {
        throw new UnsupportedOperationException("This should never happen.");
    }

    public String variableSignature(FirVariableSymbol<? extends FirVariable> symbol, @Nullable FirBasedSymbol<?> ownerSymbol) {
        String owner = "{undefined}";
        ConeSimpleKotlinType kotlinType = symbol.getDispatchReceiverType();
        if (kotlinType instanceof ConeClassLikeType) {
            FirRegularClass regularClass = this.convertToRegularClass((ConeKotlinType)kotlinType);
            if (regularClass != null && (owner = this.signature(regularClass)).contains("<")) {
                owner = owner.substring(0, owner.indexOf(60));
            }
        } else if (symbol.getCallableId().getClassId() != null) {
            owner = KotlinTypeSignatureBuilder.convertClassIdToFqn(symbol.getCallableId().getClassId());
            if (owner.contains("<")) {
                owner = owner.substring(0, owner.indexOf(60));
            }
        } else if (ownerSymbol != null) {
            owner = this.classSignature(ownerSymbol.getFir());
        }
        String typeSig = symbol.getFir() instanceof FirJavaField || symbol.getFir() instanceof FirEnumEntry ? this.signature(((FirVariable)symbol.getFir()).getReturnTypeRef()) : this.signature(symbol.getResolvedReturnTypeRef());
        return owner + "{name=" + symbol.getName().asString() + ",type=" + typeSig + '}';
    }

    public String variableSignature(JavaField javaField) {
        String owner = this.signature(javaField.getContainingClass());
        if (owner.contains("<")) {
            owner = owner.substring(0, owner.indexOf(60));
        }
        return owner + "{name=" + javaField.getName().asString() + ",type=" + this.signature(javaField.getType()) + '}';
    }

    public String methodSignature(FirFunctionCall functionCall, @Nullable FirBasedSymbol<?> ownerSymbol) {
        String owner = "{undefined}";
        if (functionCall.getExplicitReceiver() != null) {
            owner = this.signature(functionCall.getExplicitReceiver().getTypeRef());
        } else if (functionCall.getCalleeReference() instanceof FirResolvedNamedReference && ((FirResolvedNamedReference)functionCall.getCalleeReference()).getResolvedSymbol() instanceof FirNamedFunctionSymbol) {
            FirNamedFunctionSymbol resolvedSymbol = (FirNamedFunctionSymbol)((FirResolvedNamedReference)functionCall.getCalleeReference()).getResolvedSymbol();
            if (ClassMembersKt.containingClass((FirCallableSymbol)resolvedSymbol) != null) {
                owner = this.signature(LookupTagUtilsKt.toFirRegularClassSymbol((ConeClassLikeLookupTag)ClassMembersKt.containingClass((FirCallableSymbol)resolvedSymbol), (FirSession)this.firSession), ownerSymbol);
            } else if (resolvedSymbol.getOrigin() == FirDeclarationOrigin.Library.INSTANCE) {
                if (((FirSimpleFunction)resolvedSymbol.getFir()).getContainerSource() instanceof JvmPackagePartSource) {
                    JvmPackagePartSource source = (JvmPackagePartSource)((FirSimpleFunction)resolvedSymbol.getFir()).getContainerSource();
                    owner = source.getFacadeClassName() != null ? KotlinTypeSignatureBuilder.convertKotlinFqToJavaFq(source.getFacadeClassName().toString()) : KotlinTypeSignatureBuilder.convertKotlinFqToJavaFq(source.getClassName().toString());
                } else if (!(((FirSimpleFunction)resolvedSymbol.getFir()).getOrigin().getFromSource() || ((FirSimpleFunction)resolvedSymbol.getFir()).getOrigin().getFromSupertypes() || ((FirSimpleFunction)resolvedSymbol.getFir()).getOrigin().getGenerated())) {
                    owner = "kotlin.Library";
                }
            } else if (resolvedSymbol.getOrigin() == FirDeclarationOrigin.Source.INSTANCE && ownerSymbol != null) {
                if (ownerSymbol instanceof FirFileSymbol) {
                    owner = ((FirFile)((FirFileSymbol)ownerSymbol).getFir()).getName();
                } else if (ownerSymbol instanceof FirNamedFunctionSymbol) {
                    owner = this.signature(((FirNamedFunctionSymbol)ownerSymbol).getFir());
                } else if (ownerSymbol instanceof FirRegularClassSymbol) {
                    owner = this.signature(((FirRegularClassSymbol)ownerSymbol).getFir());
                }
            }
        }
        String s = owner;
        FirNamedReference namedReference = functionCall.getCalleeReference();
        s = namedReference instanceof FirResolvedNamedReference && ((FirResolvedNamedReference)namedReference).getResolvedSymbol() instanceof FirConstructorSymbol ? s + "{name=<constructor>,return=" + s : s + "{name=" + functionCall.getCalleeReference().getName().asString() + ",return=" + this.signature(functionCall.getTypeRef());
        return s + ",parameters=" + this.methodArgumentSignature(functionCall.getArgumentList().getArguments()) + '}';
    }

    public String methodDeclarationSignature(FirFunctionSymbol<? extends FirFunction> symbol) {
        String s;
        String string = symbol instanceof FirConstructorSymbol ? this.classSignature(symbol.getResolvedReturnTypeRef()) : (s = symbol.getDispatchReceiverType() != null ? this.classSignature(symbol.getDispatchReceiverType()) : this.classSignature(ClassMembersKt.containingClass(symbol)));
        if (symbol instanceof FirConstructorSymbol) {
            s = s + "{name=<constructor>,return=" + s;
        } else {
            String returnSignature = symbol.getFir() instanceof FirJavaMethod ? this.signature(((FirFunction)symbol.getFir()).getReturnTypeRef()) : this.signature(symbol.getResolvedReturnTypeRef());
            s = s + "{name=" + symbol.getName().asString() + ",return=" + returnSignature;
        }
        return s + ",parameters=" + this.methodArgumentSignature(symbol) + '}';
    }

    public String methodDeclarationSignature(JavaMethod method) {
        String s = this.javaClassSignature(method.getContainingClass());
        String returnSignature = this.signature(method.getReturnType());
        s = s + "{name=" + method.getName().asString() + ",return=" + returnSignature;
        return s + ",parameters=" + this.javaMethodArgumentSignature(method.getValueParameters()) + '}';
    }

    public String methodConstructorSignature(JavaConstructor method) {
        String s = this.javaClassSignature(method.getContainingClass());
        s = s + "{name=<constructor>,return=" + s;
        return s + ",parameters=" + this.javaMethodArgumentSignature(method.getValueParameters()) + '}';
    }

    private String methodArgumentSignature(List<FirExpression> argumentsList) {
        StringJoiner genericArgumentTypes = new StringJoiner(",", "[", "]");
        if (argumentsList.size() == 1 && argumentsList.get(0) instanceof FirVarargArgumentsExpression) {
            FirVarargArgumentsExpression varargArgumentsExpression = (FirVarargArgumentsExpression)argumentsList.get(0);
            for (FirExpression argument : varargArgumentsExpression.getArguments()) {
                genericArgumentTypes.add(this.signature(argument));
            }
        } else {
            for (FirExpression firExpression : argumentsList) {
                genericArgumentTypes.add(this.signature(firExpression));
            }
        }
        return genericArgumentTypes.toString();
    }

    private String methodArgumentSignature(FirFunctionSymbol<? extends FirFunction> sym) {
        StringJoiner genericArgumentTypes = new StringJoiner(",", "[", "]");
        for (FirValueParameterSymbol parameterSymbol : sym.getValueParameterSymbols()) {
            String paramSignature = parameterSymbol.getFir() instanceof FirJavaValueParameter ? this.signature(((FirValueParameter)parameterSymbol.getFir()).getReturnTypeRef(), (FirBasedSymbol<?>)sym) : this.signature(parameterSymbol.getResolvedReturnType(), (FirBasedSymbol<?>)sym);
            genericArgumentTypes.add(paramSignature);
        }
        return genericArgumentTypes.toString();
    }

    private String javaMethodArgumentSignature(List<JavaValueParameter> valueParameters) {
        StringJoiner genericArgumentTypes = new StringJoiner(",", "[", "]");
        for (JavaValueParameter valueParameter : valueParameters) {
            genericArgumentTypes.add(this.signature(valueParameter));
        }
        return genericArgumentTypes.toString();
    }

    @Nullable
    public FirRegularClass convertToRegularClass(@Nullable ConeKotlinType kotlinType) {
        FirRegularClassSymbol symbol;
        if (kotlinType != null && (symbol = TypeUtilsKt.toRegularClassSymbol((ConeKotlinType)kotlinType, (FirSession)this.firSession)) != null) {
            return (FirRegularClass)symbol.getFir();
        }
        return null;
    }

    public static String convertClassIdToFqn(@Nullable ClassId classId) {
        return classId == null ? "{undefined}" : KotlinTypeSignatureBuilder.convertKotlinFqToJavaFq(classId.toString());
    }

    public static String convertKotlinFqToJavaFq(String kotlinFqn) {
        String cleanedFqn = kotlinFqn.replace(".", "$").replace("/", ".").replace("?", "");
        return cleanedFqn.startsWith(".") ? cleanedFqn.replaceFirst(".", "") : cleanedFqn;
    }
}

