/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kotlin.cleanup;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.kotlin.KotlinVisitor;

public final class ImplicitParameterInLambda
extends Recipe {
    public String getDisplayName() {
        return "`it` shouldn't be used as a lambda parameter name";
    }

    public String getDescription() {
        return "`it` is a special identifier that allows you to refer to the current parameter being passed to a lambda expression without explicitly naming the parameter. Lambda expressions are a concise way of writing anonymous functions. Many lambda expressions have only one parameter, when this is true the compiler can determine the parameter type by context. Thus when using it with single parameter lambda expressions, you do not need to declare the type.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(2L);
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-6558");
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new KotlinVisitor<ExecutionContext>(){

            public J visitLambda(J.Lambda lambda, ExecutionContext ctx) {
                if (ImplicitParameterInLambda.isParameterExplicitIt(lambda = (J.Lambda)super.visitLambda(lambda, (Object)ctx))) {
                    lambda = lambda.withParameters(lambda.getParameters().withParameters(Collections.emptyList()));
                    return this.autoFormat((J)lambda, ctx);
                }
                return lambda;
            }
        };
    }

    private static boolean isParameterExplicitIt(J.Lambda lambda) {
        J.Lambda.Parameters parameters = lambda.getParameters();
        if (parameters.getParameters().size() != 1) {
            return false;
        }
        J parameter = (J)parameters.getParameters().get(0);
        if (parameter instanceof J.VariableDeclarations) {
            J.VariableDeclarations vs = (J.VariableDeclarations)parameter;
            if (vs.getVariables().size() != 1 || vs.getTypeExpression() != null) {
                return false;
            }
            J.VariableDeclarations.NamedVariable v = (J.VariableDeclarations.NamedVariable)vs.getVariables().get(0);
            return "it".equals(v.getSimpleName());
        }
        return false;
    }

    public String toString() {
        return "ImplicitParameterInLambda()";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImplicitParameterInLambda)) {
            return false;
        }
        ImplicitParameterInLambda other = (ImplicitParameterInLambda)((Object)o);
        return other.canEqual((Object)this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof ImplicitParameterInLambda;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

