/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kotlin.cleanup;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.kotlin.KotlinParser;
import org.openrewrite.kotlin.KotlinVisitor;
import org.openrewrite.kotlin.tree.K;

public final class EqualsMethodUsage
extends Recipe {
    private static // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable J.Binary equalsBinaryTemplate;

    public String getDisplayName() {
        return "Structural equality tests should use `==` or `!=`";
    }

    public String getDescription() {
        return "In Kotlin, `==` means structural equality and `!=` structural inequality and both map to the left-side term\u2019s `equals()` function. It is, therefore, redundant to call `equals()` as a function. Also, `==` and `!=` are more general than `equals()` and `!equals()` because it allows either of both operands to be `null`.\nDevelopers using `equals()` instead of `==` or `!=` is often the result of adapting styles from other languages like Java, where `==` means reference equality and `!=` means reference inequality.\nThe `==` and `!=` operators are a more concise and elegant way to test structural equality than calling a function.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-S6519");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(3L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new KotlinVisitor<ExecutionContext>(){

            public J visitUnary(J.Unary unary, ExecutionContext ctx) {
                J.Binary binary;
                if ((unary = (J.Unary)super.visitUnary(unary, (Object)ctx)).getExpression() instanceof J.Binary && this.getCursor().pollMessage("replaced") != null && (binary = (J.Binary)unary.getExpression()).getOperator() == J.Binary.Type.Equal) {
                    return binary.withOperator(J.Binary.Type.NotEqual);
                }
                return unary;
            }

            public <T extends J> J visitParentheses(J.Parentheses<T> parens, ExecutionContext ctx) {
                J pa = super.visitParentheses(parens, (Object)ctx);
                if (pa instanceof J.Parentheses && this.getCursor().pollMessage("replaced") != null) {
                    this.getCursor().getParentTreeCursor().putMessage("replaced", (Object)true);
                    return ((J.Parentheses)pa).getTree();
                }
                return pa;
            }

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                if ("equals".equals((method = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx)).getSimpleName()) && method.getMethodType() != null && method.getArguments().size() == 1 && TypeUtils.isOfClassType((JavaType)method.getMethodType().getReturnType(), (String)"kotlin.Boolean") && method.getSelect() != null) {
                    Expression lhs = method.getSelect();
                    Expression rhs = (Expression)method.getArguments().get(0);
                    Cursor parentCursor = this.getCursor().getParentTreeCursor();
                    parentCursor.putMessage("replaced", (Object)true);
                    J.Binary binary = EqualsMethodUsage.buildEqualsBinary(lhs, rhs);
                    return parentCursor.getValue() instanceof J.Block ? new K.ExpressionStatement(Tree.randomId(), (Expression)binary) : binary;
                }
                return method;
            }
        };
    }

    private static J.Binary buildEqualsBinary(Expression left, Expression right) {
        Space rhsPrefix;
        if (equalsBinaryTemplate == null) {
            K.CompilationUnit kcu = KotlinParser.builder().build().parse("fun method(a : String, b : String) {val isSame = a == b}").map(K.CompilationUnit.class::cast).findFirst().get();
            equalsBinaryTemplate = (J.Binary)((AtomicReference)new KotlinVisitor<AtomicReference<J.Binary>>(){

                public J visitBinary(J.Binary binary, AtomicReference<J.Binary> target) {
                    target.set(binary);
                    return binary;
                }
            }.reduce((Tree)kcu, new AtomicReference())).get();
        }
        if ((rhsPrefix = right.getPrefix()).getWhitespace().isEmpty()) {
            rhsPrefix = rhsPrefix.withWhitespace(" ");
        }
        return equalsBinaryTemplate.withLeft((Expression)left.withPrefix(left.getPrefix())).withRight((Expression)right.withPrefix(rhsPrefix));
    }

    @Generated
    public EqualsMethodUsage() {
    }

    @Generated
    public String toString() {
        return "EqualsMethodUsage()";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EqualsMethodUsage)) {
            return false;
        }
        EqualsMethodUsage other = (EqualsMethodUsage)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EqualsMethodUsage;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

