/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kotlin.format;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.List;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.marker.ImplicitReturn;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.kotlin.KotlinIsoVisitor;
import org.openrewrite.kotlin.tree.K;

public class MinimumViableSpacingVisitor<P>
extends KotlinIsoVisitor<P> {
    @Nullable
    private final Tree stopAfter;

    @JsonCreator
    public MinimumViableSpacingVisitor(@Nullable Tree stopAfter) {
        this.stopAfter = stopAfter;
    }

    public MinimumViableSpacingVisitor() {
        this(null);
    }

    @Override
    public K.CompilationUnit visitCompilationUnit(K.CompilationUnit cu, P p) {
        J kcu = super.visitCompilationUnit(cu, (Object)p);
        kcu = kcu.withStatements(ListUtils.map(kcu.getStatements(), (i, st) -> i != 0 ? (Statement)st.withPrefix(st.getPrefix().withWhitespace("\n")) : st));
        return kcu;
    }

    @Override
    public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, P p) {
        Space before;
        J.ClassDeclaration.Padding padding;
        JContainer typeParameters;
        boolean hasFinalModifierOnly;
        J.ClassDeclaration c = super.visitClassDeclaration(classDecl, p);
        boolean first = c.getLeadingAnnotations().isEmpty();
        boolean bl = hasFinalModifierOnly = c.getModifiers().size() == 1 && ((J.Modifier)c.getModifiers().get(0)).getType() == J.Modifier.Type.Final;
        if (!hasFinalModifierOnly && !c.getModifiers().isEmpty()) {
            if (!first && Space.firstPrefix((List)c.getModifiers()).getWhitespace().isEmpty()) {
                c = c.withModifiers(Space.formatFirstPrefix((List)c.getModifiers(), (Space)((J.Modifier)c.getModifiers().iterator().next()).getPrefix().withWhitespace(" ")));
            }
            if (c.getModifiers().size() > 1) {
                c = c.withModifiers(ListUtils.map((List)c.getModifiers(), (index, modifier) -> {
                    if (index > 0 && modifier.getPrefix().getWhitespace().isEmpty() && modifier.getType() != J.Modifier.Type.Final) {
                        return modifier.withPrefix(modifier.getPrefix().withWhitespace(" "));
                    }
                    return modifier;
                }));
            }
            first = false;
        }
        if (c.getPadding().getKind().getPrefix().isEmpty()) {
            if (!first) {
                c = c.getPadding().withKind(c.getPadding().getKind().withPrefix(c.getPadding().getKind().getPrefix().withWhitespace(" ")));
            }
            first = false;
        }
        if (!first && c.getName().getPrefix().getWhitespace().isEmpty()) {
            c = c.withName(c.getName().withPrefix(c.getName().getPrefix().withWhitespace(" ")));
        }
        if (!((typeParameters = (padding = c.getPadding()).getTypeParameters()) == null || typeParameters.getElements().isEmpty() || first || typeParameters.getBefore().getWhitespace().isEmpty())) {
            c = padding.withTypeParameters(typeParameters.withBefore(typeParameters.getBefore().withWhitespace(" ")));
        }
        if (c.getPadding().getExtends() != null && (before = c.getPadding().getExtends().getBefore()).getWhitespace().isEmpty()) {
            c = c.getPadding().withExtends(c.getPadding().getExtends().withBefore(before.withWhitespace(" ")));
        }
        if (c.getPadding().getImplements() != null && (before = c.getPadding().getImplements().getBefore()).getWhitespace().isEmpty()) {
            c = c.getPadding().withImplements(c.getPadding().getImplements().withBefore(before.withWhitespace(" ")));
            c = c.withImplements(ListUtils.mapFirst((List)c.getImplements(), anImplements -> {
                if (anImplements.getPrefix().getWhitespace().isEmpty()) {
                    return (TypeTree)anImplements.withPrefix(anImplements.getPrefix().withWhitespace(" "));
                }
                return anImplements;
            }));
        }
        c = c.withBody(c.getBody().withStatements(ListUtils.map((List)c.getBody().getStatements(), (i, st) -> i != 0 ? (Statement)st.withPrefix(st.getPrefix().withWhitespace("\n")) : st)));
        return c;
    }

    @Override
    public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, P p) {
        Space before;
        J.TypeParameters typeParameters;
        J.MethodDeclaration m = super.visitMethodDeclaration(method, p);
        boolean first = m.getLeadingAnnotations().isEmpty();
        if (!m.getModifiers().isEmpty()) {
            int startPosition;
            if (!first && Space.firstPrefix((List)m.getModifiers()).getWhitespace().isEmpty()) {
                m = m.withModifiers(Space.formatFirstPrefix((List)m.getModifiers(), (Space)((J.Modifier)m.getModifiers().iterator().next()).getPrefix().withWhitespace(" ")));
            }
            boolean firstFinal = ((J.Modifier)m.getModifiers().get(0)).getType() == J.Modifier.Type.Final;
            int n = startPosition = firstFinal ? 1 : 0;
            if (m.getModifiers().size() > 1) {
                m = m.withModifiers(ListUtils.map((List)m.getModifiers(), (index, modifier) -> {
                    if (index > startPosition && modifier.getPrefix().getWhitespace().isEmpty()) {
                        return modifier.withPrefix(modifier.getPrefix().withWhitespace(" "));
                    }
                    return modifier;
                }));
            }
            first = false;
        }
        if ((typeParameters = m.getAnnotations().getTypeParameters()) != null && !typeParameters.getTypeParameters().isEmpty()) {
            if (!first && typeParameters.getPrefix().getWhitespace().isEmpty()) {
                m = m.getAnnotations().withTypeParameters(typeParameters.withPrefix(typeParameters.getPrefix().withWhitespace(" ")));
            }
            first = false;
        }
        if (m.getReturnTypeExpression() != null && m.getReturnTypeExpression().getPrefix().getWhitespace().isEmpty()) {
            TypeTree returnTypeExpression;
            if (!first && (returnTypeExpression = m.getReturnTypeExpression()) instanceof J.AnnotatedType) {
                J.AnnotatedType annotatedType = (J.AnnotatedType)returnTypeExpression;
                List annotations = ListUtils.mapFirst((List)annotatedType.getAnnotations(), annotation -> annotation.withPrefix(annotation.getPrefix().withWhitespace(" ")));
                m = m.withReturnTypeExpression((TypeTree)annotatedType.withAnnotations(annotations));
            }
            first = false;
        }
        if (!first) {
            m = m.withName(m.getName().withPrefix(m.getName().getPrefix().withWhitespace(" ")));
        }
        if (m.getPadding().getThrows() != null && (before = m.getPadding().getThrows().getBefore()).getWhitespace().isEmpty()) {
            m = m.getPadding().withThrows(m.getPadding().getThrows().withBefore(before.withWhitespace(" ")));
        }
        m = m.withBody(m.getBody().withStatements(ListUtils.map((List)m.getBody().getStatements(), (i, st) -> i != 0 ? (Statement)st.withPrefix(st.getPrefix().withWhitespace("\n")) : st)));
        return m;
    }

    @Override
    public J.Return visitReturn(J.Return return_, P p) {
        J.Return r = super.visitReturn(return_, p);
        if (r.getExpression() != null && r.getExpression().getPrefix().getWhitespace().isEmpty() && !return_.getMarkers().findFirst(ImplicitReturn.class).isPresent()) {
            r = r.withExpression((Expression)r.getExpression().withPrefix(r.getExpression().getPrefix().withWhitespace(" ")));
        }
        return r;
    }

    @Override
    public K.Binary visitBinary(K.Binary binary, P p) {
        J kb = super.visitBinary(binary, (Object)p);
        if (kb.getOperator() == K.Binary.Type.Contains) {
            kb = kb.getPadding().withOperator((JLeftPadded<K.Binary.Type>)kb.getPadding().getOperator().withBefore(MinimumViableSpacingVisitor.updateSpace(kb.getPadding().getOperator().getBefore(), true)));
            kb = kb.withRight(MinimumViableSpacingVisitor.spaceBefore(kb.getRight(), true));
        }
        return kb;
    }

    @Override
    public J.If visitIf(J.If iff, P p) {
        J.If updatedIff = super.visitIf(iff, p);
        if (updatedIff.getElsePart() != null) {
            updatedIff = updatedIff.withElsePart(MinimumViableSpacingVisitor.spaceBefore(updatedIff.getElsePart(), true));
            updatedIff = updatedIff.withElsePart(updatedIff.getElsePart().withBody(MinimumViableSpacingVisitor.spaceBefore(updatedIff.getElsePart().getBody(), true)));
        }
        return updatedIff;
    }

    @Override
    public J.ForEachLoop.Control visitForEachControl(J.ForEachLoop.Control control, P p) {
        J.ForEachLoop.Control c = super.visitForEachControl(control, p);
        c = c.getPadding().withVariable(c.getPadding().getVariable().withAfter(MinimumViableSpacingVisitor.updateSpace(c.getPadding().getVariable().getAfter(), true)));
        c = c.withIterable(MinimumViableSpacingVisitor.spaceBefore(c.getIterable(), true));
        return c;
    }

    @Override
    public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, P p) {
        J firstEnclosing;
        J.VariableDeclarations v = super.visitVariableDeclarations(multiVariable, p);
        boolean first = v.getLeadingAnnotations().isEmpty();
        if (!v.getModifiers().isEmpty()) {
            boolean needFirstSpace = !first;
            v = v.withModifiers(ListUtils.map((List)v.getModifiers(), (index, modifier) -> {
                if ((index != 0 || needFirstSpace) && modifier.getPrefix().getWhitespace().isEmpty()) {
                    modifier = modifier.withPrefix(modifier.getPrefix().withWhitespace(" "));
                }
                return modifier;
            }));
        }
        if (!((firstEnclosing = (J)this.getCursor().getParentOrThrow().firstEnclosing(J.class)) instanceof J.Lambda) && Space.firstPrefix((List)v.getVariables()).getWhitespace().isEmpty() && !v.getModifiers().isEmpty()) {
            v = v.withVariables(Space.formatFirstPrefix((List)v.getVariables(), (Space)((J.VariableDeclarations.NamedVariable)v.getVariables().iterator().next()).getPrefix().withWhitespace(" ")));
        }
        return v;
    }

    @Nullable
    public J postVisit(J tree, P p) {
        if (this.stopAfter != null && this.stopAfter.isScope((Tree)tree)) {
            this.getCursor().putMessageOnFirstEnclosing(JavaSourceFile.class, "stop", (Object)true);
        }
        return (J)super.postVisit((Tree)tree, p);
    }

    @Nullable
    public J visit(@Nullable Tree tree, P p) {
        if (this.getCursor().getNearestMessage("stop") != null) {
            return (J)tree;
        }
        return (J)super.visit(tree, p);
    }

    private static <T extends J> T spaceBefore(T j, boolean spaceBefore) {
        if (!j.getComments().isEmpty()) {
            return j;
        }
        if (spaceBefore && MinimumViableSpacingVisitor.notSingleSpace(j.getPrefix().getWhitespace())) {
            return (T)j.withPrefix(j.getPrefix().withWhitespace(" "));
        }
        if (!spaceBefore && MinimumViableSpacingVisitor.onlySpacesAndNotEmpty(j.getPrefix().getWhitespace())) {
            return (T)j.withPrefix(j.getPrefix().withWhitespace(""));
        }
        return j;
    }

    private static Space updateSpace(Space s, boolean haveSpace) {
        if (!s.getComments().isEmpty()) {
            return s;
        }
        if (haveSpace && MinimumViableSpacingVisitor.notSingleSpace(s.getWhitespace())) {
            return s.withWhitespace(" ");
        }
        if (!haveSpace && MinimumViableSpacingVisitor.onlySpacesAndNotEmpty(s.getWhitespace())) {
            return s.withWhitespace("");
        }
        return s;
    }

    private static boolean onlySpaces(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == ' ' || c == '\t') continue;
            return false;
        }
        return true;
    }

    private static boolean onlySpacesAndNotEmpty(String s) {
        return !StringUtils.isNullOrEmpty((String)s) && MinimumViableSpacingVisitor.onlySpaces(s);
    }

    private static boolean notSingleSpace(String str) {
        return MinimumViableSpacingVisitor.onlySpaces(str) && !" ".equals(str);
    }
}

