/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kotlin.style;

import org.openrewrite.kotlin.KotlinStyle;
import org.openrewrite.kotlin.style.IntelliJ;
import org.openrewrite.style.Style;
import org.openrewrite.style.StyleHelper;

public final class TabsAndIndentsStyle
implements KotlinStyle {
    private final Boolean useTabCharacter;
    private final Integer tabSize;
    private final Integer indentSize;
    private final Integer continuationIndent;
    private final Boolean keepIndentsOnEmptyLines;

    public Style applyDefaults() {
        return (Style)StyleHelper.merge((Object)IntelliJ.tabsAndIndents(), (Object)this);
    }

    public TabsAndIndentsStyle(Boolean useTabCharacter, Integer tabSize, Integer indentSize, Integer continuationIndent, Boolean keepIndentsOnEmptyLines) {
        this.useTabCharacter = useTabCharacter;
        this.tabSize = tabSize;
        this.indentSize = indentSize;
        this.continuationIndent = continuationIndent;
        this.keepIndentsOnEmptyLines = keepIndentsOnEmptyLines;
    }

    public Boolean getUseTabCharacter() {
        return this.useTabCharacter;
    }

    public Integer getTabSize() {
        return this.tabSize;
    }

    public Integer getIndentSize() {
        return this.indentSize;
    }

    public Integer getContinuationIndent() {
        return this.continuationIndent;
    }

    public Boolean getKeepIndentsOnEmptyLines() {
        return this.keepIndentsOnEmptyLines;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TabsAndIndentsStyle)) {
            return false;
        }
        TabsAndIndentsStyle other = (TabsAndIndentsStyle)o;
        Boolean this$useTabCharacter = this.getUseTabCharacter();
        Boolean other$useTabCharacter = other.getUseTabCharacter();
        if (this$useTabCharacter == null ? other$useTabCharacter != null : !((Object)this$useTabCharacter).equals(other$useTabCharacter)) {
            return false;
        }
        Integer this$tabSize = this.getTabSize();
        Integer other$tabSize = other.getTabSize();
        if (this$tabSize == null ? other$tabSize != null : !((Object)this$tabSize).equals(other$tabSize)) {
            return false;
        }
        Integer this$indentSize = this.getIndentSize();
        Integer other$indentSize = other.getIndentSize();
        if (this$indentSize == null ? other$indentSize != null : !((Object)this$indentSize).equals(other$indentSize)) {
            return false;
        }
        Integer this$continuationIndent = this.getContinuationIndent();
        Integer other$continuationIndent = other.getContinuationIndent();
        if (this$continuationIndent == null ? other$continuationIndent != null : !((Object)this$continuationIndent).equals(other$continuationIndent)) {
            return false;
        }
        Boolean this$keepIndentsOnEmptyLines = this.getKeepIndentsOnEmptyLines();
        Boolean other$keepIndentsOnEmptyLines = other.getKeepIndentsOnEmptyLines();
        return !(this$keepIndentsOnEmptyLines == null ? other$keepIndentsOnEmptyLines != null : !((Object)this$keepIndentsOnEmptyLines).equals(other$keepIndentsOnEmptyLines));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $useTabCharacter = this.getUseTabCharacter();
        result = result * 59 + ($useTabCharacter == null ? 43 : ((Object)$useTabCharacter).hashCode());
        Integer $tabSize = this.getTabSize();
        result = result * 59 + ($tabSize == null ? 43 : ((Object)$tabSize).hashCode());
        Integer $indentSize = this.getIndentSize();
        result = result * 59 + ($indentSize == null ? 43 : ((Object)$indentSize).hashCode());
        Integer $continuationIndent = this.getContinuationIndent();
        result = result * 59 + ($continuationIndent == null ? 43 : ((Object)$continuationIndent).hashCode());
        Boolean $keepIndentsOnEmptyLines = this.getKeepIndentsOnEmptyLines();
        result = result * 59 + ($keepIndentsOnEmptyLines == null ? 43 : ((Object)$keepIndentsOnEmptyLines).hashCode());
        return result;
    }

    public String toString() {
        return "TabsAndIndentsStyle(useTabCharacter=" + this.getUseTabCharacter() + ", tabSize=" + this.getTabSize() + ", indentSize=" + this.getIndentSize() + ", continuationIndent=" + this.getContinuationIndent() + ", keepIndentsOnEmptyLines=" + this.getKeepIndentsOnEmptyLines() + ")";
    }

    public TabsAndIndentsStyle withUseTabCharacter(Boolean useTabCharacter) {
        return this.useTabCharacter == useTabCharacter ? this : new TabsAndIndentsStyle(useTabCharacter, this.tabSize, this.indentSize, this.continuationIndent, this.keepIndentsOnEmptyLines);
    }

    public TabsAndIndentsStyle withTabSize(Integer tabSize) {
        return this.tabSize == tabSize ? this : new TabsAndIndentsStyle(this.useTabCharacter, tabSize, this.indentSize, this.continuationIndent, this.keepIndentsOnEmptyLines);
    }

    public TabsAndIndentsStyle withIndentSize(Integer indentSize) {
        return this.indentSize == indentSize ? this : new TabsAndIndentsStyle(this.useTabCharacter, this.tabSize, indentSize, this.continuationIndent, this.keepIndentsOnEmptyLines);
    }

    public TabsAndIndentsStyle withContinuationIndent(Integer continuationIndent) {
        return this.continuationIndent == continuationIndent ? this : new TabsAndIndentsStyle(this.useTabCharacter, this.tabSize, this.indentSize, continuationIndent, this.keepIndentsOnEmptyLines);
    }

    public TabsAndIndentsStyle withKeepIndentsOnEmptyLines(Boolean keepIndentsOnEmptyLines) {
        return this.keepIndentsOnEmptyLines == keepIndentsOnEmptyLines ? this : new TabsAndIndentsStyle(this.useTabCharacter, this.tabSize, this.indentSize, this.continuationIndent, keepIndentsOnEmptyLines);
    }
}

