/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kotlin;

import org.openrewrite.Cursor;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypedTree;
import org.openrewrite.kotlin.marker.AnnotationCallSite;
import org.openrewrite.kotlin.marker.CheckNotNull;
import org.openrewrite.kotlin.marker.IsNullSafe;
import org.openrewrite.kotlin.marker.IsNullable;
import org.openrewrite.kotlin.marker.KObject;
import org.openrewrite.kotlin.marker.SpreadArgument;
import org.openrewrite.kotlin.marker.TypeReferencePrefix;
import org.openrewrite.kotlin.service.KotlinAutoFormatService;
import org.openrewrite.kotlin.tree.K;
import org.openrewrite.kotlin.tree.KSpace;
import org.openrewrite.marker.Marker;

public class KotlinVisitor<P>
extends JavaVisitor<P> {
    public boolean isAcceptable(SourceFile sourceFile, P p) {
        return sourceFile instanceof K.CompilationUnit;
    }

    public String getLanguage() {
        return "kotlin";
    }

    public J visitCompilationUnit(K.CompilationUnit cu, P p) {
        K.CompilationUnit c = cu;
        c = c.withPrefix(this.visitSpace(c.getPrefix(), Space.Location.COMPILATION_UNIT_PREFIX, p));
        c = c.withMarkers(this.visitMarkers(c.getMarkers(), p));
        if ((c = c.withAnnotations(ListUtils.map(c.getAnnotations(), e -> (J.Annotation)this.visitAndCast((Tree)e, p)))).getPadding().getPackageDeclaration() != null) {
            c = c.getPadding().withPackageDeclaration((JRightPadded<J.Package>)this.visitRightPadded(c.getPadding().getPackageDeclaration(), JRightPadded.Location.PACKAGE, p));
        }
        c = c.getPadding().withImports(ListUtils.map(c.getPadding().getImports(), t -> this.visitRightPadded((JRightPadded)t, JRightPadded.Location.IMPORT, p)));
        c = c.withStatements(ListUtils.map(c.getStatements(), e -> (Statement)this.visitAndCast((Tree)e, p)));
        c = c.withEof(this.visitSpace(c.getEof(), Space.Location.COMPILATION_UNIT_EOF, p));
        return c;
    }

    public J visitCompilationUnit(J.CompilationUnit cu, P p) {
        throw new UnsupportedOperationException("Kotlin has a different structure for its compilation unit. See K.CompilationUnit.");
    }

    public <J2 extends J> J2 autoFormat(J2 j, P p) {
        return this.autoFormat(j, p, this.getCursor().getParentTreeCursor());
    }

    public <J2 extends J> J2 autoFormat(J2 j, @Nullable J stopAfter, P p, Cursor cursor) {
        KotlinAutoFormatService service = (KotlinAutoFormatService)((Object)((JavaSourceFile)this.getCursor().firstEnclosingOrThrow(JavaSourceFile.class)).service(KotlinAutoFormatService.class));
        return (J2)((J)service.autoFormatVisitor((Tree)stopAfter).visit(j, p, cursor));
    }

    public <J2 extends J> J2 autoFormat(J2 j, P p, Cursor cursor) {
        return this.autoFormat(j, null, p, cursor);
    }

    public <J2 extends J> J2 maybeAutoFormat(J2 before, J2 after, P p) {
        return this.maybeAutoFormat(before, after, p, this.getCursor().getParentTreeCursor());
    }

    public <J2 extends J> J2 maybeAutoFormat(J2 before, J2 after, P p, Cursor cursor) {
        return this.maybeAutoFormat(before, after, null, p, cursor);
    }

    public <J2 extends J> J2 maybeAutoFormat(J2 before, J2 after, @Nullable J stopAfter, P p, Cursor cursor) {
        if (before != after) {
            return this.autoFormat(after, stopAfter, p, cursor);
        }
        return after;
    }

    public J visitBinary(K.Binary binary, P p) {
        K.Binary b = binary;
        b = b.withPrefix(this.visitSpace(b.getPrefix(), KSpace.Location.BINARY_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(b = b.withMarkers(this.visitMarkers(b.getMarkers(), p)), p);
        if (!(temp instanceof K.Binary)) {
            return temp;
        }
        b = (K.Binary)temp;
        b = b.withLeft((Expression)this.visitAndCast((Tree)b.getLeft(), p));
        b = b.getPadding().withOperator(this.visitLeftPadded(b.getPadding().getOperator(), p));
        b = b.withRight((Expression)this.visitAndCast((Tree)b.getRight(), p));
        b = b.withType(this.visitType(b.getType(), p));
        return b;
    }

    public J visitDestructuringDeclaration(K.DestructuringDeclaration destructuringDeclaration, P p) {
        K.DestructuringDeclaration d = destructuringDeclaration;
        d = d.withPrefix(this.visitSpace(d.getPrefix(), KSpace.Location.DESTRUCTURING_DECLARATION_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(d = d.withMarkers(this.visitMarkers(d.getMarkers(), p)), p);
        if (!(temp instanceof K.DestructuringDeclaration)) {
            return temp;
        }
        d = (K.DestructuringDeclaration)temp;
        d = d.withInitializer((J.VariableDeclarations)this.visitAndCast((Tree)d.getInitializer(), p));
        d = d.getPadding().withAssignments(this.visitContainer(d.getPadding().getAssignments(), p));
        return d;
    }

    public J visitFunctionType(K.FunctionType functionType, P p) {
        K.FunctionType f = functionType;
        f = f.withPrefix(this.visitSpace(f.getPrefix(), KSpace.Location.FUNCTION_TYPE_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(f = f.withMarkers(this.visitMarkers(f.getMarkers(), p)), p);
        if (!(temp instanceof K.FunctionType)) {
            return temp;
        }
        f = (K.FunctionType)temp;
        f = f.withLeadingAnnotations(ListUtils.map(f.getLeadingAnnotations(), a -> (J.Annotation)this.visitAndCast((Tree)a, p)));
        f = f.withModifiers(ListUtils.map(f.getModifiers(), e -> (J.Modifier)this.visitAndCast((Tree)e, p)));
        f = f.withReceiver(this.visitRightPadded(f.getReceiver(), p));
        f = f.withTypedTree((TypedTree)this.visitAndCast((Tree)f.getTypedTree(), p));
        return f;
    }

    public J visitKReturn(K.KReturn kReturn, P p) {
        K.KReturn r = kReturn;
        r = (K.KReturn)r.withPrefix(this.visitSpace(r.getPrefix(), KSpace.Location.KRETURN_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(r = (K.KReturn)r.withMarkers(this.visitMarkers(r.getMarkers(), p)), p);
        if (!(temp instanceof K.KReturn)) {
            return temp;
        }
        r = (K.KReturn)temp;
        r = r.withAnnotations(ListUtils.map(r.getAnnotations(), a -> (J.Annotation)this.visitAndCast((Tree)a, p)));
        r = r.withExpression((J.Return)this.visitAndCast((Tree)r.getExpression(), p));
        r = r.withLabel((J.Identifier)this.visitAndCast((Tree)r.getLabel(), p));
        return r;
    }

    public J visitKString(K.KString kString, P p) {
        K.KString k = kString;
        k = k.withPrefix(this.visitSpace(k.getPrefix(), KSpace.Location.KSTRING_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(k = k.withMarkers(this.visitMarkers(k.getMarkers(), p)), p);
        if (!(temp instanceof K.KString)) {
            return temp;
        }
        k = (K.KString)temp;
        k = k.withStrings(ListUtils.map(k.getStrings(), s -> (J)this.visit((Tree)s, p)));
        k = k.withType(this.visitType(k.getType(), p));
        return k;
    }

    public J visitKThis(K.KThis kThis, P p) {
        K.KThis k = kThis;
        k = k.withPrefix(this.visitSpace(k.getPrefix(), KSpace.Location.KTHIS_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(k = k.withMarkers(this.visitMarkers(k.getMarkers(), p)), p);
        if (!(temp instanceof K.KThis)) {
            return temp;
        }
        k = (K.KThis)temp;
        k = k.withType(this.visitType(k.getType(), p));
        return k;
    }

    public J visitKStringValue(K.KString.Value value, P p) {
        K.KString.Value v2 = value;
        v2 = v2.withPrefix(this.visitSpace(v2.getPrefix(), KSpace.Location.KSTRING_VALUE_PREFIX, p));
        v2 = v2.withMarkers(this.visitMarkers(v2.getMarkers(), p));
        v2 = v2.withTree((J)this.visit((Tree)v2.getTree(), p));
        v2 = v2.withAfter(this.visitSpace(v2.getAfter(), KSpace.Location.KSTRING_VALUE_AFTER, p));
        return v2;
    }

    public J visitListLiteral(K.ListLiteral listLiteral, P p) {
        K.ListLiteral l = listLiteral;
        l = l.withPrefix(this.visitSpace(l.getPrefix(), KSpace.Location.LIST_LITERAL_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(l = l.withMarkers(this.visitMarkers(l.getMarkers(), p)), p);
        if (!(temp instanceof K.ListLiteral)) {
            return temp;
        }
        l = (K.ListLiteral)temp;
        l = l.getPadding().withElements(this.visitContainer(l.getPadding().getElements(), p));
        l = l.withType(this.visitType(l.getType(), p));
        return l;
    }

    public J visitNamedVariableInitializer(K.NamedVariableInitializer namedVariableInitializer, P p) {
        K.NamedVariableInitializer n = namedVariableInitializer;
        n = n.withPrefix(this.visitSpace(n.getPrefix(), KSpace.Location.NAMED_VARIABLE_INITIALIZER_PREFIX, p));
        n = n.withMarkers(this.visitMarkers(n.getMarkers(), p));
        n = n.withInitializations(ListUtils.map(n.getInitializations(), it -> (J)this.visitAndCast((Tree)it, p)));
        return n;
    }

    public J visitProperty(K.Property property, P p) {
        K.Property pr = property;
        pr = pr.withPrefix(this.visitSpace(pr.getPrefix(), KSpace.Location.PROPERTY_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(pr = pr.withMarkers(this.visitMarkers(pr.getMarkers(), p)), p);
        if (!(temp instanceof K.Property)) {
            return temp;
        }
        pr = (K.Property)temp;
        pr = pr.withVariableDeclarations((J.VariableDeclarations)this.visitAndCast((Tree)pr.getVariableDeclarations(), p));
        pr = pr.withGetter((J.MethodDeclaration)this.visitAndCast((Tree)pr.getGetter(), p));
        pr = pr.withSetter((J.MethodDeclaration)this.visitAndCast((Tree)pr.getSetter(), p));
        return pr;
    }

    public J visitWhen(K.When when, P p) {
        K.When w = when;
        w = w.withPrefix(this.visitSpace(w.getPrefix(), KSpace.Location.WHEN_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(w = w.withMarkers(this.visitMarkers(w.getMarkers(), p)), p);
        if (!(temp instanceof K.When)) {
            return temp;
        }
        w = (K.When)temp;
        w = w.withSelector((J.ControlParentheses<Expression>)((J.ControlParentheses)this.visitAndCast((Tree)w.getSelector(), p)));
        w = w.withBranches((J.Block)this.visitAndCast((Tree)w.getBranches(), p));
        w = w.withType(this.visitType(w.getType(), p));
        return w;
    }

    public J visitWhenBranch(K.WhenBranch whenBranch, P p) {
        K.WhenBranch w = whenBranch;
        w = w.withPrefix(this.visitSpace(w.getPrefix(), KSpace.Location.WHEN_BRANCH_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(w = w.withMarkers(this.visitMarkers(w.getMarkers(), p)), p);
        if (!(temp instanceof K.WhenBranch)) {
            return temp;
        }
        w = (K.WhenBranch)temp;
        w = w.getPadding().withExpressions(this.visitContainer(w.getPadding().getExpressions(), p));
        w = w.getPadding().withBody((JRightPadded<J>)this.visitRightPadded(w.getPadding().getBody(), JRightPadded.Location.CASE_BODY, p));
        return w;
    }

    public <T> JRightPadded<T> visitRightPadded(@Nullable JRightPadded<T> right, P p) {
        return super.visitRightPadded(right, JRightPadded.Location.LANGUAGE_EXTENSION, p);
    }

    public <T> JLeftPadded<T> visitLeftPadded(JLeftPadded<T> left, P p) {
        return super.visitLeftPadded(left, JLeftPadded.Location.LANGUAGE_EXTENSION, p);
    }

    public Space visitSpace(Space space, KSpace.Location loc, P p) {
        return this.visitSpace(space, Space.Location.LANGUAGE_EXTENSION, p);
    }

    public <J2 extends J> JContainer<J2> visitContainer(JContainer<J2> container, P p) {
        return super.visitContainer(container, JContainer.Location.LANGUAGE_EXTENSION, p);
    }

    public <M extends Marker> M visitMarker(Marker marker, P p) {
        Marker m = super.visitMarker(marker, p);
        if (m instanceof AnnotationCallSite) {
            AnnotationCallSite acs = (AnnotationCallSite)marker;
            m = acs.withSuffix(this.visitSpace(acs.getSuffix(), KSpace.Location.ANNOTATION_CALL_SITE_PREFIX, p));
        } else if (marker instanceof CheckNotNull) {
            CheckNotNull cnn = (CheckNotNull)marker;
            m = cnn.withPrefix(this.visitSpace(cnn.getPrefix(), KSpace.Location.CHECK_NOT_NULL_PREFIX, p));
        } else if (marker instanceof IsNullable) {
            IsNullable isn = (IsNullable)marker;
            m = isn.withPrefix(this.visitSpace(isn.getPrefix(), KSpace.Location.IS_NULLABLE_PREFIX, p));
        } else if (marker instanceof IsNullSafe) {
            IsNullSafe ins = (IsNullSafe)marker;
            m = ins.withPrefix(this.visitSpace(ins.getPrefix(), KSpace.Location.IS_NULLABLE_PREFIX, p));
        } else if (marker instanceof KObject) {
            KObject ko = (KObject)marker;
            m = ko.withPrefix(this.visitSpace(ko.getPrefix(), KSpace.Location.OBJECT_PREFIX, p));
        } else if (marker instanceof SpreadArgument) {
            SpreadArgument sa = (SpreadArgument)marker;
            m = sa.withPrefix(this.visitSpace(sa.getPrefix(), KSpace.Location.SPREAD_ARGUMENT_PREFIX, p));
        } else if (marker instanceof TypeReferencePrefix) {
            TypeReferencePrefix tr = (TypeReferencePrefix)marker;
            m = tr.withPrefix(this.visitSpace(tr.getPrefix(), KSpace.Location.TYPE_REFERENCE_PREFIX, p));
        }
        return (M)m;
    }
}

