/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kotlin.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.openrewrite.Parser;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u00122\u0006\u0010\u0004\u001a\u00020\u0005H\u0002R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001d\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0018"}, d2={"Lorg/openrewrite/kotlin/internal/KotlinSource;", "", "input", "Lorg/openrewrite/Parser$Input;", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "(Lorg/openrewrite/Parser$Input;Lorg/jetbrains/kotlin/psi/KtFile;)V", "firFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "getFirFile", "()Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "setFirFile", "(Lorg/jetbrains/kotlin/fir/declarations/FirFile;)V", "getInput", "()Lorg/openrewrite/Parser$Input;", "setInput", "(Lorg/openrewrite/Parser$Input;)V", "nodes", "", "", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "getNodes", "()Ljava/util/Map;", "map", "rewrite-kotlin"})
public final class KotlinSource {
    @NotNull
    private Parser.Input input;
    @NotNull
    private final Map<Integer, ASTNode> nodes;
    @Nullable
    private FirFile firFile;

    public KotlinSource(@NotNull Parser.Input input, @NotNull KtFile ktFile) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)ktFile, (String)"ktFile");
        this.input = input;
        this.nodes = this.map(ktFile);
    }

    @NotNull
    public final Parser.Input getInput() {
        return this.input;
    }

    public final void setInput(@NotNull Parser.Input input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"<set-?>");
        this.input = input;
    }

    @NotNull
    public final Map<Integer, ASTNode> getNodes() {
        return this.nodes;
    }

    @Nullable
    public final FirFile getFirFile() {
        return this.firFile;
    }

    public final void setFirFile(@Nullable FirFile firFile) {
        this.firFile = firFile;
    }

    private final Map<Integer, ASTNode> map(KtFile ktFile) {
        Map result = new HashMap();
        ArrayDeque stack = new ArrayDeque();
        stack.addFirst((Object)ktFile);
        while (!((Collection)stack).isEmpty()) {
            PsiElement curr = (PsiElement)stack.removeFirst();
            if (curr instanceof KtElement) {
                ASTNode aSTNode;
                Map map = result;
                Integer n = ((KtElement)curr).getTextRange().getStartOffset();
                Intrinsics.checkNotNullExpressionValue((Object)((KtElement)curr).getNode(), (String)"getNode(...)");
                map.put(n, aSTNode);
            }
            if (curr.getFirstChild() != null) {
                PsiElement psiElement = curr.getFirstChild();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getFirstChild(...)");
                stack.addFirst((Object)psiElement);
            }
            if (curr.getNextSibling() == null) continue;
            PsiElement psiElement = curr.getNextSibling();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getNextSibling(...)");
            stack.addFirst((Object)psiElement);
        }
        return result;
    }
}

