/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kotlin.format;

import java.util.Iterator;
import java.util.List;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.marker.ImplicitReturn;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.Javadoc;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TextComment;
import org.openrewrite.kotlin.KotlinIsoVisitor;
import org.openrewrite.kotlin.marker.Implicit;
import org.openrewrite.kotlin.marker.OmitBraces;
import org.openrewrite.kotlin.marker.SingleExpressionBlock;
import org.openrewrite.kotlin.marker.TrailingLambdaArgument;
import org.openrewrite.kotlin.style.TabsAndIndentsStyle;
import org.openrewrite.kotlin.style.WrappingAndBracesStyle;
import org.openrewrite.kotlin.tree.K;
import org.openrewrite.kotlin.tree.KSpace;
import org.openrewrite.marker.Markers;

public class TabsAndIndentsVisitor<P>
extends KotlinIsoVisitor<P> {
    @Nullable
    private final Tree stopAfter;
    private final TabsAndIndentsStyle style;
    private final WrappingAndBracesStyle wrappingStyle;

    public TabsAndIndentsVisitor(TabsAndIndentsStyle style, WrappingAndBracesStyle wrappingStyle) {
        this(style, wrappingStyle, null);
    }

    public TabsAndIndentsVisitor(TabsAndIndentsStyle style, WrappingAndBracesStyle wrappingStyle, @Nullable Tree stopAfter) {
        this.style = style;
        this.wrappingStyle = wrappingStyle;
        this.stopAfter = stopAfter;
    }

    @Nullable
    public J visit(@Nullable Tree tree, P p, Cursor parent) {
        J next;
        this.setCursor(parent);
        for (Cursor c = parent; c != null; c = c.getParent()) {
            int indent;
            Object v = c.getValue();
            Space space = null;
            if (v instanceof J) {
                space = ((J)v).getPrefix();
            } else if (v instanceof JRightPadded) {
                space = ((JRightPadded)v).getAfter();
            } else if (v instanceof JLeftPadded) {
                space = ((JLeftPadded)v).getBefore();
            } else if (v instanceof JContainer) {
                space = ((JContainer)v).getBefore();
            }
            if (space == null || !space.getLastWhitespace().contains("\n") || (indent = this.findIndent(space)) == 0) continue;
            c.putMessage("lastIndent", (Object)indent);
        }
        Iterator itr = parent.getPath(J.class::isInstance);
        J j = next = itr.hasNext() ? (J)itr.next() : null;
        if (next != null) {
            this.preVisit(next, p);
        }
        return this.visit(tree, p);
    }

    @Nullable
    public J preVisit(@Nullable J tree, P p) {
        if (tree instanceof JavaSourceFile || tree instanceof J.Package || tree instanceof J.Import || tree instanceof J.Label || tree instanceof J.DoWhileLoop || tree instanceof J.ArrayDimension) {
            this.getCursor().putMessage("indentType", (Object)IndentType.ALIGN);
        } else if (tree instanceof J.Block && tree.getMarkers().findFirst(SingleExpressionBlock.class).isPresent()) {
            this.getCursor().putMessage("indentType", (Object)(this.wrappingStyle.getExpressionBodyFunctions().getUseContinuationIndent() != false ? IndentType.CONTINUATION_INDENT : IndentType.INDENT));
        } else if (tree instanceof J.Block || tree instanceof K.Property || tree instanceof K.AnnotatedExpression || tree instanceof J.If || tree instanceof J.If.Else || tree instanceof J.ForLoop || tree instanceof J.ForEachLoop || tree instanceof J.WhileLoop || tree instanceof J.Case || tree instanceof J.EnumValueSet || tree instanceof J.Ternary && !this.wrappingStyle.getElvisExpressions().getUseContinuationIndent().booleanValue() || tree instanceof J.ClassDeclaration || tree instanceof K.ClassDeclaration || (tree instanceof J.FieldAccess || tree instanceof J.MethodInvocation) && !this.wrappingStyle.getChainedFunctionCalls().getUseContinuationIndent().booleanValue() || tree instanceof J.Annotation) {
            this.getCursor().putMessage("indentType", (Object)IndentType.INDENT);
        } else if (!(tree instanceof K.ExpressionStatement || tree instanceof K.StatementExpression || tree instanceof K.KReturn || tree instanceof K.When || tree instanceof K.WhenBranch || tree != null && tree.getMarkers().findFirst(ImplicitReturn.class).isPresent())) {
            this.getCursor().putMessage("indentType", (Object)IndentType.CONTINUATION_INDENT);
        }
        return tree;
    }

    @Override
    public J.ForLoop.Control visitForControl(J.ForLoop.Control control, P p) {
        return control;
    }

    @Override
    public J.ForEachLoop.Control visitForEachControl(J.ForEachLoop.Control control, P p) {
        return control;
    }

    @Override
    public Space visitSpace(Space space, KSpace.Location loc, P p) {
        if (loc == KSpace.Location.KRETURN_PREFIX && ((K.KReturn)this.getCursor().getValue()).getExpression().getMarkers().findFirst(ImplicitReturn.class).isPresent() && ((K.KReturn)this.getCursor().getValue()).getExpression().getExpression() == null) {
            return space;
        }
        return super.visitSpace(space, loc, p);
    }

    public Space visitSpace(Space space, Space.Location loc, P p) {
        boolean alignBlockToParent;
        Integer chainedIndent;
        this.getCursor().putMessage("lastLocation", (Object)loc);
        if (loc == Space.Location.RETURN_PREFIX) {
            return space;
        }
        boolean alignToAnnotation = false;
        Object value = this.getCursor().getValue();
        Cursor parent = this.getCursor().getParent();
        if (parent != null && parent.getValue() instanceof J.Annotation) {
            parent.getParentOrThrow().putMessage("afterAnnotation", (Object)true);
        } else {
            if (loc == Space.Location.BLOCK_PREFIX && ((J.Block)value).getMarkers().findFirst(OmitBraces.class).isPresent() && ((J.Block)value).getStatements().isEmpty()) {
                return space;
            }
            if (parent != null) {
                if (!this.getCursor().getParentOrThrow().getPath(J.Annotation.class::isInstance).hasNext()) {
                    J.MethodDeclaration m;
                    J.ClassDeclaration c;
                    boolean bl = alignToAnnotation = this.getCursor().pollNearestMessage("afterAnnotation") != null && !(this.getCursor().getParentOrThrow().getValue() instanceof J.Annotation);
                    if ((loc == Space.Location.CLASS_KIND || loc == Space.Location.METHOD_DECLARATION_PREFIX) && value instanceof J.ClassDeclaration && !(c = (J.ClassDeclaration)value).getLeadingAnnotations().isEmpty()) {
                        alignToAnnotation = true;
                    }
                    if (loc == Space.Location.MODIFIER_PREFIX && value instanceof J.MethodDeclaration && !(m = (J.MethodDeclaration)this.getCursor().getValue()).getLeadingAnnotations().isEmpty()) {
                        alignToAnnotation = true;
                    }
                }
            }
        }
        if (space.getComments().isEmpty() && !space.getLastWhitespace().contains("\n") || parent == null) {
            return space;
        }
        if (loc == Space.Location.METHOD_SELECT_SUFFIX && (chainedIndent = (Integer)this.getCursor().getParentTreeCursor().getMessage("chainedIndent")) != null) {
            this.getCursor().getParentTreeCursor().putMessage("lastIndent", (Object)chainedIndent);
            return this.indentTo(space, chainedIndent, loc);
        }
        int indent = (Integer)this.getCursor().getNearestMessage("lastIndent", (Object)0);
        IndentType indentType = (IndentType)((Object)parent.getNearestMessage("indentType", (Object)IndentType.ALIGN));
        boolean alignBlockPrefixToParent = loc.equals((Object)Space.Location.BLOCK_PREFIX) && space.getWhitespace().contains("\n") && value instanceof J.Block && !(this.getCursor().getParentTreeCursor().getValue() instanceof J.Block);
        boolean bl = alignBlockToParent = loc.equals((Object)Space.Location.BLOCK_END) || loc.equals((Object)Space.Location.NEW_ARRAY_INITIALIZER_SUFFIX) || loc.equals((Object)Space.Location.CATCH_PREFIX) || loc.equals((Object)Space.Location.TRY_FINALLY) || loc.equals((Object)Space.Location.ELSE_PREFIX);
        if (loc.equals((Object)Space.Location.EXTENDS) && space.getWhitespace().contains("\n") || Space.Location.EXTENDS.equals(this.getCursor().getParent().getMessage("lastLocation"))) {
            indentType = IndentType.CONTINUATION_INDENT;
        }
        if (alignBlockPrefixToParent || alignBlockToParent || alignToAnnotation) {
            indentType = IndentType.ALIGN;
        }
        switch (indentType) {
            case ALIGN: {
                break;
            }
            case INDENT: {
                indent += this.style.getIndentSize().intValue();
                break;
            }
            case CONTINUATION_INDENT: {
                indent += this.style.getContinuationIndent().intValue();
            }
        }
        Space s = this.indentTo(space, indent, loc);
        if (value instanceof J && !(value instanceof J.EnumValueSet)) {
            this.getCursor().putMessage("lastIndent", (Object)indent);
        } else if (loc == Space.Location.METHOD_SELECT_SUFFIX) {
            this.getCursor().getParentTreeCursor().putMessage("lastIndent", (Object)indent);
        }
        return s;
    }

    public <T> JLeftPadded<T> visitLeftPadded(@Nullable JLeftPadded<T> left, JLeftPadded.Location loc, P p) {
        if (loc == JLeftPadded.Location.VARIABLE_INITIALIZER || loc == JLeftPadded.Location.ASSIGNMENT) {
            this.getCursor().putMessage("indentType", (Object)(this.wrappingStyle.getExpressionBodyFunctions().getUseContinuationIndent() != false ? IndentType.CONTINUATION_INDENT : IndentType.INDENT));
        }
        return super.visitLeftPadded(left, loc, p);
    }

    public <T> JRightPadded<T> visitRightPadded(@Nullable JRightPadded<T> right, JRightPadded.Location loc, P p) {
        Space after;
        Object t;
        block30: {
            block27: {
                J elem;
                block29: {
                    int indent;
                    block28: {
                        if (right == null) {
                            return null;
                        }
                        this.setCursor(new Cursor(this.getCursor(), right));
                        t = right.getElement();
                        indent = (Integer)this.getCursor().getNearestMessage("lastIndent", (Object)0);
                        if (!(right.getElement() instanceof J)) break block27;
                        elem = (J)right.getElement();
                        if (!right.getAfter().getLastWhitespace().contains("\n") && !elem.getPrefix().getLastWhitespace().contains("\n")) break block28;
                        switch (loc) {
                            case FOR_CONDITION: 
                            case FOR_UPDATE: {
                                J.ForLoop.Control control = (J.ForLoop.Control)this.getCursor().getParentOrThrow().getValue();
                                Space initPrefix = Space.firstPrefix((List)control.getInit());
                                if (!initPrefix.getLastWhitespace().contains("\n")) {
                                    int initIndent = this.forInitColumn();
                                    this.getCursor().getParentOrThrow().putMessage("lastIndent", (Object)(initIndent - this.style.getContinuationIndent()));
                                    elem = (J)this.visitAndCast((Tree)elem, p);
                                    this.getCursor().getParentOrThrow().putMessage("lastIndent", (Object)indent);
                                    after = this.indentTo(right.getAfter(), initIndent, loc.getAfterLocation());
                                    break;
                                }
                                elem = (J)this.visitAndCast((Tree)elem, p);
                                after = this.visitSpace(right.getAfter(), loc.getAfterLocation(), p);
                                break;
                            }
                            case METHOD_DECLARATION_PARAMETER: 
                            case RECORD_STATE_VECTOR: {
                                JContainer container = (JContainer)this.getCursor().getParentOrThrow().getValue();
                                if (elem instanceof J.Empty) {
                                    elem = elem.withPrefix(this.indentTo(elem.getPrefix(), indent, loc.getAfterLocation()));
                                    after = right.getAfter();
                                    break;
                                }
                                List elements = container.getElements();
                                J firstArg = (J)elements.iterator().next();
                                J lastArg = (J)elements.get(elements.size() - 1);
                                if (this.style.getFunctionDeclarationParameters().getAlignWhenMultiple().booleanValue()) {
                                    J.MethodDeclaration method = (J.MethodDeclaration)this.getCursor().firstEnclosing(J.MethodDeclaration.class);
                                    if (method != null) {
                                        String source;
                                        int lineBreakIndex;
                                        int firstArgIndex;
                                        int alignTo = firstArg.getPrefix().getLastWhitespace().contains("\n") ? firstArg.getPrefix().getLastWhitespace().length() - 1 : firstArgIndex - ((lineBreakIndex = (source = method.print(this.getCursor())).lastIndexOf(10, firstArgIndex = source.indexOf(firstArg.print(this.getCursor())))) == -1 ? 0 : lineBreakIndex) - 1;
                                        this.getCursor().getParentOrThrow().putMessage("lastIndent", (Object)(alignTo - this.style.getContinuationIndent()));
                                        elem = (J)this.visitAndCast((Tree)elem, p);
                                        this.getCursor().getParentOrThrow().putMessage("lastIndent", (Object)indent);
                                        after = this.indentTo(right.getAfter(), t == lastArg ? indent : alignTo, loc.getAfterLocation());
                                        break;
                                    }
                                    after = right.getAfter();
                                    break;
                                }
                                elem = (J)this.visitAndCast((Tree)elem, p);
                                Integer indentSize = this.wrappingStyle.getFunctionDeclarationParameters().getUseContinuationIndent() != false ? this.style.getContinuationIndent() : this.style.getIndentSize();
                                after = this.indentTo(right.getAfter(), t == lastArg ? indent : indentSize, loc.getAfterLocation());
                                break;
                            }
                            case METHOD_INVOCATION_ARGUMENT: {
                                Cursor parent;
                                Cursor grandparent;
                                J body;
                                if (!elem.getPrefix().getLastWhitespace().contains("\n") && elem instanceof J.Lambda && !((body = ((J.Lambda)elem).getBody()) instanceof J.Binary) && !body.getPrefix().getLastWhitespace().contains("\n")) {
                                    this.getCursor().getParentOrThrow().putMessage("lastIndent", (Object)(indent + this.style.getContinuationIndent()));
                                }
                                elem = (J)this.visitAndCast((Tree)elem, p);
                                after = this.indentTo(right.getAfter(), indent, loc.getAfterLocation());
                                if ((!after.getComments().isEmpty() || after.getLastWhitespace().contains("\n")) && (grandparent = (parent = this.getCursor().getParentTreeCursor()).getParentTreeCursor()).getValue() instanceof J.MethodInvocation && ((J.MethodInvocation)grandparent.getValue()).getSelect() == parent.getValue()) {
                                    grandparent.putMessage("lastIndent", (Object)indent);
                                    grandparent.putMessage("chainedIndent", (Object)indent);
                                    break;
                                }
                                break block29;
                            }
                            case NEW_CLASS_ARGUMENTS: 
                            case ARRAY_INDEX: 
                            case PARENTHESES: 
                            case TYPE_PARAMETER: {
                                elem = (J)this.visitAndCast((Tree)elem, p);
                                after = this.indentTo(right.getAfter(), indent, loc.getAfterLocation());
                                break;
                            }
                            case ANNOTATION_ARGUMENT: {
                                JContainer args = (JContainer)this.getCursor().getParentOrThrow().getValue();
                                elem = (J)this.visitAndCast((Tree)elem, p);
                                if (args.getPadding().getElements().get(args.getElements().size() - 1) == right) {
                                    this.getCursor().getParentOrThrow().putMessage("indentType", (Object)IndentType.ALIGN);
                                }
                                after = this.visitSpace(right.getAfter(), loc.getAfterLocation(), p);
                                break;
                            }
                            default: {
                                elem = (J)this.visitAndCast((Tree)elem, p);
                                after = this.visitSpace(right.getAfter(), loc.getAfterLocation(), p);
                                break;
                            }
                        }
                        break block29;
                    }
                    switch (loc) {
                        case METHOD_INVOCATION_ARGUMENT: 
                        case NEW_CLASS_ARGUMENTS: {
                            int chainedIncrement = this.wrappingStyle.getChainedFunctionCalls().getUseContinuationIndent() != false ? this.style.getContinuationIndent() : this.style.getIndentSize();
                            if (!elem.getPrefix().getLastWhitespace().contains("\n")) {
                                JContainer args = (JContainer)this.getCursor().getParentOrThrow().getValue();
                                boolean anyOtherArgOnOwnLine = false;
                                for (JRightPadded arg : args.getPadding().getElements()) {
                                    if (arg == this.getCursor().getValue() || !((J)arg.getElement()).getPrefix().getLastWhitespace().contains("\n")) continue;
                                    anyOtherArgOnOwnLine = true;
                                    break;
                                }
                                if (!anyOtherArgOnOwnLine) {
                                    elem = (J)this.visitAndCast((Tree)elem, p);
                                    after = this.indentTo(right.getAfter(), indent, loc.getAfterLocation());
                                    break;
                                }
                            }
                            if (!(elem instanceof J.Binary) && !elem.getMarkers().findFirst(TrailingLambdaArgument.class).isPresent()) {
                                if (!(elem instanceof J.MethodInvocation)) {
                                    this.getCursor().putMessage("lastIndent", (Object)(indent + this.style.getContinuationIndent()));
                                } else if (elem.getPrefix().getLastWhitespace().contains("\n")) {
                                    this.getCursor().putMessage("lastIndent", (Object)(indent + chainedIncrement));
                                } else {
                                    J.MethodInvocation methodInvocation = (J.MethodInvocation)elem;
                                    Expression select = methodInvocation.getSelect();
                                    if (select instanceof J.FieldAccess || select instanceof J.Identifier || select instanceof J.MethodInvocation) {
                                        this.getCursor().putMessage("lastIndent", (Object)(indent + chainedIncrement));
                                    }
                                }
                            }
                            elem = (J)this.visitAndCast((Tree)elem, p);
                            after = this.visitSpace(right.getAfter(), loc.getAfterLocation(), p);
                            break;
                        }
                        default: {
                            elem = (J)this.visitAndCast((Tree)elem, p);
                            after = right.getAfter();
                        }
                    }
                }
                t = elem;
                break block30;
            }
            after = this.visitSpace(right.getAfter(), loc.getAfterLocation(), p);
        }
        this.setCursor(this.getCursor().getParent());
        return after == right.getAfter() && t == right.getElement() ? right : new JRightPadded(t, after, right.getMarkers());
    }

    public <J2 extends J> JContainer<J2> visitContainer(JContainer<J2> container, JContainer.Location loc, P p) {
        List js;
        Space before;
        this.setCursor(new Cursor(this.getCursor(), container));
        int indent = (Integer)this.getCursor().getNearestMessage("lastIndent", (Object)0);
        if (container.getBefore().getLastWhitespace().contains("\n")) {
            int increment;
            switch (loc) {
                case NEW_CLASS_ARGUMENTS: 
                case METHOD_INVOCATION_ARGUMENTS: {
                    increment = this.wrappingStyle.getFunctionCallArguments().getUseContinuationIndent() != false ? this.style.getContinuationIndent() : this.style.getIndentSize();
                    break;
                }
                default: {
                    increment = this.style.getContinuationIndent();
                }
            }
            switch (loc) {
                case NEW_CLASS_ARGUMENTS: 
                case METHOD_INVOCATION_ARGUMENTS: 
                case TYPE_PARAMETERS: 
                case IMPLEMENTS: 
                case THROWS: {
                    before = this.indentTo(container.getBefore(), indent + increment, loc.getBeforeLocation());
                    this.getCursor().putMessage("indentType", (Object)IndentType.ALIGN);
                    this.getCursor().putMessage("lastIndent", (Object)(indent + increment));
                    js = ListUtils.map((List)container.getPadding().getElements(), t -> this.visitRightPadded((JRightPadded)t, loc.getElementLocation(), p));
                    break;
                }
                default: {
                    before = this.visitSpace(container.getBefore(), loc.getBeforeLocation(), p);
                    js = ListUtils.map((List)container.getPadding().getElements(), t -> this.visitRightPadded((JRightPadded)t, loc.getElementLocation(), p));
                    break;
                }
            }
        } else {
            switch (loc) {
                case IMPLEMENTS: {
                    this.getCursor().putMessage("indentType", (Object)(this.wrappingStyle.getExtendsImplementsPermitsList().getUseContinuationIndent() != false ? IndentType.CONTINUATION_INDENT : IndentType.INDENT));
                    break;
                }
                case NEW_CLASS_ARGUMENTS: 
                case METHOD_INVOCATION_ARGUMENTS: {
                    this.getCursor().putMessage("indentType", (Object)(this.wrappingStyle.getFunctionCallArguments().getUseContinuationIndent() != false ? IndentType.CONTINUATION_INDENT : IndentType.INDENT));
                    break;
                }
                case TYPE_PARAMETERS: 
                case THROWS: {
                    this.getCursor().putMessage("indentType", (Object)IndentType.CONTINUATION_INDENT);
                }
            }
            before = this.visitSpace(container.getBefore(), loc.getBeforeLocation(), p);
            js = ListUtils.map((List)container.getPadding().getElements(), t -> this.visitRightPadded((JRightPadded)t, loc.getElementLocation(), p));
        }
        this.setCursor(this.getCursor().getParent());
        return js == container.getPadding().getElements() && before == container.getBefore() ? container : JContainer.build((Space)before, (List)js, (Markers)container.getMarkers());
    }

    private Space indentTo(Space space, int column, Space.Location spaceLocation) {
        Space s = space;
        String whitespace = s.getWhitespace();
        if (spaceLocation == Space.Location.COMPILATION_UNIT_PREFIX && !StringUtils.isNullOrEmpty((String)whitespace)) {
            s = s.withWhitespace("");
        } else if (s.getComments().isEmpty() && !s.getLastWhitespace().contains("\n")) {
            return s;
        }
        if (s.getComments().isEmpty()) {
            int indent = this.findIndent(s);
            if (indent != column) {
                int shift = column - indent;
                s = s.withWhitespace(this.indent(whitespace, shift));
            }
        } else {
            boolean hasFileLeadingComment = !space.getComments().isEmpty() && (spaceLocation == Space.Location.COMPILATION_UNIT_PREFIX || spaceLocation == Space.Location.CLASS_DECLARATION_PREFIX && ((Comment)space.getComments().get(0)).isMultiline());
            int finalColumn = spaceLocation == Space.Location.BLOCK_END ? column + this.style.getIndentSize() : column;
            String lastIndent = space.getWhitespace().substring(space.getWhitespace().lastIndexOf(10) + 1);
            int indent = this.getLengthOfWhitespace(StringUtils.indent((String)lastIndent));
            if (indent != finalColumn) {
                if (hasFileLeadingComment || whitespace.contains("\n") && (s.getComments().isEmpty() || !(s.getComments().get(0) instanceof TextComment) || ((Comment)s.getComments().get(0)).isMultiline() || this.getLengthOfWhitespace(s.getWhitespace()) != 0)) {
                    int shift = finalColumn - indent;
                    s = s.withWhitespace(whitespace.substring(0, whitespace.lastIndexOf(10) + 1) + this.indent(lastIndent, shift));
                }
                Space finalSpace = s;
                int lastCommentPos = s.getComments().size() - 1;
                s = s.withComments(ListUtils.map((List)s.getComments(), (i, c) -> {
                    if (c instanceof TextComment && !c.isMultiline() && i != lastCommentPos && this.getLengthOfWhitespace(c.getSuffix()) == 0) {
                        return c;
                    }
                    String priorSuffix = i == 0 ? space.getWhitespace() : ((Comment)finalSpace.getComments().get(i - 1)).getSuffix();
                    int toColumn = spaceLocation == Space.Location.BLOCK_END && i != finalSpace.getComments().size() - 1 ? column + this.style.getIndentSize() : column;
                    Comment c2 = c;
                    if (priorSuffix.contains("\n") || hasFileLeadingComment) {
                        c2 = this.indentComment((Comment)c, priorSuffix, toColumn);
                    }
                    if (c2.getSuffix().contains("\n")) {
                        int suffixIndent = this.getLengthOfWhitespace(c2.getSuffix());
                        int shift = toColumn - suffixIndent;
                        c2 = c2.withSuffix(this.indent(c2.getSuffix(), shift));
                    }
                    return c2;
                }));
            }
        }
        return s;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Comment indentComment(Comment comment, String priorSuffix, int column) {
        if (comment instanceof TextComment) {
            TextComment textComment = (TextComment)comment;
            if (!textComment.getText().contains("\n")) {
                return comment;
            }
            String margin = StringUtils.commonMargin(null, (CharSequence)priorSuffix);
            int indent = this.getLengthOfWhitespace(margin);
            int shift = column - indent;
            if (shift > 0) {
                String newMargin = this.indent(margin, shift);
                if (!textComment.isMultiline()) return comment;
                StringBuilder multiline = new StringBuilder();
                char[] chars = textComment.getText().toCharArray();
                for (int i2 = 0; i2 < chars.length; ++i2) {
                    char c = chars[i2];
                    if (c == '\n') {
                        multiline.append(c).append(newMargin);
                        i2 += margin.length();
                        continue;
                    }
                    multiline.append(c);
                }
                return textComment.withText(multiline.toString());
            }
            if (shift >= 0) return textComment;
            if (!textComment.isMultiline()) return comment;
            StringBuilder multiline = new StringBuilder();
            char[] chars = textComment.getText().toCharArray();
            for (int i3 = 0; i3 < chars.length; ++i3) {
                char c = chars[i3];
                if (c == '\n') {
                    multiline.append(c);
                    for (int j = 0; j < Math.abs(shift) && i3 + j + 1 < chars.length && (chars[j + i3 + 1] == ' ' || chars[j + i3 + 1] == '\t'); ++j) {
                        ++i3;
                    }
                    continue;
                }
                multiline.append(c);
            }
            return textComment.withText(multiline.toString());
        }
        if (!(comment instanceof Javadoc.DocComment)) return comment;
        Javadoc.DocComment docComment = (Javadoc.DocComment)comment;
        return docComment.withBody(ListUtils.map((List)docComment.getBody(), (i, jdoc) -> {
            if (!(jdoc instanceof Javadoc.LineBreak)) {
                return jdoc;
            }
            Javadoc.LineBreak lineBreak = (Javadoc.LineBreak)jdoc;
            String linebreak = lineBreak.getMargin().charAt(0) == '\r' ? "\r\n" : "\n";
            return lineBreak.withMargin(lineBreak.getMargin().replaceAll("^\\s+", this.indent(linebreak, column + 1)));
        }));
    }

    private String indent(String whitespace, int shift) {
        StringBuilder newWhitespace = new StringBuilder(whitespace);
        this.shift(newWhitespace, shift);
        return newWhitespace.toString();
    }

    private void shift(StringBuilder text, int shift) {
        int tabIndent = this.style.getTabSize();
        if (!this.style.getUseTabCharacter().booleanValue()) {
            tabIndent = Integer.MAX_VALUE;
        }
        if (shift > 0) {
            int i;
            for (i = 0; i < shift / tabIndent; ++i) {
                text.append('\t');
            }
            for (i = 0; i < shift % tabIndent; ++i) {
                text.append(' ');
            }
        } else {
            int len = this.style.getUseTabCharacter() != false ? text.length() + shift / tabIndent : text.length() + shift;
            if (len >= 0) {
                text.delete(len, text.length());
            }
        }
    }

    private int findIndent(Space space) {
        String indent = space.getIndent();
        return this.getLengthOfWhitespace(indent);
    }

    private int getLengthOfWhitespace(@Nullable String whitespace) {
        if (whitespace == null) {
            return 0;
        }
        int size = 0;
        for (int i = 0; i < whitespace.length(); ++i) {
            char c = whitespace.charAt(i);
            size += c == '\t' ? this.style.getTabSize() : 1;
            if (c != '\n' && c != '\r') continue;
            size = 0;
        }
        return size;
    }

    private int forInitColumn() {
        Cursor forCursor = this.getCursor().dropParentUntil(J.ForLoop.class::isInstance);
        J.ForLoop forLoop = (J.ForLoop)forCursor.getValue();
        Object parent = forCursor.getParentOrThrow().getValue();
        J.ForLoop alignTo = parent instanceof J.Label ? ((J.Label)parent).withStatement((Statement)forLoop.withBody(null)) : forLoop.withBody(null);
        int column = 0;
        boolean afterInitStart = false;
        for (char c : alignTo.print(this.getCursor()).toCharArray()) {
            if (c == '(') {
                afterInitStart = true;
            } else if (afterInitStart && !Character.isWhitespace(c)) {
                return column - 1;
            }
            ++column;
        }
        throw new IllegalStateException("For loops must have a control section");
    }

    @Nullable
    public J postVisit(J tree, P p) {
        if (this.stopAfter != null && this.stopAfter.isScope((Tree)tree)) {
            this.getCursor().putMessageOnFirstEnclosing(JavaSourceFile.class, "stop", (Object)true);
        }
        return (J)super.postVisit((Tree)tree, p);
    }

    @Nullable
    public J visit(@Nullable Tree tree, P p) {
        if (tree instanceof J && tree.getMarkers().findFirst(Implicit.class).isPresent()) {
            return (J)tree;
        }
        if (this.getCursor().getNearestMessage("stop") != null) {
            return (J)tree;
        }
        return (J)super.visit(tree, p);
    }

    private static enum IndentType {
        ALIGN,
        INDENT,
        CONTINUATION_INDENT;

    }
}

