/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kotlin.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.kotlin.com.intellij.lang.impl.TokenSequence;
import org.jetbrains.kotlin.com.intellij.lexer.Lexer;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.lexer.KotlinLexer;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.kotlin.internal.PsiToken;

public class PsiTree {
    private PsiFile psiFile;
    private String source;
    private Node root;
    private List<PsiToken> tokens;
    private Map<Integer, PsiToken> tokenOffSetMap;

    PsiTree(PsiFile psiFile, String source) {
        this.psiFile = psiFile;
        this.source = source;
        this.root = PsiTree.toTree((PsiElement)psiFile, null);
        this.expandRawPsiTree(this.root);
        this.tokenize(this.source);
    }

    public List<Node> findByCursor(int cursor) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        this.findByCursor(this.root, nodes, cursor);
        return nodes;
    }

    @Nullable
    private void findByCursor(Node node, List<Node> result, int cursor) {
        if (node.getRange().getStartOffset() == cursor) {
            result.add(node);
        }
        if (!node.getRange().contains(cursor)) {
            return;
        }
        for (Node childNode : node.getChildNodes()) {
            this.findByCursor(childNode, result, cursor);
        }
    }

    private static Node toNode(PsiElement psiElement, Node parentNode) {
        return new Node(psiElement.getTextRange(), psiElement.getNode().getElementType().toString(), parentNode, psiElement);
    }

    private static Node toTree(PsiElement psiElement, Node parentNode) {
        Node node = PsiTree.toNode(psiElement, parentNode);
        for (PsiElement childPsiElement : psiElement.getChildren()) {
            Node childNode = PsiTree.toTree(childPsiElement, node);
            node.getChildNodes().add(childNode);
        }
        return node;
    }

    private void expandRawPsiTree(Node node) {
        for (Node childNode : node.getChildNodes()) {
            this.expandRawPsiTree(childNode);
        }
        if (node.getParent() == null) {
            return;
        }
        List<Node> childNodes = node.getParent().getChildNodes();
        int leftBound = Integer.MAX_VALUE;
        int rightBound = -1;
        if (!childNodes.isEmpty()) {
            leftBound = childNodes.get(0).getRange().getStartOffset();
            rightBound = childNodes.get(childNodes.size() - 1).getRange().getStartOffset();
        }
        ArrayList<Node> nodesBefore = new ArrayList<Node>();
        ArrayList<Node> nodesAfter = new ArrayList<Node>();
        for (PsiElement preSibling = node.getPsiElement().getPrevSibling(); preSibling != null && preSibling.getTextRange().getStartOffset() < leftBound; preSibling = preSibling.getPrevSibling()) {
            nodesBefore.add(PsiTree.toNode(preSibling, node.getParent()));
        }
        Collections.reverse(nodesBefore);
        for (PsiElement nextSibling = node.getPsiElement().getNextSibling(); nextSibling != null && nextSibling.getTextRange().getStartOffset() > rightBound; nextSibling = nextSibling.getNextSibling()) {
            nodesAfter.add(PsiTree.toNode(nextSibling, node.getParent()));
        }
        if (!nodesBefore.isEmpty() || !nodesAfter.isEmpty()) {
            ArrayList<Node> newChildNodes = new ArrayList<Node>();
            newChildNodes.addAll(nodesBefore);
            newChildNodes.addAll(node.getParent().getChildNodes());
            newChildNodes.addAll(nodesAfter);
            node.getParent().setChildNodes(newChildNodes);
        }
    }

    private void tokenize(String sourceCode) {
        this.tokens = new ArrayList<PsiToken>();
        this.tokenOffSetMap = new HashMap<Integer, PsiToken>();
        KotlinLexer kotlinLexer = new KotlinLexer();
        TokenSequence tokenSequence = TokenSequence.performLexing((CharSequence)sourceCode, (Lexer)kotlinLexer);
        int tokenCount = tokenSequence.getTokenCount();
        PsiToken preToken = null;
        for (int i = 0; i < tokenCount; ++i) {
            int tokenStart = tokenSequence.getTokenStart(i);
            IElementType iElementType = tokenSequence.getTokenType(i);
            PsiToken token = new PsiToken();
            token.setRange(new TextRange(tokenStart, Integer.MAX_VALUE));
            token.setType(iElementType.toString());
            if (preToken != null) {
                preToken.setText(sourceCode.substring(preToken.getRange().getStartOffset(), tokenStart));
                TextRange newRange = new TextRange(preToken.getRange().getStartOffset(), tokenStart);
                preToken.setRange(newRange);
            }
            this.tokens.add(token);
            this.tokenOffSetMap.put(token.getRange().getStartOffset(), token);
            preToken = token;
        }
        if (preToken != null) {
            preToken.setText(sourceCode.substring(preToken.getRange().getStartOffset()));
            TextRange newRange = new TextRange(preToken.getRange().getStartOffset(), sourceCode.length());
            preToken.setRange(newRange);
        }
    }

    public PsiFile getPsiFile() {
        return this.psiFile;
    }

    public String getSource() {
        return this.source;
    }

    public Node getRoot() {
        return this.root;
    }

    public List<PsiToken> getTokens() {
        return this.tokens;
    }

    public Map<Integer, PsiToken> getTokenOffSetMap() {
        return this.tokenOffSetMap;
    }

    public void setPsiFile(PsiFile psiFile) {
        this.psiFile = psiFile;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setRoot(Node root) {
        this.root = root;
    }

    public void setTokens(List<PsiToken> tokens) {
        this.tokens = tokens;
    }

    public void setTokenOffSetMap(Map<Integer, PsiToken> tokenOffSetMap) {
        this.tokenOffSetMap = tokenOffSetMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PsiTree)) {
            return false;
        }
        PsiTree other = (PsiTree)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PsiFile this$psiFile = this.getPsiFile();
        PsiFile other$psiFile = other.getPsiFile();
        if (this$psiFile == null ? other$psiFile != null : !this$psiFile.equals(other$psiFile)) {
            return false;
        }
        String this$source = this.getSource();
        String other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        Node this$root = this.getRoot();
        Node other$root = other.getRoot();
        if (this$root == null ? other$root != null : !((Object)this$root).equals(other$root)) {
            return false;
        }
        List<PsiToken> this$tokens = this.getTokens();
        List<PsiToken> other$tokens = other.getTokens();
        if (this$tokens == null ? other$tokens != null : !((Object)this$tokens).equals(other$tokens)) {
            return false;
        }
        Map<Integer, PsiToken> this$tokenOffSetMap = this.getTokenOffSetMap();
        Map<Integer, PsiToken> other$tokenOffSetMap = other.getTokenOffSetMap();
        return !(this$tokenOffSetMap == null ? other$tokenOffSetMap != null : !((Object)this$tokenOffSetMap).equals(other$tokenOffSetMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PsiTree;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PsiFile $psiFile = this.getPsiFile();
        result = result * 59 + ($psiFile == null ? 43 : $psiFile.hashCode());
        String $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        Node $root = this.getRoot();
        result = result * 59 + ($root == null ? 43 : $root.hashCode());
        List<PsiToken> $tokens = this.getTokens();
        result = result * 59 + ($tokens == null ? 43 : ((Object)$tokens).hashCode());
        Map<Integer, PsiToken> $tokenOffSetMap = this.getTokenOffSetMap();
        result = result * 59 + ($tokenOffSetMap == null ? 43 : ((Object)$tokenOffSetMap).hashCode());
        return result;
    }

    public String toString() {
        return "PsiTree(psiFile=" + this.getPsiFile() + ", source=" + this.getSource() + ", root=" + this.getRoot() + ", tokens=" + this.getTokens() + ", tokenOffSetMap=" + this.getTokenOffSetMap() + ")";
    }

    public static class Node {
        TextRange range;
        String type;
        List<Node> childNodes;
        @Nullable
        Node parent;
        PsiElement psiElement;

        public Node(TextRange range, String type, @Nullable Node parent, PsiElement psiElement) {
            this.range = range;
            this.type = type;
            this.psiElement = psiElement;
            this.childNodes = new ArrayList<Node>();
            this.parent = parent;
        }

        public String toString() {
            return this.range + " type:" + this.type;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Node other = (Node)obj;
            return this.range.equals((Object)other.range) && this.type.equals(other.getType());
        }

        public TextRange getRange() {
            return this.range;
        }

        public String getType() {
            return this.type;
        }

        public List<Node> getChildNodes() {
            return this.childNodes;
        }

        public Node getParent() {
            return this.parent;
        }

        public PsiElement getPsiElement() {
            return this.psiElement;
        }

        public void setRange(TextRange range) {
            this.range = range;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setChildNodes(List<Node> childNodes) {
            this.childNodes = childNodes;
        }

        public void setParent(Node parent) {
            this.parent = parent;
        }

        public void setPsiElement(PsiElement psiElement) {
            this.psiElement = psiElement;
        }
    }
}

