/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kotlin.format;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.List;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.marker.ImplicitReturn;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.Javadoc;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.kotlin.KotlinIsoVisitor;
import org.openrewrite.kotlin.marker.Extension;
import org.openrewrite.kotlin.marker.Implicit;
import org.openrewrite.kotlin.marker.PrimaryConstructor;
import org.openrewrite.kotlin.marker.Semicolon;
import org.openrewrite.kotlin.tree.K;

public class MinimumViableSpacingVisitor<P>
extends KotlinIsoVisitor<P> {
    @Nullable
    private final Tree stopAfter;

    @JsonCreator
    public MinimumViableSpacingVisitor(@Nullable Tree stopAfter) {
        this.stopAfter = stopAfter;
    }

    public MinimumViableSpacingVisitor() {
        this(null);
    }

    @Override
    public K.CompilationUnit visitCompilationUnit(K.CompilationUnit cu, P p) {
        J kcu = super.visitCompilationUnit(cu, (Object)p);
        kcu = kcu.getPadding().withStatements(this.visitStatementList(kcu.getPadding().getStatements()));
        return kcu;
    }

    @Override
    public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, P p) {
        Space before;
        J.ClassDeclaration.Padding padding;
        JContainer typeParameters;
        boolean hasFinalModifierOnly;
        J.ClassDeclaration c = super.visitClassDeclaration(classDecl, p);
        boolean first = c.getLeadingAnnotations().isEmpty();
        boolean bl = hasFinalModifierOnly = c.getModifiers().size() == 1 && ((J.Modifier)c.getModifiers().get(0)).getType() == J.Modifier.Type.Final;
        if (!hasFinalModifierOnly && !c.getModifiers().isEmpty()) {
            if (!first && Space.firstPrefix((List)c.getModifiers()).getWhitespace().isEmpty()) {
                c = c.withModifiers(Space.formatFirstPrefix((List)c.getModifiers(), (Space)((J.Modifier)c.getModifiers().iterator().next()).getPrefix().withWhitespace(" ")));
            }
            if (c.getModifiers().size() > 1) {
                c = c.withModifiers(ListUtils.map((List)c.getModifiers(), (index, modifier) -> {
                    if (index > 0 && modifier.getPrefix().getWhitespace().isEmpty() && modifier.getType() != J.Modifier.Type.Final) {
                        return modifier.withPrefix(modifier.getPrefix().withWhitespace(" "));
                    }
                    return modifier;
                }));
            }
            first = false;
        }
        if (c.getPadding().getKind().getPrefix().isEmpty()) {
            if (!first) {
                c = c.getPadding().withKind(c.getPadding().getKind().withPrefix(c.getPadding().getKind().getPrefix().withWhitespace(" ")));
            }
            first = false;
        }
        if (!first && !c.getName().getMarkers().findFirst(Implicit.class).isPresent() && c.getName().getPrefix().getWhitespace().isEmpty()) {
            c = c.withName(c.getName().withPrefix(c.getName().getPrefix().withWhitespace(" ")));
        }
        if (!((typeParameters = (padding = c.getPadding()).getTypeParameters()) == null || typeParameters.getElements().isEmpty() || first || typeParameters.getBefore().getWhitespace().isEmpty())) {
            c = padding.withTypeParameters(typeParameters.withBefore(typeParameters.getBefore().withWhitespace(" ")));
        }
        if (c.getPadding().getExtends() != null && (before = c.getPadding().getExtends().getBefore()).getWhitespace().isEmpty()) {
            c = c.getPadding().withExtends(c.getPadding().getExtends().withBefore(before.withWhitespace(" ")));
        }
        c = c.withBody(c.getBody().withStatements(ListUtils.map((List)c.getBody().getStatements(), (i, st) -> i != 0 ? (Statement)st.withPrefix(this.addNewline(st.getPrefix())) : st)));
        return c;
    }

    private Space addNewline(Space prefix) {
        if (prefix.getComments().isEmpty() || prefix.getWhitespace().contains("\n") || prefix.getComments().get(0) instanceof Javadoc || ((Comment)prefix.getComments().get(0)).isMultiline() && ((Comment)prefix.getComments().get(0)).printComment(this.getCursor()).contains("\n")) {
            return prefix.withWhitespace(this.minimumLines(prefix.getWhitespace()));
        }
        return prefix.withComments(ListUtils.map((List)prefix.getComments(), (i, c) -> i == 0 ? c.withSuffix(this.minimumLines(c.getSuffix())) : c));
    }

    private String minimumLines(String whitespace) {
        String minWhitespace = whitespace;
        if (MinimumViableSpacingVisitor.getNewLineCount(whitespace) == 0) {
            minWhitespace = "\n" + minWhitespace;
        }
        return minWhitespace;
    }

    private static int getNewLineCount(String whitespace) {
        int newLineCount = 0;
        for (char c : whitespace.toCharArray()) {
            if (c != '\n') continue;
            ++newLineCount;
        }
        return newLineCount;
    }

    @Override
    public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, P p) {
        Space before;
        J.TypeParameters typeParameters;
        J.MethodDeclaration m = super.visitMethodDeclaration(method, p);
        if (m.getMarkers().findFirst(PrimaryConstructor.class).isPresent()) {
            return m;
        }
        boolean first = m.getLeadingAnnotations().isEmpty();
        if (!m.getModifiers().isEmpty()) {
            int startPosition;
            boolean firstFinal = ((J.Modifier)m.getModifiers().get(0)).getType() == J.Modifier.Type.Final;
            int n = startPosition = firstFinal ? 1 : 0;
            if (!first && !firstFinal && Space.firstPrefix((List)m.getModifiers()).getWhitespace().isEmpty()) {
                m = m.withModifiers(Space.formatFirstPrefix((List)m.getModifiers(), (Space)((J.Modifier)m.getModifiers().iterator().next()).getPrefix().withWhitespace(" ")));
            }
            if (m.getModifiers().size() > 1) {
                m = m.withModifiers(ListUtils.map((List)m.getModifiers(), (index, modifier) -> {
                    if (index > startPosition && modifier.getType() != J.Modifier.Type.Final && modifier.getPrefix().getWhitespace().isEmpty()) {
                        return modifier.withPrefix(modifier.getPrefix().withWhitespace(" "));
                    }
                    return modifier;
                }));
            }
            first = false;
        }
        if ((typeParameters = m.getAnnotations().getTypeParameters()) != null && !typeParameters.getTypeParameters().isEmpty()) {
            if (!first && typeParameters.getPrefix().getWhitespace().isEmpty()) {
                m = m.getAnnotations().withTypeParameters(typeParameters.withPrefix(typeParameters.getPrefix().withWhitespace(" ")));
            }
            first = false;
        }
        if (m.getReturnTypeExpression() != null && m.getReturnTypeExpression().getPrefix().getWhitespace().isEmpty()) {
            TypeTree returnTypeExpression;
            if (!first && (returnTypeExpression = m.getReturnTypeExpression()) instanceof J.AnnotatedType) {
                J.AnnotatedType annotatedType = (J.AnnotatedType)returnTypeExpression;
                List annotations = ListUtils.mapFirst((List)annotatedType.getAnnotations(), annotation -> annotation.withPrefix(annotation.getPrefix().withWhitespace(" ")));
                m = m.withReturnTypeExpression((TypeTree)annotatedType.withAnnotations(annotations));
            }
            first = false;
        }
        boolean hasReceiverType = method.getMarkers().findFirst(Extension.class).isPresent();
        if (!first && !hasReceiverType) {
            m = m.withName(m.getName().withPrefix(MinimumViableSpacingVisitor.updateSpace(m.getName().getPrefix(), true)));
        }
        if (m.getPadding().getThrows() != null && (before = m.getPadding().getThrows().getBefore()).getWhitespace().isEmpty()) {
            m = m.getPadding().withThrows(m.getPadding().getThrows().withBefore(before.withWhitespace(" ")));
        }
        return m;
    }

    @Override
    public J.Block visitBlock(J.Block block, P p) {
        J.Block b = super.visitBlock(block, p);
        b = b.getPadding().withStatements(this.visitStatementList(b.getPadding().getStatements()));
        return b;
    }

    private List<JRightPadded<Statement>> visitStatementList(List<JRightPadded<Statement>> statements) {
        return ListUtils.map(statements, (i, st) -> {
            Statement element = (Statement)st.getElement();
            if (i == 0 || element.getPrefix().getWhitespace().contains("\n") || element.getPrefix().getLastWhitespace().contains("\n") || ((JRightPadded)statements.get(i - 1)).getMarkers().findFirst(Semicolon.class).isPresent()) {
                return st;
            }
            return st.withElement((Object)((Statement)element.withPrefix(this.addNewline(element.getPrefix()))));
        });
    }

    @Override
    public J.Return visitReturn(J.Return return_, P p) {
        J.Return r = super.visitReturn(return_, p);
        if (r.getExpression() != null && r.getExpression().getPrefix().getWhitespace().isEmpty() && !return_.getMarkers().findFirst(ImplicitReturn.class).isPresent()) {
            r = r.withExpression((Expression)r.getExpression().withPrefix(r.getExpression().getPrefix().withWhitespace(" ")));
        }
        return r;
    }

    @Override
    public K.Binary visitBinary(K.Binary binary, P p) {
        J kb = super.visitBinary(binary, (Object)p);
        if (kb.getOperator() == K.Binary.Type.Contains || kb.getOperator() == K.Binary.Type.NotContains) {
            kb = kb.getPadding().withOperator((JLeftPadded<K.Binary.Type>)kb.getPadding().getOperator().withBefore(MinimumViableSpacingVisitor.updateSpace(kb.getPadding().getOperator().getBefore(), true)));
            kb = kb.withRight(MinimumViableSpacingVisitor.spaceBefore(kb.getRight(), true));
        }
        return kb;
    }

    @Override
    public J.If visitIf(J.If iff, P p) {
        J.If updatedIff = super.visitIf(iff, p);
        if (updatedIff.getElsePart() != null) {
            updatedIff = updatedIff.withElsePart(MinimumViableSpacingVisitor.spaceBefore(updatedIff.getElsePart(), true));
            updatedIff = updatedIff.withElsePart(updatedIff.getElsePart().withBody(MinimumViableSpacingVisitor.spaceBefore(updatedIff.getElsePart().getBody(), true)));
        }
        return updatedIff;
    }

    @Override
    public J.ForEachLoop.Control visitForEachControl(J.ForEachLoop.Control control, P p) {
        J.ForEachLoop.Control c = super.visitForEachControl(control, p);
        c = c.getPadding().withVariable(c.getPadding().getVariable().withAfter(MinimumViableSpacingVisitor.updateSpace(c.getPadding().getVariable().getAfter(), true)));
        c = c.withIterable(MinimumViableSpacingVisitor.spaceBefore(c.getIterable(), true));
        return c;
    }

    @Override
    public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, P p) {
        J.VariableDeclarations v = super.visitVariableDeclarations(multiVariable, p);
        boolean first = v.getLeadingAnnotations().isEmpty();
        if (!v.getModifiers().isEmpty()) {
            boolean needFirstSpace = !first;
            v = v.withModifiers(ListUtils.map((List)v.getModifiers(), (index, modifier) -> {
                if ((index != 0 || needFirstSpace) && modifier.getPrefix().getWhitespace().isEmpty()) {
                    modifier = modifier.withPrefix(modifier.getPrefix().withWhitespace(" "));
                }
                return modifier;
            }));
        }
        J firstEnclosing = (J)this.getCursor().getParentOrThrow().firstEnclosing(J.class);
        if (!v.getVariables().isEmpty() && !(firstEnclosing instanceof J.Lambda)) {
            boolean extension = v.getMarkers().findFirst(Extension.class).isPresent();
            if (((J.VariableDeclarations.NamedVariable)v.getVariables().get(0)).getPrefix().getWhitespace().isEmpty() && !v.getModifiers().isEmpty() && !extension) {
                v = v.withVariables(ListUtils.mapFirst((List)v.getVariables(), v0 -> v0.withName(v0.getName().withPrefix(v0.getName().getPrefix().withWhitespace(" ")))));
            }
        }
        return v;
    }

    @Nullable
    public J postVisit(J tree, P p) {
        if (this.stopAfter != null && this.stopAfter.isScope((Tree)tree)) {
            this.getCursor().putMessageOnFirstEnclosing(JavaSourceFile.class, "stop", (Object)true);
        }
        return (J)super.postVisit((Tree)tree, p);
    }

    @Nullable
    public J visit(@Nullable Tree tree, P p) {
        if (this.getCursor().getNearestMessage("stop") != null) {
            return (J)tree;
        }
        return (J)super.visit(tree, p);
    }

    private static <T extends J> T spaceBefore(T j, boolean spaceBefore) {
        if (!j.getComments().isEmpty()) {
            return j;
        }
        if (spaceBefore && MinimumViableSpacingVisitor.notSingleSpace(j.getPrefix().getWhitespace())) {
            return (T)j.withPrefix(j.getPrefix().withWhitespace(" "));
        }
        if (!spaceBefore && MinimumViableSpacingVisitor.onlySpacesAndNotEmpty(j.getPrefix().getWhitespace())) {
            return (T)j.withPrefix(j.getPrefix().withWhitespace(""));
        }
        return j;
    }

    private static Space updateSpace(Space s, boolean haveSpace) {
        if (!s.getComments().isEmpty()) {
            return s;
        }
        if (haveSpace && MinimumViableSpacingVisitor.notSingleSpace(s.getWhitespace())) {
            return s.withWhitespace(" ");
        }
        if (!haveSpace && MinimumViableSpacingVisitor.onlySpacesAndNotEmpty(s.getWhitespace())) {
            return s.withWhitespace("");
        }
        return s;
    }

    private static boolean onlySpaces(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == ' ' || c == '\t') continue;
            return false;
        }
        return true;
    }

    private static boolean onlySpacesAndNotEmpty(String s) {
        return !StringUtils.isNullOrEmpty((String)s) && MinimumViableSpacingVisitor.onlySpaces(s);
    }

    private static boolean notSingleSpace(String str) {
        return MinimumViableSpacingVisitor.onlySpaces(str) && !" ".equals(str);
    }
}

