/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kotlin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.ParseExceptionResult;
import org.openrewrite.Parser;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.internal.ThrowingConsumer;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.search.FindMissingTypes;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Javadoc;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TextComment;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.kotlin.KotlinIsoVisitor;
import org.openrewrite.kotlin.KotlinParser;
import org.openrewrite.kotlin.marker.AnnotationUseSite;
import org.openrewrite.kotlin.marker.Extension;
import org.openrewrite.kotlin.marker.IndexedAccess;
import org.openrewrite.kotlin.tree.K;
import org.openrewrite.kotlin.tree.KSpace;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.test.SourceSpec;
import org.openrewrite.test.SourceSpecs;
import org.openrewrite.test.TypeValidation;
import org.openrewrite.test.UncheckedConsumer;
import org.opentest4j.AssertionFailedError;

public final class Assertions {
    private Assertions() {
    }

    public static SourceFile validateTypes(SourceFile source, TypeValidation typeValidation) {
        if (source instanceof JavaSourceFile) {
            Assertions.assertValidTypes(typeValidation, (J)((JavaSourceFile)source));
        }
        return source;
    }

    static void customizeExecutionContext(ExecutionContext ctx) {
        if (ctx.getMessage("org.openrewrite.kotlin.skipSourceSetTypeGeneration") == null) {
            ctx.putMessage("org.openrewrite.kotlin.skipSourceSetTypeGeneration", (Object)true);
        }
    }

    @Nullable
    private static String adjustSpaces(@Nullable String input) {
        if (input == null) {
            return null;
        }
        StringBuilder out = new StringBuilder();
        int count = 0;
        int limit = 1;
        char pre = '\u0000';
        for (char c : input.toCharArray()) {
            if (c == ' ') {
                if (pre == ' ') {
                    if (++count <= limit) {
                        out.append(c);
                    }
                } else {
                    ++count;
                    out.append(c);
                }
            } else {
                if (pre == ' ') {
                    for (int i = count; i < limit; ++i) {
                        out.append(' ');
                    }
                    count = 0;
                    if (++limit > 5) {
                        limit = 1;
                    }
                }
                out.append(c);
            }
            pre = c;
        }
        return out.toString();
    }

    public static SourceSpecs kotlin(@Nullable @Language(value="kotlin") String before) {
        return Assertions.kotlin(before, (SourceSpec<K.CompilationUnit> s) -> {});
    }

    public static SourceSpecs kotlinScript(@Nullable @Language(value="kts") String before) {
        return Assertions.kotlinScript(before, s -> {});
    }

    public static SourceSpecs kotlin(@Nullable @Language(value="kotlin") String before, Consumer<SourceSpec<K.CompilationUnit>> spec) {
        SourceSpec kotlin = new SourceSpec(K.CompilationUnit.class, null, (Parser.Builder)KotlinParser.builder(), before, Assertions::validateTypes, Assertions::customizeExecutionContext);
        Assertions.acceptSpec(spec, (SourceSpec<K.CompilationUnit>)kotlin);
        return kotlin;
    }

    public static SourceSpecs kotlinScript(@Nullable @Language(value="kts") String before, Consumer<SourceSpec<K.CompilationUnit>> spec) {
        SourceSpec kotlinScript = new SourceSpec(K.CompilationUnit.class, null, (Parser.Builder)KotlinParser.builder().isKotlinScript(true), before, Assertions::validateTypes, Assertions::customizeExecutionContext);
        Assertions.acceptSpec(spec, (SourceSpec<K.CompilationUnit>)kotlinScript);
        return kotlinScript;
    }

    public static SourceSpecs kotlin(@Nullable @Language(value="kotlin") String before, @Language(value="kotlin") String after) {
        return Assertions.kotlin(before, after, s -> {});
    }

    public static SourceSpecs kotlin(@Nullable @Language(value="kotlin") String before, @Language(value="kotlin") String after, Consumer<SourceSpec<K.CompilationUnit>> spec) {
        SourceSpec kotlin = new SourceSpec(K.CompilationUnit.class, null, (Parser.Builder)KotlinParser.builder(), before, Assertions::validateTypes, Assertions::customizeExecutionContext).after(s -> after);
        Assertions.acceptSpec(spec, (SourceSpec<K.CompilationUnit>)kotlin);
        return kotlin;
    }

    public static SourceSpecs srcMainKotlin(Consumer<SourceSpec<SourceFile>> spec, SourceSpecs ... kotlinSources) {
        return SourceSpecs.dir((String)"src/main/kotlin", spec, (SourceSpecs[])kotlinSources);
    }

    public static SourceSpecs srcMainKotlin(SourceSpecs ... kotlinSources) {
        return Assertions.srcMainKotlin((SourceSpec<SourceFile> spec) -> org.openrewrite.java.Assertions.sourceSet((SourceSpec)spec, (String)"main"), kotlinSources);
    }

    public static SourceSpecs srcTestKotlin(Consumer<SourceSpec<SourceFile>> spec, SourceSpecs ... kotlinSources) {
        return SourceSpecs.dir((String)"src/test/kotlin", spec, (SourceSpecs[])kotlinSources);
    }

    public static SourceSpecs srcTestKotlin(SourceSpecs ... kotlinSources) {
        return Assertions.srcTestKotlin((SourceSpec<SourceFile> spec) -> org.openrewrite.java.Assertions.sourceSet((SourceSpec)spec, (String)"test"), kotlinSources);
    }

    private static void acceptSpec(Consumer<SourceSpec<K.CompilationUnit>> spec, SourceSpec<K.CompilationUnit> kotlin) {
        Consumer consumer = kotlin.getAfterRecipe().andThen(Assertions.isFullyParsed());
        kotlin.afterRecipe(consumer::accept);
        spec.accept(kotlin);
    }

    public static ThrowingConsumer<K.CompilationUnit> isFullyParsed() {
        return cu -> new KotlinIsoVisitor<Integer>(){

            public J visitUnknownSource(J.Unknown.Source source, Integer integer) {
                Optional result = source.getMarkers().findFirst(ParseExceptionResult.class);
                if (result.isPresent()) {
                    System.out.println(((ParseExceptionResult)result.get()).getMessage());
                    throw new AssertionFailedError("Parsing error, J.Unknown detected");
                }
                throw new UnsupportedOperationException("A J.Unknown should always have a parse exception result.");
            }

            public Space visitSpace(Space space, Space.Location loc, Integer integer) {
                if (!space.getWhitespace().trim().isEmpty()) {
                    throw new AssertionFailedError("Parsing error detected, whitespace contains non-whitespace characters: " + space.getWhitespace());
                }
                return super.visitSpace(space, loc, (Object)integer);
            }
        }.visit((Tree)cu, 0);
    }

    public static UncheckedConsumer<SourceSpec<?>> spaceConscious() {
        return source -> {
            if (source.getSourceFileType() == K.CompilationUnit.class) {
                SourceSpec kotlinSourceSpec = source;
                kotlinSourceSpec.afterRecipe(Assertions.spaceConscious((SourceSpec<K.CompilationUnit>)kotlinSourceSpec));
            }
        };
    }

    private static void assertValidTypes(TypeValidation typeValidation, J sf) {
        if (typeValidation.identifiers() || typeValidation.methodInvocations() || typeValidation.methodDeclarations() || typeValidation.classDeclarations() || typeValidation.constructorInvocations()) {
            List<Object> missingTypeResults = Assertions.findMissingTypes(sf);
            if (!(missingTypeResults = missingTypeResults.stream().filter(missingType -> {
                if (missingType.getJ() instanceof J.Identifier) {
                    return typeValidation.identifiers();
                }
                if (missingType.getJ() instanceof J.ClassDeclaration) {
                    return typeValidation.classDeclarations();
                }
                if (missingType.getJ() instanceof J.MethodInvocation || missingType.getJ() instanceof J.MemberReference) {
                    return typeValidation.methodInvocations();
                }
                if (missingType.getJ() instanceof J.NewClass) {
                    return typeValidation.constructorInvocations();
                }
                if (missingType.getJ() instanceof J.MethodDeclaration) {
                    return typeValidation.methodDeclarations();
                }
                if (missingType.getJ() instanceof J.VariableDeclarations.NamedVariable) {
                    return typeValidation.variableDeclarations();
                }
                return true;
            }).collect(Collectors.toList())).isEmpty()) {
                throw new IllegalStateException("LST contains missing or invalid type information\n" + missingTypeResults.stream().map(v -> v.getPath() + "\n" + v.getPrintedTree()).collect(Collectors.joining("\n\n")));
            }
        }
    }

    public static ThrowingConsumer<K.CompilationUnit> spaceConscious(SourceSpec<K.CompilationUnit> spec) {
        return cu -> {
            K.CompilationUnit visited = (K.CompilationUnit)new KotlinIsoVisitor<Integer>(){
                int id = 0;

                @Override
                public Space visitSpace(Space space, KSpace.Location loc, Integer integer) {
                    return this.next(space);
                }

                @NotNull
                private Space next(Space space) {
                    if (!space.getComments().isEmpty()) {
                        return space;
                    }
                    return space.withComments(Collections.singletonList(new TextComment(true, Integer.toString(this.id++), "", Markers.EMPTY)));
                }

                public Space visitSpace(Space space, Space.Location loc, Integer integer) {
                    Cursor parentCursor = this.getCursor().getParentOrThrow();
                    if (loc == Space.Location.IDENTIFIER_PREFIX && parentCursor.getValue() instanceof J.Annotation) {
                        return space;
                    }
                    if (loc == Space.Location.IDENTIFIER_PREFIX && parentCursor.getValue() instanceof J.Break && ((J.Break)parentCursor.getValue()).getLabel() == this.getCursor().getValue()) {
                        return space;
                    }
                    if (loc == Space.Location.IDENTIFIER_PREFIX && parentCursor.getValue() instanceof K.KReturn && ((K.KReturn)parentCursor.getValue()).getLabel() == this.getCursor().getValue()) {
                        return space;
                    }
                    if (loc == Space.Location.LABEL_SUFFIX) {
                        return space;
                    }
                    if (this.getCursor().firstEnclosing(J.Import.class) != null) {
                        return space;
                    }
                    if (this.getCursor().firstEnclosing(J.Package.class) != null) {
                        return space;
                    }
                    return this.next(space);
                }
            }.visit((Tree)cu, 0);
            try {
                String s = visited.printAll();
                InMemoryExecutionContext ctx = new InMemoryExecutionContext();
                ctx.putMessage("org.openrewrite.requirePrintEqualsInput", (Object)false);
                SourceFile cu2 = (SourceFile)spec.getParser().build().parse((ExecutionContext)ctx, new String[]{s}).findFirst().get();
                String s1 = cu2.printAll();
                org.junit.jupiter.api.Assertions.assertEquals((Object)s, (Object)s1, (String)"Parser is not whitespace print idempotent");
            }
            catch (Exception e) {
                org.junit.jupiter.api.Assertions.fail((Throwable)e);
            }
        };
    }

    public static List<FindMissingTypes.MissingTypeResult> findMissingTypes(J j) {
        J j1 = (J)new FindMissingTypesVisitor().visit((Tree)j, new InMemoryExecutionContext());
        ArrayList<FindMissingTypes.MissingTypeResult> results = new ArrayList<FindMissingTypes.MissingTypeResult>();
        if (j1 != j) {
            new KotlinIsoVisitor<List<FindMissingTypes.MissingTypeResult>>(){

                @Override
                public <M extends Marker> M visitMarker(Marker marker, List<FindMissingTypes.MissingTypeResult> missingTypeResults) {
                    if (marker instanceof SearchResult) {
                        String message = ((SearchResult)marker).getDescription();
                        String path = this.getCursor().getPathAsStream(j -> j instanceof J || j instanceof Javadoc).map(t -> t.getClass().getSimpleName()).collect(Collectors.joining("->"));
                        J j2 = (J)this.getCursor().firstEnclosing(J.class);
                        String printedTree = this.getCursor().firstEnclosing(JavaSourceFile.class) != null ? (j2 != null ? j2.printTrimmed((Object)new InMemoryExecutionContext(), this.getCursor().getParentOrThrow()) : "") : String.valueOf(j2);
                        missingTypeResults.add(new FindMissingTypes.MissingTypeResult(message, path, printedTree, j2));
                    }
                    return super.visitMarker(marker, missingTypeResults);
                }
            }.visit((Tree)j1, results);
        }
        return results;
    }

    static class FindMissingTypesVisitor
    extends KotlinIsoVisitor<ExecutionContext> {
        private final Set<JavaType> seenTypes = new HashSet<JavaType>();

        FindMissingTypesVisitor() {
        }

        @Override
        public J.Identifier visitIdentifier(J.Identifier identifier, ExecutionContext ctx) {
            if (!TypeUtils.isWellFormedType((JavaType)identifier.getType(), this.seenTypes) && !this.isAllowedToHaveNullType(identifier) && this.isValidated(identifier)) {
                identifier = (J.Identifier)SearchResult.found((Tree)identifier, (String)"Identifier type is missing or malformed");
            }
            if (identifier.getFieldType() != null && !identifier.getSimpleName().equals(identifier.getFieldType().getName()) && this.isNotDestructType(identifier.getFieldType())) {
                identifier = (J.Identifier)SearchResult.found((Tree)identifier, (String)("type information has a different variable name '" + identifier.getFieldType().getName() + "'"));
            }
            return identifier;
        }

        @Override
        public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, ExecutionContext ctx) {
            J.VariableDeclarations.NamedVariable v = super.visitVariable(variable, ctx);
            if (v == variable) {
                JavaType.Variable variableType2 = v.getVariableType();
                if (!TypeUtils.isWellFormedType((JavaType)variableType2, this.seenTypes) && !this.isAllowedToHaveUnknownType()) {
                    if (this.isValidated(variable)) {
                        v = (J.VariableDeclarations.NamedVariable)SearchResult.found((Tree)v, (String)"Variable type is missing or malformed");
                    }
                } else if (variableType2 != null && !variableType2.getName().equals(v.getSimpleName()) && this.isNotDestructType(variableType2)) {
                    v = (J.VariableDeclarations.NamedVariable)SearchResult.found((Tree)v, (String)("type information has a different variable name '" + variableType2.getName() + "'"));
                }
            }
            return v;
        }

        private boolean isAllowedToHaveUnknownType() {
            Cursor parent2;
            for (parent2 = this.getCursor().getParent(); parent2 != null && parent2.getParent() != null && !(parent2.getParentTreeCursor().getValue() instanceof J.ClassDeclaration); parent2 = parent2.getParentTreeCursor()) {
            }
            return parent2 != null && parent2.getValue() instanceof J.Block;
        }

        @Override
        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J.MethodInvocation mi = super.visitMethodInvocation(method, ctx);
            if (mi == method) {
                JavaType.Method type2 = mi.getMethodType();
                if (!TypeUtils.isWellFormedType((JavaType)type2, this.seenTypes)) {
                    mi = (J.MethodInvocation)SearchResult.found((Tree)mi, (String)"MethodInvocation type is missing or malformed");
                } else if (!type2.getName().equals(mi.getSimpleName()) && !type2.isConstructor() && this.isValidated(mi)) {
                    mi = (J.MethodInvocation)SearchResult.found((Tree)mi, (String)("type information has a different method name '" + type2.getName() + "'"));
                }
                if (mi.getName().getType() != null && type2 != mi.getName().getType()) {
                    mi = (J.MethodInvocation)SearchResult.found((Tree)mi, (String)"MethodInvocation#name type is not the MethodType of MethodInvocation.");
                }
            }
            return mi;
        }

        @Override
        public J.MemberReference visitMemberReference(J.MemberReference memberRef, ExecutionContext ctx) {
            J.MemberReference mr = super.visitMemberReference(memberRef, ctx);
            JavaType.Method type2 = mr.getMethodType();
            if (type2 != null) {
                if (!TypeUtils.isWellFormedType((JavaType)type2, this.seenTypes)) {
                    mr = (J.MemberReference)SearchResult.found((Tree)mr, (String)"MemberReference type is missing or malformed");
                } else if (!type2.getName().equals(mr.getReference().getSimpleName()) && !type2.isConstructor()) {
                    mr = (J.MemberReference)SearchResult.found((Tree)mr, (String)("type information has a different method name '" + type2.getName() + "'"));
                }
            } else {
                JavaType.Variable variableType2 = mr.getVariableType();
                if (!TypeUtils.isWellFormedType((JavaType)variableType2, this.seenTypes)) {
                    if (!"class".equals(mr.getReference().getSimpleName())) {
                        mr = (J.MemberReference)SearchResult.found((Tree)mr, (String)"MemberReference type is missing or malformed");
                    }
                } else if (!variableType2.getName().equals(mr.getReference().getSimpleName())) {
                    mr = (J.MemberReference)SearchResult.found((Tree)mr, (String)("type information has a different variable name '" + variableType2.getName() + "'"));
                }
            }
            return mr;
        }

        @Override
        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
            J.MethodDeclaration md = super.visitMethodDeclaration(method, ctx);
            JavaType.Method type2 = md.getMethodType();
            if (!TypeUtils.isWellFormedType((JavaType)type2, this.seenTypes)) {
                md = (J.MethodDeclaration)SearchResult.found((Tree)md, (String)"MethodDeclaration type is missing or malformed");
            } else if (!(md.getSimpleName().equals(type2.getName()) || type2.isConstructor() || "anonymous".equals(type2.getName()))) {
                md = (J.MethodDeclaration)SearchResult.found((Tree)md, (String)("type information has a different method name '" + type2.getName() + "'"));
            }
            if (md.getName().getType() != null && type2 != md.getName().getType()) {
                md = (J.MethodDeclaration)SearchResult.found((Tree)md, (String)"MethodDeclaration#name type is not the MethodType of MethodDeclaration.");
            }
            return md;
        }

        @Override
        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
            J.Package pkg;
            J.CompilationUnit jc;
            J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, ctx);
            JavaType.FullyQualified t = cd.getType();
            if (!TypeUtils.isWellFormedType((JavaType)t, this.seenTypes)) {
                return (J.ClassDeclaration)SearchResult.found((Tree)cd, (String)"ClassDeclaration type is missing or malformed");
            }
            if (!cd.getKind().name().equals(t.getKind().name())) {
                cd = (J.ClassDeclaration)SearchResult.found((Tree)cd, (String)(" J.ClassDeclaration kind " + cd.getKind() + " does not match the kind in its type information " + t.getKind()));
            }
            if ((jc = (J.CompilationUnit)this.getCursor().firstEnclosing(J.CompilationUnit.class)) != null && (pkg = jc.getPackageDeclaration()) != null && t.getPackageName().equals(pkg.printTrimmed(this.getCursor()))) {
                cd = (J.ClassDeclaration)SearchResult.found((Tree)cd, (String)(" J.ClassDeclaration package " + pkg + " does not match the package in its type information " + pkg.printTrimmed(this.getCursor())));
            }
            return cd;
        }

        @Override
        public J.NewClass visitNewClass(J.NewClass newClass, ExecutionContext ctx) {
            J.NewClass n = super.visitNewClass(newClass, ctx);
            if (n == newClass && !TypeUtils.isWellFormedType((JavaType)n.getType(), this.seenTypes)) {
                n = (J.NewClass)SearchResult.found((Tree)n, (String)"NewClass type is missing or malformed");
            }
            if (n.getClazz() instanceof J.Identifier && n.getClazz().getType() != null && !(n.getClazz().getType() instanceof JavaType.Class) && !(n.getClazz().getType() instanceof JavaType.Unknown)) {
                n = (J.NewClass)SearchResult.found((Tree)n, (String)"NewClass#clazz is J.Identifier and the type is is not JavaType$Class.");
            }
            return n;
        }

        @Override
        public J.ParameterizedType visitParameterizedType(J.ParameterizedType type2, ExecutionContext ctx) {
            J.ParameterizedType p = super.visitParameterizedType(type2, ctx);
            if (p.getClazz() instanceof J.Identifier && p.getClazz().getType() != null && !(p.getClazz().getType() instanceof JavaType.Class) && !(p.getClazz().getType() instanceof JavaType.Unknown)) {
                p = (J.ParameterizedType)SearchResult.found((Tree)p, (String)"ParameterizedType#clazz is J.Identifier and the type is is not JavaType$Class.");
            }
            return p;
        }

        private boolean isAllowedToHaveNullType(J.Identifier ident) {
            return this.inPackageDeclaration() || this.inImport() || this.isClassName() || this.isMethodName() || this.isMethodInvocationName() || this.isFieldAccess(ident) || this.isBeingDeclared(ident) || this.isParameterizedType(ident) || this.isNewClass(ident) || this.isTypeParameter() || this.isMemberReference(ident) || this.isCaseLabel() || this.isLabel() || this.isAnnotationField(ident) || this.isInJavaDoc(ident) || this.isWhenLabel();
        }

        private boolean inPackageDeclaration() {
            return this.getCursor().firstEnclosing(J.Package.class) != null;
        }

        private boolean inImport() {
            return this.getCursor().firstEnclosing(J.Import.class) != null;
        }

        private boolean isClassName() {
            Cursor parent2 = this.getCursor().getParent();
            return parent2 != null && parent2.getValue() instanceof J.ClassDeclaration;
        }

        private boolean isMethodName() {
            Cursor parent2 = this.getCursor().getParent();
            return parent2 != null && parent2.getValue() instanceof J.MethodDeclaration;
        }

        private boolean isMethodInvocationName() {
            Cursor parent2 = this.getCursor().getParent();
            return parent2 != null && parent2.getValue() instanceof J.MethodInvocation;
        }

        private boolean isFieldAccess(J.Identifier ident) {
            Tree value = (Tree)this.getCursor().getParentTreeCursor().getValue();
            return value instanceof J.FieldAccess && (ident == ((J.FieldAccess)value).getName() || ident == ((J.FieldAccess)value).getTarget() && !((J.FieldAccess)value).getSimpleName().equals("class"));
        }

        private boolean isBeingDeclared(J.Identifier ident) {
            Tree value = (Tree)this.getCursor().getParentTreeCursor().getValue();
            return value instanceof J.VariableDeclarations.NamedVariable && ident == ((J.VariableDeclarations.NamedVariable)value).getName();
        }

        private boolean isParameterizedType(J.Identifier ident) {
            Tree value = (Tree)this.getCursor().getParentTreeCursor().getValue();
            return value instanceof J.ParameterizedType && ident == ((J.ParameterizedType)value).getClazz();
        }

        private boolean isNewClass(J.Identifier ident) {
            Tree value = (Tree)this.getCursor().getParentTreeCursor().getValue();
            return value instanceof J.NewClass && ident == ((J.NewClass)value).getClazz();
        }

        private boolean isTypeParameter() {
            return this.getCursor().getParent() != null && this.getCursor().getParent().getValue() instanceof J.TypeParameter;
        }

        private boolean isMemberReference(J.Identifier ident) {
            Tree value = (Tree)this.getCursor().getParentTreeCursor().getValue();
            return value instanceof J.MemberReference && ident == ((J.MemberReference)value).getReference();
        }

        private boolean isInJavaDoc(J.Identifier ident) {
            Tree value = (Tree)this.getCursor().getParentTreeCursor().getValue();
            return value instanceof Javadoc.Reference && ident == ((Javadoc.Reference)value).getTree();
        }

        private boolean isCaseLabel() {
            return this.getCursor().getParentTreeCursor().getValue() instanceof J.Case;
        }

        private boolean isWhenLabel() {
            return this.getCursor().getParentTreeCursor().getValue() instanceof K.WhenBranch;
        }

        private boolean isLabel() {
            return this.getCursor().firstEnclosing(J.Label.class) != null;
        }

        private boolean isAnnotationField(J.Identifier ident) {
            Cursor parent2 = this.getCursor().getParent();
            return parent2 != null && parent2.getValue() instanceof J.Assignment && ident == ((J.Assignment)parent2.getValue()).getVariable() && this.getCursor().firstEnclosing(J.Annotation.class) != null;
        }

        private boolean isValidated(J.Identifier i) {
            J j = (J)this.getCursor().dropParentUntil(it -> it instanceof J).getValue();
            return !j.getMarkers().findFirst(AnnotationUseSite.class).isPresent() && !(j instanceof K.KReturn);
        }

        private boolean isValidated(J.MethodInvocation mi) {
            return !mi.getMarkers().findFirst(IndexedAccess.class).isPresent();
        }

        private boolean isValidated(J.VariableDeclarations.NamedVariable v) {
            J.VariableDeclarations j = (J.VariableDeclarations)this.getCursor().firstEnclosing(J.VariableDeclarations.class);
            return j.getModifiers().stream().noneMatch(it -> "typealias".equals(it.getKeyword())) && !j.getMarkers().findFirst(Extension.class).isPresent();
        }

        private boolean isNotDestructType(JavaType.Variable variable) {
            return !"<destruct>".equals(variable.getName());
        }
    }
}

