/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kotlin.tree;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.beans.Transient;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.openrewrite.Checksum;
import org.openrewrite.Cursor;
import org.openrewrite.FileAttributes;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaPrinter;
import org.openrewrite.java.JavaTypeVisitor;
import org.openrewrite.java.internal.TypesInUse;
import org.openrewrite.java.service.AutoFormatService;
import org.openrewrite.java.service.ImportService;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.CoordinateBuilder;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypedTree;
import org.openrewrite.kotlin.KotlinVisitor;
import org.openrewrite.kotlin.internal.KotlinPrinter;
import org.openrewrite.kotlin.service.KotlinAutoFormatService;
import org.openrewrite.kotlin.service.KotlinImportService;
import org.openrewrite.marker.Markers;

public interface K
extends J {
    default public <R extends Tree, P> R accept(TreeVisitor<R, P> v, P p) {
        return (R)this.acceptKotlin((KotlinVisitor)v.adapt(KotlinVisitor.class), p);
    }

    default public <P> boolean isAcceptable(TreeVisitor<?, P> v, P p) {
        return v.isAdaptableTo(KotlinVisitor.class);
    }

    @Nullable
    default public <P> J acceptKotlin(KotlinVisitor<P> v, P p) {
        return (J)v.defaultValue((Tree)this, p);
    }

    public Space getPrefix();

    default public List<Comment> getComments() {
        return this.getPrefix().getComments();
    }

    public static final class MultiAnnotationType
    implements K,
    NameTree {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final JRightPadded<Expression> useSite;
        private final JContainer<J.Annotation> annotations;

        public Expression getUseSite() {
            return (Expression)this.useSite.getElement();
        }

        @Nullable
        public JavaType getType() {
            return null;
        }

        public <T extends J> T withType(@Nullable JavaType type2) {
            return (T)this;
        }

        @Override
        public <P> J acceptKotlin(KotlinVisitor<P> v, P p) {
            return v.visitMultiAnnotationType(this, p);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MultiAnnotationType)) {
                return false;
            }
            MultiAnnotationType other = (MultiAnnotationType)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public MultiAnnotationType(UUID id, Space prefix, Markers markers, JRightPadded<Expression> useSite, JContainer<J.Annotation> annotations) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.useSite = useSite;
            this.annotations = annotations;
        }

        private MultiAnnotationType(WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, JRightPadded<Expression> useSite, JContainer<J.Annotation> annotations) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.useSite = useSite;
            this.annotations = annotations;
        }

        public UUID getId() {
            return this.id;
        }

        public MultiAnnotationType withId(UUID id) {
            return this.id == id ? this : new MultiAnnotationType(this.padding, id, this.prefix, this.markers, this.useSite, this.annotations);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public MultiAnnotationType withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new MultiAnnotationType(this.padding, this.id, prefix, this.markers, this.useSite, this.annotations);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public MultiAnnotationType withMarkers(Markers markers) {
            return this.markers == markers ? this : new MultiAnnotationType(this.padding, this.id, this.prefix, markers, this.useSite, this.annotations);
        }

        public JContainer<J.Annotation> getAnnotations() {
            return this.annotations;
        }

        public MultiAnnotationType withAnnotations(JContainer<J.Annotation> annotations) {
            return this.annotations == annotations ? this : new MultiAnnotationType(this.padding, this.id, this.prefix, this.markers, this.useSite, annotations);
        }

        public static class Padding {
            private final MultiAnnotationType t;

            public JRightPadded<Expression> getUseSite() {
                return this.t.useSite;
            }

            public MultiAnnotationType withUseSite(JRightPadded<Expression> useSite) {
                return this.t.useSite == useSite ? this.t : new MultiAnnotationType(this.t.id, this.t.prefix, this.t.markers, useSite, (JContainer<J.Annotation>)this.t.annotations);
            }

            public Padding(MultiAnnotationType t) {
                this.t = t;
            }
        }
    }

    public static final class AnnotationType
    implements K,
    NameTree {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final JRightPadded<Expression> useSite;
        private final J.Annotation callee;

        public Expression getUseSite() {
            return (Expression)this.useSite.getElement();
        }

        @Nullable
        public JavaType getType() {
            return null;
        }

        public <T extends J> T withType(@Nullable JavaType type2) {
            return (T)this;
        }

        @Override
        public <P> J acceptKotlin(KotlinVisitor<P> v, P p) {
            return v.visitAnnotationType(this, p);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AnnotationType)) {
                return false;
            }
            AnnotationType other = (AnnotationType)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public AnnotationType(UUID id, Space prefix, Markers markers, JRightPadded<Expression> useSite, J.Annotation callee) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.useSite = useSite;
            this.callee = callee;
        }

        private AnnotationType(WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, JRightPadded<Expression> useSite, J.Annotation callee) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.useSite = useSite;
            this.callee = callee;
        }

        public UUID getId() {
            return this.id;
        }

        public AnnotationType withId(UUID id) {
            return this.id == id ? this : new AnnotationType(this.padding, id, this.prefix, this.markers, this.useSite, this.callee);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public AnnotationType withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new AnnotationType(this.padding, this.id, prefix, this.markers, this.useSite, this.callee);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public AnnotationType withMarkers(Markers markers) {
            return this.markers == markers ? this : new AnnotationType(this.padding, this.id, this.prefix, markers, this.useSite, this.callee);
        }

        public J.Annotation getCallee() {
            return this.callee;
        }

        public AnnotationType withCallee(J.Annotation callee) {
            return this.callee == callee ? this : new AnnotationType(this.padding, this.id, this.prefix, this.markers, this.useSite, callee);
        }

        public static class Padding {
            private final AnnotationType t;

            public JRightPadded<Expression> getUseSite() {
                return this.t.useSite;
            }

            public AnnotationType withUseSite(JRightPadded<Expression> useSite) {
                return this.t.useSite == useSite ? this.t : new AnnotationType(this.t.id, this.t.prefix, this.t.markers, useSite, this.t.callee);
            }

            public Padding(AnnotationType t) {
                this.t = t;
            }
        }
    }

    public static final class Unary
    implements K,
    Statement,
    Expression,
    TypedTree {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final JLeftPadded<Type> operator;
        private final Expression expression;
        @Nullable
        private final JavaType type;

        public Type getOperator() {
            return (Type)((Object)this.operator.getElement());
        }

        public Unary withOperator(Type operator) {
            return this.getPadding().withOperator((JLeftPadded<Type>)this.operator.withElement((Object)operator));
        }

        @Override
        public <R extends Tree, P> R accept(TreeVisitor<R, P> v, P p) {
            return K.super.accept(v, p);
        }

        @Override
        public <P> J acceptKotlin(KotlinVisitor<P> v, P p) {
            return v.visitUnary(this, p);
        }

        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement((Statement)this);
        }

        @Transient
        public List<J> getSideEffects() {
            return this.getOperator().isModifying() ? Collections.singletonList(this) : this.expression.getSideEffects();
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed((TreeVisitor)new JavaPrinter());
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Unary)) {
                return false;
            }
            Unary other = (Unary)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Unary(UUID id, Space prefix, Markers markers, JLeftPadded<Type> operator, Expression expression, JavaType type2) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.operator = operator;
            this.expression = expression;
            this.type = type2;
        }

        private Unary(WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, JLeftPadded<Type> operator, Expression expression, JavaType type2) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.operator = operator;
            this.expression = expression;
            this.type = type2;
        }

        public Unary withId(UUID id) {
            return this.id == id ? this : new Unary(this.padding, id, this.prefix, this.markers, this.operator, this.expression, this.type);
        }

        public UUID getId() {
            return this.id;
        }

        public Unary withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Unary(this.padding, this.id, prefix, this.markers, this.operator, this.expression, this.type);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Unary withMarkers(Markers markers) {
            return this.markers == markers ? this : new Unary(this.padding, this.id, this.prefix, markers, this.operator, this.expression, this.type);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Unary withExpression(Expression expression) {
            return this.expression == expression ? this : new Unary(this.padding, this.id, this.prefix, this.markers, this.operator, expression, this.type);
        }

        public Expression getExpression() {
            return this.expression;
        }

        public Unary withType(JavaType type2) {
            return this.type == type2 ? this : new Unary(this.padding, this.id, this.prefix, this.markers, this.operator, this.expression, type2);
        }

        public JavaType getType() {
            return this.type;
        }

        public static enum Type {
            NotNull;


            public boolean isModifying() {
                switch (this) {
                    default: 
                }
                return false;
            }
        }

        public static class Padding {
            private final Unary t;

            public JLeftPadded<Type> getOperator() {
                return this.t.operator;
            }

            public Unary withOperator(JLeftPadded<Type> operator) {
                return this.t.operator == operator ? this.t : new Unary(this.t.id, this.t.prefix, this.t.markers, operator, this.t.expression, this.t.type);
            }

            public Padding(Unary t) {
                this.t = t;
            }
        }
    }

    public static final class WhenBranch
    implements K,
    Statement {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final JContainer<Expression> expressions;
        private final JRightPadded<J> body;

        public List<Expression> getExpressions() {
            return this.expressions.getElements();
        }

        public WhenBranch withExpressions(List<Expression> expressions) {
            return this.getPadding().withExpressions((JContainer<Expression>)Objects.requireNonNull(JContainer.withElementsNullable(this.expressions, expressions)));
        }

        public J getBody() {
            return (J)this.body.getElement();
        }

        public WhenBranch withBody(J body) {
            return this.getPadding().withBody((JRightPadded<J>)JRightPadded.withElement(this.body, (Object)body));
        }

        @Override
        public <P> J acceptKotlin(KotlinVisitor<P> v, P p) {
            return v.visitWhenBranch(this, p);
        }

        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement((Statement)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed((TreeVisitor)new KotlinPrinter());
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WhenBranch)) {
                return false;
            }
            WhenBranch other = (WhenBranch)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public WhenBranch(UUID id, Space prefix, Markers markers, JContainer<Expression> expressions, JRightPadded<J> body) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.expressions = expressions;
            this.body = body;
        }

        private WhenBranch(WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, JContainer<Expression> expressions, JRightPadded<J> body) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.expressions = expressions;
            this.body = body;
        }

        public WhenBranch withId(UUID id) {
            return this.id == id ? this : new WhenBranch(this.padding, id, this.prefix, this.markers, this.expressions, this.body);
        }

        public UUID getId() {
            return this.id;
        }

        public WhenBranch withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new WhenBranch(this.padding, this.id, prefix, this.markers, this.expressions, this.body);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public WhenBranch withMarkers(Markers markers) {
            return this.markers == markers ? this : new WhenBranch(this.padding, this.id, this.prefix, markers, this.expressions, this.body);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public static class Padding {
            private final WhenBranch t;

            public JRightPadded<J> getBody() {
                return this.t.body;
            }

            public WhenBranch withBody(JRightPadded<J> body) {
                return this.t.body == body ? this.t : new WhenBranch(this.t.id, this.t.prefix, this.t.markers, (JContainer<Expression>)this.t.expressions, body);
            }

            public JContainer<Expression> getExpressions() {
                return this.t.expressions;
            }

            public WhenBranch withExpressions(JContainer<Expression> expressions) {
                return this.t.expressions == expressions ? this.t : new WhenBranch(this.t.id, this.t.prefix, this.t.markers, expressions, (JRightPadded<J>)this.t.body);
            }

            public Padding(WhenBranch t) {
                this.t = t;
            }
        }
    }

    public static final class When
    implements K,
    Statement,
    Expression {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        @Nullable
        private final J.ControlParentheses<J> selector;
        private final J.Block branches;
        @Nullable
        private final JavaType type;

        @Override
        public <P> J acceptKotlin(KotlinVisitor<P> v, P p) {
            return v.visitWhen(this, p);
        }

        @Nullable
        public JavaType getType() {
            return this.type;
        }

        public When withType(@Nullable JavaType type2) {
            if (type2 == this.type) {
                return this;
            }
            return new When(this.id, this.prefix, this.markers, this.selector, this.branches, this.type);
        }

        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement((Statement)this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof When)) {
                return false;
            }
            When other = (When)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public When(UUID id, Space prefix, Markers markers, J.ControlParentheses<J> selector, J.Block branches, JavaType type2) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.selector = selector;
            this.branches = branches;
            this.type = type2;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public J.ControlParentheses<J> getSelector() {
            return this.selector;
        }

        public J.Block getBranches() {
            return this.branches;
        }

        public String toString() {
            return "K.When(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", selector=" + this.getSelector() + ", branches=" + this.getBranches() + ", type=" + this.getType() + ")";
        }

        public When withId(UUID id) {
            return this.id == id ? this : new When(id, this.prefix, this.markers, this.selector, this.branches, this.type);
        }

        public When withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new When(this.id, prefix, this.markers, this.selector, this.branches, this.type);
        }

        public When withMarkers(Markers markers) {
            return this.markers == markers ? this : new When(this.id, this.prefix, markers, this.selector, this.branches, this.type);
        }

        public When withSelector(J.ControlParentheses<J> selector) {
            return this.selector == selector ? this : new When(this.id, this.prefix, this.markers, selector, this.branches, this.type);
        }

        public When withBranches(J.Block branches) {
            return this.branches == branches ? this : new When(this.id, this.prefix, this.markers, this.selector, branches, this.type);
        }
    }

    public static final class TypeParameterExpression
    implements K,
    Expression {
        private final UUID id;
        private final J.TypeParameter typeParameter;

        @Override
        public <P> J acceptKotlin(KotlinVisitor<P> v, P p) {
            J j = (J)v.visit((Tree)this.getTypeParameter(), p);
            if (j instanceof TypeParameterExpression) {
                return j;
            }
            if (j instanceof J.TypeParameter) {
                return this.withTypeParameter((J.TypeParameter)j);
            }
            return j;
        }

        public <J2 extends J> J2 withPrefix(Space space) {
            return (J2)this.withTypeParameter(this.typeParameter.withPrefix(space));
        }

        @Override
        public Space getPrefix() {
            return this.typeParameter.getPrefix();
        }

        public <J2 extends Tree> J2 withMarkers(Markers markers) {
            return (J2)this.withTypeParameter(this.typeParameter.withMarkers(markers));
        }

        public Markers getMarkers() {
            return this.typeParameter.getMarkers();
        }

        @Nullable
        public JavaType getType() {
            return null;
        }

        public <T extends J> T withType(@Nullable JavaType type2) {
            return (T)this.typeParameter;
        }

        @Transient
        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        public UUID getId() {
            return this.id;
        }

        public J.TypeParameter getTypeParameter() {
            return this.typeParameter;
        }

        public String toString() {
            return "K.TypeParameterExpression(id=" + this.getId() + ", typeParameter=" + this.getTypeParameter() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TypeParameterExpression)) {
                return false;
            }
            TypeParameterExpression other = (TypeParameterExpression)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public TypeParameterExpression(UUID id, J.TypeParameter typeParameter) {
            this.id = id;
            this.typeParameter = typeParameter;
        }

        public TypeParameterExpression withId(UUID id) {
            return this.id == id ? this : new TypeParameterExpression(id, this.typeParameter);
        }

        public TypeParameterExpression withTypeParameter(J.TypeParameter typeParameter) {
            return this.typeParameter == typeParameter ? this : new TypeParameterExpression(this.id, typeParameter);
        }
    }

    public static final class TypeConstraints
    implements K {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Markers markers;
        private final JContainer<J.TypeParameter> constraints;

        public List<J.TypeParameter> getConstraints() {
            return this.constraints.getElements();
        }

        public TypeConstraints withConstraints(List<J.TypeParameter> constraints) {
            return this.getPadding().withConstraints((JContainer<J.TypeParameter>)Objects.requireNonNull(JContainer.withElementsNullable(this.constraints, constraints)));
        }

        @Override
        public <P> J acceptKotlin(KotlinVisitor<P> v, P p) {
            return v.visitTypeConstraints(this, p);
        }

        public <J2 extends J> J2 withPrefix(Space space) {
            return (J2)this.getPadding().withConstraints((JContainer<J.TypeParameter>)this.constraints.withBefore(space));
        }

        @Override
        public Space getPrefix() {
            return this.constraints.getBefore();
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed(new KotlinPrinter());
        }

        public UUID getId() {
            return this.id;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TypeConstraints)) {
                return false;
            }
            TypeConstraints other = (TypeConstraints)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public TypeConstraints(UUID id, Markers markers, JContainer<J.TypeParameter> constraints) {
            this.id = id;
            this.markers = markers;
            this.constraints = constraints;
        }

        private TypeConstraints(WeakReference<Padding> padding, UUID id, Markers markers, JContainer<J.TypeParameter> constraints) {
            this.padding = padding;
            this.id = id;
            this.markers = markers;
            this.constraints = constraints;
        }

        public TypeConstraints withId(UUID id) {
            return this.id == id ? this : new TypeConstraints(this.padding, id, this.markers, this.constraints);
        }

        public TypeConstraints withMarkers(Markers markers) {
            return this.markers == markers ? this : new TypeConstraints(this.padding, this.id, markers, this.constraints);
        }

        public static class Padding {
            private final TypeConstraints t;

            public JContainer<J.TypeParameter> getConstraints() {
                return this.t.constraints;
            }

            public TypeConstraints withConstraints(JContainer<J.TypeParameter> constraints) {
                return this.t.constraints == constraints ? this.t : new TypeConstraints(this.t.id, this.t.markers, constraints);
            }

            public Padding(TypeConstraints t) {
                this.t = t;
            }
        }
    }

    public static final class StatementExpression
    implements K,
    Expression,
    Statement {
        private final UUID id;
        private final Statement statement;

        @Override
        public <P> J acceptKotlin(KotlinVisitor<P> v, P p) {
            J j = (J)v.visit((Tree)this.getStatement(), p);
            if (j instanceof StatementExpression) {
                return j;
            }
            if (j instanceof Statement) {
                return this.withStatement((Statement)j);
            }
            return j;
        }

        public <J2 extends J> J2 withPrefix(Space space) {
            return (J2)this.withStatement((Statement)this.statement.withPrefix(space));
        }

        @Override
        public Space getPrefix() {
            return this.statement.getPrefix();
        }

        public <J2 extends Tree> J2 withMarkers(Markers markers) {
            return (J2)this.withStatement((Statement)this.statement.withMarkers(markers));
        }

        public Markers getMarkers() {
            return this.statement.getMarkers();
        }

        @Nullable
        public JavaType getType() {
            return null;
        }

        public <T extends J> T withType(@Nullable JavaType type2) {
            throw new UnsupportedOperationException("StatementExpression cannot have a type");
        }

        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement((Statement)this);
        }

        public UUID getId() {
            return this.id;
        }

        public Statement getStatement() {
            return this.statement;
        }

        public String toString() {
            return "K.StatementExpression(id=" + this.getId() + ", statement=" + this.getStatement() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StatementExpression)) {
                return false;
            }
            StatementExpression other = (StatementExpression)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public StatementExpression(UUID id, Statement statement) {
            this.id = id;
            this.statement = statement;
        }

        public StatementExpression withId(UUID id) {
            return this.id == id ? this : new StatementExpression(id, this.statement);
        }

        public StatementExpression withStatement(Statement statement) {
            return this.statement == statement ? this : new StatementExpression(this.id, statement);
        }
    }

    public static final class SpreadArgument
    implements K,
    Expression {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Expression expression;

        @Nullable
        public JavaType getType() {
            return this.expression.getType() != null ? new JavaType.Array(null, this.expression.getType()) : null;
        }

        public <T extends J> T withType(@Nullable JavaType type2) {
            throw new UnsupportedOperationException("Type of SpreadArgument cannot be changed directly");
        }

        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        @Override
        public <P> J acceptKotlin(KotlinVisitor<P> v, P p) {
            return v.visitSpreadArgument(this, p);
        }

        public SpreadArgument(UUID id, Space prefix, Markers markers, Expression expression) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.expression = expression;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Expression getExpression() {
            return this.expression;
        }

        public String toString() {
            return "K.SpreadArgument(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", expression=" + this.getExpression() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SpreadArgument)) {
                return false;
            }
            SpreadArgument other = (SpreadArgument)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public SpreadArgument withId(UUID id) {
            return this.id == id ? this : new SpreadArgument(id, this.prefix, this.markers, this.expression);
        }

        public SpreadArgument withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new SpreadArgument(this.id, prefix, this.markers, this.expression);
        }

        public SpreadArgument withMarkers(Markers markers) {
            return this.markers == markers ? this : new SpreadArgument(this.id, this.prefix, markers, this.expression);
        }

        public SpreadArgument withExpression(Expression expression) {
            return this.expression == expression ? this : new SpreadArgument(this.id, this.prefix, this.markers, expression);
        }
    }

    public static final class NamedVariableInitializer
    implements K,
    Expression {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final List<J> initializations;

        @Nullable
        public JavaType getType() {
            return null;
        }

        public <T extends J> T withType(@Nullable JavaType type2) {
            throw new UnsupportedOperationException("NamedVariableInitializer cannot have a type");
        }

        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        @Override
        public <P> J acceptKotlin(KotlinVisitor<P> v, P p) {
            return v.visitNamedVariableInitializer(this, p);
        }

        public NamedVariableInitializer(UUID id, Space prefix, Markers markers, List<J> initializations) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.initializations = initializations;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<J> getInitializations() {
            return this.initializations;
        }

        public String toString() {
            return "K.NamedVariableInitializer(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", initializations=" + this.getInitializations() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NamedVariableInitializer)) {
                return false;
            }
            NamedVariableInitializer other = (NamedVariableInitializer)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public NamedVariableInitializer withId(UUID id) {
            return this.id == id ? this : new NamedVariableInitializer(id, this.prefix, this.markers, this.initializations);
        }

        public NamedVariableInitializer withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new NamedVariableInitializer(this.id, prefix, this.markers, this.initializations);
        }

        public NamedVariableInitializer withMarkers(Markers markers) {
            return this.markers == markers ? this : new NamedVariableInitializer(this.id, this.prefix, markers, this.initializations);
        }

        public NamedVariableInitializer withInitializations(List<J> initializations) {
            return this.initializations == initializations ? this : new NamedVariableInitializer(this.id, this.prefix, this.markers, initializations);
        }
    }

    public static final class Property
    implements K,
    Statement {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        @Nullable
        private final JContainer<J.TypeParameter> typeParameters;
        private final J.VariableDeclarations variableDeclarations;
        @Nullable
        private final TypeConstraints typeConstraints;
        private final JContainer<J.MethodDeclaration> accessors;
        @Nullable
        private final JRightPadded<Expression> receiver;

        @Nullable
        public List<J.TypeParameter> getTypeParameters() {
            return this.typeParameters == null ? null : this.typeParameters.getElements();
        }

        @Deprecated
        @JsonCreator
        public Property(UUID id, Space prefix, Markers markers, JContainer<J.TypeParameter> typeParameters, J.VariableDeclarations variableDeclarations, @Nullable TypeConstraints typeConstraints, @Nullable @JsonProperty(value="getter") J.MethodDeclaration getter, @Nullable @JsonProperty(value="setter") J.MethodDeclaration setter, @Nullable @JsonProperty(value="isSetterFirst") Boolean isSetterFirst, JContainer<J.MethodDeclaration> accessors, @Nullable JRightPadded<Expression> receiver) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.typeParameters = typeParameters;
            this.variableDeclarations = variableDeclarations;
            this.typeConstraints = typeConstraints;
            if (getter != null || setter != null || isSetterFirst != null) {
                ArrayList<JRightPadded> rps = new ArrayList<JRightPadded>(2);
                if (setter != null) {
                    rps.add(new JRightPadded((Object)setter, Space.EMPTY, Markers.EMPTY));
                }
                if (getter != null) {
                    rps.add(new JRightPadded((Object)getter, Space.EMPTY, Markers.EMPTY));
                }
                if (Boolean.FALSE.equals(isSetterFirst)) {
                    Collections.reverse(rps);
                }
                this.accessors = JContainer.build(rps);
            } else {
                this.accessors = accessors;
            }
            this.receiver = receiver;
        }

        @Nullable
        public Expression getReceiver() {
            return this.receiver == null ? null : (Expression)this.receiver.getElement();
        }

        @Override
        public <P> J acceptKotlin(KotlinVisitor<P> v, P p) {
            return v.visitProperty(this, p);
        }

        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement((Statement)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed((TreeVisitor)new KotlinPrinter());
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Property)) {
                return false;
            }
            Property other = (Property)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Property(UUID id, Space prefix, Markers markers, JContainer<J.TypeParameter> typeParameters, J.VariableDeclarations variableDeclarations, TypeConstraints typeConstraints, JContainer<J.MethodDeclaration> accessors, JRightPadded<Expression> receiver) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.typeParameters = typeParameters;
            this.variableDeclarations = variableDeclarations;
            this.typeConstraints = typeConstraints;
            this.accessors = accessors;
            this.receiver = receiver;
        }

        private Property(WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, JContainer<J.TypeParameter> typeParameters, J.VariableDeclarations variableDeclarations, TypeConstraints typeConstraints, JContainer<J.MethodDeclaration> accessors, JRightPadded<Expression> receiver) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.typeParameters = typeParameters;
            this.variableDeclarations = variableDeclarations;
            this.typeConstraints = typeConstraints;
            this.accessors = accessors;
            this.receiver = receiver;
        }

        public Property withPadding(WeakReference<Padding> padding) {
            return this.padding == padding ? this : new Property(padding, this.id, this.prefix, this.markers, this.typeParameters, this.variableDeclarations, this.typeConstraints, this.accessors, this.receiver);
        }

        public Property withId(UUID id) {
            return this.id == id ? this : new Property(this.padding, id, this.prefix, this.markers, this.typeParameters, this.variableDeclarations, this.typeConstraints, this.accessors, this.receiver);
        }

        public Property withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Property(this.padding, this.id, prefix, this.markers, this.typeParameters, this.variableDeclarations, this.typeConstraints, this.accessors, this.receiver);
        }

        public Property withMarkers(Markers markers) {
            return this.markers == markers ? this : new Property(this.padding, this.id, this.prefix, markers, this.typeParameters, this.variableDeclarations, this.typeConstraints, this.accessors, this.receiver);
        }

        public Property withTypeParameters(JContainer<J.TypeParameter> typeParameters) {
            return this.typeParameters == typeParameters ? this : new Property(this.padding, this.id, this.prefix, this.markers, typeParameters, this.variableDeclarations, this.typeConstraints, this.accessors, this.receiver);
        }

        public Property withVariableDeclarations(J.VariableDeclarations variableDeclarations) {
            return this.variableDeclarations == variableDeclarations ? this : new Property(this.padding, this.id, this.prefix, this.markers, this.typeParameters, variableDeclarations, this.typeConstraints, this.accessors, this.receiver);
        }

        public Property withTypeConstraints(TypeConstraints typeConstraints) {
            return this.typeConstraints == typeConstraints ? this : new Property(this.padding, this.id, this.prefix, this.markers, this.typeParameters, this.variableDeclarations, typeConstraints, this.accessors, this.receiver);
        }

        public Property withAccessors(JContainer<J.MethodDeclaration> accessors) {
            return this.accessors == accessors ? this : new Property(this.padding, this.id, this.prefix, this.markers, this.typeParameters, this.variableDeclarations, this.typeConstraints, accessors, this.receiver);
        }

        public Property withReceiver(JRightPadded<Expression> receiver) {
            return this.receiver == receiver ? this : new Property(this.padding, this.id, this.prefix, this.markers, this.typeParameters, this.variableDeclarations, this.typeConstraints, this.accessors, receiver);
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public J.VariableDeclarations getVariableDeclarations() {
            return this.variableDeclarations;
        }

        public TypeConstraints getTypeConstraints() {
            return this.typeConstraints;
        }

        public JContainer<J.MethodDeclaration> getAccessors() {
            return this.accessors;
        }

        public void setPadding(WeakReference<Padding> padding) {
            this.padding = padding;
        }

        public static class Padding {
            private final Property t;

            @Nullable
            public JContainer<J.TypeParameter> getTypeParameters() {
                return this.t.typeParameters;
            }

            public Property withTypeParameters(@Nullable JContainer<J.TypeParameter> typeParameters) {
                return this.t.typeParameters == typeParameters ? this.t : new Property(this.t.id, this.t.prefix, this.t.markers, typeParameters, this.t.variableDeclarations, this.t.typeConstraints, (JContainer<J.MethodDeclaration>)this.t.accessors, (JRightPadded<Expression>)this.t.receiver);
            }

            @Nullable
            public JRightPadded<Expression> getReceiver() {
                return this.t.receiver;
            }

            @Nullable
            public Property withReceiver(@Nullable JRightPadded<Expression> receiver) {
                return this.t.receiver == receiver ? this.t : new Property(this.t.id, this.t.prefix, this.t.markers, (JContainer<J.TypeParameter>)this.t.typeParameters, this.t.variableDeclarations, this.t.typeConstraints, (JContainer<J.MethodDeclaration>)this.t.accessors, receiver);
            }

            public Padding(Property t) {
                this.t = t;
            }
        }
    }

    public static final class MethodDeclaration
    implements K,
    Statement,
    TypedTree {
        private final UUID id;
        private final Markers markers;
        private final J.MethodDeclaration methodDeclaration;
        private final TypeConstraints typeConstraints;

        @Override
        public <P> J acceptKotlin(KotlinVisitor<P> v, P p) {
            return v.visitMethodDeclaration(this, p);
        }

        public <J2 extends J> J2 withPrefix(Space space) {
            return (J2)this.withMethodDeclaration(this.methodDeclaration.withPrefix(space));
        }

        @Override
        public Space getPrefix() {
            return this.methodDeclaration.getPrefix();
        }

        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement((Statement)this);
        }

        @Nullable
        public JavaType getType() {
            return this.methodDeclaration.getType();
        }

        public <T extends J> T withType(@Nullable JavaType type2) {
            return (T)this.withMethodDeclaration(this.methodDeclaration.withType(type2));
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MethodDeclaration)) {
                return false;
            }
            MethodDeclaration other = (MethodDeclaration)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public MethodDeclaration(UUID id, Markers markers, J.MethodDeclaration methodDeclaration, TypeConstraints typeConstraints) {
            this.id = id;
            this.markers = markers;
            this.methodDeclaration = methodDeclaration;
            this.typeConstraints = typeConstraints;
        }

        public UUID getId() {
            return this.id;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public J.MethodDeclaration getMethodDeclaration() {
            return this.methodDeclaration;
        }

        public TypeConstraints getTypeConstraints() {
            return this.typeConstraints;
        }

        public String toString() {
            return "K.MethodDeclaration(id=" + this.getId() + ", markers=" + this.getMarkers() + ", methodDeclaration=" + this.getMethodDeclaration() + ", typeConstraints=" + this.getTypeConstraints() + ")";
        }

        public MethodDeclaration withId(UUID id) {
            return this.id == id ? this : new MethodDeclaration(id, this.markers, this.methodDeclaration, this.typeConstraints);
        }

        public MethodDeclaration withMarkers(Markers markers) {
            return this.markers == markers ? this : new MethodDeclaration(this.id, markers, this.methodDeclaration, this.typeConstraints);
        }

        public MethodDeclaration withMethodDeclaration(J.MethodDeclaration methodDeclaration) {
            return this.methodDeclaration == methodDeclaration ? this : new MethodDeclaration(this.id, this.markers, methodDeclaration, this.typeConstraints);
        }

        public MethodDeclaration withTypeConstraints(TypeConstraints typeConstraints) {
            return this.typeConstraints == typeConstraints ? this : new MethodDeclaration(this.id, this.markers, this.methodDeclaration, typeConstraints);
        }
    }

    public static final class ListLiteral
    implements K,
    Expression,
    TypedTree {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final JContainer<Expression> elements;
        @Nullable
        private final JavaType type;

        public List<Expression> getElements() {
            return this.elements.getElements();
        }

        public ListLiteral withElements(List<Expression> elements) {
            return this.getPadding().withElements((JContainer<Expression>)JContainer.withElements(this.elements, elements));
        }

        @Override
        public <P> J acceptKotlin(KotlinVisitor<P> v, P p) {
            return v.visitListLiteral(this, p);
        }

        @Transient
        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ListLiteral)) {
                return false;
            }
            ListLiteral other = (ListLiteral)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public ListLiteral(UUID id, Space prefix, Markers markers, JContainer<Expression> elements, JavaType type2) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.elements = elements;
            this.type = type2;
        }

        private ListLiteral(WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, JContainer<Expression> elements, JavaType type2) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.elements = elements;
            this.type = type2;
        }

        public UUID getId() {
            return this.id;
        }

        public ListLiteral withId(UUID id) {
            return this.id == id ? this : new ListLiteral(this.padding, id, this.prefix, this.markers, this.elements, this.type);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public ListLiteral withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ListLiteral(this.padding, this.id, prefix, this.markers, this.elements, this.type);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public ListLiteral withMarkers(Markers markers) {
            return this.markers == markers ? this : new ListLiteral(this.padding, this.id, this.prefix, markers, this.elements, this.type);
        }

        public JavaType getType() {
            return this.type;
        }

        public ListLiteral withType(JavaType type2) {
            return this.type == type2 ? this : new ListLiteral(this.padding, this.id, this.prefix, this.markers, this.elements, type2);
        }

        public static class Padding {
            private final ListLiteral t;

            public JContainer<Expression> getElements() {
                return this.t.elements;
            }

            public ListLiteral withElements(JContainer<Expression> elements) {
                return this.t.elements == elements ? this.t : new ListLiteral(this.t.id, this.t.prefix, this.t.markers, elements, this.t.type);
            }

            public Padding(ListLiteral t) {
                this.t = t;
            }
        }
    }

    public static final class KThis
    implements K,
    Expression {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        @Nullable
        private final J.Identifier label;
        @Nullable
        private final JavaType type;

        @Override
        public <P> J acceptKotlin(KotlinVisitor<P> v, P p) {
            return v.visitKThis(this, p);
        }

        @Transient
        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed((TreeVisitor)new KotlinPrinter());
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof KThis)) {
                return false;
            }
            KThis other = (KThis)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public KThis(UUID id, Space prefix, Markers markers, J.Identifier label, JavaType type2) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.label = label;
            this.type = type2;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public J.Identifier getLabel() {
            return this.label;
        }

        public JavaType getType() {
            return this.type;
        }

        public KThis withId(UUID id) {
            return this.id == id ? this : new KThis(id, this.prefix, this.markers, this.label, this.type);
        }

        public KThis withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new KThis(this.id, prefix, this.markers, this.label, this.type);
        }

        public KThis withMarkers(Markers markers) {
            return this.markers == markers ? this : new KThis(this.id, this.prefix, markers, this.label, this.type);
        }

        public KThis withLabel(J.Identifier label) {
            return this.label == label ? this : new KThis(this.id, this.prefix, this.markers, label, this.type);
        }

        public KThis withType(JavaType type2) {
            return this.type == type2 ? this : new KThis(this.id, this.prefix, this.markers, this.label, type2);
        }
    }

    public static final class KString
    implements K,
    Statement,
    Expression {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final String delimiter;
        private final List<J> strings;
        @Nullable
        private final JavaType type;

        @Override
        public <P> J acceptKotlin(KotlinVisitor<P> v, P p) {
            return v.visitKString(this, p);
        }

        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement((Statement)this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof KString)) {
                return false;
            }
            KString other = (KString)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public KString(UUID id, Space prefix, Markers markers, String delimiter, List<J> strings, JavaType type2) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.delimiter = delimiter;
            this.strings = strings;
            this.type = type2;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public String getDelimiter() {
            return this.delimiter;
        }

        public List<J> getStrings() {
            return this.strings;
        }

        public JavaType getType() {
            return this.type;
        }

        public String toString() {
            return "K.KString(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", delimiter=" + this.getDelimiter() + ", strings=" + this.getStrings() + ", type=" + this.getType() + ")";
        }

        public KString withId(UUID id) {
            return this.id == id ? this : new KString(id, this.prefix, this.markers, this.delimiter, this.strings, this.type);
        }

        public KString withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new KString(this.id, prefix, this.markers, this.delimiter, this.strings, this.type);
        }

        public KString withMarkers(Markers markers) {
            return this.markers == markers ? this : new KString(this.id, this.prefix, markers, this.delimiter, this.strings, this.type);
        }

        public KString withDelimiter(String delimiter) {
            return this.delimiter == delimiter ? this : new KString(this.id, this.prefix, this.markers, delimiter, this.strings, this.type);
        }

        public KString withStrings(List<J> strings) {
            return this.strings == strings ? this : new KString(this.id, this.prefix, this.markers, this.delimiter, strings, this.type);
        }

        public KString withType(JavaType type2) {
            return this.type == type2 ? this : new KString(this.id, this.prefix, this.markers, this.delimiter, this.strings, type2);
        }

        public static final class Value
        implements K {
            private final UUID id;
            @Nullable
            private final Space prefix;
            private final Markers markers;
            private final J tree;
            @Nullable
            private final Space after;
            private final boolean enclosedInBraces;

            @Override
            public Space getPrefix() {
                return this.prefix == null ? Space.EMPTY : this.prefix;
            }

            public Space getAfter() {
                return this.after == null ? Space.EMPTY : this.after;
            }

            @Override
            public <P> J acceptKotlin(KotlinVisitor<P> v, P p) {
                return v.visitKStringValue(this, p);
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Value)) {
                    return false;
                }
                Value other = (Value)o;
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            public Value(UUID id, Space prefix, Markers markers, J tree, Space after, boolean enclosedInBraces) {
                this.id = id;
                this.prefix = prefix;
                this.markers = markers;
                this.tree = tree;
                this.after = after;
                this.enclosedInBraces = enclosedInBraces;
            }

            public UUID getId() {
                return this.id;
            }

            public Markers getMarkers() {
                return this.markers;
            }

            public J getTree() {
                return this.tree;
            }

            public boolean isEnclosedInBraces() {
                return this.enclosedInBraces;
            }

            public String toString() {
                return "K.KString.Value(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", tree=" + this.getTree() + ", after=" + this.getAfter() + ", enclosedInBraces=" + this.isEnclosedInBraces() + ")";
            }

            public Value withId(UUID id) {
                return this.id == id ? this : new Value(id, this.prefix, this.markers, this.tree, this.after, this.enclosedInBraces);
            }

            public Value withPrefix(Space prefix) {
                return this.prefix == prefix ? this : new Value(this.id, prefix, this.markers, this.tree, this.after, this.enclosedInBraces);
            }

            public Value withMarkers(Markers markers) {
                return this.markers == markers ? this : new Value(this.id, this.prefix, markers, this.tree, this.after, this.enclosedInBraces);
            }

            public Value withTree(J tree) {
                return this.tree == tree ? this : new Value(this.id, this.prefix, this.markers, tree, this.after, this.enclosedInBraces);
            }

            public Value withAfter(Space after) {
                return this.after == after ? this : new Value(this.id, this.prefix, this.markers, this.tree, after, this.enclosedInBraces);
            }

            public Value withEnclosedInBraces(boolean enclosedInBraces) {
                return this.enclosedInBraces == enclosedInBraces ? this : new Value(this.id, this.prefix, this.markers, this.tree, this.after, enclosedInBraces);
            }
        }
    }

    public static final class KReturn
    implements K,
    Statement,
    Expression {
        private final UUID id;
        @Deprecated
        private final List<J.Annotation> annotations;
        private final J.Return expression;
        @Nullable
        private final J.Identifier label;

        public KReturn(UUID id, J.Return expression, @Nullable J.Identifier label) {
            this(id, Collections.emptyList(), expression, label);
        }

        @Override
        public Space getPrefix() {
            return this.expression.getPrefix();
        }

        public <J2 extends J> J2 withPrefix(Space space) {
            return (J2)this.withExpression(this.expression.withPrefix(space));
        }

        public Markers getMarkers() {
            return this.expression.getMarkers();
        }

        public <J2 extends Tree> J2 withMarkers(Markers markers) {
            return (J2)this.withExpression(this.expression.withMarkers(markers));
        }

        @Nullable
        public JavaType getType() {
            return this.expression.getExpression().getType();
        }

        public <T extends J> T withType(@Nullable JavaType type2) {
            return (T)this;
        }

        @Override
        public <P> J acceptKotlin(KotlinVisitor<P> v, P p) {
            return v.visitKReturn(this, p);
        }

        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement((Statement)this);
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed(new KotlinPrinter());
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof KReturn)) {
                return false;
            }
            KReturn other = (KReturn)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        private KReturn(UUID id, List<J.Annotation> annotations, J.Return expression, J.Identifier label) {
            this.id = id;
            this.annotations = annotations;
            this.expression = expression;
            this.label = label;
        }

        public UUID getId() {
            return this.id;
        }

        @Deprecated
        public List<J.Annotation> getAnnotations() {
            return this.annotations;
        }

        public J.Return getExpression() {
            return this.expression;
        }

        public J.Identifier getLabel() {
            return this.label;
        }

        public KReturn withId(UUID id) {
            return this.id == id ? this : new KReturn(id, this.annotations, this.expression, this.label);
        }

        @Deprecated
        public KReturn withAnnotations(List<J.Annotation> annotations) {
            return this.annotations == annotations ? this : new KReturn(this.id, annotations, this.expression, this.label);
        }

        public KReturn withExpression(J.Return expression) {
            return this.expression == expression ? this : new KReturn(this.id, this.annotations, expression, this.label);
        }

        public KReturn withLabel(J.Identifier label) {
            return this.label == label ? this : new KReturn(this.id, this.annotations, this.expression, label);
        }
    }

    public static final class FunctionType
    implements K,
    TypeTree,
    Expression {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final List<J.Annotation> leadingAnnotations;
        private final List<J.Modifier> modifiers;
        @Nullable
        private final JRightPadded<NameTree> receiver;
        @Nullable
        private final JContainer<TypeTree> parameters;
        @Nullable
        private final Space arrow;
        private final JRightPadded<TypedTree> returnType;

        @Override
        public Space getPrefix() {
            return this.prefix == null ? ((TypedTree)this.returnType.getElement()).getPrefix() : this.prefix;
        }

        public Markers getMarkers() {
            return this.markers == null ? this.returnType.getMarkers() : this.markers;
        }

        public List<J.Annotation> getLeadingAnnotations() {
            return this.leadingAnnotations == null ? Collections.emptyList() : this.leadingAnnotations;
        }

        public List<J.Modifier> getModifiers() {
            return this.modifiers == null ? Collections.emptyList() : this.modifiers;
        }

        public List<TypeTree> getParameters() {
            return this.parameters != null ? this.parameters.getElements() : Collections.emptyList();
        }

        public FunctionType withParameters(List<TypeTree> parameters) {
            return this.getPadding().withParameters((JContainer<TypeTree>)JContainer.withElementsNullable(this.parameters, parameters));
        }

        @Nullable
        public JavaType getType() {
            return this.returnType != null && this.returnType.getElement() != null ? ((TypedTree)this.returnType.getElement()).getType() : null;
        }

        public <T extends J> T withType(@Nullable JavaType type2) {
            TypeTree newType = (TypeTree)((TypedTree)this.returnType.getElement()).withType(type2);
            return (T)(newType == type2 ? this : this.withReturnType((JRightPadded<TypedTree>)this.returnType.withElement((Object)newType)));
        }

        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        @Override
        public <P> J acceptKotlin(KotlinVisitor<P> v, P p) {
            return v.visitFunctionType(this, p);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public String toString() {
            return "K.FunctionType(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", leadingAnnotations=" + this.getLeadingAnnotations() + ", modifiers=" + this.getModifiers() + ", receiver=" + this.getReceiver() + ", parameters=" + this.getParameters() + ", arrow=" + this.getArrow() + ", returnType=" + this.getReturnType() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FunctionType)) {
                return false;
            }
            FunctionType other = (FunctionType)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public FunctionType(UUID id, Space prefix, Markers markers, List<J.Annotation> leadingAnnotations, List<J.Modifier> modifiers, JRightPadded<NameTree> receiver, JContainer<TypeTree> parameters, Space arrow, JRightPadded<TypedTree> returnType) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.leadingAnnotations = leadingAnnotations;
            this.modifiers = modifiers;
            this.receiver = receiver;
            this.parameters = parameters;
            this.arrow = arrow;
            this.returnType = returnType;
        }

        private FunctionType(WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, List<J.Annotation> leadingAnnotations, List<J.Modifier> modifiers, JRightPadded<NameTree> receiver, JContainer<TypeTree> parameters, Space arrow, JRightPadded<TypedTree> returnType) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.leadingAnnotations = leadingAnnotations;
            this.modifiers = modifiers;
            this.receiver = receiver;
            this.parameters = parameters;
            this.arrow = arrow;
            this.returnType = returnType;
        }

        public FunctionType withId(UUID id) {
            return this.id == id ? this : new FunctionType(this.padding, id, this.prefix, this.markers, this.leadingAnnotations, this.modifiers, this.receiver, this.parameters, this.arrow, this.returnType);
        }

        public UUID getId() {
            return this.id;
        }

        public FunctionType withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new FunctionType(this.padding, this.id, prefix, this.markers, this.leadingAnnotations, this.modifiers, this.receiver, this.parameters, this.arrow, this.returnType);
        }

        public FunctionType withMarkers(Markers markers) {
            return this.markers == markers ? this : new FunctionType(this.padding, this.id, this.prefix, markers, this.leadingAnnotations, this.modifiers, this.receiver, this.parameters, this.arrow, this.returnType);
        }

        public FunctionType withLeadingAnnotations(List<J.Annotation> leadingAnnotations) {
            return this.leadingAnnotations == leadingAnnotations ? this : new FunctionType(this.padding, this.id, this.prefix, this.markers, leadingAnnotations, this.modifiers, this.receiver, this.parameters, this.arrow, this.returnType);
        }

        public FunctionType withModifiers(List<J.Modifier> modifiers) {
            return this.modifiers == modifiers ? this : new FunctionType(this.padding, this.id, this.prefix, this.markers, this.leadingAnnotations, modifiers, this.receiver, this.parameters, this.arrow, this.returnType);
        }

        public FunctionType withReceiver(JRightPadded<NameTree> receiver) {
            return this.receiver == receiver ? this : new FunctionType(this.padding, this.id, this.prefix, this.markers, this.leadingAnnotations, this.modifiers, receiver, this.parameters, this.arrow, this.returnType);
        }

        public JRightPadded<NameTree> getReceiver() {
            return this.receiver;
        }

        public FunctionType withArrow(Space arrow) {
            return this.arrow == arrow ? this : new FunctionType(this.padding, this.id, this.prefix, this.markers, this.leadingAnnotations, this.modifiers, this.receiver, this.parameters, arrow, this.returnType);
        }

        public Space getArrow() {
            return this.arrow;
        }

        public FunctionType withReturnType(JRightPadded<TypedTree> returnType) {
            return this.returnType == returnType ? this : new FunctionType(this.padding, this.id, this.prefix, this.markers, this.leadingAnnotations, this.modifiers, this.receiver, this.parameters, this.arrow, returnType);
        }

        public JRightPadded<TypedTree> getReturnType() {
            return this.returnType;
        }

        public static class Padding {
            private final FunctionType t;

            @Nullable
            public JContainer<TypeTree> getParameters() {
                return this.t.parameters;
            }

            public FunctionType withParameters(@Nullable JContainer<TypeTree> parameters) {
                return this.t.parameters == parameters ? this.t : new FunctionType(this.t.id, this.t.prefix, this.t.markers, this.t.leadingAnnotations, this.t.modifiers, (JRightPadded<NameTree>)this.t.receiver, parameters, this.t.arrow, (JRightPadded<TypedTree>)this.t.returnType);
            }

            public Padding(FunctionType t) {
                this.t = t;
            }
        }

        public static final class Parameter
        implements K,
        TypeTree {
            private final UUID id;
            private final Markers markers;
            @Nullable
            private final J.Identifier name;
            private final TypeTree parameterType;

            @Override
            public Space getPrefix() {
                return this.name != null ? this.name.getPrefix() : this.parameterType.getPrefix();
            }

            public <J2 extends J> J2 withPrefix(Space space) {
                return (J2)(this.name != null ? this.withName(this.name.withPrefix(space)) : this.withType((JavaType)this.parameterType.withPrefix(space)));
            }

            @Override
            public <P> J acceptKotlin(KotlinVisitor<P> v, P p) {
                return v.visitFunctionTypeParameter(this, p);
            }

            public JavaType getType() {
                return this.parameterType.getType();
            }

            public <T extends J> T withType(@Nullable JavaType type2) {
                return (T)new Parameter(this.id, this.markers, this.name, (TypeTree)this.parameterType.withType(type2));
            }

            public String toString() {
                return "K.FunctionType.Parameter(id=" + this.getId() + ", markers=" + this.getMarkers() + ", name=" + this.getName() + ", parameterType=" + this.getParameterType() + ")";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Parameter)) {
                    return false;
                }
                Parameter other = (Parameter)o;
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            public UUID getId() {
                return this.id;
            }

            public Markers getMarkers() {
                return this.markers;
            }

            public J.Identifier getName() {
                return this.name;
            }

            public TypeTree getParameterType() {
                return this.parameterType;
            }

            public Parameter(UUID id, Markers markers, J.Identifier name, TypeTree parameterType) {
                this.id = id;
                this.markers = markers;
                this.name = name;
                this.parameterType = parameterType;
            }

            public Parameter withId(UUID id) {
                return this.id == id ? this : new Parameter(id, this.markers, this.name, this.parameterType);
            }

            public Parameter withMarkers(Markers markers) {
                return this.markers == markers ? this : new Parameter(this.id, markers, this.name, this.parameterType);
            }

            public Parameter withName(J.Identifier name) {
                return this.name == name ? this : new Parameter(this.id, this.markers, name, this.parameterType);
            }

            public Parameter withParameterType(TypeTree parameterType) {
                return this.parameterType == parameterType ? this : new Parameter(this.id, this.markers, this.name, parameterType);
            }
        }
    }

    public static final class ExpressionStatement
    implements K,
    Expression,
    Statement {
        private final UUID id;
        private final Expression expression;

        public ExpressionStatement(Expression expression) {
            this.id = Tree.randomId();
            this.expression = expression;
        }

        @Override
        public <P> J acceptKotlin(KotlinVisitor<P> v, P p) {
            J j = (J)v.visit((Tree)this.getExpression(), p);
            if (j instanceof ExpressionStatement) {
                return j;
            }
            if (j instanceof Expression) {
                return this.withExpression((Expression)j);
            }
            return j;
        }

        public <J2 extends J> J2 withPrefix(Space space) {
            return (J2)this.withExpression((Expression)this.expression.withPrefix(space));
        }

        @Override
        public Space getPrefix() {
            return this.expression.getPrefix();
        }

        public <J2 extends Tree> J2 withMarkers(Markers markers) {
            return (J2)this.withExpression((Expression)this.expression.withMarkers(markers));
        }

        public Markers getMarkers() {
            return this.expression.getMarkers();
        }

        @Nullable
        public JavaType getType() {
            return this.expression.getType();
        }

        public <T extends J> T withType(@Nullable JavaType type2) {
            ExpressionStatement newExpression = this.withExpression((Expression)this.expression.withType(type2));
            return (T)(newExpression == this.expression ? this : newExpression);
        }

        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement((Statement)this);
        }

        public UUID getId() {
            return this.id;
        }

        public Expression getExpression() {
            return this.expression;
        }

        public String toString() {
            return "K.ExpressionStatement(id=" + this.getId() + ", expression=" + this.getExpression() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ExpressionStatement)) {
                return false;
            }
            ExpressionStatement other = (ExpressionStatement)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public ExpressionStatement(UUID id, Expression expression) {
            this.id = id;
            this.expression = expression;
        }

        public ExpressionStatement withId(UUID id) {
            return this.id == id ? this : new ExpressionStatement(id, this.expression);
        }

        public ExpressionStatement withExpression(Expression expression) {
            return this.expression == expression ? this : new ExpressionStatement(this.id, expression);
        }
    }

    public static final class DestructuringDeclaration
    implements K,
    Statement {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final J.VariableDeclarations initializer;
        @Deprecated
        @Nullable
        private final JContainer<J.VariableDeclarations.NamedVariable> assignments;
        private final JContainer<Statement> destructAssignments;

        @Deprecated
        @Nullable
        public List<J.VariableDeclarations.NamedVariable> getAssignments() {
            return this.assignments != null ? this.assignments.getElements() : null;
        }

        public List<Statement> getDestructAssignments() {
            return this.destructAssignments.getElements();
        }

        @Deprecated
        public DestructuringDeclaration withAssignments(List<J.VariableDeclarations.NamedVariable> assignments) {
            return this.getPadding().withAssignments((JContainer<J.VariableDeclarations.NamedVariable>)Objects.requireNonNull(JContainer.withElementsNullable(this.assignments, assignments)));
        }

        public DestructuringDeclaration withDestructAssignments(List<Statement> assignments) {
            return this.getPadding().withDestructAssignments((JContainer<Statement>)Objects.requireNonNull(JContainer.withElementsNullable(this.destructAssignments, assignments)));
        }

        @Override
        public <P> J acceptKotlin(KotlinVisitor<P> v, P p) {
            return v.visitDestructuringDeclaration(this, p);
        }

        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement((Statement)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed((TreeVisitor)new KotlinPrinter());
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DestructuringDeclaration)) {
                return false;
            }
            DestructuringDeclaration other = (DestructuringDeclaration)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public DestructuringDeclaration(UUID id, Space prefix, Markers markers, J.VariableDeclarations initializer, JContainer<J.VariableDeclarations.NamedVariable> assignments, JContainer<Statement> destructAssignments) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.initializer = initializer;
            this.assignments = assignments;
            this.destructAssignments = destructAssignments;
        }

        private DestructuringDeclaration(WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, J.VariableDeclarations initializer, JContainer<J.VariableDeclarations.NamedVariable> assignments, JContainer<Statement> destructAssignments) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.initializer = initializer;
            this.assignments = assignments;
            this.destructAssignments = destructAssignments;
        }

        public UUID getId() {
            return this.id;
        }

        public DestructuringDeclaration withId(UUID id) {
            return this.id == id ? this : new DestructuringDeclaration(this.padding, id, this.prefix, this.markers, this.initializer, this.assignments, this.destructAssignments);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public DestructuringDeclaration withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new DestructuringDeclaration(this.padding, this.id, prefix, this.markers, this.initializer, this.assignments, this.destructAssignments);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public DestructuringDeclaration withMarkers(Markers markers) {
            return this.markers == markers ? this : new DestructuringDeclaration(this.padding, this.id, this.prefix, markers, this.initializer, this.assignments, this.destructAssignments);
        }

        public J.VariableDeclarations getInitializer() {
            return this.initializer;
        }

        public DestructuringDeclaration withInitializer(J.VariableDeclarations initializer) {
            return this.initializer == initializer ? this : new DestructuringDeclaration(this.padding, this.id, this.prefix, this.markers, initializer, this.assignments, this.destructAssignments);
        }

        public static class Padding {
            private final DestructuringDeclaration t;

            @Deprecated
            @Nullable
            public JContainer<J.VariableDeclarations.NamedVariable> getAssignments() {
                return this.t.assignments;
            }

            @Deprecated
            public DestructuringDeclaration withAssignments(JContainer<J.VariableDeclarations.NamedVariable> assignments) {
                return this.t;
            }

            public JContainer<Statement> getDestructAssignments() {
                return this.t.destructAssignments;
            }

            public DestructuringDeclaration withDestructAssignments(JContainer<Statement> assignments) {
                return this.t.destructAssignments == assignments ? this.t : new DestructuringDeclaration(this.t.id, this.t.prefix, this.t.markers, this.t.initializer, null, assignments);
            }

            public Padding(DestructuringDeclaration t) {
                this.t = t;
            }
        }
    }

    public static final class DelegatedSuperType
    implements K,
    TypeTree {
        private final UUID id;
        private final Markers markers;
        private final TypeTree typeTree;
        private final Space by;
        private final Expression delegate;

        public DelegatedSuperType withType(@Nullable JavaType type2) {
            return this.withTypeTree((TypeTree)this.typeTree.withType(type2));
        }

        @Override
        public <P> J acceptKotlin(KotlinVisitor<P> v, P p) {
            return v.visitDelegatedSuperType(this, p);
        }

        public <J2 extends J> J2 withPrefix(Space space) {
            return (J2)this.withTypeTree((TypeTree)this.typeTree.withPrefix(space));
        }

        @Override
        public Space getPrefix() {
            return this.typeTree.getPrefix();
        }

        @Nullable
        public JavaType getType() {
            return this.typeTree.getType();
        }

        public String toString() {
            return this.withBy(Space.EMPTY).printTrimmed((TreeVisitor)new KotlinPrinter());
        }

        public UUID getId() {
            return this.id;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public TypeTree getTypeTree() {
            return this.typeTree;
        }

        public Space getBy() {
            return this.by;
        }

        public Expression getDelegate() {
            return this.delegate;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DelegatedSuperType)) {
                return false;
            }
            DelegatedSuperType other = (DelegatedSuperType)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public DelegatedSuperType(UUID id, Markers markers, TypeTree typeTree, Space by, Expression delegate) {
            this.id = id;
            this.markers = markers;
            this.typeTree = typeTree;
            this.by = by;
            this.delegate = delegate;
        }

        public DelegatedSuperType withId(UUID id) {
            return this.id == id ? this : new DelegatedSuperType(id, this.markers, this.typeTree, this.by, this.delegate);
        }

        public DelegatedSuperType withMarkers(Markers markers) {
            return this.markers == markers ? this : new DelegatedSuperType(this.id, markers, this.typeTree, this.by, this.delegate);
        }

        public DelegatedSuperType withTypeTree(TypeTree typeTree) {
            return this.typeTree == typeTree ? this : new DelegatedSuperType(this.id, this.markers, typeTree, this.by, this.delegate);
        }

        public DelegatedSuperType withBy(Space by) {
            return this.by == by ? this : new DelegatedSuperType(this.id, this.markers, this.typeTree, by, this.delegate);
        }

        public DelegatedSuperType withDelegate(Expression delegate) {
            return this.delegate == delegate ? this : new DelegatedSuperType(this.id, this.markers, this.typeTree, this.by, delegate);
        }
    }

    public static final class ConstructorInvocation
    implements K,
    TypeTree {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final TypeTree typeTree;
        private final JContainer<Expression> arguments;

        public List<Expression> getArguments() {
            return this.arguments.getElements();
        }

        public ConstructorInvocation withArguments(List<Expression> arguments) {
            return this.getPadding().withArguments((JContainer<Expression>)JContainer.withElements(this.arguments, arguments));
        }

        public ConstructorInvocation withType(@Nullable JavaType type2) {
            return this.withTypeTree((TypeTree)this.typeTree.withType(type2));
        }

        @Override
        public <P> J acceptKotlin(KotlinVisitor<P> v, P p) {
            return v.visitConstructorInvocation(this, p);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Nullable
        public JavaType getType() {
            return this.typeTree.getType();
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed((TreeVisitor)new KotlinPrinter());
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConstructorInvocation)) {
                return false;
            }
            ConstructorInvocation other = (ConstructorInvocation)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public ConstructorInvocation(UUID id, Space prefix, Markers markers, TypeTree typeTree, JContainer<Expression> arguments) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.typeTree = typeTree;
            this.arguments = arguments;
        }

        private ConstructorInvocation(WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, TypeTree typeTree, JContainer<Expression> arguments) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.typeTree = typeTree;
            this.arguments = arguments;
        }

        public UUID getId() {
            return this.id;
        }

        public ConstructorInvocation withId(UUID id) {
            return this.id == id ? this : new ConstructorInvocation(this.padding, id, this.prefix, this.markers, this.typeTree, this.arguments);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public ConstructorInvocation withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ConstructorInvocation(this.padding, this.id, prefix, this.markers, this.typeTree, this.arguments);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public ConstructorInvocation withMarkers(Markers markers) {
            return this.markers == markers ? this : new ConstructorInvocation(this.padding, this.id, this.prefix, markers, this.typeTree, this.arguments);
        }

        public TypeTree getTypeTree() {
            return this.typeTree;
        }

        public ConstructorInvocation withTypeTree(TypeTree typeTree) {
            return this.typeTree == typeTree ? this : new ConstructorInvocation(this.padding, this.id, this.prefix, this.markers, typeTree, this.arguments);
        }

        public static class Padding {
            private final ConstructorInvocation t;

            public JContainer<Expression> getArguments() {
                return this.t.arguments;
            }

            public ConstructorInvocation withArguments(JContainer<Expression> arguments) {
                return this.t.arguments == arguments ? this.t : new ConstructorInvocation(this.t.id, this.t.prefix, this.t.markers, this.t.typeTree, arguments);
            }

            public Padding(ConstructorInvocation t) {
                this.t = t;
            }
        }
    }

    public static final class Constructor
    implements K,
    Statement,
    TypedTree {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Markers markers;
        private final J.MethodDeclaration methodDeclaration;
        private final JLeftPadded<ConstructorInvocation> invocation;

        public ConstructorInvocation getInvocation() {
            return (ConstructorInvocation)this.invocation.getElement();
        }

        public Constructor withInvocation(ConstructorInvocation invocation) {
            return this.getPadding().withInvocation((JLeftPadded<ConstructorInvocation>)this.invocation.withElement((Object)invocation));
        }

        @Deprecated
        @JsonCreator
        public Constructor(UUID id, Markers markers, J.MethodDeclaration methodDeclaration, @Nullable @JsonProperty(value="colon") Space colon, @Nullable @JsonProperty(value="constructorInvocation") ConstructorInvocation constructorInvocation, JLeftPadded<ConstructorInvocation> invocation) {
            this.padding = null;
            this.id = id;
            this.markers = markers;
            this.methodDeclaration = methodDeclaration;
            this.invocation = colon != null && constructorInvocation != null ? new JLeftPadded(colon, (Object)constructorInvocation, Markers.EMPTY) : invocation;
        }

        public Constructor withType(@Nullable JavaType type2) {
            return this;
        }

        @Override
        public <P> J acceptKotlin(KotlinVisitor<P> v, P p) {
            return v.visitConstructor(this, p);
        }

        public <J2 extends J> J2 withPrefix(Space space) {
            return (J2)this.withMethodDeclaration(this.methodDeclaration.withPrefix(space));
        }

        @Override
        public Space getPrefix() {
            return this.methodDeclaration.getPrefix();
        }

        @Nullable
        public JavaType getType() {
            return this.methodDeclaration.getType();
        }

        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement((Statement)this);
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed(new KotlinPrinter());
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Constructor)) {
                return false;
            }
            Constructor other = (Constructor)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Constructor(UUID id, Markers markers, J.MethodDeclaration methodDeclaration, JLeftPadded<ConstructorInvocation> invocation) {
            this.id = id;
            this.markers = markers;
            this.methodDeclaration = methodDeclaration;
            this.invocation = invocation;
        }

        private Constructor(WeakReference<Padding> padding, UUID id, Markers markers, J.MethodDeclaration methodDeclaration, JLeftPadded<ConstructorInvocation> invocation) {
            this.padding = padding;
            this.id = id;
            this.markers = markers;
            this.methodDeclaration = methodDeclaration;
            this.invocation = invocation;
        }

        public UUID getId() {
            return this.id;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public J.MethodDeclaration getMethodDeclaration() {
            return this.methodDeclaration;
        }

        public void setPadding(WeakReference<Padding> padding) {
            this.padding = padding;
        }

        public Constructor withId(UUID id) {
            return this.id == id ? this : new Constructor(this.padding, id, this.markers, this.methodDeclaration, this.invocation);
        }

        public Constructor withMarkers(Markers markers) {
            return this.markers == markers ? this : new Constructor(this.padding, this.id, markers, this.methodDeclaration, this.invocation);
        }

        public Constructor withMethodDeclaration(J.MethodDeclaration methodDeclaration) {
            return this.methodDeclaration == methodDeclaration ? this : new Constructor(this.padding, this.id, this.markers, methodDeclaration, this.invocation);
        }

        public static class Padding {
            private final Constructor t;

            public JLeftPadded<ConstructorInvocation> getInvocation() {
                return this.t.invocation;
            }

            public Constructor withInvocation(JLeftPadded<ConstructorInvocation> invocation) {
                return this.t.invocation == invocation ? this.t : new Constructor(this.t.id, this.t.markers, this.t.methodDeclaration, invocation);
            }

            public Padding(Constructor t) {
                this.t = t;
            }
        }
    }

    public static final class ClassDeclaration
    implements K,
    Statement,
    TypedTree {
        private final UUID id;
        private final Markers markers;
        private final J.ClassDeclaration classDeclaration;
        private final TypeConstraints typeConstraints;

        @Override
        public <P> J acceptKotlin(KotlinVisitor<P> v, P p) {
            return v.visitClassDeclaration(this, p);
        }

        public <J2 extends J> J2 withPrefix(Space space) {
            return (J2)this.withClassDeclaration(this.classDeclaration.withPrefix(space));
        }

        @Override
        public Space getPrefix() {
            return this.classDeclaration.getPrefix();
        }

        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement((Statement)this);
        }

        @Nullable
        public JavaType getType() {
            return this.classDeclaration.getType();
        }

        public <T extends J> T withType(@Nullable JavaType type2) {
            return (T)this.withClassDeclaration(this.classDeclaration.withType(type2));
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ClassDeclaration)) {
                return false;
            }
            ClassDeclaration other = (ClassDeclaration)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public ClassDeclaration(UUID id, Markers markers, J.ClassDeclaration classDeclaration, TypeConstraints typeConstraints) {
            this.id = id;
            this.markers = markers;
            this.classDeclaration = classDeclaration;
            this.typeConstraints = typeConstraints;
        }

        public UUID getId() {
            return this.id;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public J.ClassDeclaration getClassDeclaration() {
            return this.classDeclaration;
        }

        public TypeConstraints getTypeConstraints() {
            return this.typeConstraints;
        }

        public String toString() {
            return "K.ClassDeclaration(id=" + this.getId() + ", markers=" + this.getMarkers() + ", classDeclaration=" + this.getClassDeclaration() + ", typeConstraints=" + this.getTypeConstraints() + ")";
        }

        public ClassDeclaration withId(UUID id) {
            return this.id == id ? this : new ClassDeclaration(id, this.markers, this.classDeclaration, this.typeConstraints);
        }

        public ClassDeclaration withMarkers(Markers markers) {
            return this.markers == markers ? this : new ClassDeclaration(this.id, markers, this.classDeclaration, this.typeConstraints);
        }

        public ClassDeclaration withClassDeclaration(J.ClassDeclaration classDeclaration) {
            return this.classDeclaration == classDeclaration ? this : new ClassDeclaration(this.id, this.markers, classDeclaration, this.typeConstraints);
        }

        public ClassDeclaration withTypeConstraints(TypeConstraints typeConstraints) {
            return this.typeConstraints == typeConstraints ? this : new ClassDeclaration(this.id, this.markers, this.classDeclaration, typeConstraints);
        }
    }

    public static final class Binary
    implements K,
    Expression,
    TypedTree {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Expression left;
        private final JLeftPadded<Type> operator;
        private final Expression right;
        private final Space after;
        @Nullable
        private final JavaType type;

        public Type getOperator() {
            return (Type)((Object)this.operator.getElement());
        }

        public Binary withOperator(Type operator) {
            return this.getPadding().withOperator((JLeftPadded<Type>)this.operator.withElement((Object)operator));
        }

        @Override
        public <P> J acceptKotlin(KotlinVisitor<P> v, P p) {
            return v.visitBinary(this, p);
        }

        @Transient
        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed((TreeVisitor)new KotlinPrinter());
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Binary)) {
                return false;
            }
            Binary other = (Binary)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Binary(UUID id, Space prefix, Markers markers, Expression left, JLeftPadded<Type> operator, Expression right, Space after, JavaType type2) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.left = left;
            this.operator = operator;
            this.right = right;
            this.after = after;
            this.type = type2;
        }

        private Binary(WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, Expression left, JLeftPadded<Type> operator, Expression right, Space after, JavaType type2) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.left = left;
            this.operator = operator;
            this.right = right;
            this.after = after;
            this.type = type2;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Expression getLeft() {
            return this.left;
        }

        public Expression getRight() {
            return this.right;
        }

        public Space getAfter() {
            return this.after;
        }

        public JavaType getType() {
            return this.type;
        }

        public void setPadding(WeakReference<Padding> padding) {
            this.padding = padding;
        }

        public Binary withId(UUID id) {
            return this.id == id ? this : new Binary(this.padding, id, this.prefix, this.markers, this.left, this.operator, this.right, this.after, this.type);
        }

        public Binary withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Binary(this.padding, this.id, prefix, this.markers, this.left, this.operator, this.right, this.after, this.type);
        }

        public Binary withMarkers(Markers markers) {
            return this.markers == markers ? this : new Binary(this.padding, this.id, this.prefix, markers, this.left, this.operator, this.right, this.after, this.type);
        }

        public Binary withLeft(Expression left) {
            return this.left == left ? this : new Binary(this.padding, this.id, this.prefix, this.markers, left, this.operator, this.right, this.after, this.type);
        }

        public Binary withRight(Expression right) {
            return this.right == right ? this : new Binary(this.padding, this.id, this.prefix, this.markers, this.left, this.operator, right, this.after, this.type);
        }

        public Binary withAfter(Space after) {
            return this.after == after ? this : new Binary(this.padding, this.id, this.prefix, this.markers, this.left, this.operator, this.right, after, this.type);
        }

        public Binary withType(JavaType type2) {
            return this.type == type2 ? this : new Binary(this.padding, this.id, this.prefix, this.markers, this.left, this.operator, this.right, this.after, type2);
        }

        public static enum Type {
            Contains,
            Elvis,
            NotContains,
            Get,
            IdentityEquals,
            IdentityNotEquals,
            RangeTo,
            RangeUntil;

        }

        public static class Padding {
            private final Binary t;

            public JLeftPadded<Type> getOperator() {
                return this.t.operator;
            }

            public Binary withOperator(JLeftPadded<Type> operator) {
                return this.t.operator == operator ? this.t : new Binary(this.t.id, this.t.prefix, this.t.markers, this.t.left, operator, this.t.right, this.t.after, this.t.type);
            }

            public Padding(Binary t) {
                this.t = t;
            }
        }
    }

    public static final class AnnotatedExpression
    implements K,
    Expression {
        private final UUID id;
        private final Markers markers;
        private final List<J.Annotation> annotations;
        private final Expression expression;

        @Override
        public Space getPrefix() {
            return this.annotations.isEmpty() ? this.expression.getPrefix() : this.annotations.get(0).getPrefix();
        }

        public <J2 extends J> J2 withPrefix(Space space) {
            return (J2)(this.annotations.isEmpty() ? this.withExpression((Expression)this.expression.withPrefix(space)) : this.withAnnotations(ListUtils.mapFirst(this.annotations, a -> a.withPrefix(space))));
        }

        @Override
        public <P> J acceptKotlin(KotlinVisitor<P> v, P p) {
            return v.visitAnnotatedExpression(this, p);
        }

        @Nullable
        public JavaType getType() {
            return this.expression.getType();
        }

        public <T extends J> T withType(@Nullable JavaType type2) {
            return (T)this;
        }

        @Transient
        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed(new KotlinPrinter());
        }

        public UUID getId() {
            return this.id;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<J.Annotation> getAnnotations() {
            return this.annotations;
        }

        public Expression getExpression() {
            return this.expression;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AnnotatedExpression)) {
                return false;
            }
            AnnotatedExpression other = (AnnotatedExpression)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public AnnotatedExpression(UUID id, Markers markers, List<J.Annotation> annotations, Expression expression) {
            this.id = id;
            this.markers = markers;
            this.annotations = annotations;
            this.expression = expression;
        }

        public AnnotatedExpression withId(UUID id) {
            return this.id == id ? this : new AnnotatedExpression(id, this.markers, this.annotations, this.expression);
        }

        public AnnotatedExpression withMarkers(Markers markers) {
            return this.markers == markers ? this : new AnnotatedExpression(this.id, markers, this.annotations, this.expression);
        }

        public AnnotatedExpression withAnnotations(List<J.Annotation> annotations) {
            return this.annotations == annotations ? this : new AnnotatedExpression(this.id, this.markers, annotations, this.expression);
        }

        public AnnotatedExpression withExpression(Expression expression) {
            return this.expression == expression ? this : new AnnotatedExpression(this.id, this.markers, this.annotations, expression);
        }
    }

    public static final class CompilationUnit
    implements K,
    JavaSourceFile,
    SourceFile {
        @Nullable
        private transient SoftReference<TypesInUse> typesInUse;
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Path sourcePath;
        @Nullable
        private final FileAttributes fileAttributes;
        @Nullable
        private final String charsetName;
        private final boolean charsetBomMarked;
        @Nullable
        private final Checksum checksum;
        private final List<J.Annotation> annotations;
        @Nullable
        private final JRightPadded<J.Package> packageDeclaration;
        private final List<JRightPadded<J.Import>> imports;
        private final List<JRightPadded<Statement>> statements;
        private final Space eof;

        @Transient
        public long getWeight(final Predicate<Object> uniqueIdentity) {
            AtomicInteger n = new AtomicInteger();
            new KotlinVisitor<AtomicInteger>(){
                final JavaTypeVisitor<AtomicInteger> typeVisitor = new JavaTypeVisitor<AtomicInteger>(){

                    public JavaType visit(@Nullable JavaType javaType, AtomicInteger n) {
                        if (javaType != null && uniqueIdentity.test(javaType)) {
                            n.incrementAndGet();
                            return super.visit(javaType, (Object)n);
                        }
                        return javaType;
                    }
                };

                @Nullable
                public J visit(@Nullable Tree tree, AtomicInteger n) {
                    if (tree != null) {
                        n.incrementAndGet();
                    }
                    return (J)super.visit(tree, (Object)n);
                }

                public JavaType visitType(@Nullable JavaType javaType, AtomicInteger n) {
                    return this.typeVisitor.visit(javaType, (Object)n);
                }

                public Markers visitMarkers(@Nullable Markers markers, AtomicInteger n) {
                    if (markers != null) {
                        n.addAndGet(markers.getMarkers().size());
                    }
                    return markers;
                }
            }.visit((Tree)this, n);
            return n.get();
        }

        public Charset getCharset() {
            return this.charsetName == null ? StandardCharsets.UTF_8 : Charset.forName(this.charsetName);
        }

        public SourceFile withCharset(Charset charset) {
            return this.withCharsetName(charset.name());
        }

        @Nullable
        public J.Package getPackageDeclaration() {
            return this.packageDeclaration == null ? null : (J.Package)this.packageDeclaration.getElement();
        }

        public CompilationUnit withPackageDeclaration(J.Package packageDeclaration) {
            return this.getPadding().withPackageDeclaration((JRightPadded<J.Package>)JRightPadded.withElement(this.packageDeclaration, (Object)packageDeclaration));
        }

        public List<J.Import> getImports() {
            return JRightPadded.getElements(this.imports);
        }

        public CompilationUnit withImports(List<J.Import> imports) {
            return this.getPadding().withImports(JRightPadded.withElements(this.imports, imports));
        }

        public List<Statement> getStatements() {
            return JRightPadded.getElements(this.statements);
        }

        public CompilationUnit withStatements(List<Statement> statements) {
            return this.getPadding().withStatements(JRightPadded.withElements(this.statements, statements));
        }

        @Transient
        public List<J.ClassDeclaration> getClasses() {
            return this.statements.stream().map(JRightPadded::getElement).filter(J.ClassDeclaration.class::isInstance).map(J.ClassDeclaration.class::cast).collect(Collectors.toList());
        }

        @Deprecated
        public CompilationUnit withClasses(List<J.ClassDeclaration> classes) {
            return this.getPadding().withClasses(JRightPadded.withElements(this.getPadding().getClasses(), classes));
        }

        @Override
        public <P> J acceptKotlin(KotlinVisitor<P> v, P p) {
            return v.visitCompilationUnit(this, p);
        }

        public <P> TreeVisitor<?, PrintOutputCapture<P>> printer(Cursor cursor) {
            return new KotlinPrinter();
        }

        @Transient
        public TypesInUse getTypesInUse() {
            TypesInUse cache;
            if (this.typesInUse == null) {
                cache = TypesInUse.build((JavaSourceFile)this);
                this.typesInUse = new SoftReference<TypesInUse>(cache);
            } else {
                cache = this.typesInUse.get();
                if (cache == null || cache.getCu() != this) {
                    cache = TypesInUse.build((JavaSourceFile)this);
                    this.typesInUse = new SoftReference<TypesInUse>(cache);
                }
            }
            return cache;
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public <S> S service(Class<S> service) {
            String serviceName = service.getName();
            try {
                Class<Object> serviceClass;
                if (KotlinImportService.class.getName().equals(serviceName)) {
                    serviceClass = service;
                } else if (ImportService.class.getName().equals(serviceName)) {
                    serviceClass = service.getClassLoader().loadClass(KotlinImportService.class.getName());
                } else if (KotlinAutoFormatService.class.getName().equals(serviceName)) {
                    serviceClass = service;
                } else if (AutoFormatService.class.getName().equals(serviceName)) {
                    serviceClass = service.getClassLoader().loadClass(KotlinAutoFormatService.class.getName());
                } else {
                    return (S)super.service(service);
                }
                return serviceClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public String toString() {
            return "K.CompilationUnit(typesInUse=" + this.getTypesInUse() + ", padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", sourcePath=" + this.getSourcePath() + ", fileAttributes=" + this.getFileAttributes() + ", charsetName=" + this.charsetName + ", charsetBomMarked=" + this.isCharsetBomMarked() + ", checksum=" + this.getChecksum() + ", annotations=" + this.getAnnotations() + ", packageDeclaration=" + this.getPackageDeclaration() + ", imports=" + this.getImports() + ", statements=" + this.getStatements() + ", eof=" + this.getEof() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CompilationUnit)) {
                return false;
            }
            CompilationUnit other = (CompilationUnit)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public CompilationUnit(UUID id, Space prefix, Markers markers, Path sourcePath, FileAttributes fileAttributes, String charsetName, boolean charsetBomMarked, Checksum checksum, List<J.Annotation> annotations, JRightPadded<J.Package> packageDeclaration, List<JRightPadded<J.Import>> imports, List<JRightPadded<Statement>> statements, Space eof) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.sourcePath = sourcePath;
            this.fileAttributes = fileAttributes;
            this.charsetName = charsetName;
            this.charsetBomMarked = charsetBomMarked;
            this.checksum = checksum;
            this.annotations = annotations;
            this.packageDeclaration = packageDeclaration;
            this.imports = imports;
            this.statements = statements;
            this.eof = eof;
        }

        private CompilationUnit(SoftReference<TypesInUse> typesInUse, WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, Path sourcePath, FileAttributes fileAttributes, String charsetName, boolean charsetBomMarked, Checksum checksum, List<J.Annotation> annotations, JRightPadded<J.Package> packageDeclaration, List<JRightPadded<J.Import>> imports, List<JRightPadded<Statement>> statements, Space eof) {
            this.typesInUse = typesInUse;
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.sourcePath = sourcePath;
            this.fileAttributes = fileAttributes;
            this.charsetName = charsetName;
            this.charsetBomMarked = charsetBomMarked;
            this.checksum = checksum;
            this.annotations = annotations;
            this.packageDeclaration = packageDeclaration;
            this.imports = imports;
            this.statements = statements;
            this.eof = eof;
        }

        public CompilationUnit withId(UUID id) {
            return this.id == id ? this : new CompilationUnit(this.typesInUse, this.padding, id, this.prefix, this.markers, this.sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.annotations, this.packageDeclaration, this.imports, this.statements, this.eof);
        }

        public UUID getId() {
            return this.id;
        }

        public CompilationUnit withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, prefix, this.markers, this.sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.annotations, this.packageDeclaration, this.imports, this.statements, this.eof);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public CompilationUnit withMarkers(Markers markers) {
            return this.markers == markers ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.prefix, markers, this.sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.annotations, this.packageDeclaration, this.imports, this.statements, this.eof);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public CompilationUnit withSourcePath(Path sourcePath) {
            return this.sourcePath == sourcePath ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.prefix, this.markers, sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.annotations, this.packageDeclaration, this.imports, this.statements, this.eof);
        }

        public Path getSourcePath() {
            return this.sourcePath;
        }

        public CompilationUnit withFileAttributes(FileAttributes fileAttributes) {
            return this.fileAttributes == fileAttributes ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.prefix, this.markers, this.sourcePath, fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.annotations, this.packageDeclaration, this.imports, this.statements, this.eof);
        }

        public FileAttributes getFileAttributes() {
            return this.fileAttributes;
        }

        private CompilationUnit withCharsetName(String charsetName) {
            return this.charsetName == charsetName ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.prefix, this.markers, this.sourcePath, this.fileAttributes, charsetName, this.charsetBomMarked, this.checksum, this.annotations, this.packageDeclaration, this.imports, this.statements, this.eof);
        }

        public CompilationUnit withCharsetBomMarked(boolean charsetBomMarked) {
            return this.charsetBomMarked == charsetBomMarked ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.prefix, this.markers, this.sourcePath, this.fileAttributes, this.charsetName, charsetBomMarked, this.checksum, this.annotations, this.packageDeclaration, this.imports, this.statements, this.eof);
        }

        public boolean isCharsetBomMarked() {
            return this.charsetBomMarked;
        }

        public CompilationUnit withChecksum(Checksum checksum) {
            return this.checksum == checksum ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.prefix, this.markers, this.sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, checksum, this.annotations, this.packageDeclaration, this.imports, this.statements, this.eof);
        }

        public Checksum getChecksum() {
            return this.checksum;
        }

        public CompilationUnit withAnnotations(List<J.Annotation> annotations) {
            return this.annotations == annotations ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.prefix, this.markers, this.sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, annotations, this.packageDeclaration, this.imports, this.statements, this.eof);
        }

        public List<J.Annotation> getAnnotations() {
            return this.annotations;
        }

        public CompilationUnit withEof(Space eof) {
            return this.eof == eof ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.prefix, this.markers, this.sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.annotations, this.packageDeclaration, this.imports, this.statements, eof);
        }

        public Space getEof() {
            return this.eof;
        }

        public static class Padding
        implements JavaSourceFile.Padding {
            private final CompilationUnit t;

            @Nullable
            public JRightPadded<J.Package> getPackageDeclaration() {
                return this.t.packageDeclaration;
            }

            public CompilationUnit withPackageDeclaration(@Nullable JRightPadded<J.Package> packageDeclaration) {
                return this.t.packageDeclaration == packageDeclaration ? this.t : new CompilationUnit(this.t.id, this.t.prefix, this.t.markers, this.t.sourcePath, this.t.fileAttributes, this.t.charsetName, this.t.charsetBomMarked, null, this.t.annotations, packageDeclaration, this.t.imports, this.t.statements, this.t.eof);
            }

            @Transient
            public List<JRightPadded<J.ClassDeclaration>> getClasses() {
                return this.t.statements.stream().filter(s -> s.getElement() instanceof J.ClassDeclaration).map(s -> s).collect(Collectors.toList());
            }

            public CompilationUnit withClasses(List<JRightPadded<J.ClassDeclaration>> classes) {
                List<JRightPadded<Statement>> statements = this.t.statements.stream().filter(s -> !(s.getElement() instanceof J.ClassDeclaration)).collect(Collectors.toList());
                statements.addAll(0, classes.stream().map(i -> i).collect(Collectors.toList()));
                return this.t.getPadding().getClasses() == classes ? this.t : new CompilationUnit(this.t.id, this.t.prefix, this.t.markers, this.t.sourcePath, this.t.fileAttributes, this.t.charsetName, this.t.charsetBomMarked, this.t.checksum, this.t.annotations, (JRightPadded<J.Package>)this.t.packageDeclaration, this.t.imports, statements, this.t.eof);
            }

            public List<JRightPadded<J.Import>> getImports() {
                return this.t.imports;
            }

            public CompilationUnit withImports(List<JRightPadded<J.Import>> imports) {
                return this.t.imports == imports ? this.t : new CompilationUnit(this.t.id, this.t.prefix, this.t.markers, this.t.sourcePath, this.t.fileAttributes, this.t.charsetName, this.t.charsetBomMarked, null, this.t.annotations, (JRightPadded<J.Package>)this.t.packageDeclaration, imports, this.t.statements, this.t.eof);
            }

            public List<JRightPadded<Statement>> getStatements() {
                return this.t.statements;
            }

            public CompilationUnit withStatements(List<JRightPadded<Statement>> statements) {
                return this.t.statements == statements ? this.t : new CompilationUnit(this.t.id, this.t.prefix, this.t.markers, this.t.sourcePath, this.t.fileAttributes, this.t.charsetName, this.t.charsetBomMarked, this.t.checksum, this.t.annotations, (JRightPadded<J.Package>)this.t.packageDeclaration, this.t.imports, statements, this.t.eof);
            }

            public Padding(CompilationUnit t) {
                this.t = t;
            }
        }
    }
}

