/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.aether.repository.RemoteRepository;
import org.openrewrite.Parser;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenModuleLoader;
import org.openrewrite.maven.tree.Maven;
import org.openrewrite.maven.tree.MavenModel;
import org.openrewrite.xml.XmlParser;
import org.openrewrite.xml.tree.Xml;

public class MavenParser
implements Parser<Maven.Pom> {
    public static final File DEFAULT_LOCAL_REPOSITORY = new File(System.getProperty("user.home") + "/.m2/rewrite");
    private final XmlParser xmlParser = new XmlParser();
    private final boolean resolveDependencies;
    private final File localRepository;
    @Nullable
    private final File workspaceDir;
    private final List<RemoteRepository> remoteRepositories;

    private MavenParser(boolean resolveDependencies, File localRepository, @Nullable File workspaceDir, List<RemoteRepository> remoteRepositories) {
        this.resolveDependencies = resolveDependencies;
        this.localRepository = localRepository;
        this.workspaceDir = workspaceDir;
        this.remoteRepositories = remoteRepositories;
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<Maven.Pom> parseInputs(Iterable<Parser.Input> sourceFiles, @Nullable Path relativeTo) {
        List pomSourceFiles = this.acceptedInputs(sourceFiles);
        List<MavenModel> modules = new MavenModuleLoader(this.resolveDependencies, this.localRepository, this.workspaceDir, this.remoteRepositories).load(pomSourceFiles);
        ArrayList<Maven.Pom> poms = new ArrayList<Maven.Pom>();
        Iterator xmlDocuments = this.xmlParser.parseInputs((Iterable)pomSourceFiles, relativeTo).iterator();
        for (MavenModel module : modules) {
            poms.add(new Maven.Pom(module, (Xml.Document)xmlDocuments.next()));
        }
        return poms;
    }

    public boolean accept(Path path) {
        return path.getFileName().toString().equals("pom.xml");
    }

    public static class Builder {
        private boolean resolveDependencies = true;
        private File localRepository = DEFAULT_LOCAL_REPOSITORY;
        private List<RemoteRepository> remoteRepositories = new ArrayList<RemoteRepository>();
        @Nullable
        private File workspaceDir;

        public Builder() {
            this.remoteRepositories.add(new RemoteRepository.Builder("central", "default", "https://repo1.maven.org/maven2/").build());
        }

        public Builder localRepository(File localRepository) {
            this.localRepository = localRepository;
            return this;
        }

        public Builder workspaceDir(File workspaceDir) {
            this.workspaceDir = workspaceDir;
            return this;
        }

        public Builder resolveDependencies(boolean resolveDependencies) {
            this.resolveDependencies = resolveDependencies;
            return this;
        }

        public Builder remoteRepositories(List<RemoteRepository> remoteRepositories) {
            this.remoteRepositories = remoteRepositories;
            return this;
        }

        public Builder addRemoteRepository(RemoteRepository remoteRepository) {
            this.remoteRepositories.add(remoteRepository);
            return this;
        }

        public MavenParser build() {
            return new MavenParser(this.resolveDependencies, this.localRepository, this.workspaceDir, this.remoteRepositories);
        }
    }
}

