/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.tree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.openrewrite.Tree;
import org.openrewrite.xml.ChangeTagContent;
import org.openrewrite.xml.search.FindTag;
import org.openrewrite.xml.search.FindTags;
import org.openrewrite.xml.tree.Content;
import org.openrewrite.xml.tree.Xml;

class MemoizedTags<M> {
    private final Xml.Tag root;
    private final String pathToModel;
    private final Function<Xml.Tag, M> buildModel;
    private final Function<M, Xml.Tag> modelToTag;
    private final Xml.Tag parent;
    private List<M> memoized;

    protected MemoizedTags(Xml.Tag root, String pathToModel, Function<Xml.Tag, M> buildModel, Function<M, Xml.Tag> modelToTag) {
        this.root = root;
        this.pathToModel = pathToModel;
        this.buildModel = buildModel;
        this.modelToTag = modelToTag;
        this.parent = (Xml.Tag)new FindTag(pathToModel.substring(0, pathToModel.lastIndexOf(47))).visit((Tree)root);
    }

    public List<M> getModels() {
        return this.memoizeIfNecessary();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<Xml.Tag> with(List<M> maybeMutated) {
        if (this.root == null) {
            throw new IllegalStateException("Expecting parent tag to already exist");
        }
        MemoizedTags memoizedTags = this;
        synchronized (memoizedTags) {
            if (maybeMutated != this.getModels()) {
                ArrayList content = new ArrayList();
                maybeMutated.forEach(model -> content.add((Content)this.modelToTag.apply(model)));
                return Optional.ofNullable((Xml.Tag)new ChangeTagContent(this.parent, content).visit((Tree)this.root));
            }
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<M> memoizeIfNecessary() {
        if (this.memoized == null) {
            List memoizable = Optional.ofNullable(this.root).map(parent -> (List)new FindTags(this.pathToModel).visit((Tree)this.root)).map(tags -> tags.stream().map(this.buildModel).collect(Collectors.toList())).orElse(Collections.emptyList());
            MemoizedTags memoizedTags = this;
            synchronized (memoizedTags) {
                if (this.memoized == null) {
                    this.memoized = memoizable;
                }
            }
        }
        return this.memoized;
    }
}

