/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.internal;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import okhttp3.ConnectionSpec;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.openrewrite.Parser;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.cache.CacheResult;
import org.openrewrite.maven.cache.MavenCache;
import org.openrewrite.maven.internal.MavenMetadata;
import org.openrewrite.maven.internal.RawMaven;
import org.openrewrite.maven.internal.RawRepositories;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenDownloader {
    private static final Logger logger = LoggerFactory.getLogger(MavenDownloader.class);
    private static final OkHttpClient httpClient = new OkHttpClient.Builder().connectionSpecs(Arrays.asList(ConnectionSpec.CLEARTEXT, ConnectionSpec.MODERN_TLS, ConnectionSpec.COMPATIBLE_TLS)).build();
    private static final RawRepositories.Repository SUPER_POM_REPOSITORY = new RawRepositories.Repository("https://repo.maven.apache.org/maven2", new RawRepositories.ArtifactPolicy(true), new RawRepositories.ArtifactPolicy(false));
    private final MavenCache mavenCache;
    private final Map<String, RawMaven> projectPoms;

    public MavenDownloader(MavenCache mavenCache) {
        this(mavenCache, Collections.emptyMap());
    }

    public MavenDownloader(MavenCache mavenCache, Map<String, RawMaven> projectPoms) {
        this.mavenCache = mavenCache;
        this.projectPoms = projectPoms;
    }

    public MavenMetadata downloadMetadata(String groupId, String artifactId, List<RawRepositories.Repository> repositories) {
        Timer.Sample sample = Timer.start();
        return Stream.concat(repositories.stream().distinct().map(this::normalizeRepository), Stream.of(SUPER_POM_REPOSITORY)).filter(Objects::nonNull).map(repo -> {
            Timer.Builder timer = Timer.builder((String)"rewrite.maven.download").tag("group.id", groupId).tag("artifact.id", artifactId).tag("type", "metadata");
            try {
                CacheResult<MavenMetadata> result = this.mavenCache.computeMavenMetadata(URI.create(repo.getUrl()).toURL(), groupId, artifactId, () -> this.forceDownloadMetadata(groupId, artifactId, null, (RawRepositories.Repository)repo));
                sample.stop(this.addTagsByResult(timer, result).register((MeterRegistry)Metrics.globalRegistry));
                return result.getData();
            }
            catch (Exception e) {
                sample.stop(timer.tags(new String[]{"outcome", "error", "exception", e.getClass().getName()}).register((MeterRegistry)Metrics.globalRegistry));
                return null;
            }
        }).filter(Objects::nonNull).reduce(MavenMetadata.EMPTY, (m1, m2) -> {
            if (m1 == MavenMetadata.EMPTY) {
                if (m2 == MavenMetadata.EMPTY) {
                    return m1;
                }
                return m2;
            }
            if (m2 == MavenMetadata.EMPTY) {
                return m1;
            }
            return new MavenMetadata(new MavenMetadata.Versioning(Stream.concat(m1.getVersioning().getVersions().stream(), m2.getVersioning().getVersions().stream()).collect(Collectors.toList()), null));
        });
    }

    @Nullable
    private MavenMetadata forceDownloadMetadata(String groupId, String artifactId, @Nullable String version, RawRepositories.Repository repo) throws IOException {
        logger.debug("Resolving {}:{} metadata from {}", new Object[]{groupId, artifactId, repo.getUrl()});
        String uri = repo.getUrl() + "/" + groupId.replace('.', '/') + '/' + artifactId + '/' + (version == null ? "" : version + '/') + "maven-metadata.xml";
        Request request = new Request.Builder().url(uri).get().build();
        try (Response response = httpClient.newCall(request).execute();){
            if (response.isSuccessful() && response.body() != null) {
                byte[] responseBody = response.body().bytes();
                MavenMetadata mavenMetadata = MavenMetadata.parse(responseBody);
                return mavenMetadata;
            }
        }
        return null;
    }

    private Timer.Builder addTagsByResult(Timer.Builder timer, CacheResult<?> result) {
        switch (result.getState()) {
            case Cached: {
                timer = timer.tags(new String[]{"outcome", "cached", "exception", "none"});
                break;
            }
            case Unavailable: {
                timer = timer.tags(new String[]{"outcome", "unavailable", "exception", "none"});
                break;
            }
            case Updated: {
                timer = timer.tags(new String[]{"outcome", "downloaded", "exception", "none"});
            }
        }
        return timer;
    }

    @Nullable
    public RawMaven download(String groupId, String artifactId, String version, @Nullable String classifier, @Nullable String relativePath, @Nullable RawMaven containingPom, List<RawRepositories.Repository> repositories) {
        String versionMaybeDatedSnapshot = this.findDatedSnapshotVersionIfNecessary(groupId, artifactId, version, repositories);
        if (versionMaybeDatedSnapshot == null) {
            return null;
        }
        Timer.Sample sample = Timer.start();
        if (containingPom == null || !containingPom.getSourcePath().contains("http")) {
            if (!StringUtils.isBlank((String)relativePath)) {
                return Optional.ofNullable(containingPom).map(pom -> {
                    Path relativePomPath = Paths.get(pom.getSourcePath(), new String[0]).getParent().resolve(Paths.get(relativePath, "pom.xml")).normalize();
                    return this.projectPoms.get(relativePomPath.toString());
                }).orElse(null);
            }
            for (RawMaven projectPom : this.projectPoms.values()) {
                if (!groupId.equals(projectPom.getPom().getGroupId()) || !artifactId.equals(projectPom.getPom().getArtifactId())) continue;
                return projectPom;
            }
        }
        return Stream.concat(repositories.stream().distinct().map(this::normalizeRepository), Stream.of(SUPER_POM_REPOSITORY)).filter(Objects::nonNull).filter(repo -> repo.acceptsVersion(version)).map(repo -> {
            Timer.Builder timer = Timer.builder((String)"rewrite.maven.download").tag("group.id", groupId).tag("artifact.id", artifactId).tag("type", "pom");
            try {
                CacheResult<RawMaven> result = this.mavenCache.computeMaven(URI.create(repo.getUrl()).toURL(), groupId, artifactId, versionMaybeDatedSnapshot, () -> {
                    String uri = repo.getUrl() + "/" + groupId.replace('.', '/') + '/' + artifactId + '/' + version + '/' + artifactId + '-' + versionMaybeDatedSnapshot + ".pom";
                    Request request = new Request.Builder().url(uri).get().build();
                    try (Response response = httpClient.newCall(request).execute();){
                        if (response.isSuccessful() && response.body() != null) {
                            byte[] responseBody = response.body().bytes();
                            RawMaven rawMaven = RawMaven.parse(new Parser.Input(URI.create(uri), () -> new ByteArrayInputStream(responseBody)), null, versionMaybeDatedSnapshot.equals(version) ? null : versionMaybeDatedSnapshot);
                            return rawMaven;
                        }
                    }
                    return null;
                });
                sample.stop(this.addTagsByResult(timer, result).register((MeterRegistry)Metrics.globalRegistry));
                return result.getData();
            }
            catch (Exception e) {
                logger.debug("Failed to download {}:{}:{}:{}", new Object[]{groupId, artifactId, version, classifier, e});
                sample.stop(timer.tags(new String[]{"outcome", "error", "exception", e.getClass().getName()}).register((MeterRegistry)Metrics.globalRegistry));
                return null;
            }
        }).filter(Objects::nonNull).findFirst().orElse(null);
    }

    @Nullable
    private String findDatedSnapshotVersionIfNecessary(String groupId, String artifactId, String version, List<RawRepositories.Repository> repositories) {
        MavenMetadata mavenMetadata;
        if (version.endsWith("-SNAPSHOT") && (mavenMetadata = (MavenMetadata)repositories.stream().distinct().map(this::normalizeRepository).filter(Objects::nonNull).filter(repo -> repo.acceptsVersion(version)).map(repo -> {
            try {
                return this.forceDownloadMetadata(groupId, artifactId, version, (RawRepositories.Repository)repo);
            }
            catch (IOException e) {
                logger.debug("Failed to download snapshot metadata for {}:{}:{}", new Object[]{groupId, artifactId, version});
                return null;
            }
        }).filter(Objects::nonNull).findFirst().orElse(null)) != null) {
            MavenMetadata.Snapshot snapshot = mavenMetadata.getVersioning().getSnapshot();
            if (snapshot == null) {
                return null;
            }
            return version.replaceFirst("SNAPSHOT$", snapshot.getTimestamp() + "-" + snapshot.getBuildNumber());
        }
        return version;
    }

    @Nullable
    private RawRepositories.Repository normalizeRepository(RawRepositories.Repository repository) {
        try {
            CacheResult<RawRepositories.Repository> result = this.mavenCache.computeRepository(repository, () -> {
                String url = repository.getUrl();
                Request request = new Request.Builder().url(url).head().build();
                try (Response response = httpClient.newCall(request).execute();){
                    if (url.toLowerCase().contains("http://")) {
                        RawRepositories.Repository repository2 = this.normalizeRepository(new RawRepositories.Repository(url.toLowerCase().replace("http://", "https://"), repository.getReleases(), repository.getSnapshots()));
                        return repository2;
                    }
                    if (response.isSuccessful()) {
                        RawRepositories.Repository repository3 = new RawRepositories.Repository(url, repository.getReleases(), repository.getSnapshots());
                        return repository3;
                    }
                    RawRepositories.Repository repository4 = null;
                    return repository4;
                }
            });
            return result.getData();
        }
        catch (Exception e) {
            return null;
        }
    }
}

