/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Optional;
import java.util.stream.Collectors;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.maven.cache.MavenPomCache;
import org.openrewrite.maven.internal.MavenMetadata;
import org.openrewrite.maven.internal.MavenPomDownloader;
import org.openrewrite.maven.tree.Maven;
import org.openrewrite.semver.LatestRelease;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;
import org.openrewrite.xml.ChangeTagValueVisitor;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.tree.Xml;

public final class UpgradeParentVersion
extends Recipe {
    private static final XPathMatcher PARENT_VERSION_MATCHER = new XPathMatcher("/project/parent/version");
    @Option(displayName="Group", description="The first part of a dependency coordinate 'org.springframework.boot:spring-boot-parent:VERSION'.", example="org.springframework.boot")
    private final String groupId;
    @Option(displayName="Artifact", description="The second part of a dependency coordinate 'org.springframework.boot:spring-boot-parent:VERSION'.", example="spring-boot-parent")
    private final String artifactId;
    @Option(displayName="New version", description="An exact version number, or node-style semver selector used to select the version number.", example="29.X")
    private final String newVersion;
    @Option(displayName="Version pattern", description="Allows version selection to be extended beyond the original Node Semver semantics. So for example,Setting 'version' to \"25-29\" can be paired with a metadata pattern of \"-jre\" to select Guava 29.0-jre", example="-jre", required=false)
    @Nullable
    private final String versionPattern;

    public Validated validate() {
        Validated validated = super.validate();
        if (this.newVersion != null) {
            validated = validated.and(Semver.validate((String)this.newVersion, (String)this.versionPattern));
        }
        return validated;
    }

    public String getDisplayName() {
        return "Upgrade Maven parent project version";
    }

    public String getDescription() {
        return "Set the parent pom version number according to a node-style semver selector or to a specific version number.";
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new UpgradeParentVersionVisitor(this.newVersion, this.versionPattern);
    }

    public UpgradeParentVersion(String groupId, String artifactId, String newVersion, @Nullable String versionPattern) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.newVersion = newVersion;
        this.versionPattern = versionPattern;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getNewVersion() {
        return this.newVersion;
    }

    @Nullable
    public String getVersionPattern() {
        return this.versionPattern;
    }

    @NonNull
    public String toString() {
        return "UpgradeParentVersion(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", newVersion=" + this.getNewVersion() + ", versionPattern=" + this.getVersionPattern() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpgradeParentVersion)) {
            return false;
        }
        UpgradeParentVersion other = (UpgradeParentVersion)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$newVersion = this.getNewVersion();
        String other$newVersion = other.getNewVersion();
        if (this$newVersion == null ? other$newVersion != null : !this$newVersion.equals(other$newVersion)) {
            return false;
        }
        String this$versionPattern = this.getVersionPattern();
        String other$versionPattern = other.getVersionPattern();
        return !(this$versionPattern == null ? other$versionPattern != null : !this$versionPattern.equals(other$versionPattern));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof UpgradeParentVersion;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $newVersion = this.getNewVersion();
        result = result * 59 + ($newVersion == null ? 43 : $newVersion.hashCode());
        String $versionPattern = this.getVersionPattern();
        result = result * 59 + ($versionPattern == null ? 43 : $versionPattern.hashCode());
        return result;
    }

    private class ChangeParentVersion
    extends MavenVisitor {
        private final String toVersion;

        private ChangeParentVersion(String toVersion) {
            this.toVersion = toVersion;
        }

        public Xml visitTag(Xml.Tag tag, ExecutionContext ctx) {
            if (PARENT_VERSION_MATCHER.matches(this.getCursor())) {
                Xml.Tag parent = (Xml.Tag)this.getCursor().getParentOrThrow().getValue();
                if (UpgradeParentVersion.this.groupId.equals(parent.getChildValue("groupId").orElse(null)) && UpgradeParentVersion.this.artifactId.equals(parent.getChildValue("artifactId").orElse(null)) && !this.toVersion.equals(tag.getValue().orElse(null))) {
                    this.doAfterVisit((TreeVisitor)new ChangeTagValueVisitor(tag, this.toVersion));
                }
            }
            return super.visitTag(tag, (Object)ctx);
        }
    }

    private class UpgradeParentVersionVisitor
    extends MavenVisitor {
        @Nullable
        private Collection<String> availableVersions;
        private final VersionComparator versionComparator;

        public UpgradeParentVersionVisitor(@Nullable String toVersion, String metadataPattern) {
            this.versionComparator = (VersionComparator)Semver.validate((String)toVersion, (String)metadataPattern).getValue();
        }

        @Override
        public Maven visitMaven(Maven maven, ExecutionContext ctx) {
            return super.visitMaven(maven, ctx);
        }

        public Xml visitTag(Xml.Tag tag, ExecutionContext ctx) {
            if (this.isParentTag() && UpgradeParentVersion.this.groupId.equals(tag.getChildValue("groupId").orElse(null)) && UpgradeParentVersion.this.artifactId.equals(tag.getChildValue("artifactId").orElse(null))) {
                tag.getChildValue("version").flatMap(parentVersion -> this.findNewerDependencyVersion(UpgradeParentVersion.this.groupId, UpgradeParentVersion.this.artifactId, (String)parentVersion, ctx)).ifPresent(newer -> {
                    ChangeParentVersion changeParentVersion = new ChangeParentVersion((String)newer);
                    this.doAfterVisit((TreeVisitor)changeParentVersion);
                });
            }
            return super.visitTag(tag, (Object)ctx);
        }

        private Optional<String> findNewerDependencyVersion(String groupId, String artifactId, String currentVersion, ExecutionContext ctx) {
            if (this.availableVersions == null) {
                MavenMetadata mavenMetadata = new MavenPomDownloader(MavenPomCache.NOOP, Collections.emptyMap(), ctx).downloadMetadata(groupId, artifactId, Collections.emptyList());
                this.availableVersions = mavenMetadata.getVersioning().getVersions().stream().filter(arg_0 -> ((VersionComparator)this.versionComparator).isValid(arg_0)).collect(Collectors.toList());
            }
            LatestRelease latestRelease = new LatestRelease(UpgradeParentVersion.this.versionPattern);
            return this.availableVersions.stream().filter(v -> latestRelease.compare(currentVersion, v) < 0).max((Comparator<String>)this.versionComparator);
        }
    }
}

