/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.internal;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.internal.MavenXmlMapper;
import org.openrewrite.xml.XmlParser;

public class MavenMetadata {
    private static final XmlParser xmlParser = new XmlParser(){

        public boolean accept(Path path) {
            return super.accept(path) || path.toString().endsWith(".pom");
        }
    };
    public static final MavenMetadata EMPTY = new MavenMetadata(new Versioning(Collections.emptyList(), null));
    private final Versioning versioning;

    public MavenMetadata(Versioning versioning) {
        this.versioning = versioning;
    }

    public static MavenMetadata parse(byte[] document) {
        try {
            return (MavenMetadata)MavenXmlMapper.readMapper().readValue(document, MavenMetadata.class);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public Versioning getVersioning() {
        return this.versioning;
    }

    public static class Snapshot {
        private final String timestamp;
        private final String buildNumber;

        public Snapshot(String timestamp, String buildNumber) {
            this.timestamp = timestamp;
            this.buildNumber = buildNumber;
        }

        public String getTimestamp() {
            return this.timestamp;
        }

        public String getBuildNumber() {
            return this.buildNumber;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Snapshot)) {
                return false;
            }
            Snapshot other = (Snapshot)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$timestamp = this.getTimestamp();
            String other$timestamp = other.getTimestamp();
            if (this$timestamp == null ? other$timestamp != null : !this$timestamp.equals(other$timestamp)) {
                return false;
            }
            String this$buildNumber = this.getBuildNumber();
            String other$buildNumber = other.getBuildNumber();
            return !(this$buildNumber == null ? other$buildNumber != null : !this$buildNumber.equals(other$buildNumber));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Snapshot;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $timestamp = this.getTimestamp();
            result = result * 59 + ($timestamp == null ? 43 : $timestamp.hashCode());
            String $buildNumber = this.getBuildNumber();
            result = result * 59 + ($buildNumber == null ? 43 : $buildNumber.hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "MavenMetadata.Snapshot(timestamp=" + this.getTimestamp() + ", buildNumber=" + this.getBuildNumber() + ")";
        }
    }

    public static class Versioning {
        private final List<String> versions;
        @Nullable
        private final Snapshot snapshot;

        public Versioning(@JacksonXmlElementWrapper(localName="versions") List<String> versions, @Nullable Snapshot snapshot) {
            this.versions = versions;
            this.snapshot = snapshot;
        }

        public List<String> getVersions() {
            return this.versions;
        }

        @Nullable
        public Snapshot getSnapshot() {
            return this.snapshot;
        }
    }
}

