/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.internal;

import java.util.Collections;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.internal.RequestedVersion;
import org.openrewrite.maven.tree.GroupArtifact;

public class ProfileActivation {
    @Nullable
    private final Boolean activeByDefault;
    @Nullable
    private final String jdk;
    @Nullable
    private final Property property;

    public static boolean isActive(@Nullable String id, Iterable<String> activeProfiles, @Nullable ProfileActivation activation) {
        if (id != null) {
            for (String activeProfile : activeProfiles) {
                if (!activeProfile.trim().equals(id)) continue;
                return true;
            }
        }
        return activation != null && activation.isActive();
    }

    public boolean isActive() {
        return this.activeByDefault != null && this.activeByDefault != false || this.isActiveByJdk() || this.isActiveByProperty();
    }

    private boolean isActiveByJdk() {
        if (this.jdk == null) {
            return false;
        }
        String version = System.getProperty("java.version");
        RequestedVersion requestedVersion = new RequestedVersion(new GroupArtifact("", ""), null, this.jdk);
        if (requestedVersion.isDynamic() || requestedVersion.isRange()) {
            return requestedVersion.selectFrom(Collections.singletonList(version)) != null;
        }
        return version.startsWith(requestedVersion.nearestVersion());
    }

    private boolean isActiveByProperty() {
        if (this.property == null) {
            return false;
        }
        String name = this.property.getName().trim();
        if (name.startsWith("!")) {
            return !System.getenv().containsKey(name.replace("!", ""));
        }
        if (this.property.getValue() == null) {
            return System.getenv().containsKey(name);
        }
        return this.property.getValue().equals(System.getenv(name));
    }

    public ProfileActivation(@Nullable Boolean activeByDefault, @Nullable String jdk, @Nullable Property property) {
        this.activeByDefault = activeByDefault;
        this.jdk = jdk;
        this.property = property;
    }

    @Nullable
    public Boolean getActiveByDefault() {
        return this.activeByDefault;
    }

    @Nullable
    public String getJdk() {
        return this.jdk;
    }

    @Nullable
    public Property getProperty() {
        return this.property;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProfileActivation)) {
            return false;
        }
        ProfileActivation other = (ProfileActivation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$activeByDefault = this.getActiveByDefault();
        Boolean other$activeByDefault = other.getActiveByDefault();
        if (this$activeByDefault == null ? other$activeByDefault != null : !((Object)this$activeByDefault).equals(other$activeByDefault)) {
            return false;
        }
        String this$jdk = this.getJdk();
        String other$jdk = other.getJdk();
        if (this$jdk == null ? other$jdk != null : !this$jdk.equals(other$jdk)) {
            return false;
        }
        Property this$property = this.getProperty();
        Property other$property = other.getProperty();
        return !(this$property == null ? other$property != null : !((Object)this$property).equals(other$property));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ProfileActivation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $activeByDefault = this.getActiveByDefault();
        result = result * 59 + ($activeByDefault == null ? 43 : ((Object)$activeByDefault).hashCode());
        String $jdk = this.getJdk();
        result = result * 59 + ($jdk == null ? 43 : $jdk.hashCode());
        Property $property = this.getProperty();
        result = result * 59 + ($property == null ? 43 : ((Object)$property).hashCode());
        return result;
    }

    @NonNull
    public String toString() {
        return "ProfileActivation(activeByDefault=" + this.getActiveByDefault() + ", jdk=" + this.getJdk() + ", property=" + this.getProperty() + ")";
    }

    public static class Property {
        private final String name;
        @Nullable
        private final String value;

        public Property(String name, @Nullable String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        @Nullable
        public String getValue() {
            return this.value;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Property)) {
                return false;
            }
            Property other = (Property)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Property;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "ProfileActivation.Property(name=" + this.getName() + ", value=" + this.getValue() + ")";
        }
    }
}

