/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.search;

import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.RecipeSearchResult;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.maven.tree.Pom;
import org.openrewrite.maven.tree.Scope;
import org.openrewrite.xml.tree.Xml;

@Incubating(since="7.0.0")
public final class DependencyInsight
extends Recipe {
    @Option(displayName="Group pattern", description="Group glob pattern used to match dependencies.", example="com.fasterxml.jackson.module")
    private final String groupIdPattern;
    @Option(displayName="Artifact pattern", description="Artifact glob pattern used to match dependencies.", example="jackson-module-*")
    private final String artifactIdPattern;
    @Option(displayName="Scope", description="Match dependencies with the specified scope", valid={"compile", "test", "runtime", "provided"})
    private final String scope;

    public Validated validate() {
        return super.validate().and(Validated.test((String)"scope", (String)"scope is a valid Maven scope", (Object)this.scope, s -> {
            try {
                Scope.fromName(s);
                return true;
            }
            catch (Throwable t) {
                return false;
            }
        }));
    }

    public String getDisplayName() {
        return "Maven dependency insight";
    }

    public String getDescription() {
        return "Find direct and transitive dependencies matching a group, artifact, and scope. Results include dependencies that either directly match or transitively include a matching dependency.";
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        final Pattern groupIdMatcher = Pattern.compile(this.groupIdPattern.replace(".", "\\.").replace("*", ".*"));
        final Pattern artifactIdMatcher = Pattern.compile(this.artifactIdPattern.replace(".", "\\.").replace("*", ".*"));
        final Scope aScope = Scope.fromName(this.scope);
        return new MavenVisitor(){

            public Xml visitTag(Xml.Tag tag, ExecutionContext context) {
                Set<Pom.Dependency> dependencies;
                Optional<Pom.Dependency> match;
                Pom.Dependency dependency;
                Xml.Tag t = (Xml.Tag)super.visitTag(tag, (Object)context);
                if (this.isDependencyTag() && (dependency = this.findDependency(t)) != null && (match = (dependencies = this.model.getDependencies(dependency, aScope)).stream().filter(this::dependencyMatches).findFirst()).isPresent()) {
                    t = this.dependencyMatches(dependency) ? (Xml.Tag)t.withMarker(new Marker[]{new RecipeSearchResult((Recipe)DependencyInsight.this)}) : (Xml.Tag)t.withMarker(new Marker[]{new RecipeSearchResult((Recipe)DependencyInsight.this, match.get().getCoordinates())});
                }
                return t;
            }

            private boolean dependencyMatches(Pom.Dependency d) {
                return groupIdMatcher.matcher(d.getGroupId()).matches() && artifactIdMatcher.matcher(d.getArtifactId()).matches();
            }
        };
    }

    public DependencyInsight(String groupIdPattern, String artifactIdPattern, String scope) {
        this.groupIdPattern = groupIdPattern;
        this.artifactIdPattern = artifactIdPattern;
        this.scope = scope;
    }

    public String getGroupIdPattern() {
        return this.groupIdPattern;
    }

    public String getArtifactIdPattern() {
        return this.artifactIdPattern;
    }

    public String getScope() {
        return this.scope;
    }

    @NonNull
    public String toString() {
        return "DependencyInsight(groupIdPattern=" + this.getGroupIdPattern() + ", artifactIdPattern=" + this.getArtifactIdPattern() + ", scope=" + this.getScope() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DependencyInsight)) {
            return false;
        }
        DependencyInsight other = (DependencyInsight)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$groupIdPattern = this.getGroupIdPattern();
        String other$groupIdPattern = other.getGroupIdPattern();
        if (this$groupIdPattern == null ? other$groupIdPattern != null : !this$groupIdPattern.equals(other$groupIdPattern)) {
            return false;
        }
        String this$artifactIdPattern = this.getArtifactIdPattern();
        String other$artifactIdPattern = other.getArtifactIdPattern();
        if (this$artifactIdPattern == null ? other$artifactIdPattern != null : !this$artifactIdPattern.equals(other$artifactIdPattern)) {
            return false;
        }
        String this$scope = this.getScope();
        String other$scope = other.getScope();
        return !(this$scope == null ? other$scope != null : !this$scope.equals(other$scope));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof DependencyInsight;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $groupIdPattern = this.getGroupIdPattern();
        result = result * 59 + ($groupIdPattern == null ? 43 : $groupIdPattern.hashCode());
        String $artifactIdPattern = this.getArtifactIdPattern();
        result = result * 59 + ($artifactIdPattern == null ? 43 : $artifactIdPattern.hashCode());
        String $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        return result;
    }
}

