/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.maven.tree.Maven;
import org.openrewrite.xml.AutoFormat;
import org.openrewrite.xml.tree.Content;
import org.openrewrite.xml.tree.Xml;

public class OrderPomElements
extends Recipe {
    private static final List<String> REQUIRED_ORDER = Arrays.asList("modelVersion", "parent", "groupId", "artifactId", "version", "packaging", "name", "description", "url", "inceptionYear", "organization", "licenses", "developers", "contributors", "mailingLists", "prerequisites", "modules", "scm", "issueManagement", "ciManagement", "distributionManagement", "properties", "dependencyManagement", "dependencies", "repositories", "pluginRepositories", "build", "reporting", "profiles");

    public String getDisplayName() {
        return "Order POM elements";
    }

    public String getDescription() {
        return "Order POM elements according to the [recommended](http://maven.apache.org/developers/conventions/code.html#pom-code-convention) order.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-3423");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(10L);
    }

    protected MavenVisitor getVisitor() {
        return new MavenVisitor(){

            @Override
            public Maven visitMaven(Maven maven, ExecutionContext ctx) {
                Maven mvn = super.visitMaven(maven, ctx);
                Xml.Tag root = mvn.getRoot();
                if (root.getContent() != null) {
                    ArrayList content = new ArrayList(root.getContent());
                    ArrayList<Object> updatedOrder = new ArrayList<Object>();
                    block0: for (String order : REQUIRED_ORDER) {
                        Iterator iterator = content.iterator();
                        while (iterator.hasNext()) {
                            Xml.Tag tag;
                            Content c = (Content)iterator.next();
                            if (!(c instanceof Xml.Tag) || !(tag = (Xml.Tag)c).getName().equals(order)) continue;
                            updatedOrder.add(c);
                            iterator.remove();
                            continue block0;
                        }
                    }
                    updatedOrder.addAll(content);
                    boolean foundChange = false;
                    for (int i = 0; i < root.getContent().size(); ++i) {
                        if (root.getContent().get(i) == updatedOrder.get(i)) continue;
                        foundChange = true;
                        break;
                    }
                    if (foundChange) {
                        root = root.withContent(updatedOrder);
                        mvn = mvn.withRoot(root);
                        this.doAfterVisit((Recipe)new AutoFormat());
                    }
                }
                return mvn;
            }

            public Xml visitTag(Xml.Tag tag, ExecutionContext executionContext) {
                Xml.Tag tg = (Xml.Tag)super.visitTag(tag, (Object)executionContext);
                if ("dependency".equals(tg.getName()) || "parent".equals(tg.getName())) {
                    tg = this.orderGav(tg);
                }
                return tg;
            }

            private Xml.Tag orderGav(Xml.Tag gavParent) {
                List gavParentContent = gavParent.getChildren();
                int groupPos = -1;
                int artifactPos = -1;
                int versionPos = -1;
                HashMap<String, Xml.Tag> gavGroups = new HashMap<String, Xml.Tag>();
                for (int i = 0; i < gavParentContent.size(); ++i) {
                    Content content = (Content)gavParentContent.get(i);
                    Xml.Tag tag = (Xml.Tag)content;
                    if ("groupId".equals(tag.getName())) {
                        gavGroups.put("group", tag);
                        groupPos = i;
                        continue;
                    }
                    if ("artifactId".equals(tag.getName())) {
                        gavGroups.put("artifact", tag);
                        artifactPos = i;
                        continue;
                    }
                    if (!"version".equals(tag.getName())) continue;
                    gavGroups.put("version", tag);
                    versionPos = i;
                }
                if (groupPos > artifactPos || versionPos > -1 && artifactPos > versionPos) {
                    ArrayList<Content> orderedContents = new ArrayList<Content>();
                    for (String type : new String[]{"group", "artifact", "version"}) {
                        Content gavContent = (Content)gavGroups.get(type);
                        if (gavContent == null) continue;
                        orderedContents.add(gavContent);
                    }
                    gavParent = gavParent.withContent(orderedContents);
                }
                return gavParent;
            }
        };
    }
}

