/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.internal;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.micrometer.core.instrument.Timer;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.internal.MavenXmlMapper;
import org.openrewrite.maven.internal.RawPom;
import org.openrewrite.maven.tree.MavenRepository;

public class RawMaven {
    @JsonIgnore
    private final Timer.Sample sample = Timer.start();
    private final Path sourcePath;
    private final RawPom pom;
    private final boolean projectPom;
    @Nullable
    private final MavenRepository repository;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RawMaven rawMaven = (RawMaven)o;
        return this.getSourceUri().equals(rawMaven.getSourceUri());
    }

    public int hashCode() {
        return Objects.hash(this.getSourceUri());
    }

    public static RawMaven parse(Parser.Input source, @Nullable Path relativeTo, @Nullable String snapshotVersion, ExecutionContext ctx) {
        try {
            RawPom pom = (RawPom)MavenXmlMapper.readMapper().readValue(source.getSource(), RawPom.class);
            if (snapshotVersion != null) {
                pom.setSnapshotVersion(snapshotVersion);
            }
            return new RawMaven(source.getPath(), pom, false, null);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to parse " + source.getPath(), e);
        }
    }

    public Map<String, String> getActiveProperties(Collection<String> activeProfiles) {
        return this.pom.getActiveProperties(activeProfiles);
    }

    public List<RawPom.Dependency> getActiveDependencies(Collection<String> activeProfiles) {
        return this.pom.getActiveDependencies(activeProfiles);
    }

    public String getSourceUri() {
        String sourceUri = this.repository != null ? this.repository.getUri().toString() + '/' + (this.pom.getGroupId() == null ? "null" : this.pom.getGroupId().replace('.', '/')) + '/' + this.pom.getArtifactId() + '/' + this.pom.getVersion() + '/' + this.pom.getArtifactId() + '-' + (this.pom.getSnapshotVersion() == null ? this.pom.getVersion() : this.pom.getSnapshotVersion()) + ".pom" : "file://" + this.sourcePath.toString();
        return sourceUri;
    }

    public String toString() {
        return "RawMaven{from=" + this.getSourceUri() + " / pom=" + this.pom + "}";
    }

    public RawMaven(Path sourcePath, RawPom pom, boolean projectPom, @Nullable MavenRepository repository) {
        this.sourcePath = sourcePath;
        this.pom = pom;
        this.projectPom = projectPom;
        this.repository = repository;
    }

    public Timer.Sample getSample() {
        return this.sample;
    }

    public Path getSourcePath() {
        return this.sourcePath;
    }

    public RawPom getPom() {
        return this.pom;
    }

    public boolean isProjectPom() {
        return this.projectPom;
    }

    @Nullable
    public MavenRepository getRepository() {
        return this.repository;
    }

    @NonNull
    public RawMaven withProjectPom(boolean projectPom) {
        return this.projectPom == projectPom ? this : new RawMaven(this.sourcePath, this.pom, projectPom, this.repository);
    }

    @NonNull
    public RawMaven withRepository(@Nullable MavenRepository repository) {
        return this.repository == repository ? this : new RawMaven(this.sourcePath, this.pom, this.projectPom, repository);
    }
}

