/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.tree;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.maven.tree.MavenModel;
import org.openrewrite.maven.tree.Modules;
import org.openrewrite.maven.tree.Pom;
import org.openrewrite.xml.XmlVisitor;
import org.openrewrite.xml.tree.Xml;

public class Maven
extends Xml.Document {
    private final transient MavenModel mavenModel;
    private final transient List<Pom> modules;

    public Maven(Xml.Document document) {
        super(document.getId(), document.getSourcePath(), document.getPrefix(), document.getMarkers(), document.getProlog(), document.getRoot(), document.getEof());
        this.mavenModel = document.getMarkers().findFirst(MavenModel.class).orElse(null);
        assert (this.mavenModel != null);
        this.modules = document.getMarkers().findFirst(Modules.class).map(Modules::getModules).orElse(Collections.emptyList());
    }

    @JsonCreator
    public Maven(UUID id, Path sourcePath, String prefix, Markers markers, Xml.Prolog prolog, Xml.Tag root, String eof) {
        super(id, sourcePath, prefix, markers, prolog, root, eof);
        this.mavenModel = markers.findFirst(MavenModel.class).orElse(null);
        assert (this.mavenModel != null);
        this.modules = markers.findFirst(Modules.class).map(Modules::getModules).orElse(Collections.emptyList());
    }

    public Maven withMavenModel(MavenModel model) {
        return this.withMarkers(this.getMarkers().withMarkers(ListUtils.map((List)this.getMarkers().getMarkers(), m -> m instanceof MavenModel ? model : m)));
    }

    public Maven withModules(List<Pom> modules) {
        return this.withMarkers(this.getMarkers().withMarkers(ListUtils.map((List)this.getMarkers().getMarkers(), m -> m instanceof Modules ? ((Modules)m).withModules(modules) : m)));
    }

    public static List<Path> getMavenPoms(Path projectDir, ExecutionContext ctx) {
        return Maven.getSources(projectDir, ctx, "pom.xml").stream().filter(p -> p.getFileName().toString().equals("pom.xml") && !p.toString().contains("/src/")).collect(Collectors.toList());
    }

    public List<Path> getJavaSources(Path projectDir, ExecutionContext ctx) {
        if (!"jar".equals(this.mavenModel.getPom().getPackaging()) && !"bundle".equals(this.mavenModel.getPom().getPackaging())) {
            return Collections.emptyList();
        }
        return Maven.getSources(projectDir.resolve(this.getSourcePath()).getParent().resolve(Paths.get("src", "main", "java")), ctx, ".java");
    }

    public List<Path> getTestJavaSources(Path projectDir, ExecutionContext ctx) {
        if (!"jar".equals(this.mavenModel.getPom().getPackaging()) && !"bundle".equals(this.mavenModel.getPom().getPackaging())) {
            return Collections.emptyList();
        }
        return Maven.getSources(projectDir.resolve(this.getSourcePath()).getParent().resolve(Paths.get("src", "test", "java")), ctx, ".java");
    }

    public List<Path> getResources(Path projectDir, ExecutionContext ctx) {
        if (!"jar".equals(this.mavenModel.getPom().getPackaging()) && !"bundle".equals(this.mavenModel.getPom().getPackaging())) {
            return Collections.emptyList();
        }
        return Maven.getSources(projectDir.resolve(this.getSourcePath()).getParent().resolve(Paths.get("src", "main", "resources")), ctx, ".properties", ".xml", ".yml", ".yaml");
    }

    public List<Path> getTestResources(Path projectDir, ExecutionContext ctx) {
        if (!"jar".equals(this.mavenModel.getPom().getPackaging()) && !"bundle".equals(this.mavenModel.getPom().getPackaging())) {
            return Collections.emptyList();
        }
        return Maven.getSources(projectDir.resolve(this.getSourcePath()).getParent().resolve(Paths.get("src", "test", "resources")), ctx, ".properties", ".xml", ".yml", ".yaml");
    }

    private static List<Path> getSources(Path srcDir, ExecutionContext ctx, String ... fileTypes) {
        if (!srcDir.toFile().exists()) {
            return Collections.emptyList();
        }
        BiPredicate<Path, BasicFileAttributes> predicate = (p, bfa) -> bfa.isRegularFile() && Arrays.stream(fileTypes).anyMatch(type -> p.getFileName().toString().endsWith((String)type));
        try {
            return Files.find(srcDir, 999, predicate, new FileVisitOption[0]).collect(Collectors.toList());
        }
        catch (IOException e) {
            ctx.getOnError().accept(e);
            return Collections.emptyList();
        }
    }

    @JsonIgnore
    public Pom getModel() {
        return this.mavenModel.getPom();
    }

    public String getCoordinates() {
        return this.mavenModel.getPom().getCoordinates();
    }

    @Nullable
    public <R extends Tree, P> R accept(TreeVisitor<R, P> v, P p) {
        if (v instanceof MavenVisitor && p instanceof ExecutionContext) {
            return (R)((Object)((MavenVisitor)v).visitMaven(this, (ExecutionContext)p));
        }
        if (v instanceof XmlVisitor) {
            return (R)super.accept(v, p);
        }
        return (R)v.defaultValue((Tree)this, p);
    }

    public <P> boolean isAcceptable(TreeVisitor<?, P> v, P p) {
        return v instanceof XmlVisitor;
    }

    public Maven withRoot(Xml.Tag root) {
        Xml.Document m = super.withRoot(root);
        if (m instanceof Maven) {
            return (Maven)m;
        }
        return new Maven(m);
    }

    public Maven withMarkers(Markers markers) {
        Xml.Document m = super.withMarkers(markers);
        if (m instanceof Maven) {
            return (Maven)m;
        }
        return new Maven(m);
    }

    public Maven withPrefix(String prefix) {
        Xml.Document m = super.withPrefix(prefix);
        if (m instanceof Maven) {
            return (Maven)m;
        }
        return new Maven(m);
    }

    public Maven withProlog(Xml.Prolog prolog) {
        Xml.Document m = super.withProlog(prolog);
        if (m instanceof Maven) {
            return (Maven)m;
        }
        return new Maven(m);
    }

    public Maven withModel(Pom model) {
        MavenModel withMavenModel = this.mavenModel.withPom(model);
        return this.withMarkers(this.getMarkers().computeByType((Marker)withMavenModel, (old, n) -> n));
    }

    public MavenModel getMavenModel() {
        return this.mavenModel;
    }

    public List<Pom> getModules() {
        return this.modules;
    }
}

