/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.internal;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openrewrite.maven.tree.Scope;
import org.openrewrite.xml.tree.Xml;

public class InsertDependencyComparator
implements Comparator<Xml.Tag> {
    private final Map<Xml.Tag, Float> positions = new HashMap<Xml.Tag, Float>();
    private static final Comparator<Xml.Tag> dependencyComparator = (d1, d2) -> {
        String artifactId2;
        String groupId2;
        Scope scope2;
        Scope scope1 = Scope.fromName(d1.getChildValue("scope").orElse(null));
        if (!scope1.equals((Object)(scope2 = Scope.fromName(d2.getChildValue("scope").orElse(null))))) {
            return scope1.compareTo(scope2);
        }
        String groupId1 = d1.getChildValue("groupId").orElse("");
        if (!groupId1.equals(groupId2 = d2.getChildValue("groupId").orElse(""))) {
            return InsertDependencyComparator.comparePartByPart(groupId1, groupId2);
        }
        String artifactId1 = d1.getChildValue("artifactId").orElse("");
        if (!artifactId1.equals(artifactId2 = d2.getChildValue("artifactId").orElse(""))) {
            return InsertDependencyComparator.comparePartByPart(artifactId1, artifactId2);
        }
        String classifier1 = d1.getChildValue("classifier").orElse(null);
        String classifier2 = d2.getChildValue("classifier").orElse(null);
        if (classifier1 == null && classifier2 != null) {
            return -1;
        }
        if (classifier1 != null) {
            if (classifier2 == null) {
                return 1;
            }
            if (!classifier1.equals(classifier2)) {
                return classifier1.compareTo(classifier2);
            }
        }
        return d1.getChildValue("version").orElse("").compareTo(d2.getChildValue("version").orElse(""));
    };

    public InsertDependencyComparator(List<Xml.Tag> existingDependencies, Xml.Tag dependencyTag) {
        int existingDependenciesSize = existingDependencies.size();
        for (int i = 0; i < existingDependenciesSize; ++i) {
            this.positions.put(existingDependencies.get(i), Float.valueOf(i));
        }
        ArrayList<Xml.Tag> ideallySortedDependencies = new ArrayList<Xml.Tag>(existingDependencies);
        ideallySortedDependencies.add(dependencyTag);
        ideallySortedDependencies.sort(dependencyComparator);
        Xml.Tag afterDependency = null;
        for (int i = 0; i < ideallySortedDependencies.size(); ++i) {
            Xml.Tag d = (Xml.Tag)ideallySortedDependencies.get(i);
            if (dependencyTag != d) continue;
            if (i <= 0) break;
            afterDependency = (Xml.Tag)ideallySortedDependencies.get(i - 1);
            break;
        }
        this.positions.put(dependencyTag, Float.valueOf(afterDependency == null ? -0.5f : this.positions.get(afterDependency).floatValue() + 0.5f));
    }

    @Override
    public int compare(Xml.Tag o1, Xml.Tag o2) {
        return this.positions.get(o1).compareTo(this.positions.get(o2));
    }

    private static int comparePartByPart(String d1, String d2) {
        String[] d1Parts = d1.split("[.-]");
        String[] d2Parts = d2.split("[.-]");
        for (int i = 0; i < Math.min(d1Parts.length, d2Parts.length); ++i) {
            if (d1Parts[i].equals(d2Parts[i])) continue;
            return d1Parts[i].compareTo(d2Parts[i]);
        }
        return d1Parts.length - d2Parts.length;
    }
}

