/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.internal;

import com.ctc.wstx.stax.WstxInputFactory;
import com.ctc.wstx.stax.WstxOutputFactory;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.cfg.ConstructorDetector;
import com.fasterxml.jackson.databind.deser.std.StringDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.dataformat.xml.XmlFactory;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import java.io.IOException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;

public class MavenXmlMapper {
    private static final ObjectMapper readMapper;
    private static final ObjectMapper writeMapper;

    private MavenXmlMapper() {
    }

    public static ObjectMapper readMapper() {
        return readMapper;
    }

    public static ObjectMapper writeMapper() {
        return writeMapper;
    }

    static {
        WstxInputFactory input = new WstxInputFactory();
        input.setProperty("javax.xml.stream.isReplacingEntityReferences", false);
        input.setProperty("javax.xml.stream.isNamespaceAware", false);
        XmlFactory xmlFactory = new XmlFactory((XMLInputFactory)input, (XMLOutputFactory)new WstxOutputFactory());
        ObjectMapper m = ((XmlMapper)((XmlMapper.Builder)XmlMapper.builder((XmlFactory)xmlFactory).constructorDetector(ConstructorDetector.USE_PROPERTIES_BASED)).defaultUseWrapper(false).build()).registerModule((Module)new ParameterNamesModule()).disable(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT).disable(DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        readMapper = m.setVisibility(m.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.NONE).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withCreatorVisibility(JsonAutoDetect.Visibility.PUBLIC_ONLY)).registerModule((Module)new StringTrimModule());
        writeMapper = ((XmlMapper)XmlMapper.builder((XmlFactory)xmlFactory).defaultUseWrapper(false).build()).registerModule((Module)new JaxbAnnotationModule());
    }

    public static class StringTrimModule
    extends SimpleModule {
        public StringTrimModule() {
            this.addDeserializer(String.class, (JsonDeserializer)new StringDeserializer(){

                public String deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
                    String value = super.deserialize(p, ctxt);
                    return value != null ? value.trim() : null;
                }
            });
        }
    }
}

