/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.tree;

import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;

public final class License {
    private final String name;
    private final Type type;

    public static License fromName(@Nullable String license) {
        if (license == null) {
            return new License("", Type.Unknown);
        }
        switch (license) {
            case "Apache License, Version 2.0": 
            case "The Apache Software License, Version 2.0": {
                return new License(license, Type.Apache2);
            }
            case "GNU Lesser General Public License": 
            case "GNU Library General Public License": {
                return new License(license, Type.LGPL);
            }
            case "Public Domain": {
                return new License(license, Type.PublicDomain);
            }
        }
        if (license.contains("LGPL")) {
            return new License(license, Type.LGPL);
        }
        if (license.contains("GPL") || license.contains("GNU General Public License")) {
            return new License(license, Type.GPL);
        }
        if (license.contains("CDDL")) {
            return new License(license, Type.CDDL);
        }
        if (license.contains("Creative Commons") || license.contains("CC0")) {
            return new License(license, Type.CreativeCommons);
        }
        if (license.contains("BSD")) {
            return new License(license, Type.BSD);
        }
        if (license.contains("MIT")) {
            return new License(license, Type.MIT);
        }
        if (license.contains("Eclipse") || license.contains("EPL")) {
            return new License(license, Type.Eclipse);
        }
        if (license.contains("Apache") || license.contains("ASF")) {
            return new License(license, Type.Apache2);
        }
        if (license.contains("Mozilla")) {
            return new License(license, Type.Mozilla);
        }
        if (license.toLowerCase().contains("GNU Lesser General Public License".toLowerCase()) || license.contains("GNU Library General Public License")) {
            return new License(license, Type.LGPL);
        }
        return new License(license, Type.Unknown);
    }

    public License(String name, Type type) {
        this.name = name;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof License)) {
            return false;
        }
        License other = (License)o;
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Type this$type = this.getType();
        Type other$type = other.getType();
        return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Type $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        return result;
    }

    @NonNull
    public String toString() {
        return "License(name=" + this.getName() + ", type=" + (Object)((Object)this.getType()) + ")";
    }

    public static enum Type {
        Apache2,
        BSD,
        CDDL,
        CreativeCommons,
        Eclipse,
        GPL,
        LGPL,
        MIT,
        Mozilla,
        PublicDomain,
        Unknown;

    }
}

