/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.tree;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Marker;
import org.openrewrite.maven.internal.MavenPomDownloader;
import org.openrewrite.maven.tree.Dependency;
import org.openrewrite.maven.tree.ManagedDependency;
import org.openrewrite.maven.tree.Pom;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.maven.tree.ResolvedManagedDependency;
import org.openrewrite.maven.tree.ResolvedPom;
import org.openrewrite.maven.tree.Scope;

public final class MavenResolutionResult
implements Marker {
    private final UUID id;
    private final ResolvedPom pom;
    private final List<MavenResolutionResult> modules;
    @Nullable
    private MavenResolutionResult parent;
    private final Map<Scope, List<ResolvedDependency>> dependencies;

    @Nullable
    @Incubating(since="7.18.0")
    public ResolvedDependency getResolvedDependency(Dependency dependency) {
        for (int i = Scope.values().length - 1; i >= 0; --i) {
            Scope scope = Scope.values()[i];
            if (!this.dependencies.containsKey((Object)scope)) continue;
            for (ResolvedDependency resolvedDependency : this.dependencies.get((Object)scope)) {
                if (resolvedDependency.getRequested() != dependency) continue;
                return resolvedDependency;
            }
        }
        return null;
    }

    public void unsafeSetParent(MavenResolutionResult parent) {
        this.parent = parent;
    }

    @Nullable
    @Incubating(since="7.18.0")
    public ResolvedManagedDependency getResolvedManagedDependency(ManagedDependency dependency) {
        for (ResolvedManagedDependency dm : this.pom.getDependencyManagement()) {
            if (dm.getRequested() != dependency && dm.getRequestedBom() != dependency) continue;
            return dm;
        }
        return null;
    }

    public MavenResolutionResult resolveDependencies(MavenPomDownloader downloader, ExecutionContext ctx) {
        HashMap<Scope, List<ResolvedDependency>> dependencies = new HashMap<Scope, List<ResolvedDependency>>();
        dependencies.put(Scope.Compile, this.pom.resolveDependencies(Scope.Compile, downloader, ctx));
        dependencies.put(Scope.Test, this.pom.resolveDependencies(Scope.Test, downloader, ctx));
        dependencies.put(Scope.Runtime, this.pom.resolveDependencies(Scope.Runtime, downloader, ctx));
        dependencies.put(Scope.Provided, this.pom.resolveDependencies(Scope.Provided, downloader, ctx));
        return this.withDependencies(dependencies);
    }

    public Map<Path, Pom> getProjectPoms() {
        return this.getProjectPomsRecursive(new HashMap<Path, Pom>());
    }

    private Map<Path, Pom> getProjectPomsRecursive(Map<Path, Pom> projectPoms) {
        projectPoms.put(this.pom.getRequested().getSourcePath(), this.pom.getRequested());
        if (this.parent != null) {
            this.parent.getProjectPomsRecursive(projectPoms);
        }
        for (MavenResolutionResult module : this.modules) {
            if (projectPoms.containsKey(module.getPom().getRequested().getSourcePath())) continue;
            module.getProjectPomsRecursive(projectPoms);
        }
        return projectPoms;
    }

    public MavenResolutionResult(UUID id, ResolvedPom pom, List<MavenResolutionResult> modules, @Nullable MavenResolutionResult parent, Map<Scope, List<ResolvedDependency>> dependencies) {
        this.id = id;
        this.pom = pom;
        this.modules = modules;
        this.parent = parent;
        this.dependencies = dependencies;
    }

    public UUID getId() {
        return this.id;
    }

    public ResolvedPom getPom() {
        return this.pom;
    }

    public List<MavenResolutionResult> getModules() {
        return this.modules;
    }

    @Nullable
    public MavenResolutionResult getParent() {
        return this.parent;
    }

    public Map<Scope, List<ResolvedDependency>> getDependencies() {
        return this.dependencies;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MavenResolutionResult)) {
            return false;
        }
        MavenResolutionResult other = (MavenResolutionResult)o;
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        ResolvedPom this$pom = this.getPom();
        ResolvedPom other$pom = other.getPom();
        if (this$pom == null ? other$pom != null : !this$pom.equals(other$pom)) {
            return false;
        }
        List<MavenResolutionResult> this$modules = this.getModules();
        List<MavenResolutionResult> other$modules = other.getModules();
        if (this$modules == null ? other$modules != null : !((Object)this$modules).equals(other$modules)) {
            return false;
        }
        MavenResolutionResult this$parent = this.getParent();
        MavenResolutionResult other$parent = other.getParent();
        if (this$parent == null ? other$parent != null : !((Object)this$parent).equals(other$parent)) {
            return false;
        }
        Map<Scope, List<ResolvedDependency>> this$dependencies = this.getDependencies();
        Map<Scope, List<ResolvedDependency>> other$dependencies = other.getDependencies();
        return !(this$dependencies == null ? other$dependencies != null : !((Object)this$dependencies).equals(other$dependencies));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        ResolvedPom $pom = this.getPom();
        result = result * 59 + ($pom == null ? 43 : $pom.hashCode());
        List<MavenResolutionResult> $modules = this.getModules();
        result = result * 59 + ($modules == null ? 43 : ((Object)$modules).hashCode());
        MavenResolutionResult $parent = this.getParent();
        result = result * 59 + ($parent == null ? 43 : ((Object)$parent).hashCode());
        Map<Scope, List<ResolvedDependency>> $dependencies = this.getDependencies();
        result = result * 59 + ($dependencies == null ? 43 : ((Object)$dependencies).hashCode());
        return result;
    }

    @NonNull
    public String toString() {
        return "MavenResolutionResult(id=" + this.getId() + ", pom=" + this.getPom() + ", modules=" + this.getModules() + ", parent=" + this.getParent() + ", dependencies=" + this.getDependencies() + ")";
    }

    @NonNull
    public MavenResolutionResult withId(UUID id) {
        return this.id == id ? this : new MavenResolutionResult(id, this.pom, this.modules, this.parent, this.dependencies);
    }

    @NonNull
    public MavenResolutionResult withPom(ResolvedPom pom) {
        return this.pom == pom ? this : new MavenResolutionResult(this.id, pom, this.modules, this.parent, this.dependencies);
    }

    @NonNull
    public MavenResolutionResult withModules(List<MavenResolutionResult> modules) {
        return this.modules == modules ? this : new MavenResolutionResult(this.id, this.pom, modules, this.parent, this.dependencies);
    }

    @NonNull
    public MavenResolutionResult withDependencies(Map<Scope, List<ResolvedDependency>> dependencies) {
        return this.dependencies == dependencies ? this : new MavenResolutionResult(this.id, this.pom, this.modules, this.parent, dependencies);
    }
}

