/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.tree;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import java.util.List;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.tree.Dependency;
import org.openrewrite.maven.tree.License;
import org.openrewrite.maven.tree.MavenRepository;
import org.openrewrite.maven.tree.ResolvedGroupArtifactVersion;

@JsonIdentityInfo(generator=ObjectIdGenerators.IntSequenceGenerator.class, property="@ref")
public final class ResolvedDependency {
    @Nullable
    private final MavenRepository repository;
    private final ResolvedGroupArtifactVersion gav;
    private final Dependency requested;
    private List<ResolvedDependency> dependencies;
    private final List<License> licenses;

    void unsafeSetDependencies(List<ResolvedDependency> dependencies) {
        this.dependencies = dependencies;
    }

    public ResolvedGroupArtifactVersion getGav() {
        return this.gav;
    }

    public String getGroupId() {
        return this.gav.getGroupId();
    }

    public String getArtifactId() {
        return this.gav.getArtifactId();
    }

    public String getVersion() {
        return this.gav.getVersion();
    }

    public String getType() {
        return this.requested.getType() == null ? "jar" : this.requested.getType();
    }

    @Nullable
    public String getClassifier() {
        return this.requested.getClassifier();
    }

    public boolean isOptional() {
        return this.requested.isOptional();
    }

    @Nullable
    public String getDatedSnapshotVersion() {
        return this.gav.getDatedSnapshotVersion();
    }

    @Nullable
    public ResolvedDependency findDependency(String groupId, String artifactId) {
        if (StringUtils.matchesGlob((String)this.getGroupId(), (String)groupId) && StringUtils.matchesGlob((String)this.getArtifactId(), (String)artifactId)) {
            return this;
        }
        for (ResolvedDependency dependency : this.dependencies) {
            ResolvedDependency found = dependency.findDependency(groupId, artifactId);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public String toString() {
        return (this.repository == null ? "" : this.repository.getUri() + "/") + this.gav.getGroupId().replace('.', '/') + "/" + this.gav.getArtifactId() + "/" + this.gav.getVersion() + "/" + this.gav.getArtifactId() + "-" + this.gav.getVersion() + ".pom";
    }

    public ResolvedDependency(@Nullable MavenRepository repository, ResolvedGroupArtifactVersion gav, Dependency requested, List<ResolvedDependency> dependencies, List<License> licenses) {
        this.repository = repository;
        this.gav = gav;
        this.requested = requested;
        this.dependencies = dependencies;
        this.licenses = licenses;
    }

    @Nullable
    public MavenRepository getRepository() {
        return this.repository;
    }

    public Dependency getRequested() {
        return this.requested;
    }

    public List<ResolvedDependency> getDependencies() {
        return this.dependencies;
    }

    public List<License> getLicenses() {
        return this.licenses;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResolvedDependency)) {
            return false;
        }
        ResolvedDependency other = (ResolvedDependency)o;
        MavenRepository this$repository = this.getRepository();
        MavenRepository other$repository = other.getRepository();
        if (this$repository == null ? other$repository != null : !((Object)this$repository).equals(other$repository)) {
            return false;
        }
        ResolvedGroupArtifactVersion this$gav = this.getGav();
        ResolvedGroupArtifactVersion other$gav = other.getGav();
        if (this$gav == null ? other$gav != null : !((Object)this$gav).equals(other$gav)) {
            return false;
        }
        Dependency this$requested = this.getRequested();
        Dependency other$requested = other.getRequested();
        if (this$requested == null ? other$requested != null : !((Object)this$requested).equals(other$requested)) {
            return false;
        }
        List<ResolvedDependency> this$dependencies = this.getDependencies();
        List<ResolvedDependency> other$dependencies = other.getDependencies();
        if (this$dependencies == null ? other$dependencies != null : !((Object)this$dependencies).equals(other$dependencies)) {
            return false;
        }
        List<License> this$licenses = this.getLicenses();
        List<License> other$licenses = other.getLicenses();
        return !(this$licenses == null ? other$licenses != null : !((Object)this$licenses).equals(other$licenses));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MavenRepository $repository = this.getRepository();
        result = result * 59 + ($repository == null ? 43 : ((Object)$repository).hashCode());
        ResolvedGroupArtifactVersion $gav = this.getGav();
        result = result * 59 + ($gav == null ? 43 : ((Object)$gav).hashCode());
        Dependency $requested = this.getRequested();
        result = result * 59 + ($requested == null ? 43 : ((Object)$requested).hashCode());
        List<ResolvedDependency> $dependencies = this.getDependencies();
        result = result * 59 + ($dependencies == null ? 43 : ((Object)$dependencies).hashCode());
        List<License> $licenses = this.getLicenses();
        result = result * 59 + ($licenses == null ? 43 : ((Object)$licenses).hashCode());
        return result;
    }

    @NonNull
    public ResolvedDependency withRepository(@Nullable MavenRepository repository) {
        return this.repository == repository ? this : new ResolvedDependency(repository, this.gav, this.requested, this.dependencies, this.licenses);
    }

    @NonNull
    public ResolvedDependency withGav(ResolvedGroupArtifactVersion gav) {
        return this.gav == gav ? this : new ResolvedDependency(this.repository, gav, this.requested, this.dependencies, this.licenses);
    }

    @NonNull
    public ResolvedDependency withRequested(Dependency requested) {
        return this.requested == requested ? this : new ResolvedDependency(this.repository, this.gav, requested, this.dependencies, this.licenses);
    }

    @NonNull
    public ResolvedDependency withDependencies(List<ResolvedDependency> dependencies) {
        return this.dependencies == dependencies ? this : new ResolvedDependency(this.repository, this.gav, this.requested, dependencies, this.licenses);
    }

    @NonNull
    public ResolvedDependency withLicenses(List<License> licenses) {
        return this.licenses == licenses ? this : new ResolvedDependency(this.repository, this.gav, this.requested, this.dependencies, licenses);
    }
}

