/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.utilities;

import java.nio.file.Paths;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Markers;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.maven.tree.Scope;
import org.openrewrite.text.PlainText;
import org.openrewrite.xml.tree.Xml;

public final class ListDependencies
extends Recipe {
    @Option(displayName="Scope", description="A scope to use when it is not what can be inferred from usage. Most of the time this will be left empty, but is used when adding a runtime, provided, or compile dependency.", example="runtime", valid={"compile", "runtime", "provided", "test"}, required=false)
    @Nullable
    private final String scope;

    public String getDisplayName() {
        return "List all dependencies";
    }

    public String getDescription() {
        return "List all the dependencies in a scope and add to a text file.";
    }

    protected List<SourceFile> visit(List<SourceFile> before, ExecutionContext ctx) {
        final HashSet dependencies = new HashSet();
        for (SourceFile sourceFile : before) {
            new MavenVisitor<ExecutionContext>(){

                public Xml visitDocument(Xml.Document document, ExecutionContext ctx) {
                    for (ResolvedDependency resolvedDependency : this.getResolutionResult().getDependencies().get((Object)Scope.fromName(ListDependencies.this.scope))) {
                        dependencies.add(resolvedDependency.getGav().toString());
                    }
                    return super.visitDocument(document, (Object)ctx);
                }
            }.visit((Tree)sourceFile, ctx);
        }
        return ListUtils.concat(before, (Object)new PlainText(Tree.randomId(), Paths.get("dependencies.txt", new String[0]), Markers.EMPTY, dependencies.stream().sorted().collect(Collectors.joining("\n"))));
    }

    public ListDependencies(@Nullable String scope) {
        this.scope = scope;
    }

    @Nullable
    public String getScope() {
        return this.scope;
    }

    @NonNull
    public String toString() {
        return "ListDependencies(scope=" + this.getScope() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListDependencies)) {
            return false;
        }
        ListDependencies other = (ListDependencies)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$scope = this.getScope();
        String other$scope = other.getScope();
        return !(this$scope == null ? other$scope != null : !this$scope.equals(other$scope));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ListDependencies;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        return result;
    }
}

