/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.maven.RemoveRedundantDependencyVersions;
import org.openrewrite.maven.tree.MavenMetadata;
import org.openrewrite.maven.tree.Parent;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;
import org.openrewrite.xml.ChangeTagValueVisitor;
import org.openrewrite.xml.tree.Xml;

public final class ChangeParentPom
extends Recipe {
    @Option(displayName="Old GroupId", description="The groupId of the maven parent pom to be changed away from.", example="org.springframework.boot")
    private final String oldGroupId;
    @Option(displayName="New GroupId", description="The groupId of the new maven parent pom to be adopted. If this argument is omitted it defaults to the value of `oldGroupId`.", example="org.springframework.boot", required=false)
    @Nullable
    private final String newGroupId;
    @Option(displayName="Old ArtifactId", description="The artifactId of the maven parent pom to be changed away from.", example="spring-boot-starter-parent")
    private final String oldArtifactId;
    @Option(displayName="New ArtifactId", description="The artifactId of the new maven parent pom to be adopted. If this argument is omitted it defaults to the value of `oldArtifactId`.", example="spring-boot-starter-parent", required=false)
    @Nullable
    private final String newArtifactId;
    @Option(displayName="New version", description="An exact version number, or node-style semver selector used to select the version number.", example="29.X")
    private final String newVersion;
    @Option(displayName="Version pattern", description="Allows version selection to be extended beyond the original Node Semver semantics. So for example,Setting 'version' to \"25-29\" can be paired with a metadata pattern of \"-jre\" to select Guava 29.0-jre", example="-jre", required=false)
    @Nullable
    private final String versionPattern;
    @Option(displayName="Allow version downgrades", description="If the new parent has the same group/artifact, this flag can be used to only upgrade the version if the target version is newer than the current.", example="false", required=false)
    @Nullable
    private final boolean allowVersionDowngrades;

    public String getDisplayName() {
        return "Change Maven Parent Pom";
    }

    public String getDescription() {
        return "Change the parent pom of a Maven pom.xml. Identifies the parent pom to be changed by its groupId and artifactId.";
    }

    public ChangeParentPom(String oldGroupId, @Nullable String newGroupId, String oldArtifactId, @Nullable String newArtifactId, String newVersion, @Nullable String versionPattern, @Nullable Boolean allowVersionDowngrades) {
        this.oldGroupId = oldGroupId;
        this.newGroupId = newGroupId;
        this.oldArtifactId = oldArtifactId;
        this.newArtifactId = newArtifactId;
        this.newVersion = newVersion;
        this.versionPattern = versionPattern;
        this.allowVersionDowngrades = allowVersionDowngrades != null && allowVersionDowngrades != false;
    }

    protected MavenVisitor<ExecutionContext> getSingleSourceApplicableTest() {
        return new MavenVisitor<ExecutionContext>(){

            public Xml visitDocument(Xml.Document document, ExecutionContext executionContext) {
                Parent parent = this.getResolutionResult().getPom().getRequested().getParent();
                if (parent != null && ChangeParentPom.this.oldArtifactId.equals(parent.getArtifactId()) && ChangeParentPom.this.oldGroupId.equals(parent.getGroupId())) {
                    return document.withMarkers(document.getMarkers().searchResult());
                }
                return document;
            }
        };
    }

    public Validated validate() {
        Validated validated = super.validate();
        if (this.newVersion != null) {
            validated = validated.and(Semver.validate((String)this.newVersion, (String)this.versionPattern));
        }
        return validated;
    }

    protected MavenVisitor<ExecutionContext> getVisitor() {
        final VersionComparator versionComparator = (VersionComparator)Semver.validate((String)this.newVersion, (String)this.versionPattern).getValue();
        assert (versionComparator != null);
        return new MavenIsoVisitor<ExecutionContext>(){
            @Nullable
            private Collection<String> availableVersions;

            @Override
            public Xml.Document visitDocument(Xml.Document document, ExecutionContext executionContext) {
                Xml.Document m = super.visitDocument(document, executionContext);
                if (m != document) {
                    this.maybeUpdateModel();
                }
                return m;
            }

            @Override
            public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
                if (this.isParentTag()) {
                    String targetArtifactId;
                    String targetGroupId = ChangeParentPom.this.newGroupId == null ? ChangeParentPom.this.oldGroupId : ChangeParentPom.this.newGroupId;
                    String string = targetArtifactId = ChangeParentPom.this.newArtifactId == null ? ChangeParentPom.this.oldArtifactId : ChangeParentPom.this.newArtifactId;
                    if (ChangeParentPom.this.oldGroupId.equals(tag.getChildValue("groupId").orElse(null)) && ChangeParentPom.this.oldArtifactId.equals(tag.getChildValue("artifactId").orElse(null))) {
                        tag.getChildValue("version").flatMap(parentVersion -> this.findNewerDependencyVersion(targetGroupId, targetArtifactId, (String)parentVersion, ctx)).ifPresent(newVersion -> {
                            if (!ChangeParentPom.this.oldGroupId.equals(targetGroupId)) {
                                this.doAfterVisit((TreeVisitor)new ChangeTagValueVisitor((Xml.Tag)tag.getChild("groupId").get(), targetGroupId));
                            }
                            if (!ChangeParentPom.this.oldArtifactId.equals(targetArtifactId)) {
                                this.doAfterVisit((TreeVisitor)new ChangeTagValueVisitor((Xml.Tag)tag.getChild("artifactId").get(), targetArtifactId));
                            }
                            if (!newVersion.equals(tag.getChildValue("version").orElse(null))) {
                                this.doAfterVisit((TreeVisitor)new ChangeTagValueVisitor((Xml.Tag)tag.getChild("version").get(), newVersion));
                            }
                            this.doAfterVisit(new RemoveRedundantDependencyVersions());
                        });
                    }
                }
                return super.visitTag(tag, ctx);
            }

            private Optional<String> findNewerDependencyVersion(String groupId, String artifactId, String currentVersion, ExecutionContext ctx) {
                if (this.availableVersions == null) {
                    MavenMetadata mavenMetadata = this.downloadMetadata(groupId, artifactId, ctx);
                    this.availableVersions = mavenMetadata.getVersioning().getVersions().stream().filter(v -> versionComparator.isValid(currentVersion, v)).filter(v -> ChangeParentPom.this.allowVersionDowngrades || versionComparator.compare(currentVersion, currentVersion, v) < 0).collect(Collectors.toList());
                }
                return ChangeParentPom.this.allowVersionDowngrades ? this.availableVersions.stream().max((v1, v2) -> versionComparator.compare(currentVersion, v1, v2)) : versionComparator.upgrade(currentVersion, this.availableVersions);
            }
        };
    }

    public String getOldGroupId() {
        return this.oldGroupId;
    }

    @Nullable
    public String getNewGroupId() {
        return this.newGroupId;
    }

    public String getOldArtifactId() {
        return this.oldArtifactId;
    }

    @Nullable
    public String getNewArtifactId() {
        return this.newArtifactId;
    }

    public String getNewVersion() {
        return this.newVersion;
    }

    @Nullable
    public String getVersionPattern() {
        return this.versionPattern;
    }

    @Nullable
    public boolean isAllowVersionDowngrades() {
        return this.allowVersionDowngrades;
    }

    @NonNull
    public String toString() {
        return "ChangeParentPom(oldGroupId=" + this.getOldGroupId() + ", newGroupId=" + this.getNewGroupId() + ", oldArtifactId=" + this.getOldArtifactId() + ", newArtifactId=" + this.getNewArtifactId() + ", newVersion=" + this.getNewVersion() + ", versionPattern=" + this.getVersionPattern() + ", allowVersionDowngrades=" + this.isAllowVersionDowngrades() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeParentPom)) {
            return false;
        }
        ChangeParentPom other = (ChangeParentPom)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isAllowVersionDowngrades() != other.isAllowVersionDowngrades()) {
            return false;
        }
        String this$oldGroupId = this.getOldGroupId();
        String other$oldGroupId = other.getOldGroupId();
        if (this$oldGroupId == null ? other$oldGroupId != null : !this$oldGroupId.equals(other$oldGroupId)) {
            return false;
        }
        String this$newGroupId = this.getNewGroupId();
        String other$newGroupId = other.getNewGroupId();
        if (this$newGroupId == null ? other$newGroupId != null : !this$newGroupId.equals(other$newGroupId)) {
            return false;
        }
        String this$oldArtifactId = this.getOldArtifactId();
        String other$oldArtifactId = other.getOldArtifactId();
        if (this$oldArtifactId == null ? other$oldArtifactId != null : !this$oldArtifactId.equals(other$oldArtifactId)) {
            return false;
        }
        String this$newArtifactId = this.getNewArtifactId();
        String other$newArtifactId = other.getNewArtifactId();
        if (this$newArtifactId == null ? other$newArtifactId != null : !this$newArtifactId.equals(other$newArtifactId)) {
            return false;
        }
        String this$newVersion = this.getNewVersion();
        String other$newVersion = other.getNewVersion();
        if (this$newVersion == null ? other$newVersion != null : !this$newVersion.equals(other$newVersion)) {
            return false;
        }
        String this$versionPattern = this.getVersionPattern();
        String other$versionPattern = other.getVersionPattern();
        return !(this$versionPattern == null ? other$versionPattern != null : !this$versionPattern.equals(other$versionPattern));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ChangeParentPom;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isAllowVersionDowngrades() ? 79 : 97);
        String $oldGroupId = this.getOldGroupId();
        result = result * 59 + ($oldGroupId == null ? 43 : $oldGroupId.hashCode());
        String $newGroupId = this.getNewGroupId();
        result = result * 59 + ($newGroupId == null ? 43 : $newGroupId.hashCode());
        String $oldArtifactId = this.getOldArtifactId();
        result = result * 59 + ($oldArtifactId == null ? 43 : $oldArtifactId.hashCode());
        String $newArtifactId = this.getNewArtifactId();
        result = result * 59 + ($newArtifactId == null ? 43 : $newArtifactId.hashCode());
        String $newVersion = this.getNewVersion();
        result = result * 59 + ($newVersion == null ? 43 : $newVersion.hashCode());
        String $versionPattern = this.getVersionPattern();
        result = result * 59 + ($versionPattern == null ? 43 : $versionPattern.hashCode());
        return result;
    }
}

