/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.List;
import java.util.Objects;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.maven.tree.Scope;
import org.openrewrite.xml.tree.Xml;

public final class RemoveRedundantDependencyVersions
extends Recipe {
    public String getDisplayName() {
        return "Remove redundant explicit dependency versions";
    }

    public String getDescription() {
        return "Remove explicitly-specified dependency versions when a parent POM's dependencyManagement specifies the same explicit version.";
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MavenIsoVisitor<ExecutionContext>(){

            @Override
            public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
                ResolvedDependency d;
                if (!this.isManagedDependencyTag() && (d = this.findDependency(tag)) != null && this.matchesVersion(d) && this.matchesScope(d, tag)) {
                    Xml.Tag version = tag.getChild("version").orElse(null);
                    return tag.withContent(ListUtils.map((List)tag.getContent(), c -> c == version ? null : c));
                }
                return super.visitTag(tag, ctx);
            }

            private boolean matchesVersion(ResolvedDependency d) {
                return d.getRequested().getVersion() != null && d.getRequested().getVersion().equals(this.getResolutionResult().getPom().getManagedVersion(d.getGroupId(), d.getArtifactId(), d.getRequested().getType(), d.getRequested().getClassifier()));
            }

            private boolean matchesScope(ResolvedDependency d, Xml.Tag dependencyTag) {
                return Objects.equals((Object)Scope.fromName(dependencyTag.getChildValue("scope").orElse(null)), (Object)this.getResolutionResult().getPom().getManagedScope(d.getGroupId(), d.getArtifactId(), d.getRequested().getType(), d.getRequested().getClassifier()));
            }
        };
    }

    @NonNull
    public String toString() {
        return "RemoveRedundantDependencyVersions()";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveRedundantDependencyVersions)) {
            return false;
        }
        RemoveRedundantDependencyVersions other = (RemoveRedundantDependencyVersions)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof RemoveRedundantDependencyVersions;
    }

    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

