/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.internal;

import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.internal.MavenPomDownloader;
import org.openrewrite.maven.internal.grammar.VersionRangeLexer;
import org.openrewrite.maven.internal.grammar.VersionRangeParser;
import org.openrewrite.maven.internal.grammar.VersionRangeParserBaseVisitor;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.maven.tree.MavenMetadata;
import org.openrewrite.maven.tree.MavenRepository;
import org.openrewrite.maven.tree.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionRequirement {
    private static final Logger logger = LoggerFactory.getLogger(VersionRequirement.class);
    @Nullable
    private final VersionRequirement nearer;
    private final VersionSpec versionSpec;
    @Nullable
    private volatile transient String selected;

    public static VersionRequirement fromVersion(String requested, int depth) {
        return new VersionRequirement(null, VersionSpec.build(requested, depth == 0));
    }

    public VersionRequirement addRequirement(String requested) {
        if (this.versionSpec instanceof DirectRequirement) {
            return this;
        }
        VersionSpec newRequirement = VersionSpec.build(requested, false);
        VersionRequirement next = this;
        while (next != null) {
            if (next.versionSpec.equals(newRequirement)) {
                return this;
            }
            next = next.nearer;
        }
        return new VersionRequirement(this, newRequirement);
    }

    @Nullable
    public String resolve(Supplier<Iterable<String>> availableVersions) {
        if (this.selected == null) {
            this.selected = this.cacheResolved(availableVersions);
        }
        return this.selected;
    }

    @Nullable
    private String cacheResolved(Supplier<Iterable<String>> availableVersions) {
        boolean hasHardRequirements = false;
        String nearestSoftRequirement = null;
        VersionRequirement next = this;
        while (next != null) {
            VersionSpec spec = next.versionSpec;
            if (spec instanceof DirectRequirement) {
                return ((DirectRequirement)spec).getVersion();
            }
            if (spec instanceof SoftRequirement) {
                nearestSoftRequirement = ((SoftRequirement)spec).version;
            } else {
                hasHardRequirements = true;
            }
            next = next.nearer;
        }
        if (!hasHardRequirements) {
            return nearestSoftRequirement;
        }
        Version latest = null;
        for (String availableVersion : availableVersions.get()) {
            Version version = new Version(availableVersion);
            boolean matchesAllHardRequirements = true;
            next = this;
            while (next != null) {
                VersionSpec spec = next.versionSpec;
                if (spec instanceof DynamicVersion) {
                    matchesAllHardRequirements &= ((DynamicVersion)spec).matches(version);
                } else if (spec instanceof RangeSet) {
                    matchesAllHardRequirements &= ((RangeSet)spec).matches(version);
                }
                next = next.nearer;
            }
            if (!matchesAllHardRequirements || latest != null && version.compareTo(latest) <= 0) continue;
            latest = version;
        }
        if (latest == null) {
            return null;
        }
        return latest.toString();
    }

    @Nullable
    public String resolve(GroupArtifact groupArtifact, MavenPomDownloader downloader, List<MavenRepository> repositories) {
        return this.resolve(() -> {
            MavenMetadata metadata = downloader.downloadMetadata(groupArtifact, null, repositories);
            return metadata.getVersioning().getVersions();
        });
    }

    public VersionRequirement(@Nullable VersionRequirement nearer, VersionSpec versionSpec) {
        this.nearer = nearer;
        this.versionSpec = versionSpec;
    }

    private static class LoggingErrorListener
    extends BaseErrorListener {
        private LoggingErrorListener() {
        }

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
            logger.warn("Syntax error at line {}:{} {}", new Object[]{line, charPositionInLine, msg});
        }
    }

    private static final class Range {
        private final boolean lowerClosed;
        @Nullable
        private final Version lower;
        private final boolean upperClosed;
        @Nullable
        private final Version upper;

        public String toString() {
            return (this.lowerClosed ? "[" : "(") + this.lower + "," + this.upper + (this.upperClosed ? (char)']' : ')');
        }

        public Range(boolean lowerClosed, @Nullable Version lower, boolean upperClosed, @Nullable Version upper) {
            this.lowerClosed = lowerClosed;
            this.lower = lower;
            this.upperClosed = upperClosed;
            this.upper = upper;
        }

        public boolean isLowerClosed() {
            return this.lowerClosed;
        }

        @Nullable
        public Version getLower() {
            return this.lower;
        }

        public boolean isUpperClosed() {
            return this.upperClosed;
        }

        @Nullable
        public Version getUpper() {
            return this.upper;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Range)) {
                return false;
            }
            Range other = (Range)o;
            if (this.isLowerClosed() != other.isLowerClosed()) {
                return false;
            }
            if (this.isUpperClosed() != other.isUpperClosed()) {
                return false;
            }
            Version this$lower = this.getLower();
            Version other$lower = other.getLower();
            if (this$lower == null ? other$lower != null : !((Object)this$lower).equals(other$lower)) {
                return false;
            }
            Version this$upper = this.getUpper();
            Version other$upper = other.getUpper();
            return !(this$upper == null ? other$upper != null : !((Object)this$upper).equals(other$upper));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isLowerClosed() ? 79 : 97);
            result = result * 59 + (this.isUpperClosed() ? 79 : 97);
            Version $lower = this.getLower();
            result = result * 59 + ($lower == null ? 43 : ((Object)$lower).hashCode());
            Version $upper = this.getUpper();
            result = result * 59 + ($upper == null ? 43 : ((Object)$upper).hashCode());
            return result;
        }
    }

    private static final class RangeSet
    implements VersionSpec {
        private final List<Range> ranges;

        public boolean matches(Version version) {
            for (Range range : this.ranges) {
                boolean lowerMatches = true;
                if (range.lower != null) {
                    int lowComp = range.lower.compareTo(version);
                    boolean bl = lowComp == 0 ? range.lowerClosed : (lowerMatches = lowComp < 0);
                }
                if (!lowerMatches) {
                    return false;
                }
                boolean upperMatches = true;
                if (range.upper != null) {
                    int upperComp = range.upper.compareTo(version);
                    boolean bl = upperComp == 0 ? range.upperClosed : (upperMatches = upperComp > 0);
                }
                if (!upperMatches) continue;
                return true;
            }
            return false;
        }

        public RangeSet(List<Range> ranges) {
            this.ranges = ranges;
        }

        public List<Range> getRanges() {
            return this.ranges;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RangeSet)) {
                return false;
            }
            RangeSet other = (RangeSet)o;
            List<Range> this$ranges = this.getRanges();
            List<Range> other$ranges = other.getRanges();
            return !(this$ranges == null ? other$ranges != null : !((Object)this$ranges).equals(other$ranges));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Range> $ranges = this.getRanges();
            result = result * 59 + ($ranges == null ? 43 : ((Object)$ranges).hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "VersionRequirement.RangeSet(ranges=" + this.getRanges() + ")";
        }
    }

    private static enum DynamicVersion implements VersionSpec
    {
        LATEST,
        RELEASE;


        public boolean matches(Version version) {
            return this == LATEST || !version.toString().endsWith("-SNAPSHOT");
        }
    }

    private static class SoftRequirement
    implements VersionSpec {
        final String version;

        public SoftRequirement(String version) {
            this.version = version;
        }

        public String getVersion() {
            return this.version;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SoftRequirement)) {
                return false;
            }
            SoftRequirement other = (SoftRequirement)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            return !(this$version == null ? other$version != null : !this$version.equals(other$version));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof SoftRequirement;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "VersionRequirement.SoftRequirement(version=" + this.getVersion() + ")";
        }
    }

    private static final class DirectRequirement
    extends SoftRequirement {
        private DirectRequirement(String version) {
            super(version);
        }

        @Override
        @NonNull
        public String toString() {
            return "VersionRequirement.DirectRequirement()";
        }

        @Override
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DirectRequirement)) {
                return false;
            }
            DirectRequirement other = (DirectRequirement)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        protected boolean canEqual(@Nullable Object other) {
            return other instanceof DirectRequirement;
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            return result;
        }
    }

    static interface VersionSpec {
        public static VersionSpec build(String requested, boolean direct) {
            if ("LATEST".equals(requested)) {
                return DynamicVersion.LATEST;
            }
            if ("RELEASE".equals(requested)) {
                return DynamicVersion.RELEASE;
            }
            if (requested.contains("[") || requested.contains("(")) {
                if (!requested.contains("]") && !requested.contains(")")) {
                    requested = requested + "]";
                }
                VersionRangeParser parser = new VersionRangeParser((TokenStream)new CommonTokenStream((TokenSource)new VersionRangeLexer((CharStream)CharStreams.fromString((String)requested))));
                parser.removeErrorListeners();
                parser.addErrorListener((ANTLRErrorListener)new LoggingErrorListener());
                return (VersionSpec)new VersionRangeParserBaseVisitor<VersionSpec>(){

                    @Override
                    public VersionSpec visitVersionRequirement(VersionRangeParser.VersionRequirementContext ctx) {
                        return new RangeSet(ctx.range().stream().map(range -> {
                            Version upper;
                            Version lower;
                            if (range.bounds().boundedLower() != null) {
                                Iterator<TerminalNode> versionIter = range.bounds().boundedLower().Version().iterator();
                                lower = this.toVersion(versionIter.next());
                                upper = versionIter.hasNext() ? this.toVersion(versionIter.next()) : null;
                            } else if (range.bounds().unboundedLower() != null) {
                                lower = null;
                                upper = this.toVersion(range.bounds().unboundedLower().Version());
                            } else {
                                lower = this.toVersion(range.bounds().exactly().Version());
                                upper = this.toVersion(range.bounds().exactly().Version());
                            }
                            return new Range(range.CLOSED_RANGE_OPEN() != null, lower, range.CLOSED_RANGE_CLOSE() != null, upper);
                        }).collect(Collectors.toList()));
                    }

                    private Version toVersion(TerminalNode version) {
                        return new Version(version.getText());
                    }
                }.visit((ParseTree)parser.versionRequirement());
            }
            return direct ? new DirectRequirement(requested) : new SoftRequirement(requested);
        }
    }
}

