/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.marker.JavaProject;
import org.openrewrite.java.marker.JavaSourceSet;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.maven.AddDependencyVisitor;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.maven.tree.Scope;
import org.openrewrite.semver.Semver;
import org.openrewrite.xml.tree.Xml;

public class AddDependency
extends Recipe {
    @Option(displayName="Group", description="The first part of a dependency coordinate 'com.google.guava:guava:VERSION'.", example="com.google.guava")
    private final String groupId;
    @Option(displayName="Artifact", description="The second part of a dependency coordinate 'com.google.guava:guava:VERSION'.", example="guava")
    private final String artifactId;
    @Option(displayName="Version", description="An exact version number or node-style semver selector used to select the version number.", example="29.X")
    private final String version;
    @Option(displayName="Version pattern", description="Allows version selection to be extended beyond the original Node Semver semantics. So for example,Setting 'version' to \"25-29\" can be paired with a metadata pattern of \"-jre\" to select Guava 29.0-jre", example="-jre", required=false)
    @Nullable
    private String versionPattern;
    @Option(displayName="Scope", description="A scope to use when it is not what can be inferred from usage. Most of the time this will be left empty, but is used when adding a runtime, provided, or import dependency.", example="runtime", valid={"import", "runtime", "provided"}, required=false)
    @Nullable
    private final String scope;
    @Option(displayName="Releases only", description="Whether to exclude snapshots from consideration when using a semver selector", example="true", required=false)
    @Nullable
    private Boolean releasesOnly;
    @Option(displayName="Only if using", description="Used to determine if the dependency will be added and in which scope it should be placed.", example="org.junit.jupiter.api.*")
    private String onlyIfUsing;
    @Option(displayName="Type", description="The type of dependency to add. If omitted Maven defaults to assuming the type is \"jar\".", valid={"jar", "pom", "war"}, example="jar", required=false)
    @Nullable
    private String type;
    @Option(displayName="Classifier", description="A Maven classifier to add. Most commonly used to select shaded or test variants of a library", example="test", required=false)
    @Nullable
    private String classifier;
    @Option(displayName="Optional", description="Set the value of the `<optional>` tag. No `<optional>` tag will be added when this is `null`.", example="true", required=false)
    @Nullable
    private Boolean optional;
    @Option(displayName="Family pattern", description="A pattern, applied to groupIds, used to determine which other dependencies should have aligned version numbers. Accepts '*' as a wildcard character.", example="com.fasterxml.jackson*", required=false)
    @Nullable
    private String familyPattern;

    public Validated validate() {
        Validated validated = super.validate();
        if (this.version != null) {
            validated = validated.or(Semver.validate((String)this.version, (String)this.versionPattern));
        }
        return validated;
    }

    public String getDisplayName() {
        return "Add Maven dependency";
    }

    public String getDescription() {
        return "Add a maven dependency to a `pom.xml` file in the correct scope based on where it is used.";
    }

    protected TreeVisitor<?, ExecutionContext> getApplicableTest() {
        return new UsesType(this.onlyIfUsing);
    }

    protected List<SourceFile> visit(List<SourceFile> before, final ExecutionContext ctx) {
        final HashMap scopeByProject = new HashMap();
        for (SourceFile source : before) {
            source.getMarkers().findFirst(JavaProject.class).ifPresent(javaProject -> source.getMarkers().findFirst(JavaSourceSet.class).ifPresent(sourceSet -> {
                if (source != new UsesType(this.onlyIfUsing).visit((Tree)source, (Object)ctx)) {
                    scopeByProject.compute(javaProject, (jp, scope) -> "compile".equals(scope) ? scope : ("test".equals(sourceSet.getName()) ? "test" : "compile"));
                }
            }));
        }
        if (scopeByProject.isEmpty()) {
            return before;
        }
        final Pattern familyPatternCompiled = this.familyPattern == null ? null : Pattern.compile(this.familyPattern.replace("*", ".*"));
        return ListUtils.map(before, s -> s.getMarkers().findFirst(JavaProject.class).map(javaProject -> new MavenVisitor<ExecutionContext>(){

            public Xml visitDocument(Xml.Document document, ExecutionContext executionContext) {
                String resolvedScope;
                Xml maven = super.visitDocument(document, (Object)executionContext);
                String string = resolvedScope = AddDependency.this.scope == null ? (String)scopeByProject.get(javaProject) : AddDependency.this.scope;
                if (resolvedScope == null) {
                    return maven;
                }
                for (ResolvedDependency d : this.getResolutionResult().getDependencies().get((Object)Scope.Compile)) {
                    if (!d.isDirect() || !AddDependency.this.groupId.equals(d.getGroupId()) || !AddDependency.this.artifactId.equals(d.getArtifactId())) continue;
                    return maven;
                }
                if ("test".equals(resolvedScope)) {
                    for (ResolvedDependency d : this.getResolutionResult().getDependencies().get((Object)Scope.Test)) {
                        if (!AddDependency.this.groupId.equals(d.getGroupId()) || !AddDependency.this.artifactId.equals(d.getArtifactId())) continue;
                        return maven;
                    }
                }
                return (Xml)new AddDependencyVisitor(AddDependency.this.groupId, AddDependency.this.artifactId, AddDependency.this.version, AddDependency.this.versionPattern, resolvedScope, AddDependency.this.releasesOnly, AddDependency.this.type, AddDependency.this.classifier, AddDependency.this.optional, familyPatternCompiled).visitNonNull((Tree)s, ctx);
            }
        }.visit((Tree)s, ctx)).map(SourceFile.class::cast).orElse((SourceFile)s));
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    @Nullable
    public String getVersionPattern() {
        return this.versionPattern;
    }

    @Nullable
    public String getScope() {
        return this.scope;
    }

    @Nullable
    public Boolean getReleasesOnly() {
        return this.releasesOnly;
    }

    public String getOnlyIfUsing() {
        return this.onlyIfUsing;
    }

    @Nullable
    public String getType() {
        return this.type;
    }

    @Nullable
    public String getClassifier() {
        return this.classifier;
    }

    @Nullable
    public Boolean getOptional() {
        return this.optional;
    }

    @Nullable
    public String getFamilyPattern() {
        return this.familyPattern;
    }

    public AddDependency(String groupId, String artifactId, String version, @Nullable String versionPattern, @Nullable String scope, @Nullable Boolean releasesOnly, String onlyIfUsing, @Nullable String type, @Nullable String classifier, @Nullable Boolean optional, @Nullable String familyPattern) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.versionPattern = versionPattern;
        this.scope = scope;
        this.releasesOnly = releasesOnly;
        this.onlyIfUsing = onlyIfUsing;
        this.type = type;
        this.classifier = classifier;
        this.optional = optional;
        this.familyPattern = familyPattern;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddDependency)) {
            return false;
        }
        AddDependency other = (AddDependency)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$releasesOnly = this.getReleasesOnly();
        Boolean other$releasesOnly = other.getReleasesOnly();
        if (this$releasesOnly == null ? other$releasesOnly != null : !((Object)this$releasesOnly).equals(other$releasesOnly)) {
            return false;
        }
        Boolean this$optional = this.getOptional();
        Boolean other$optional = other.getOptional();
        if (this$optional == null ? other$optional != null : !((Object)this$optional).equals(other$optional)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$versionPattern = this.getVersionPattern();
        String other$versionPattern = other.getVersionPattern();
        if (this$versionPattern == null ? other$versionPattern != null : !this$versionPattern.equals(other$versionPattern)) {
            return false;
        }
        String this$scope = this.getScope();
        String other$scope = other.getScope();
        if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) {
            return false;
        }
        String this$onlyIfUsing = this.getOnlyIfUsing();
        String other$onlyIfUsing = other.getOnlyIfUsing();
        if (this$onlyIfUsing == null ? other$onlyIfUsing != null : !this$onlyIfUsing.equals(other$onlyIfUsing)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$classifier = this.getClassifier();
        String other$classifier = other.getClassifier();
        if (this$classifier == null ? other$classifier != null : !this$classifier.equals(other$classifier)) {
            return false;
        }
        String this$familyPattern = this.getFamilyPattern();
        String other$familyPattern = other.getFamilyPattern();
        return !(this$familyPattern == null ? other$familyPattern != null : !this$familyPattern.equals(other$familyPattern));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AddDependency;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $releasesOnly = this.getReleasesOnly();
        result = result * 59 + ($releasesOnly == null ? 43 : ((Object)$releasesOnly).hashCode());
        Boolean $optional = this.getOptional();
        result = result * 59 + ($optional == null ? 43 : ((Object)$optional).hashCode());
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $versionPattern = this.getVersionPattern();
        result = result * 59 + ($versionPattern == null ? 43 : $versionPattern.hashCode());
        String $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        String $onlyIfUsing = this.getOnlyIfUsing();
        result = result * 59 + ($onlyIfUsing == null ? 43 : $onlyIfUsing.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $classifier = this.getClassifier();
        result = result * 59 + ($classifier == null ? 43 : $classifier.hashCode());
        String $familyPattern = this.getFamilyPattern();
        result = result * 59 + ($familyPattern == null ? 43 : $familyPattern.hashCode());
        return result;
    }

    @NonNull
    public AddDependency withFamilyPattern(@Nullable String familyPattern) {
        return this.familyPattern == familyPattern ? this : new AddDependency(this.groupId, this.artifactId, this.version, this.versionPattern, this.scope, this.releasesOnly, this.onlyIfUsing, this.type, this.classifier, this.optional, familyPattern);
    }
}

