/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openrewrite.ExecutionContext;
import org.openrewrite.HttpSenderExecutionContextView;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.ipc.http.HttpSender;
import org.openrewrite.marker.Marker;
import org.openrewrite.maven.internal.MavenPomDownloader;
import org.openrewrite.maven.internal.RawPom;
import org.openrewrite.maven.tree.MavenResolutionResult;
import org.openrewrite.maven.tree.Parent;
import org.openrewrite.maven.tree.Pom;
import org.openrewrite.maven.tree.ResolvedPom;
import org.openrewrite.xml.XmlParser;
import org.openrewrite.xml.tree.Xml;

public class MavenParser
implements Parser<Xml.Document> {
    @Deprecated
    @Nullable
    private final HttpSender httpSender;
    private final Collection<String> activeProfiles;

    private MavenParser(@Nullable HttpSender httpSender, Collection<String> activeProfiles) {
        this.httpSender = httpSender;
        this.activeProfiles = activeProfiles;
    }

    public List<Xml.Document> parse(String ... sources) {
        return this.parse((ExecutionContext)new InMemoryExecutionContext(), sources);
    }

    public List<Xml.Document> parse(ExecutionContext ctx, String ... sources) {
        return super.parse(ctx, sources);
    }

    public List<Xml.Document> parseInputs(Iterable<Parser.Input> sources, @Nullable Path relativeTo, ExecutionContext ctx) {
        LinkedHashMap<Xml.Document, Object> projectPoms = new LinkedHashMap<Xml.Document, Object>();
        HashMap<Path, Pom> projectPomsByPath = new HashMap<Path, Pom>();
        for (Parser.Input source : sources) {
            Object pom = RawPom.parse((InputStream)source.getSource(), null).toPom(source.getPath(), null);
            if (relativeTo != null) {
                if (((Pom)pom).getProperties() == null || ((Pom)pom).getProperties().isEmpty()) {
                    pom = ((Pom)pom).withProperties(new LinkedHashMap<String, String>());
                }
                ((Pom)pom).getProperties().put("project.basedir", relativeTo.toString());
                ((Pom)pom).getProperties().put("basedir", relativeTo.toString());
            }
            Xml.Document document = (Xml.Document)new MavenXmlParser().parseInputs(Collections.singletonList(source), relativeTo, ctx).iterator().next();
            projectPoms.put(document, pom);
            projectPomsByPath.put(source.getPath(), (Pom)pom);
        }
        ArrayList<Xml.Document> parsed = new ArrayList<Xml.Document>();
        if (this.httpSender != null) {
            ctx = HttpSenderExecutionContextView.view((ExecutionContext)ctx).setHttpSender(this.httpSender);
        }
        MavenPomDownloader downloader = new MavenPomDownloader(projectPomsByPath, ctx);
        for (Map.Entry entry : projectPoms.entrySet()) {
            ResolvedPom resolvedPom = ((Pom)entry.getValue()).resolve(this.activeProfiles, downloader, ctx);
            MavenResolutionResult model = new MavenResolutionResult(Tree.randomId(), resolvedPom, Collections.emptyList(), null, Collections.emptyMap()).resolveDependencies(downloader, ctx);
            parsed.add(((Xml.Document)entry.getKey()).withMarkers(((Xml.Document)entry.getKey()).getMarkers().compute((Marker)model, (old, n) -> n)));
        }
        for (int i = 0; i < parsed.size(); ++i) {
            Xml.Document document = (Xml.Document)parsed.get(i);
            MavenResolutionResult resolutionResult = (MavenResolutionResult)document.getMarkers().findFirst(MavenResolutionResult.class).orElseThrow(() -> new IllegalStateException("Expected to find a maven resolution marker"));
            ArrayList<MavenResolutionResult> modules = new ArrayList<MavenResolutionResult>(0);
            for (Xml.Document possibleModule : parsed) {
                MavenResolutionResult moduleResolutionResult;
                Parent parent;
                if (possibleModule == document || (parent = (moduleResolutionResult = (MavenResolutionResult)possibleModule.getMarkers().findFirst(MavenResolutionResult.class).orElseThrow(() -> new IllegalStateException("Expected to find a maven resolution marker"))).getPom().getRequested().getParent()) == null || !resolutionResult.getPom().getGroupId().equals(resolutionResult.getPom().getValue(parent.getGroupId())) || !resolutionResult.getPom().getArtifactId().equals(resolutionResult.getPom().getValue(parent.getArtifactId())) || !resolutionResult.getPom().getVersion().equals(resolutionResult.getPom().getValue(parent.getVersion()))) continue;
                moduleResolutionResult.unsafeSetParent(resolutionResult);
                modules.add(moduleResolutionResult);
            }
            if (modules.isEmpty()) continue;
            resolutionResult.unsafeSetModules(modules);
        }
        return parsed;
    }

    public boolean accept(Path path) {
        return "pom.xml".equals(path.toString()) || path.toString().endsWith(".pom");
    }

    public static Builder builder() {
        return new Builder();
    }

    public Path sourcePathFromSourceText(Path prefix, String sourceCode) {
        return prefix.resolve("pom.xml");
    }

    private static class MavenXmlParser
    extends XmlParser {
        private MavenXmlParser() {
        }

        public boolean accept(Path path) {
            return super.accept(path) || path.toString().endsWith(".pom");
        }
    }

    public static class Builder {
        private final Collection<String> activeProfiles = new HashSet<String>();
        @Deprecated
        @Nullable
        private HttpSender httpSender;

        public Builder activeProfiles(String ... profiles) {
            if (profiles != null) {
                Collections.addAll(this.activeProfiles, profiles);
            }
            return this;
        }

        @Deprecated
        public Builder httpSender(HttpSender httpSender) {
            this.httpSender = httpSender;
            return this;
        }

        public Builder mavenConfig(@Nullable Path mavenConfig) {
            if (mavenConfig != null && mavenConfig.toFile().exists()) {
                try {
                    String mavenConfigText = new String(Files.readAllBytes(mavenConfig));
                    Matcher matcher = Pattern.compile("(?:$|\\s)-P\\s+([^\\s]+)").matcher(mavenConfigText);
                    if (matcher.find()) {
                        String[] profiles = matcher.group(1).split(",");
                        return this.activeProfiles(profiles);
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            return this;
        }

        public MavenParser build() {
            return new MavenParser(this.httpSender, this.activeProfiles);
        }
    }
}

