/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.utilities;

import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryConfig;
import io.github.resilience4j.retry.RetryRegistry;
import io.vavr.CheckedFunction1;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.ipc.http.HttpSender;
import org.openrewrite.ipc.http.HttpUrlConnectionSender;
import org.openrewrite.maven.MavenSettings;
import org.openrewrite.maven.cache.MavenArtifactCache;
import org.openrewrite.maven.internal.MavenDownloadingException;
import org.openrewrite.maven.tree.MavenRepository;
import org.openrewrite.maven.tree.ResolvedDependency;

public class MavenArtifactDownloader {
    private static final RetryConfig retryConfig = RetryConfig.custom().retryExceptions(new Class[]{SocketTimeoutException.class, TimeoutException.class}).build();
    private static final RetryRegistry retryRegistry = RetryRegistry.of((RetryConfig)retryConfig);
    private static final Retry mavenDownloaderRetry = retryRegistry.retry("MavenDownloader");
    private final MavenArtifactCache mavenArtifactCache;
    private final Map<String, MavenSettings.Server> serverIdToServer;
    private final Consumer<Throwable> onError;
    private final HttpSender httpSender;
    private final CheckedFunction1<HttpSender.Request, HttpSender.Response> sendRequest;

    public MavenArtifactDownloader(MavenArtifactCache mavenArtifactCache, @Nullable MavenSettings settings, Consumer<Throwable> onError) {
        this(mavenArtifactCache, settings, (HttpSender)new HttpUrlConnectionSender(), onError);
    }

    public MavenArtifactDownloader(MavenArtifactCache mavenArtifactCache, @Nullable MavenSettings settings, HttpSender httpSender, Consumer<Throwable> onError) {
        this.httpSender = httpSender;
        this.sendRequest = Retry.decorateCheckedFunction((Retry)mavenDownloaderRetry, arg_0 -> ((HttpSender)httpSender).send(arg_0));
        this.mavenArtifactCache = mavenArtifactCache;
        this.onError = onError;
        this.serverIdToServer = settings == null || settings.getServers() == null ? new HashMap<String, MavenSettings.Server>() : settings.getServers().getServers().stream().collect(Collectors.toMap(MavenSettings.Server::getId, Function.identity()));
    }

    @Nullable
    public Path downloadArtifact(ResolvedDependency dependency) {
        if (dependency.getRequested().getType() != null && !"jar".equals(dependency.getRequested().getType())) {
            return null;
        }
        return this.mavenArtifactCache.computeArtifact(dependency, () -> {
            try {
                InputStream bodyStream;
                String uri = dependency.getRepository().getUri() + "/" + dependency.getGroupId().replace('.', '/') + '/' + dependency.getArtifactId() + '/' + dependency.getVersion() + '/' + dependency.getArtifactId() + '-' + (dependency.getDatedSnapshotVersion() == null ? dependency.getVersion() : dependency.getDatedSnapshotVersion()) + ".jar";
                if (uri.startsWith("~")) {
                    bodyStream = new FileInputStream(System.getProperty("user.home") + uri.substring(1));
                } else {
                    HttpSender.Request.Builder request = this.applyAuthentication(dependency.getRepository(), this.httpSender.get(uri));
                    HttpSender.Response response = (HttpSender.Response)this.sendRequest.apply((Object)request.build());
                    bodyStream = response.getBody();
                    if (!response.isSuccessful() || bodyStream == null) {
                        this.onError.accept(new MavenDownloadingException("Unable to download dependency %s:%s:%s. Response was %s", dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), Integer.toString(response.getCode())));
                        return null;
                    }
                }
                return bodyStream;
            }
            catch (Throwable t) {
                this.onError.accept(t);
                return null;
            }
        }, this.onError);
    }

    private HttpSender.Request.Builder applyAuthentication(MavenRepository repository, HttpSender.Request.Builder request) {
        MavenSettings.Server authInfo = this.serverIdToServer.get(repository.getId());
        if (authInfo != null) {
            return request.withBasicAuthentication(authInfo.getUsername(), authInfo.getPassword());
        }
        if (repository.getUsername() != null && repository.getPassword() != null) {
            return request.withBasicAuthentication(repository.getUsername(), repository.getPassword());
        }
        return request;
    }
}

