/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.xml.tree.Xml;

public final class RemoveRedundantDependencyVersions
extends Recipe {
    @Option(displayName="Group", description="Group glob expression pattern used to match dependencies that should be managed.Group is the first part of a dependency coordinate 'com.google.guava:guava:VERSION'.", example="com.google.*", required=false)
    @Nullable
    private final String groupPattern;
    @Option(displayName="Artifact", description="Artifact glob expression pattern used to match dependencies that should be managed.Artifact is the second part of a dependency coordinate 'com.google.guava:guava:VERSION'.", example="guava*", required=false)
    @Nullable
    private final String artifactPattern;
    @Option(displayName="Only if versions match", description="Only remove the explicit version if it matches the managed dependency version. Default true.", example="false", required=false)
    @Nullable
    private final Boolean onlyIfVersionsMatch;

    public String getDisplayName() {
        return "Remove redundant explicit dependency versions";
    }

    public String getDescription() {
        return "Remove explicitly-specified dependency versions when a parent POM's dependencyManagement specifies the version.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MavenIsoVisitor<ExecutionContext>(){

            @Override
            public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
                ResolvedDependency d;
                if (!this.isManagedDependencyTag() && (d = this.findDependency(tag)) != null && this.matchesVersion(d) && this.matchesGroup(d) && this.matchesArtifact(d)) {
                    Xml.Tag version = tag.getChild("version").orElse(null);
                    return tag.withContent(ListUtils.map((List)tag.getContent(), c -> c == version ? null : c));
                }
                return super.visitTag(tag, ctx);
            }

            private boolean matchesGroup(ResolvedDependency d) {
                return StringUtils.isNullOrEmpty((String)RemoveRedundantDependencyVersions.this.groupPattern) || StringUtils.matchesGlob((String)d.getGroupId(), (String)RemoveRedundantDependencyVersions.this.groupPattern);
            }

            private boolean matchesArtifact(ResolvedDependency d) {
                return StringUtils.isNullOrEmpty((String)RemoveRedundantDependencyVersions.this.artifactPattern) || StringUtils.matchesGlob((String)d.getArtifactId(), (String)RemoveRedundantDependencyVersions.this.artifactPattern);
            }

            private boolean matchesVersion(ResolvedDependency d) {
                return this.ignoreVersionMatching() || d.getRequested().getVersion() != null && d.getRequested().getVersion().equals(this.getResolutionResult().getPom().getManagedVersion(d.getGroupId(), d.getArtifactId(), d.getRequested().getType(), d.getRequested().getClassifier()));
            }

            private boolean ignoreVersionMatching() {
                return Boolean.FALSE.equals(RemoveRedundantDependencyVersions.this.onlyIfVersionsMatch);
            }
        };
    }

    public RemoveRedundantDependencyVersions(@Nullable String groupPattern, @Nullable String artifactPattern, @Nullable Boolean onlyIfVersionsMatch) {
        this.groupPattern = groupPattern;
        this.artifactPattern = artifactPattern;
        this.onlyIfVersionsMatch = onlyIfVersionsMatch;
    }

    @Nullable
    public String getGroupPattern() {
        return this.groupPattern;
    }

    @Nullable
    public String getArtifactPattern() {
        return this.artifactPattern;
    }

    @Nullable
    public Boolean getOnlyIfVersionsMatch() {
        return this.onlyIfVersionsMatch;
    }

    @NonNull
    public String toString() {
        return "RemoveRedundantDependencyVersions(groupPattern=" + this.getGroupPattern() + ", artifactPattern=" + this.getArtifactPattern() + ", onlyIfVersionsMatch=" + this.getOnlyIfVersionsMatch() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveRedundantDependencyVersions)) {
            return false;
        }
        RemoveRedundantDependencyVersions other = (RemoveRedundantDependencyVersions)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$onlyIfVersionsMatch = this.getOnlyIfVersionsMatch();
        Boolean other$onlyIfVersionsMatch = other.getOnlyIfVersionsMatch();
        if (this$onlyIfVersionsMatch == null ? other$onlyIfVersionsMatch != null : !((Object)this$onlyIfVersionsMatch).equals(other$onlyIfVersionsMatch)) {
            return false;
        }
        String this$groupPattern = this.getGroupPattern();
        String other$groupPattern = other.getGroupPattern();
        if (this$groupPattern == null ? other$groupPattern != null : !this$groupPattern.equals(other$groupPattern)) {
            return false;
        }
        String this$artifactPattern = this.getArtifactPattern();
        String other$artifactPattern = other.getArtifactPattern();
        return !(this$artifactPattern == null ? other$artifactPattern != null : !this$artifactPattern.equals(other$artifactPattern));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof RemoveRedundantDependencyVersions;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $onlyIfVersionsMatch = this.getOnlyIfVersionsMatch();
        result = result * 59 + ($onlyIfVersionsMatch == null ? 43 : ((Object)$onlyIfVersionsMatch).hashCode());
        String $groupPattern = this.getGroupPattern();
        result = result * 59 + ($groupPattern == null ? 43 : $groupPattern.hashCode());
        String $artifactPattern = this.getArtifactPattern();
        result = result * 59 + ($artifactPattern == null ? 43 : $artifactPattern.hashCode());
        return result;
    }
}

