/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Markup;
import org.openrewrite.maven.MavenDownloadingException;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.maven.tree.Parent;
import org.openrewrite.xml.tree.Xml;

public class MavenDownloadingExceptions
extends Exception {
    private final List<MavenDownloadingException> exceptions = new ArrayList<MavenDownloadingException>();

    public static MavenDownloadingExceptions append(@Nullable MavenDownloadingExceptions current, MavenDownloadingException exception) {
        if (current == null) {
            current = new MavenDownloadingExceptions();
        }
        current.exceptions.add(exception);
        return current;
    }

    public static MavenDownloadingExceptions append(@Nullable MavenDownloadingExceptions current, MavenDownloadingExceptions exceptions) {
        if (current == null) {
            current = new MavenDownloadingExceptions();
        }
        current.exceptions.addAll(exceptions.getExceptions());
        return current;
    }

    public Xml.Document warn(Xml.Document document) {
        final HashMap<GroupArtifact, List> byGav = new HashMap<GroupArtifact, List>();
        for (MavenDownloadingException exception : this.exceptions) {
            byGav.computeIfAbsent(new GroupArtifact(exception.getRoot().getGroupId(), exception.getRoot().getArtifactId()), ga -> new ArrayList()).add(exception);
        }
        return (Xml.Document)new MavenIsoVisitor<Integer>(){

            @Override
            public boolean isAcceptable(SourceFile sourceFile, Integer integer) {
                return sourceFile instanceof Xml.Document;
            }

            @Override
            public Xml.Tag visitTag(Xml.Tag tag, Integer integer) {
                Xml.Tag t = tag;
                for (GroupArtifact ga : byGav.keySet()) {
                    Parent parent;
                    boolean hasException;
                    boolean bl = hasException = (this.isDependencyTag() || this.isManagedDependencyTag()) && tag.getChildValue("groupId").map(a -> ga.getGroupId().equals(a)).orElse(false) != false && tag.getChildValue("artifactId").map(a -> ga.getArtifactId().equals(a)).orElse(false) != false;
                    if (this.isParentTag() && (parent = Objects.requireNonNull(this.getResolutionResult().getPom().getRequested().getParent())).getGroupId().equals(ga.getGroupId()) && parent.getArtifactId().equals(ga.getArtifactId())) {
                        hasException = true;
                    }
                    if (!hasException) continue;
                    for (MavenDownloadingException exception : (List)byGav.get(ga)) {
                        t = (Xml.Tag)Markup.warn((Tree)t, (Throwable)exception);
                    }
                }
                return super.visitTag(t, integer);
            }
        }.visitNonNull((Tree)document, 0);
    }

    public List<MavenDownloadingException> getExceptions() {
        return this.exceptions;
    }
}

