/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.cache;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.cfg.ConstructorDetector;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.dataformat.smile.SmileFactory;
import com.fasterxml.jackson.dataformat.smile.SmileGenerator;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenDownloadingException;
import org.openrewrite.maven.cache.MavenPomCache;
import org.openrewrite.maven.tree.GroupArtifactVersion;
import org.openrewrite.maven.tree.MavenMetadata;
import org.openrewrite.maven.tree.MavenRepository;
import org.openrewrite.maven.tree.Pom;
import org.openrewrite.maven.tree.ResolvedGroupArtifactVersion;
import org.openrewrite.maven.tree.ResolvedPom;
import org.rocksdb.Options;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.WriteOptions;

public class RocksdbMavenPomCache
implements MavenPomCache {
    static ObjectMapper mapper;
    private static final Map<String, RocksCache> cacheMap;
    private final RocksCache cache;

    static synchronized RocksCache getCache(String pomCacheDir) {
        return cacheMap.computeIfAbsent(pomCacheDir, RocksCache::new);
    }

    public RocksdbMavenPomCache(Path workspace) {
        File pomCacheDir = new File(workspace.toFile(), ".rewrite-cache");
        if (!pomCacheDir.exists() && !pomCacheDir.mkdirs()) {
            throw new IllegalStateException("Unable to find or create maven pom cache at " + pomCacheDir);
        }
        if (!pomCacheDir.isDirectory()) {
            throw new IllegalStateException("The maven pom cache workspace must be a directory at " + pomCacheDir);
        }
        File lock = new File(pomCacheDir, "LOCK");
        if (lock.exists()) {
            lock.delete();
        }
        this.cache = RocksdbMavenPomCache.getCache(pomCacheDir.getAbsolutePath());
    }

    @Override
    @Nullable
    public ResolvedPom getResolvedDependencyPom(ResolvedGroupArtifactVersion dependency) {
        return null;
    }

    @Override
    public void putResolvedDependencyPom(ResolvedGroupArtifactVersion dependency, ResolvedPom resolved) {
    }

    @Override
    @Nullable
    public Optional<MavenMetadata> getMavenMetadata(URI repo, GroupArtifactVersion gav) {
        return null;
    }

    @Override
    public void putMavenMetadata(URI repo, GroupArtifactVersion gav, @Nullable MavenMetadata metadata) {
    }

    @Override
    public Optional<Pom> getPom(ResolvedGroupArtifactVersion gav) throws MavenDownloadingException {
        try {
            return RocksdbMavenPomCache.deserializePom(this.cache.get(RocksdbMavenPomCache.serialize(gav.toString().getBytes(StandardCharsets.UTF_8))));
        }
        catch (RocksDBException e) {
            throw new MavenDownloadingException("Failed to deserialize POM from RocksDB cache", e, new GroupArtifactVersion(gav.getGroupId(), gav.getArtifactId(), gav.getVersion()));
        }
    }

    @Override
    public void putPom(ResolvedGroupArtifactVersion gav, Pom pom) {
        if (pom == null) {
            return;
        }
        try {
            this.cache.put(RocksdbMavenPomCache.serialize(gav.toString().getBytes(StandardCharsets.UTF_8)), RocksdbMavenPomCache.serialize(pom));
        }
        catch (RocksDBException e) {
            e.printStackTrace();
        }
    }

    @Override
    @Nullable
    public Optional<MavenRepository> getNormalizedRepository(MavenRepository repository) {
        return null;
    }

    @Override
    public void putNormalizedRepository(MavenRepository repository, MavenRepository normalized) {
    }

    static <T> byte[] serialize(T object) {
        if (object == null) {
            return null;
        }
        try {
            return mapper.writeValueAsBytes(object);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Unable to serialize object to byte array.");
        }
    }

    static Optional<MavenRepository> deserializeMavenRepository(byte[] bytes) {
        try {
            return bytes == null ? null : Optional.of((MavenRepository)mapper.readValue(bytes, MavenRepository.class));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Nullable
    static Optional<Pom> deserializePom(byte[] bytes) {
        try {
            return bytes == null ? null : Optional.of((Pom)mapper.readValue(bytes, Pom.class));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    static Optional<MavenMetadata> deserializeMavenMetadata(byte[] bytes) {
        try {
            return bytes == null ? null : Optional.of((MavenMetadata)mapper.readValue(bytes, MavenMetadata.class));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    static {
        cacheMap = new HashMap<String, RocksCache>();
        SmileFactory f = new SmileFactory();
        f.configure(SmileGenerator.Feature.CHECK_SHARED_STRING_VALUES, true);
        ObjectMapper m = ((JsonMapper)((JsonMapper.Builder)JsonMapper.builder((JsonFactory)f).constructorDetector(ConstructorDetector.USE_PROPERTIES_BASED)).build()).registerModule((Module)new ParameterNamesModule()).registerModule((Module)new Jdk8Module()).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS).setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper = m.setVisibility(m.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withCreatorVisibility(JsonAutoDetect.Visibility.PUBLIC_ONLY));
        RocksDB.loadLibrary();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> cacheMap.values().forEach(rec$ -> ((RocksCache)rec$).close())));
    }

    static class RocksCache {
        private final RocksDB database;
        private final Options options;
        private final WriteOptions writeOptions;
        private final String cacheFolder;

        RocksCache(String pomCacheDir) {
            try {
                this.options = new Options();
                this.options.setCreateIfMissing(true);
                this.options.setWriteBufferSize(1000000L);
                this.options.setParanoidChecks(false);
                this.options.setParanoidFileChecks(false);
                this.writeOptions = new WriteOptions();
                this.writeOptions.setDisableWAL(true);
                this.database = RocksDB.open((Options)this.options, (String)pomCacheDir);
                this.cacheFolder = pomCacheDir;
            }
            catch (RocksDBException exception) {
                throw new IllegalStateException("Unable to create cache database." + exception.getMessage(), exception);
            }
            try {
                this.cleanCacheIfCorrupt(pomCacheDir);
            }
            catch (Exception ex) {
                throw new IllegalStateException("Unable to clear corrupt maven pom cache.", ex);
            }
        }

        private void cleanCacheIfCorrupt(String pomCacheDir) throws IOException {
            try {
                this.database.verifyChecksum();
            }
            catch (RocksDBException ex) {
                try (DirectoryStream<Path> paths = Files.newDirectoryStream(Paths.get(pomCacheDir, new String[0]), "*");){
                    paths.forEach(path -> {
                        try {
                            Files.delete(path);
                        }
                        catch (IOException ioException) {
                            throw new IllegalStateException("Unable to delete maven pom cache at " + path, ioException);
                        }
                    });
                }
            }
        }

        private void put(byte[] key, byte[] value) throws RocksDBException {
            this.database.put(this.writeOptions, key, value);
        }

        private byte[] get(byte[] key) throws RocksDBException {
            return this.database.get(key);
        }

        private void close() {
            this.writeOptions.close();
            this.options.close();
            if (Files.exists(Paths.get(this.cacheFolder, new String[0]), new LinkOption[0])) {
                this.database.close();
            }
        }
    }
}

