/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.Objects;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.tree.Xml;

public final class RemoveRepository
extends Recipe {
    private static final XPathMatcher REPOS_MATCHER = new XPathMatcher("/project/repositories/repository");
    @Option(required=false, description="Repository id")
    @Nullable
    private final String id;
    @Option(description="Repository URL")
    private final String url;
    @Option(required=false, description="Repository name")
    @Nullable
    private final String repoName;
    @Option(required=false, description="Repository layout")
    @Nullable
    private final String layout;
    @Option(required=false, description="Snapshots from the repository are available")
    @Nullable
    private final Boolean snapshotsEnabled;
    @Option(required=false, description="Snapshots checksum policy")
    @Nullable
    private final String snapshotsChecksumPolicy;
    @Option(required=false, description="Snapshots update policy policy")
    @Nullable
    private final String snapshotsUpdatePolicy;
    @Option(required=false, description="Releases from the repository are available")
    @Nullable
    private final Boolean releasesEnabled;
    @Option(required=false, description="Releases checksum policy")
    @Nullable
    private final String releasesChecksumPolicy;
    @Option(required=false, description="Releases update policy")
    @Nullable
    private final String releasesUpdatePolicy;

    public String getDisplayName() {
        return "Remove repository";
    }

    public String getDescription() {
        return "Removes a matching Maven repository.";
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MavenIsoVisitor<ExecutionContext>(){

            @Override
            public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
                Xml.Tag repo = super.visitTag(tag, ctx);
                if (REPOS_MATCHER.matches(this.getCursor())) {
                    if (RemoveRepository.this.id == null && RemoveRepository.this.isReleasesEqual(repo) && RemoveRepository.this.isSnapshotsEqual(repo) && RemoveRepository.this.url.equals(repo.getChildValue("url").orElse(null))) {
                        return null;
                    }
                    if (RemoveRepository.this.id != null && (RemoveRepository.this.id.equals(repo.getChildValue("id").orElse(null)) || RemoveRepository.this.isReleasesEqual(repo) && RemoveRepository.this.isSnapshotsEqual(repo)) && RemoveRepository.this.url.equals(repo.getChildValue("url").orElse(null))) {
                        return null;
                    }
                }
                return repo;
            }
        };
    }

    private boolean isReleasesEqual(Xml.Tag repo) {
        Xml.Tag releases = repo.getChild("releases").orElse(null);
        if (releases == null) {
            return this.isNoReleases();
        }
        return Objects.equals(this.releasesEnabled == null ? null : String.valueOf(this.releasesEnabled), releases.getChildValue("enabled").orElse(null)) && Objects.equals(this.releasesUpdatePolicy, releases.getChildValue("updatePolicy").orElse(null)) && Objects.equals(this.releasesChecksumPolicy, releases.getChildValue("checksumPolicy").orElse(null));
    }

    private boolean isNoReleases() {
        return this.releasesEnabled == null && this.releasesUpdatePolicy == null && this.releasesChecksumPolicy == null;
    }

    private boolean isSnapshotsEqual(Xml.Tag repo) {
        Xml.Tag snapshots = repo.getChild("snapshots").orElse(null);
        if (snapshots == null) {
            return this.isNoSnapshots();
        }
        return Objects.equals(this.snapshotsEnabled == null ? null : String.valueOf(this.snapshotsEnabled), snapshots.getChildValue("enabled").orElse(null)) && Objects.equals(this.snapshotsUpdatePolicy, snapshots.getChildValue("updatePolicy").orElse(null)) && Objects.equals(this.snapshotsChecksumPolicy, snapshots.getChildValue("checksumPolicy").orElse(null));
    }

    private boolean isNoSnapshots() {
        return this.snapshotsEnabled == null && this.snapshotsUpdatePolicy == null && this.snapshotsChecksumPolicy == null;
    }

    public RemoveRepository(@Nullable String id, String url, @Nullable String repoName, @Nullable String layout, @Nullable Boolean snapshotsEnabled, @Nullable String snapshotsChecksumPolicy, @Nullable String snapshotsUpdatePolicy, @Nullable Boolean releasesEnabled, @Nullable String releasesChecksumPolicy, @Nullable String releasesUpdatePolicy) {
        this.id = id;
        this.url = url;
        this.repoName = repoName;
        this.layout = layout;
        this.snapshotsEnabled = snapshotsEnabled;
        this.snapshotsChecksumPolicy = snapshotsChecksumPolicy;
        this.snapshotsUpdatePolicy = snapshotsUpdatePolicy;
        this.releasesEnabled = releasesEnabled;
        this.releasesChecksumPolicy = releasesChecksumPolicy;
        this.releasesUpdatePolicy = releasesUpdatePolicy;
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    public String getUrl() {
        return this.url;
    }

    @Nullable
    public String getRepoName() {
        return this.repoName;
    }

    @Nullable
    public String getLayout() {
        return this.layout;
    }

    @Nullable
    public Boolean getSnapshotsEnabled() {
        return this.snapshotsEnabled;
    }

    @Nullable
    public String getSnapshotsChecksumPolicy() {
        return this.snapshotsChecksumPolicy;
    }

    @Nullable
    public String getSnapshotsUpdatePolicy() {
        return this.snapshotsUpdatePolicy;
    }

    @Nullable
    public Boolean getReleasesEnabled() {
        return this.releasesEnabled;
    }

    @Nullable
    public String getReleasesChecksumPolicy() {
        return this.releasesChecksumPolicy;
    }

    @Nullable
    public String getReleasesUpdatePolicy() {
        return this.releasesUpdatePolicy;
    }

    @NonNull
    public String toString() {
        return "RemoveRepository(id=" + this.getId() + ", url=" + this.getUrl() + ", repoName=" + this.getRepoName() + ", layout=" + this.getLayout() + ", snapshotsEnabled=" + this.getSnapshotsEnabled() + ", snapshotsChecksumPolicy=" + this.getSnapshotsChecksumPolicy() + ", snapshotsUpdatePolicy=" + this.getSnapshotsUpdatePolicy() + ", releasesEnabled=" + this.getReleasesEnabled() + ", releasesChecksumPolicy=" + this.getReleasesChecksumPolicy() + ", releasesUpdatePolicy=" + this.getReleasesUpdatePolicy() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveRepository)) {
            return false;
        }
        RemoveRepository other = (RemoveRepository)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$snapshotsEnabled = this.getSnapshotsEnabled();
        Boolean other$snapshotsEnabled = other.getSnapshotsEnabled();
        if (this$snapshotsEnabled == null ? other$snapshotsEnabled != null : !((Object)this$snapshotsEnabled).equals(other$snapshotsEnabled)) {
            return false;
        }
        Boolean this$releasesEnabled = this.getReleasesEnabled();
        Boolean other$releasesEnabled = other.getReleasesEnabled();
        if (this$releasesEnabled == null ? other$releasesEnabled != null : !((Object)this$releasesEnabled).equals(other$releasesEnabled)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$repoName = this.getRepoName();
        String other$repoName = other.getRepoName();
        if (this$repoName == null ? other$repoName != null : !this$repoName.equals(other$repoName)) {
            return false;
        }
        String this$layout = this.getLayout();
        String other$layout = other.getLayout();
        if (this$layout == null ? other$layout != null : !this$layout.equals(other$layout)) {
            return false;
        }
        String this$snapshotsChecksumPolicy = this.getSnapshotsChecksumPolicy();
        String other$snapshotsChecksumPolicy = other.getSnapshotsChecksumPolicy();
        if (this$snapshotsChecksumPolicy == null ? other$snapshotsChecksumPolicy != null : !this$snapshotsChecksumPolicy.equals(other$snapshotsChecksumPolicy)) {
            return false;
        }
        String this$snapshotsUpdatePolicy = this.getSnapshotsUpdatePolicy();
        String other$snapshotsUpdatePolicy = other.getSnapshotsUpdatePolicy();
        if (this$snapshotsUpdatePolicy == null ? other$snapshotsUpdatePolicy != null : !this$snapshotsUpdatePolicy.equals(other$snapshotsUpdatePolicy)) {
            return false;
        }
        String this$releasesChecksumPolicy = this.getReleasesChecksumPolicy();
        String other$releasesChecksumPolicy = other.getReleasesChecksumPolicy();
        if (this$releasesChecksumPolicy == null ? other$releasesChecksumPolicy != null : !this$releasesChecksumPolicy.equals(other$releasesChecksumPolicy)) {
            return false;
        }
        String this$releasesUpdatePolicy = this.getReleasesUpdatePolicy();
        String other$releasesUpdatePolicy = other.getReleasesUpdatePolicy();
        return !(this$releasesUpdatePolicy == null ? other$releasesUpdatePolicy != null : !this$releasesUpdatePolicy.equals(other$releasesUpdatePolicy));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof RemoveRepository;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $snapshotsEnabled = this.getSnapshotsEnabled();
        result = result * 59 + ($snapshotsEnabled == null ? 43 : ((Object)$snapshotsEnabled).hashCode());
        Boolean $releasesEnabled = this.getReleasesEnabled();
        result = result * 59 + ($releasesEnabled == null ? 43 : ((Object)$releasesEnabled).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $repoName = this.getRepoName();
        result = result * 59 + ($repoName == null ? 43 : $repoName.hashCode());
        String $layout = this.getLayout();
        result = result * 59 + ($layout == null ? 43 : $layout.hashCode());
        String $snapshotsChecksumPolicy = this.getSnapshotsChecksumPolicy();
        result = result * 59 + ($snapshotsChecksumPolicy == null ? 43 : $snapshotsChecksumPolicy.hashCode());
        String $snapshotsUpdatePolicy = this.getSnapshotsUpdatePolicy();
        result = result * 59 + ($snapshotsUpdatePolicy == null ? 43 : $snapshotsUpdatePolicy.hashCode());
        String $releasesChecksumPolicy = this.getReleasesChecksumPolicy();
        result = result * 59 + ($releasesChecksumPolicy == null ? 43 : $releasesChecksumPolicy.hashCode());
        String $releasesUpdatePolicy = this.getReleasesUpdatePolicy();
        result = result * 59 + ($releasesUpdatePolicy == null ? 43 : $releasesUpdatePolicy.hashCode());
        return result;
    }
}

