/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.Optional;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.xml.FilterTagChildrenVisitor;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.tree.Xml;

public final class RemovePluginDependency
extends Recipe {
    private static final XPathMatcher PLUGINS_MATCHER = new XPathMatcher("/project/build/plugins");
    @Option(displayName="Plugin Group", description="GroupId of the plugin from which the dependency will be removed. Supports glob.A GroupId is the first part of a dependency coordinate 'org.openrewrite.maven:rewrite-maven-plugin:VERSION'.", example="org.openrewrite.maven")
    private final String pluginGroupId;
    @Option(displayName="Plugin Artifact", description="ArtifactId of the plugin from which the dependency will be removed. Supports glob.The second part of a dependency coordinate 'org.openrewrite.maven:rewrite-maven-plugin:VERSION'.", example="rewrite-maven-plugin")
    private final String pluginArtifactId;
    @Option(displayName="Group", description="The first part of a plugin dependency coordinate. Supports glob.", example="com.google.guava")
    private final String groupId;
    @Option(displayName="Artifact", description="The second part of a plugin dependency coordinate. Supports glob.", example="guava")
    private final String artifactId;

    public String getDisplayName() {
        return "Remove Maven plugin dependency";
    }

    public String getDescription() {
        return "Removes a dependency from the <dependencies> section of a plugin in the pom.xml.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new RemoveDependencyVisitor();
    }

    public RemovePluginDependency(String pluginGroupId, String pluginArtifactId, String groupId, String artifactId) {
        this.pluginGroupId = pluginGroupId;
        this.pluginArtifactId = pluginArtifactId;
        this.groupId = groupId;
        this.artifactId = artifactId;
    }

    public String getPluginGroupId() {
        return this.pluginGroupId;
    }

    public String getPluginArtifactId() {
        return this.pluginArtifactId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    @NonNull
    public String toString() {
        return "RemovePluginDependency(pluginGroupId=" + this.getPluginGroupId() + ", pluginArtifactId=" + this.getPluginArtifactId() + ", groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemovePluginDependency)) {
            return false;
        }
        RemovePluginDependency other = (RemovePluginDependency)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$pluginGroupId = this.getPluginGroupId();
        String other$pluginGroupId = other.getPluginGroupId();
        if (this$pluginGroupId == null ? other$pluginGroupId != null : !this$pluginGroupId.equals(other$pluginGroupId)) {
            return false;
        }
        String this$pluginArtifactId = this.getPluginArtifactId();
        String other$pluginArtifactId = other.getPluginArtifactId();
        if (this$pluginArtifactId == null ? other$pluginArtifactId != null : !this$pluginArtifactId.equals(other$pluginArtifactId)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        return !(this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof RemovePluginDependency;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $pluginGroupId = this.getPluginGroupId();
        result = result * 59 + ($pluginGroupId == null ? 43 : $pluginGroupId.hashCode());
        String $pluginArtifactId = this.getPluginArtifactId();
        result = result * 59 + ($pluginArtifactId == null ? 43 : $pluginArtifactId.hashCode());
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        return result;
    }

    private class RemoveDependencyVisitor
    extends MavenIsoVisitor<ExecutionContext> {
        private RemoveDependencyVisitor() {
        }

        @Override
        public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
            Xml.Tag plugins = super.visitTag(tag, ctx);
            if (!PLUGINS_MATCHER.matches(this.getCursor())) {
                return plugins;
            }
            Optional<Xml.Tag> maybePlugin = plugins.getChildren().stream().filter(plugin -> "plugin".equals(plugin.getName()) && this.childValueMatches((Xml.Tag)plugin, "groupId", RemovePluginDependency.this.pluginGroupId) && this.childValueMatches((Xml.Tag)plugin, "artifactId", RemovePluginDependency.this.pluginArtifactId)).findAny();
            if (!maybePlugin.isPresent()) {
                return plugins;
            }
            Xml.Tag plugin2 = maybePlugin.get();
            Optional maybeDependencies = plugin2.getChild("dependencies");
            if (!maybeDependencies.isPresent()) {
                return plugins;
            }
            Xml.Tag dependencies = (Xml.Tag)maybeDependencies.get();
            plugins = FilterTagChildrenVisitor.filterTagChildren((Xml.Tag)plugins, (Xml.Tag)dependencies, dependencyTag -> !this.childValueMatches((Xml.Tag)dependencyTag, "groupId", RemovePluginDependency.this.groupId) || !this.childValueMatches((Xml.Tag)dependencyTag, "artifactId", RemovePluginDependency.this.artifactId));
            plugins = FilterTagChildrenVisitor.filterTagChildren((Xml.Tag)plugins, (Xml.Tag)plugin2, pluginChildTag -> !pluginChildTag.getName().equals("dependencies") || !pluginChildTag.getChildren().isEmpty());
            return plugins;
        }

        private boolean childValueMatches(Xml.Tag tag, String childValueName, String globPattern) {
            return tag.getChildValue(childValueName).map(it -> StringUtils.matchesGlob((String)it, (String)globPattern)).orElse(false);
        }
    }
}

