/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import org.apache.commons.lang3.StringUtils;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.tree.Xml;

public final class RemoveRepository
extends Recipe {
    private static final XPathMatcher REPOS_MATCHER = new XPathMatcher("/project/repositories/repository");
    private static final XPathMatcher PLUGIN_REPOS_MATCHER = new XPathMatcher("/project/pluginRepositories/pluginRepository");
    @Option(required=false, description="Repository id")
    @Nullable
    private final String id;
    @Option(description="Repository URL")
    @Nullable
    private final String url;

    public String getDisplayName() {
        return "Remove repository";
    }

    public String getDescription() {
        return "Removes a matching Maven repository.";
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MavenIsoVisitor<ExecutionContext>(){

            @Override
            public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
                Xml.Tag repo = super.visitTag(tag, ctx);
                if ((REPOS_MATCHER.matches(this.getCursor()) || PLUGIN_REPOS_MATCHER.matches(this.getCursor())) && RemoveRepository.this.isSameUrlAndID(repo)) {
                    return null;
                }
                return repo;
            }
        };
    }

    private boolean isSameUrlAndID(Xml.Tag repo) {
        boolean sameURL = StringUtils.isBlank((CharSequence)this.url) || StringUtils.equals((CharSequence)this.url, (CharSequence)repo.getChildValue("url").orElse(null));
        boolean sameID = StringUtils.isBlank((CharSequence)this.id) || StringUtils.equals((CharSequence)this.id, (CharSequence)repo.getChildValue("id").orElse(null));
        return sameURL && sameID;
    }

    public RemoveRepository(@Nullable String id, @Nullable String url) {
        this.id = id;
        this.url = url;
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    @Nullable
    public String getUrl() {
        return this.url;
    }

    @NonNull
    public String toString() {
        return "RemoveRepository(id=" + this.getId() + ", url=" + this.getUrl() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveRepository)) {
            return false;
        }
        RemoveRepository other = (RemoveRepository)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        return !(this$url == null ? other$url != null : !this$url.equals(other$url));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof RemoveRepository;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        return result;
    }
}

