/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.search;

import java.util.HashSet;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.xml.tree.Xml;

public final class FindDependency
extends Recipe {
    @Option(displayName="Group", description="The first part of a dependency coordinate `com.google.guava:guava:VERSION`. Supports glob.", example="com.google.guava")
    private final String groupId;
    @Option(displayName="Artifact", description="The second part of a dependency coordinate `com.google.guava:guava:VERSION`. Supports glob.", example="guava")
    private final String artifactId;

    public static Set<Xml.Tag> find(Xml.Document maven, final String groupId, final String artifactId) {
        final HashSet<Xml.Tag> ds = new HashSet<Xml.Tag>();
        new MavenIsoVisitor<ExecutionContext>(){

            @Override
            public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
                if (this.isDependencyTag(groupId, artifactId)) {
                    ds.add(tag);
                }
                return super.visitTag(tag, ctx);
            }
        }.visit((Tree)maven, new InMemoryExecutionContext());
        return ds;
    }

    public String getDisplayName() {
        return "Find Maven dependency";
    }

    public String getDescription() {
        return "Finds first-order dependency uses, i.e. dependencies that are defined directly in a project.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MavenIsoVisitor<ExecutionContext>(){

            @Override
            public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
                if (this.isDependencyTag(FindDependency.this.groupId, FindDependency.this.artifactId)) {
                    return (Xml.Tag)SearchResult.found((Tree)tag);
                }
                return super.visitTag(tag, ctx);
            }
        };
    }

    public FindDependency(String groupId, String artifactId) {
        this.groupId = groupId;
        this.artifactId = artifactId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    @NonNull
    public String toString() {
        return "FindDependency(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindDependency)) {
            return false;
        }
        FindDependency other = (FindDependency)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        return !(this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindDependency;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        return result;
    }
}

