/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.internal;

import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryConfig;
import io.github.resilience4j.retry.RetryRegistry;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import io.vavr.CheckedFunction1;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openrewrite.ExecutionContext;
import org.openrewrite.HttpSenderExecutionContextView;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.ipc.http.HttpSender;
import org.openrewrite.maven.MavenDownloadingException;
import org.openrewrite.maven.MavenExecutionContextView;
import org.openrewrite.maven.MavenSettings;
import org.openrewrite.maven.cache.MavenPomCache;
import org.openrewrite.maven.internal.RawPom;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.maven.tree.GroupArtifactVersion;
import org.openrewrite.maven.tree.MavenMetadata;
import org.openrewrite.maven.tree.MavenRepository;
import org.openrewrite.maven.tree.MavenRepositoryCredentials;
import org.openrewrite.maven.tree.MavenRepositoryMirror;
import org.openrewrite.maven.tree.Parent;
import org.openrewrite.maven.tree.Pom;
import org.openrewrite.maven.tree.ResolvedGroupArtifactVersion;
import org.openrewrite.maven.tree.ResolvedPom;

public class MavenPomDownloader {
    private static final RetryConfig retryConfig = RetryConfig.custom().retryOnException(throwable -> throwable instanceof SocketTimeoutException || throwable instanceof TimeoutException).maxAttempts(5).build();
    private static final RetryRegistry retryRegistry = RetryRegistry.of((RetryConfig)retryConfig);
    private static final Retry mavenDownloaderRetry = retryRegistry.retry("MavenDownloader");
    private static final Pattern SNAPSHOT_TIMESTAMP = Pattern.compile("^(.*-)?([0-9]{8}\\.[0-9]{6}-[0-9]+)$");
    private static final String SNAPSHOT = "SNAPSHOT";
    private final MavenPomCache mavenCache;
    private final Map<Path, Pom> projectPoms;
    private final Map<GroupArtifactVersion, Pom> projectPomsByGav;
    private final MavenExecutionContextView ctx;
    private final HttpSender httpSender;
    @Nullable
    private MavenSettings mavenSettings;
    @Nullable
    private List<String> activeProfiles;
    private final CheckedFunction1<HttpSender.Request, byte[]> sendRequest;
    private boolean addDefaultRepositories = true;

    public MavenPomDownloader(Map<Path, Pom> projectPoms, ExecutionContext ctx, @Nullable MavenSettings mavenSettings, @Nullable List<String> activeProfiles) {
        this(projectPoms, HttpSenderExecutionContextView.view((ExecutionContext)ctx).getHttpSender(), ctx);
        this.mavenSettings = mavenSettings;
        this.activeProfiles = activeProfiles;
    }

    public MavenPomDownloader(ExecutionContext ctx) {
        this(Collections.emptyMap(), HttpSenderExecutionContextView.view((ExecutionContext)ctx).getHttpSender(), ctx);
        this.addDefaultRepositories = false;
    }

    public MavenPomDownloader(Map<Path, Pom> projectPoms, ExecutionContext ctx) {
        this(projectPoms, HttpSenderExecutionContextView.view((ExecutionContext)ctx).getHttpSender(), ctx);
    }

    @Deprecated
    public MavenPomDownloader(Map<Path, Pom> projectPoms, HttpSender httpSender, ExecutionContext ctx) {
        this.projectPoms = projectPoms;
        this.projectPomsByGav = this.projectPomsByGav(projectPoms);
        this.httpSender = httpSender;
        this.ctx = MavenExecutionContextView.view(ctx);
        this.sendRequest = Retry.decorateCheckedFunction((Retry)mavenDownloaderRetry, (CheckedFunction1 & Serializable)request -> {
            int responseCode;
            long start = System.nanoTime();
            try (HttpSender.Response response = httpSender.send(request);){
                if (response.isSuccessful()) {
                    byte[] byArray = response.getBodyAsBytes();
                    return byArray;
                }
                responseCode = response.getCode();
            }
            catch (Throwable t) {
                throw new HttpSenderResponseException(t, null);
            }
            finally {
                this.ctx.recordResolutionTime(Duration.ofNanos(System.nanoTime() - start));
            }
            throw new HttpSenderResponseException(null, responseCode);
        });
        this.mavenCache = this.ctx.getPomCache();
    }

    private Map<GroupArtifactVersion, Pom> projectPomsByGav(Map<Path, Pom> projectPoms) {
        HashMap<GroupArtifactVersion, Pom> result = new HashMap<GroupArtifactVersion, Pom>();
        for (Pom projectPom : projectPoms.values()) {
            List<Pom> ancestryWithinProject = this.getAncestryWithinProject(projectPom, projectPoms);
            Map<String, String> mergedProperties = this.mergeProperties(ancestryWithinProject);
            GroupArtifactVersion gav = new GroupArtifactVersion(projectPom.getGroupId(), projectPom.getArtifactId(), ResolvedPom.placeholderHelper.replacePlaceholders(projectPom.getVersion(), mergedProperties::get));
            result.put(gav, projectPom);
        }
        return result;
    }

    private Map<String, String> mergeProperties(List<Pom> pomAncestry) {
        HashMap<String, String> mergedProperties = new HashMap<String, String>();
        for (Pom pom : pomAncestry) {
            for (Map.Entry<String, String> property : pom.getProperties().entrySet()) {
                mergedProperties.putIfAbsent(property.getKey(), property.getValue());
            }
        }
        return mergedProperties;
    }

    private List<Pom> getAncestryWithinProject(Pom projectPom, Map<Path, Pom> projectPoms) {
        Pom parentPom = this.getParentWithinProject(projectPom, projectPoms);
        if (parentPom == null) {
            return Collections.singletonList(projectPom);
        }
        return ListUtils.concat((Object)projectPom, this.getAncestryWithinProject(parentPom, projectPoms));
    }

    @Nullable
    private Pom getParentWithinProject(Pom projectPom, Map<Path, Pom> projectPoms) {
        Path parentPath;
        Pom parentPom;
        Parent parent = projectPom.getParent();
        if (parent == null || projectPom.getSourcePath() == null) {
            return null;
        }
        String relativePath = parent.getRelativePath();
        if (StringUtils.isBlank((String)relativePath)) {
            relativePath = "../pom.xml";
        }
        return (parentPom = projectPoms.get(parentPath = projectPom.getSourcePath().resolve("..").resolve(Paths.get(relativePath, new String[0])).normalize())) != null && parentPom.getGav().getGroupId().equals(parent.getGav().getGroupId()) && parentPom.getGav().getArtifactId().equals(parent.getGav().getArtifactId()) ? parentPom : null;
    }

    public MavenMetadata downloadMetadata(GroupArtifact groupArtifact, @Nullable ResolvedPom containingPom, List<MavenRepository> repositories) throws MavenDownloadingException {
        return this.downloadMetadata(new GroupArtifactVersion(groupArtifact.getGroupId(), groupArtifact.getArtifactId(), null), containingPom, repositories);
    }

    public MavenMetadata downloadMetadata(GroupArtifactVersion gav, @Nullable ResolvedPom containingPom, List<MavenRepository> repositories) throws MavenDownloadingException {
        if (gav.getGroupId() == null) {
            throw new MavenDownloadingException("Missing group id.", null, gav);
        }
        Timer.Sample sample = Timer.start();
        Timer.Builder timer = Timer.builder((String)"rewrite.maven.download").tag("type", "metadata");
        MavenMetadata mavenMetadata = null;
        Collection<MavenRepository> normalizedRepos = this.distinctNormalizedRepositories(repositories, containingPom, null);
        LinkedHashMap<MavenRepository, String> repositoryResponses = new LinkedHashMap<MavenRepository, String>();
        for (MavenRepository repo : normalizedRepos) {
            if (gav.getVersion() != null && !this.repositoryAcceptsVersion(repo, gav.getVersion(), containingPom)) continue;
            Optional<MavenMetadata> result = this.mavenCache.getMavenMetadata(URI.create(repo.getUri()), gav);
            if (result == null) {
                boolean cacheEmptyResult = false;
                try {
                    String scheme = URI.create(repo.getUri()).getScheme();
                    String uri = repo.getUri() + (repo.getUri().endsWith("/") ? "" : "/") + gav.getGroupId().replace('.', '/') + '/' + gav.getArtifactId() + '/' + (gav.getVersion() == null ? "" : gav.getVersion() + '/') + "maven-metadata.xml";
                    if ("file".equals(scheme)) {
                        Path path = Paths.get(URI.create(uri));
                        if (Files.exists(path, new LinkOption[0])) {
                            result = Optional.of(MavenMetadata.parse(Files.readAllBytes(path)));
                        }
                    } else {
                        byte[] responseBody = this.requestAsAuthenticatedOrAnonymous(repo, uri);
                        result = Optional.of(MavenMetadata.parse(responseBody));
                    }
                }
                catch (HttpSenderResponseException e) {
                    repositoryResponses.put(repo, e.getMessage());
                    if (e.isClientSideException()) {
                        cacheEmptyResult = true;
                    }
                }
                catch (IOException e) {
                    repositoryResponses.put(repo, e.getMessage());
                }
                if (result == null) {
                    try {
                        MavenMetadata derivedMeta = this.deriveMetadata(gav, repo);
                        if (derivedMeta != null) {
                            Counter.builder((String)"rewrite.maven.derived.metadata").tag("repositoryUri", repo.getUri()).tag("group", gav.getGroupId()).tag("artifact", gav.getArtifactId()).register((MeterRegistry)Metrics.globalRegistry).increment();
                            result = Optional.of(derivedMeta);
                        }
                    }
                    catch (MavenDownloadingException | HttpSenderResponseException e) {
                        repositoryResponses.put(repo, e.getMessage());
                    }
                }
                if (result == null && cacheEmptyResult) {
                    this.mavenCache.putMavenMetadata(URI.create(repo.getUri()), gav, null);
                }
            } else if (!result.isPresent()) {
                repositoryResponses.put(repo, "Did not attempt to download because of a previous failure to retrieve from this repository.");
            }
            if (result == null || !result.isPresent()) continue;
            mavenMetadata = mavenMetadata == null ? result.get() : this.mergeMetadata(mavenMetadata, result.get());
            this.mavenCache.putMavenMetadata(URI.create(repo.getUri()), gav, result.get());
        }
        if (mavenMetadata == null) {
            sample.stop(timer.tags(new String[]{"outcome", "unavailable"}).register((MeterRegistry)Metrics.globalRegistry));
            throw new MavenDownloadingException("Unable to download metadata.", null, gav).setRepositoryResponses(repositoryResponses);
        }
        sample.stop(timer.tags(new String[]{"outcome", "success"}).register((MeterRegistry)Metrics.globalRegistry));
        return mavenMetadata;
    }

    @Nullable
    private MavenMetadata deriveMetadata(GroupArtifactVersion gav, MavenRepository repo) throws HttpSenderResponseException, MavenDownloadingException {
        if (repo.getDeriveMetadataIfMissing() != null && !repo.getDeriveMetadataIfMissing().booleanValue() || gav.getVersion() != null) {
            return null;
        }
        String scheme = URI.create(repo.getUri()).getScheme();
        String uri = repo.getUri() + (repo.getUri().endsWith("/") ? "" : "/") + Objects.requireNonNull(gav.getGroupId()).replace('.', '/') + '/' + gav.getArtifactId() + '/';
        try {
            MavenMetadata.Versioning versioning;
            if ("file".equals(scheme)) {
                versioning = this.directoryToVersioning(uri, gav);
            } else {
                String responseBody = new String(this.requestAsAuthenticatedOrAnonymous(repo, uri));
                versioning = this.htmlIndexToVersioning(responseBody, uri);
            }
            if (versioning == null) {
                return null;
            }
            return new MavenMetadata(versioning);
        }
        catch (HttpSenderResponseException e) {
            if (e.isClientSideException() && e.getResponseCode() != null && e.getResponseCode() != 404) {
                repo.setDeriveMetadataIfMissing(false);
            }
            throw e;
        }
    }

    @Nullable
    private MavenMetadata.Versioning directoryToVersioning(String uri, GroupArtifactVersion gav) throws MavenDownloadingException {
        Path dir = Paths.get(URI.create(uri));
        if (Files.exists(dir, new LinkOption[0])) {
            MavenMetadata.Versioning versioning;
            block10: {
                DirectoryStream<Path> stream = Files.newDirectoryStream(dir);
                try {
                    ArrayList<String> versions = new ArrayList<String>();
                    for (Path path : stream) {
                        if (!Files.isDirectory(path, new LinkOption[0]) || !MavenPomDownloader.hasPomFile(dir, path, gav)) continue;
                        versions.add(path.getFileName().toString());
                    }
                    versioning = new MavenMetadata.Versioning(versions, null, null);
                    if (stream == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new MavenDownloadingException("Unable to derive metadata from file repository. " + e.getMessage(), null, gav);
                    }
                }
                stream.close();
            }
            return versioning;
        }
        return null;
    }

    @Nullable
    private MavenMetadata.Versioning htmlIndexToVersioning(String responseBody, String uri) {
        int end;
        ArrayList<String> versions = new ArrayList<String>();
        int start = responseBody.indexOf("<a href=\"");
        while (start > 0 && (end = responseBody.indexOf("\">", start += 9)) >= 0) {
            String href = responseBody.substring(start, end).trim();
            if (href.endsWith("/")) {
                versions.add(this.hrefToVersion(href, uri));
            }
            start = responseBody.indexOf("<a href=\"", end);
        }
        if (versions.isEmpty()) {
            return null;
        }
        return new MavenMetadata.Versioning(versions, null, null);
    }

    String hrefToVersion(String href, String rootUri) {
        String version = href.startsWith(rootUri) ? href.substring(rootUri.length()) : href;
        if (version.endsWith("/")) {
            return version.substring(0, version.length() - 1);
        }
        return version;
    }

    protected MavenMetadata mergeMetadata(MavenMetadata m1, MavenMetadata m2) {
        return new MavenMetadata(new MavenMetadata.Versioning(this.mergeVersions(m1.getVersioning().getVersions(), m2.getVersioning().getVersions()), Stream.concat(m1.getVersioning().getSnapshotVersions() == null ? Stream.empty() : m1.getVersioning().getSnapshotVersions().stream(), m2.getVersioning().getSnapshotVersions() == null ? Stream.empty() : m2.getVersioning().getSnapshotVersions().stream()).collect(Collectors.toList()), this.maxSnapshot(m1.getVersioning().getSnapshot(), m2.getVersioning().getSnapshot())));
    }

    private List<String> mergeVersions(List<String> versions1, List<String> versions2) {
        HashSet<String> merged = new HashSet<String>(versions1);
        merged.addAll(versions2);
        return new ArrayList<String>(merged);
    }

    @Nullable
    private MavenMetadata.Snapshot maxSnapshot(@Nullable MavenMetadata.Snapshot s1, @Nullable MavenMetadata.Snapshot s2) {
        if (s1 == null || s1.getTimestamp() == null) {
            return s2;
        }
        if (s2 == null || s2.getTimestamp() == null) {
            return s1;
        }
        return s1.getTimestamp().compareTo(s2.getTimestamp()) >= 0 ? s1 : s2;
    }

    public Pom download(GroupArtifactVersion gav, @Nullable String relativePath, @Nullable ResolvedPom containingPom, List<MavenRepository> repositories) throws MavenDownloadingException {
        Pom maybeLocalPom;
        Path folderContainingPom;
        if (gav.getGroupId() == null || gav.getArtifactId() == null || gav.getVersion() == null) {
            if (containingPom != null) {
                this.ctx.getResolutionListener().downloadError(gav, containingPom.getRequested());
            }
            throw new MavenDownloadingException("Group id, artifact id, or version are missing.", null, gav);
        }
        Pom projectPomWithResolvedVersion = this.projectPomsByGav.get(gav);
        if (projectPomWithResolvedVersion != null) {
            return projectPomWithResolvedVersion;
        }
        for (Pom projectPom : this.projectPoms.values()) {
            if (!gav.getGroupId().equals(projectPom.getGroupId()) || !gav.getArtifactId().equals(projectPom.getArtifactId()) || !gav.getVersion().equals(projectPom.getVersion()) && !projectPom.getVersion().equals(projectPom.getValue(gav.getVersion()))) continue;
            return projectPom;
        }
        if (containingPom != null && containingPom.getRequested().getSourcePath() != null && !StringUtils.isBlank((String)relativePath) && !relativePath.contains(":") && (folderContainingPom = containingPom.getRequested().getSourcePath().getParent()) != null && (maybeLocalPom = this.projectPoms.get(folderContainingPom.resolve(Paths.get(relativePath, "pom.xml")).normalize())) != null && gav.getGroupId().equals(maybeLocalPom.getGroupId()) && gav.getArtifactId().equals(maybeLocalPom.getArtifactId()) && gav.getVersion().equals(maybeLocalPom.getVersion())) {
            return maybeLocalPom;
        }
        Collection<MavenRepository> normalizedRepos = this.distinctNormalizedRepositories(repositories, containingPom, gav.getVersion());
        Timer.Sample sample = Timer.start();
        Timer.Builder timer = Timer.builder((String)"rewrite.maven.download").tag("type", "pom");
        LinkedHashMap<MavenRepository, String> repositoryResponses = new LinkedHashMap<MavenRepository, String>();
        String versionMaybeDatedSnapshot = this.datedSnapshotVersion(gav, containingPom, repositories, (ExecutionContext)this.ctx);
        GroupArtifactVersion originalGav = gav;
        gav = this.handleSnapshotTimestampVersion(gav);
        for (MavenRepository repo : normalizedRepos) {
            if (!this.repositoryAcceptsVersion(repo, gav.getVersion(), containingPom)) continue;
            ResolvedGroupArtifactVersion resolvedGav = new ResolvedGroupArtifactVersion(repo.getUri(), gav.getGroupId(), gav.getArtifactId(), gav.getVersion(), versionMaybeDatedSnapshot);
            Optional<Pom> result = this.mavenCache.getPom(resolvedGav);
            if (result == null) {
                URI uri = URI.create(repo.getUri() + (repo.getUri().endsWith("/") ? "" : "/") + Objects.requireNonNull(gav.getGroupId()).replace('.', '/') + '/' + gav.getArtifactId() + '/' + gav.getVersion() + '/' + gav.getArtifactId() + '-' + versionMaybeDatedSnapshot + ".pom");
                if ("file".equals(uri.getScheme())) {
                    Pom pom;
                    Pom pom2;
                    FileInputStream fis;
                    block23: {
                        File jar;
                        Path inputPath = Paths.get(gav.getGroupId(), gav.getArtifactId(), gav.getVersion());
                        File f = new File(uri);
                        if (!f.exists()) continue;
                        fis = new FileInputStream(f);
                        RawPom rawPom = RawPom.parse(fis, Objects.equals(versionMaybeDatedSnapshot, gav.getVersion()) ? null : versionMaybeDatedSnapshot);
                        pom2 = rawPom.toPom(inputPath, repo).withGav(resolvedGav);
                        if (pom2.getPackaging() != null && !"jar".equals(pom2.getPackaging()) || (jar = f.toPath().resolveSibling(gav.getArtifactId() + '-' + versionMaybeDatedSnapshot + ".jar").toFile()).exists() && jar.length() != 0L) break block23;
                        fis.close();
                        continue;
                    }
                    try {
                        if (repo.getUri().equals(MavenRepository.MAVEN_LOCAL_DEFAULT.getUri())) {
                            pom2 = pom2.withRepository(MavenRepository.MAVEN_LOCAL_USER_NEUTRAL);
                        }
                        if (!Objects.equals(versionMaybeDatedSnapshot, pom2.getVersion())) {
                            pom2 = pom2.withGav(pom2.getGav().withDatedSnapshotVersion(versionMaybeDatedSnapshot));
                        }
                        this.mavenCache.putPom(resolvedGav, pom2);
                        this.ctx.getResolutionListener().downloadSuccess(resolvedGav, containingPom);
                        sample.stop(timer.tags(new String[]{"outcome", "from maven local"}).register((MeterRegistry)Metrics.globalRegistry));
                        pom = pom2;
                    }
                    catch (Throwable rawPom) {
                        try {
                            try {
                                fis.close();
                            }
                            catch (Throwable throwable) {
                                rawPom.addSuppressed(throwable);
                            }
                            throw rawPom;
                        }
                        catch (IOException e) {
                            repositoryResponses.put(repo, e.getMessage());
                        }
                    }
                    fis.close();
                    return pom;
                    continue;
                }
                try {
                    byte[] responseBody = this.requestAsAuthenticatedOrAnonymous(repo, uri.toString());
                    Path inputPath = Paths.get(gav.getGroupId(), gav.getArtifactId(), gav.getVersion());
                    RawPom rawPom = RawPom.parse(new ByteArrayInputStream(responseBody), Objects.equals(versionMaybeDatedSnapshot, gav.getVersion()) ? null : versionMaybeDatedSnapshot);
                    Pom pom = rawPom.toPom(inputPath, repo).withGav(resolvedGav);
                    if (!Objects.equals(versionMaybeDatedSnapshot, pom.getVersion())) {
                        pom = pom.withGav(pom.getGav().withDatedSnapshotVersion(versionMaybeDatedSnapshot));
                    }
                    this.mavenCache.putPom(resolvedGav, pom);
                    this.ctx.getResolutionListener().downloadSuccess(resolvedGav, containingPom);
                    sample.stop(timer.tags(new String[]{"outcome", "downloaded"}).register((MeterRegistry)Metrics.globalRegistry));
                    return pom;
                }
                catch (HttpSenderResponseException e) {
                    repositoryResponses.put(repo, e.getMessage());
                    if (!e.isClientSideException()) continue;
                    this.mavenCache.putPom(resolvedGav, null);
                    continue;
                }
            }
            if (result.isPresent()) {
                sample.stop(timer.tags(new String[]{"outcome", "cached"}).register((MeterRegistry)Metrics.globalRegistry));
                return result.get();
            }
            repositoryResponses.put(repo, "Did not attempt to download because of a previous failure to retrieve from this repository.");
        }
        sample.stop(timer.tags(new String[]{"outcome", "unavailable"}).register((MeterRegistry)Metrics.globalRegistry));
        if (containingPom != null) {
            this.ctx.getResolutionListener().downloadError(originalGav, containingPom.getRequested());
        }
        throw new MavenDownloadingException("Unable to download POM.", null, originalGav).setRepositoryResponses(repositoryResponses);
    }

    private GroupArtifactVersion handleSnapshotTimestampVersion(GroupArtifactVersion gav) {
        Matcher m = SNAPSHOT_TIMESTAMP.matcher(Objects.requireNonNull(gav.getVersion()));
        if (m.matches()) {
            String baseVersion = m.group(1) != null ? m.group(1) + SNAPSHOT : SNAPSHOT;
            return gav.withVersion(baseVersion);
        }
        return gav;
    }

    @Nullable
    private String datedSnapshotVersion(GroupArtifactVersion gav, @Nullable ResolvedPom containingPom, List<MavenRepository> repositories, ExecutionContext ctx) {
        if (gav.getVersion() != null && gav.getVersion().endsWith("-SNAPSHOT")) {
            MavenMetadata mavenMetadata;
            for (ResolvedGroupArtifactVersion pinnedSnapshotVersion : new MavenExecutionContextView(ctx).getPinnedSnapshotVersions()) {
                if (pinnedSnapshotVersion.getDatedSnapshotVersion() == null || !pinnedSnapshotVersion.getGroupId().equals(gav.getGroupId()) || !pinnedSnapshotVersion.getArtifactId().equals(gav.getArtifactId()) || !pinnedSnapshotVersion.getVersion().equals(gav.getVersion())) continue;
                return pinnedSnapshotVersion.getDatedSnapshotVersion();
            }
            try {
                mavenMetadata = this.downloadMetadata(gav, containingPom, repositories);
            }
            catch (MavenDownloadingException e) {
                return gav.getVersion();
            }
            MavenMetadata.Snapshot snapshot = mavenMetadata.getVersioning().getSnapshot();
            if (snapshot != null && snapshot.getTimestamp() != null) {
                return gav.getVersion().replaceFirst("SNAPSHOT$", snapshot.getTimestamp() + "-" + snapshot.getBuildNumber());
            }
        }
        return gav.getVersion();
    }

    private Collection<MavenRepository> distinctNormalizedRepositories(List<MavenRepository> repositories, @Nullable ResolvedPom containingPom, @Nullable String acceptsVersion) {
        MavenRepository normalizedRepo;
        MavenRepository normalizedRepo2;
        LinkedHashSet<MavenRepository> normalizedRepositories = new LinkedHashSet<MavenRepository>();
        if (this.addDefaultRepositories) {
            normalizedRepositories.add(this.ctx.getLocalRepository());
        }
        for (MavenRepository repo : repositories) {
            normalizedRepo2 = this.normalizeRepository(repo, containingPom);
            if (normalizedRepo2 == null || acceptsVersion != null && !this.repositoryAcceptsVersion(normalizedRepo2, acceptsVersion, containingPom)) continue;
            normalizedRepositories.add(normalizedRepo2);
        }
        for (MavenRepository repo : this.ctx.getRepositories(this.mavenSettings, this.activeProfiles)) {
            normalizedRepo2 = this.normalizeRepository(repo, containingPom);
            if (normalizedRepo2 == null || acceptsVersion != null && !this.repositoryAcceptsVersion(normalizedRepo2, acceptsVersion, containingPom)) continue;
            normalizedRepositories.add(normalizedRepo2);
        }
        if (this.addDefaultRepositories && (normalizedRepo = this.normalizeRepository(MavenRepository.MAVEN_CENTRAL, containingPom)) != null) {
            normalizedRepositories.add(normalizedRepo);
        }
        return normalizedRepositories;
    }

    @Nullable
    public MavenRepository normalizeRepository(MavenRepository originalRepository, @Nullable ResolvedPom containingPom) {
        return this.normalizeRepository(originalRepository, containingPom, null);
    }

    @Nullable
    public MavenRepository normalizeRepository(MavenRepository originalRepository, @Nullable ResolvedPom containingPom, @Nullable Consumer<Throwable> nullReasonConsumer) {
        Optional<MavenRepository> result;
        block20: {
            result = null;
            MavenRepository repository = this.applyAuthenticationToRepository(this.applyMirrors(originalRepository));
            if (containingPom != null) {
                repository = repository.withUri(containingPom.getValue(repository.getUri()));
            }
            try {
                MavenRepository normalized;
                block22: {
                    if (repository.isKnownToExist()) {
                        return repository;
                    }
                    if (repository.getUri().contains("${")) {
                        return null;
                    }
                    if (repository.getUri().contains("0.0.0.0")) {
                        return null;
                    }
                    String originalUrl = repository.getUri();
                    if ("file".equals(URI.create(originalUrl).getScheme())) {
                        return repository;
                    }
                    result = this.mavenCache.getNormalizedRepository(repository);
                    if (result != null) break block20;
                    if (!repository.getUri().toLowerCase().startsWith("http")) {
                        if (nullReasonConsumer != null) {
                            nullReasonConsumer.accept(new RuntimeException("Repository " + repository.getUri() + " is not HTTP(S)."));
                        }
                        return null;
                    }
                    String httpsUri = repository.getUri().toLowerCase().startsWith("http:") ? repository.getUri().replaceFirst("[hH][tT][tT][pP]://", "https://") : repository.getUri();
                    HttpSender.Request.Builder request = this.applyAuthenticationToRequest(repository, this.httpSender.get(httpsUri));
                    normalized = null;
                    try {
                        this.sendRequest.apply((Object)request.build());
                        normalized = repository.withUri(httpsUri).withKnownToExist(true);
                    }
                    catch (Throwable t) {
                        block21: {
                            HttpSenderResponseException e;
                            if (t instanceof HttpSenderResponseException && (e = (HttpSenderResponseException)t).getResponseCode() != null) {
                                normalized = repository.withUri(httpsUri);
                            }
                            if (normalized == null && !httpsUri.equals(originalUrl)) {
                                try {
                                    this.sendRequest.apply((Object)request.url(originalUrl).build());
                                    normalized = new MavenRepository(repository.getId(), originalUrl, repository.getReleases(), repository.getSnapshots(), repository.getUsername(), repository.getPassword());
                                }
                                catch (HttpSenderResponseException e2) {
                                    if (e2.getResponseCode() != null) {
                                        normalized = new MavenRepository(repository.getId(), originalUrl, repository.getReleases(), repository.getSnapshots(), repository.getUsername(), repository.getPassword());
                                    } else if (!e2.isClientSideException()) {
                                        return originalRepository;
                                    }
                                }
                                catch (Throwable e3) {
                                    if (nullReasonConsumer == null) break block21;
                                    nullReasonConsumer.accept(e3);
                                }
                            }
                        }
                        if (normalized != null || nullReasonConsumer == null) break block22;
                        nullReasonConsumer.accept(t);
                    }
                }
                this.mavenCache.putNormalizedRepository(repository, normalized);
                result = Optional.ofNullable(normalized);
            }
            catch (Exception e) {
                this.ctx.getOnError().accept(e);
                if (nullReasonConsumer != null) {
                    nullReasonConsumer.accept(e);
                }
                this.mavenCache.putNormalizedRepository(repository, null);
            }
        }
        return result == null || !result.isPresent() ? null : this.applyAuthenticationToRepository((MavenRepository)result.get());
    }

    private byte[] requestAsAuthenticatedOrAnonymous(MavenRepository repo, String uriString) throws HttpSenderResponseException {
        try {
            return (byte[])this.sendRequest.apply((Object)this.applyAuthenticationToRequest(repo, this.httpSender.get(uriString)).build());
        }
        catch (HttpSenderResponseException e) {
            if (MavenPomDownloader.hasCredentials(repo) && e.isClientSideException()) {
                return this.retryRequestAnonymously(uriString, e);
            }
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private byte[] retryRequestAnonymously(String uriString, HttpSenderResponseException originalException) throws HttpSenderResponseException {
        try {
            return (byte[])this.sendRequest.apply((Object)this.httpSender.get(uriString).build());
        }
        catch (HttpSenderResponseException retryException) {
            if (retryException.isAccessDenied()) {
                throw originalException;
            }
            throw retryException;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private MavenRepository applyAuthenticationToRepository(MavenRepository repository) {
        return MavenRepositoryCredentials.apply(this.ctx.getCredentials(this.mavenSettings), repository);
    }

    private HttpSender.Request.Builder applyAuthenticationToRequest(MavenRepository repository, HttpSender.Request.Builder request) {
        if (this.ctx.getSettings() != null && this.ctx.getSettings().getServers() != null) {
            for (MavenSettings.Server server : this.ctx.getSettings().getServers().getServers()) {
                if (!server.getId().equals(repository.getId()) || server.getConfiguration() == null || server.getConfiguration().getHttpHeaders() == null) continue;
                for (MavenSettings.HttpHeader header : server.getConfiguration().getHttpHeaders()) {
                    request.withHeader(header.getName(), header.getValue());
                }
            }
        }
        if (MavenPomDownloader.hasCredentials(repository)) {
            return request.withBasicAuthentication(repository.getUsername(), repository.getPassword());
        }
        return request;
    }

    private static boolean hasCredentials(MavenRepository repository) {
        return repository.getUsername() != null && repository.getPassword() != null;
    }

    private MavenRepository applyMirrors(MavenRepository repository) {
        return MavenRepositoryMirror.apply(this.ctx.getMirrors(this.mavenSettings), repository);
    }

    public boolean repositoryAcceptsVersion(MavenRepository repo, String version, @Nullable ResolvedPom containingPom) {
        if (version.endsWith("-SNAPSHOT")) {
            String snapshotsRaw = containingPom == null ? repo.getSnapshots() : containingPom.getValue(repo.getSnapshots());
            return snapshotsRaw == null || Boolean.parseBoolean(snapshotsRaw.trim());
        }
        if ("https://repo.spring.io/milestone".equalsIgnoreCase(repo.getUri())) {
            return version.matches(".*(M|RC)\\d+$");
        }
        String releasesRaw = containingPom == null ? repo.getReleases() : containingPom.getValue(repo.getReleases());
        return releasesRaw == null || Boolean.parseBoolean(releasesRaw.trim());
    }

    private static boolean hasPomFile(Path dir, Path versionPath, GroupArtifactVersion gav) {
        String artifactPomFile = gav.getArtifactId() + "-" + versionPath.getFileName() + ".pom";
        return Files.exists(dir.resolve(versionPath.resolve(artifactPomFile)), new LinkOption[0]);
    }

    public static class HttpSenderResponseException
    extends Exception {
        @Nullable
        private final Integer responseCode;

        public HttpSenderResponseException(@Nullable Throwable cause, @Nullable Integer responseCode) {
            super(cause);
            this.responseCode = responseCode;
        }

        public boolean isClientSideException() {
            if (this.responseCode == null || this.responseCode < 400 || this.responseCode > 499) {
                return false;
            }
            return this.responseCode != 408 && this.responseCode != 425 && this.responseCode != 429;
        }

        @Override
        public String getMessage() {
            return this.responseCode == null ? Objects.requireNonNull(this.getCause()).getMessage() : "HTTP " + this.responseCode;
        }

        public boolean isAccessDenied() {
            return this.responseCode != null && 400 < this.responseCode && this.responseCode <= 403;
        }

        @Nullable
        public Integer getResponseCode() {
            return this.responseCode;
        }
    }
}

