/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.maven.tree.Scope;
import org.openrewrite.xml.RemoveContentVisitor;
import org.openrewrite.xml.tree.Content;
import org.openrewrite.xml.tree.Xml;

public final class RemoveDependency
extends Recipe {
    @Option(displayName="Group", description="The first part of a dependency coordinate `com.google.guava:guava:VERSION`.", example="com.google.guava")
    private final String groupId;
    @Option(displayName="Artifact", description="The second part of a dependency coordinate `com.google.guava:guava:VERSION`.", example="guava")
    private final String artifactId;
    @Option(displayName="Scope", description="Only remove dependencies if they are in this scope. If 'runtime', this willalso remove dependencies in the 'compile' scope because 'compile' dependencies are part of the runtime dependency set", valid={"compile", "test", "runtime", "provided"}, example="compile", required=false)
    @Nullable
    private final String scope;

    public String getDisplayName() {
        return "Remove Maven dependency";
    }

    public String getInstanceNameSuffix() {
        return String.format("`%s:%s`", this.groupId, this.artifactId);
    }

    public String getDescription() {
        return "Removes a single dependency from the <dependencies> section of the pom.xml.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new RemoveDependencyVisitor();
    }

    public Validated<Object> validate() {
        return super.validate().and(Validated.test((String)"scope", (String)"Scope must be one of compile, runtime, test, or provided", (Object)this.scope, s -> !Scope.Invalid.equals((Object)Scope.fromName(s))));
    }

    public RemoveDependency(String groupId, String artifactId, @Nullable String scope) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.scope = scope;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    @Nullable
    public String getScope() {
        return this.scope;
    }

    @NonNull
    public String toString() {
        return "RemoveDependency(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", scope=" + this.getScope() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveDependency)) {
            return false;
        }
        RemoveDependency other = (RemoveDependency)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$scope = this.getScope();
        String other$scope = other.getScope();
        return !(this$scope == null ? other$scope != null : !this$scope.equals(other$scope));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof RemoveDependency;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        return result;
    }

    private class RemoveDependencyVisitor
    extends MavenIsoVisitor<ExecutionContext> {
        private RemoveDependencyVisitor() {
        }

        @Override
        public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
            Scope checkScope;
            ResolvedDependency dependency;
            if (this.isDependencyTag(RemoveDependency.this.groupId, RemoveDependency.this.artifactId) && (dependency = this.findDependency(tag, checkScope = RemoveDependency.this.scope != null ? Scope.fromName(RemoveDependency.this.scope) : null)) != null) {
                this.doAfterVisit((TreeVisitor)new RemoveContentVisitor((Content)tag, true));
                this.maybeUpdateModel();
            }
            return super.visitTag(tag, ctx);
        }
    }
}

